/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.sys;

import javax.baja.license.BILicensed;
import javax.baja.license.Feature;
import javax.baja.log.Log;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIService;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BAbstractService
extends BComponent
implements BIService,
BIStatus,
BILicensed {
    public static final Property status = BAbstractService.newProperty(3, BStatus.ok, null);
    public static final Property faultCause = BAbstractService.newProperty(3, "", null);
    public static final Property enabled = BAbstractService.newProperty(0, true, null);
    public static final Type TYPE;
    private boolean fatalFault;
    private boolean configFault;
    static /* synthetic */ Class class$javax$baja$sys$BAbstractService;

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus bStatus) {
        this.set(status, (BValue)bStatus, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String string) {
        this.setString(faultCause, string, null);
    }

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean bl) {
        this.setBoolean(enabled, bl, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void serviceStarted() throws Exception {
    }

    public void serviceStopped() throws Exception {
    }

    public final boolean isDisabled() {
        return this.getStatus().isDisabled();
    }

    public final boolean isFault() {
        return this.getStatus().isFault();
    }

    public final boolean isOperational() {
        BStatus bStatus = this.getStatus();
        boolean bl = false;
        if (!bStatus.isDisabled() && !bStatus.isFault()) {
            bl = true;
        }
        return bl;
    }

    public void updateStatus() {
        boolean bl = this.isDisabled() ^ true;
        int n = this.getStatus().getBits();
        int n2 = 0;
        n2 = !this.getEnabled() ? (n2 |= 1) : (n2 &= 0xFFFFFFFE);
        n2 = this.fatalFault || this.configFault ? (n2 |= 2) : (n2 &= 0xFFFFFFFD);
        if (n == n2) {
            return;
        }
        this.setStatus(BStatus.make(n2));
        boolean bl2 = this.isDisabled() ^ true;
        if (bl != bl2) {
            if (bl2) {
                this.enabled();
            } else {
                this.disabled();
            }
        }
    }

    public final boolean isFatalFault() {
        return this.fatalFault;
    }

    public final void configOk() {
        this.configFault = false;
        if (this.fatalFault) {
            return;
        }
        this.setFaultCause("");
        this.updateStatus();
    }

    public final void configFail(String string) {
        this.configFault = true;
        if (this.fatalFault) {
            return;
        }
        this.setFaultCause(string);
        this.updateStatus();
    }

    public final void configFatal(String string) {
        this.fatalFault = true;
        this.setFaultCause(string);
        this.updateStatus();
    }

    public Feature getLicenseFeature() {
        return null;
    }

    private final void checkLicense() {
        try {
            Feature feature = this.getLicenseFeature();
            if (feature != null) {
                feature.check();
            }
        }
        catch (Exception exception) {
            this.fatalFault = true;
            Log.getLog("service").error("Unlicensed: " + this.toPathString(), exception);
            this.setFaultCause("Unlicensed: " + exception);
        }
    }

    protected void enabled() {
    }

    protected void disabled() {
    }

    public Object fw(int n, Object object, Object object2, Object object3, Object object4) {
        switch (n) {
            case 15: {
                this.fwServiceStarted();
                break;
            }
            case 13: {
                this.fwDescendantsStarted();
                break;
            }
            case 12: {
                this.updateStatus();
                break;
            }
            case 2: {
                this.fwChanged((Property)object);
                break;
            }
        }
        return super.fw(n, object, object2, object3, object4);
    }

    private final void fwServiceStarted() {
        this.checkLicense();
        this.updateStatus();
    }

    private final void fwDescendantsStarted() {
        this.updateStatus();
    }

    private final void fwChanged(Property property) {
        if (!this.isRunning()) {
            return;
        }
        if (property.equals(enabled)) {
            this.updateStatus();
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$javax$baja$sys$BAbstractService;
        if (clazz == null) {
            clazz = class$javax$baja$sys$BAbstractService = BAbstractService.class("[Ljavax.baja.sys.BAbstractService;", false);
        }
        TYPE = Sys.loadType(clazz);
    }
}

