/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.sys;

import com.tridium.timezone.HistoricalTimeZoneEra;
import com.tridium.util.TimeFormat;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import javax.baja.data.BIDataValue;
import javax.baja.nre.util.IntHashMap;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BDate;
import javax.baja.sys.BIComparable;
import javax.baja.sys.BIDate;
import javax.baja.sys.BITime;
import javax.baja.sys.BMonth;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BSimple;
import javax.baja.sys.BTime;
import javax.baja.sys.BWeekday;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.timezone.DstRule;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BAbsTime
extends BSimple
implements BIDate,
BITime,
BIComparable,
BIDataValue {
    private static final int[] daysInMonth = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    public static final BAbsTime DEFAULT;
    public static final BAbsTime NULL;
    public static final String TIME_MODE_FACET = "timeMode";
    public static final int TIME_MODE_DEFAULT = 0;
    public static final int TIME_MODE_WALL_STRICT = 1;
    public static final int TIME_MODE_STANDARD = 2;
    public static final int TIME_MODE_DAYLIGHT = 3;
    public static final int TIME_MODE_UTC = 4;
    public static final int TIME_MODE_WALL_SCHD = 5;
    public static final BAbsTime END_OF_TIME;
    public static final Type TYPE;
    private static IntHashMap MIDDLE_OF_YEAR_MAP;
    private long millis;
    private BTimeZone timeZone;
    private int bits0;
    private int bits1;
    static /* synthetic */ Class class$javax$baja$sys$BAbsTime;

    public static final BAbsTime make() {
        return new BAbsTime(System.currentTimeMillis(), BTimeZone.getLocal());
    }

    public static final BAbsTime now() {
        return new BAbsTime(System.currentTimeMillis(), BTimeZone.getLocal());
    }

    public static final BAbsTime make(long l) {
        if (l == 0L) {
            return NULL;
        }
        if (l >= END_OF_TIME.getMillis()) {
            return END_OF_TIME;
        }
        return new BAbsTime(l, BTimeZone.getLocal());
    }

    public static final BAbsTime make(long l, BTimeZone bTimeZone) {
        return new BAbsTime(l, bTimeZone);
    }

    public static final BAbsTime make(int n, BMonth bMonth, int n2) {
        return BAbsTime.make(n, bMonth, n2, 0, 0, 0, 0, BTimeZone.getLocal(), null);
    }

    public static final BAbsTime make(int n, BMonth bMonth, int n2, int n3, int n4) {
        return BAbsTime.make(n, bMonth, n2, n3, n4, 0, 0, BTimeZone.getLocal(), null);
    }

    public static final BAbsTime make(int n, BMonth bMonth, int n2, int n3, int n4, int n5, int n6) {
        return BAbsTime.make(n, bMonth, n2, n3, n4, n5, n6, BTimeZone.getLocal(), null);
    }

    public static final BAbsTime make(int n, BMonth bMonth, int n2, int n3, int n4, int n5, int n6, BTimeZone bTimeZone) {
        return BAbsTime.make(n, bMonth, n2, n3, n4, n5, n6, bTimeZone, null);
    }

    public static final BAbsTime make(int n, BMonth bMonth, int n2, int n3, int n4, int n5, int n6, BTimeZone bTimeZone, Context context) {
        Calendar calendar = BAbsTime.makeCalendar(n, bMonth, n2, n3, n4, n5, n6, bTimeZone, context);
        BAbsTime bAbsTime = new BAbsTime(calendar.getTimeInMillis(), bTimeZone);
        int n7 = calendar.get(1);
        bAbsTime.bits0 |= (n7 & (char)-1) << 16;
        n7 = calendar.get(14);
        bAbsTime.bits0 |= n7 & (char)-1;
        n7 = calendar.get(2);
        bAbsTime.bits1 |= (n7 & 0xF) << 25;
        n7 = calendar.get(5);
        bAbsTime.bits1 |= (n7 & 0x1F) << 20;
        n7 = calendar.get(11);
        bAbsTime.bits1 |= (n7 & 0x1F) << 15;
        n7 = calendar.get(12);
        bAbsTime.bits1 |= (n7 & 0x3F) << 9;
        n7 = calendar.get(13);
        bAbsTime.bits1 |= (n7 & 0x3F) << 3;
        n7 = calendar.get(7) - 1;
        bAbsTime.bits1 |= n7 & 7;
        if (calendar.get(16) != 0) {
            bAbsTime.bits1 |= 0x20000000;
        }
        return bAbsTime;
    }

    public static final Calendar makeCalendar(int n, BMonth bMonth, int n2, int n3, int n4, int n5, int n6, BTimeZone bTimeZone, Context context) {
        long l;
        int n7 = 0;
        if (context != null) {
            n7 = context.getFacets().geti(TIME_MODE_FACET, 0);
        }
        int n8 = n7;
        GregorianCalendar gregorianCalendar = new GregorianCalendar(bTimeZone.getJavaTimeZone());
        boolean bl = false;
        if (n8 == 4) {
            gregorianCalendar.set(15, 0);
            gregorianCalendar.set(16, 0);
            bl = true;
        } else if (n8 == 3) {
            l = BAbsTime.getMiddleOfYear(n);
            gregorianCalendar.set(15, bTimeZone.getUtcOffset(l));
            gregorianCalendar.set(16, bTimeZone.getDaylightAdjustment(l));
            bl = true;
        } else if (n8 == 2) {
            gregorianCalendar.set(15, bTimeZone.getUtcOffset(BAbsTime.getMiddleOfYear(n)));
            gregorianCalendar.set(16, 0);
            bl = true;
        } else if (n8 == 0 || n8 == 1 || n8 == 5) {
            Object object;
            DstRule dstRule;
            boolean bl2;
            l = BAbsTime.getMiddleOfYear(n);
            boolean bl3 = false;
            if (n8 == 1) {
                bl3 = bl2 = true;
            }
            if ((dstRule = bTimeZone.getDaylightStartRule(l)) != null) {
                object = dstRule.getMonth();
                int n9 = bTimeZone.getDay(n, dstRule);
                long l2 = Long.MIN_VALUE;
                if (dstRule.getTimeMode() == 2) {
                    int n10 = BAbsTime.getDaysInMonth(n, (BMonth)object);
                    l2 = dstRule.getTime().getTimeOfDayMillis() + (long)bTimeZone.getUtcOffset(l);
                    while (l2 >= 86400000L) {
                        l2 -= 86400000L;
                        if (++n9 <= n10) continue;
                        object = ((BMonth)object).next();
                        n9 = 1;
                        n10 = BAbsTime.getDaysInMonth(n, (BMonth)object);
                    }
                    while (l2 < 0L) {
                        l2 += 86400000L;
                        if (--n9 >= 1) continue;
                        object = ((BMonth)object).previous();
                        n9 = n10 = BAbsTime.getDaysInMonth(n, (BMonth)object);
                    }
                }
                if (bMonth.equals(object)) {
                    bl2 = false;
                    if (n2 == n9) {
                        long l3 = BTime.make(n3, n4, n5, n6).getTimeOfDayMillis();
                        if (l2 == Long.MIN_VALUE) {
                            l2 = dstRule.getTime().getTimeOfDayMillis();
                        }
                        long l4 = l2 + (long)bTimeZone.getDaylightAdjustment(l);
                        if (l3 >= l2 && l3 < l4) {
                            if (n8 == 1) {
                                throw new LocalizableRuntimeException("baja", "AbsTime.invalidWallTime", new Object[]{BTime.make(n3, n4, n5, n6)});
                            }
                            BTime bTime = n8 == 0 ? BTime.make(BRelTime.make(l3 + (long)bTimeZone.getDaylightAdjustment(l))) : BTime.make(BRelTime.make(l4));
                            n3 = bTime.getHour();
                            n4 = bTime.getMinute();
                            n5 = 0;
                            n6 = 0;
                        }
                    }
                }
            }
            if (bl2 && (object = bTimeZone.getDaylightEndRule(l)) != null) {
                int n11;
                BMonth bMonth2 = ((DstRule)object).getMonth();
                int n12 = bTimeZone.getDay(n, (DstRule)object);
                long l5 = Long.MIN_VALUE;
                if (((DstRule)object).getTimeMode() == 2) {
                    n11 = BAbsTime.getDaysInMonth(n, bMonth2);
                    l5 = ((DstRule)object).getTime().getTimeOfDayMillis() + (long)bTimeZone.getUtcOffset(l);
                    while (l5 >= 86400000L) {
                        l5 -= 86400000L;
                        if (++n12 <= n11) continue;
                        bMonth2 = bMonth2.next();
                        n12 = 1;
                        n11 = BAbsTime.getDaysInMonth(n, bMonth2);
                    }
                    while (l5 < 0L) {
                        l5 += 86400000L;
                        if (--n12 >= 1) continue;
                        bMonth2 = bMonth2.previous();
                        n12 = n11 = BAbsTime.getDaysInMonth(n, bMonth2);
                    }
                } else if (((DstRule)object).getTimeMode() == 0) {
                    n11 = BAbsTime.getDaysInMonth(n, bMonth2);
                    l5 = ((DstRule)object).getTime().getTimeOfDayMillis() - (long)bTimeZone.getDaylightAdjustment(l);
                    while (l5 < 0L) {
                        l5 += 86400000L;
                        if (--n12 >= 1) continue;
                        bMonth2 = bMonth2.previous();
                        n12 = n11 = BAbsTime.getDaysInMonth(n, bMonth2);
                    }
                }
                if (bMonth.equals(bMonth2)) {
                    bl2 = false;
                    if (n2 == n12) {
                        long l6 = BTime.make(n3, n4, n5, n6).getTimeOfDayMillis();
                        if (l5 == Long.MIN_VALUE) {
                            l5 = ((DstRule)object).getTime().getTimeOfDayMillis();
                        }
                        long l7 = l5 + (long)bTimeZone.getDaylightAdjustment(l);
                        if (l6 >= l5 && l6 < l7) {
                            throw new LocalizableRuntimeException("baja", "AbsTime.ambigWallTime", new Object[]{BTime.make(n3, n4, n5, n6)});
                        }
                    }
                }
            }
        }
        gregorianCalendar.set(n, bMonth.getOrdinal(), n2, n3, n4, n5);
        gregorianCalendar.set(14, n6);
        if (bl) {
            l = gregorianCalendar.getTimeInMillis();
            gregorianCalendar = new GregorianCalendar(bTimeZone.getJavaTimeZone());
            gregorianCalendar.setTimeInMillis(l);
        }
        return gregorianCalendar;
    }

    public static final long getMiddleOfYear(int n) {
        Long l = null;
        if (MIDDLE_OF_YEAR_MAP == null) {
            MIDDLE_OF_YEAR_MAP = new IntHashMap();
        } else {
            l = (Long)MIDDLE_OF_YEAR_MAP.get(n);
        }
        if (l == null) {
            GregorianCalendar gregorianCalendar = new GregorianCalendar(BTimeZone.getJavaUTCInstance());
            gregorianCalendar.clear();
            gregorianCalendar.set(n, 6, 1);
            MIDDLE_OF_YEAR_MAP.put(n, (Object)new Long(gregorianCalendar.getTimeInMillis()));
            return gregorianCalendar.getTimeInMillis();
        }
        return l;
    }

    public static final BAbsTime make(BAbsTime bAbsTime, BTime bTime) {
        return BAbsTime.make(bAbsTime.getYear(), bAbsTime.getMonth(), bAbsTime.getDay(), bTime.getHour(), bTime.getMinute(), bTime.getSecond(), bTime.getMillisecond(), bAbsTime.getTimeZone());
    }

    public static final BAbsTime make(BDate bDate, BTime bTime, BTimeZone bTimeZone) {
        return BAbsTime.make(bDate.getYear(), bDate.getMonth(), bDate.getDay(), bTime.getHour(), bTime.getMinute(), bTime.getSecond(), bTime.getMillisecond(), bTimeZone);
    }

    public static final BAbsTime make(BAbsTime bAbsTime, BTimeZone bTimeZone) {
        if (bAbsTime.timeZone == bTimeZone) {
            return bAbsTime;
        }
        return BAbsTime.make(bAbsTime.millis, bTimeZone);
    }

    public static final BAbsTime makeDayOfYear(int n, int n2, int n3, int n4, int n5, int n6, BTimeZone bTimeZone) {
        int n7 = BAbsTime.getDaysInYear(n);
        if (n2 > n7) {
            throw new IllegalArgumentException(n2 + " > " + n7);
        }
        if (n2 < 1) {
            throw new IllegalArgumentException(n2 + " < 1");
        }
        BMonth bMonth = BMonth.january;
        int n8 = BAbsTime.getDaysInMonth(n, bMonth);
        while (n2 > n8) {
            n2 -= n8;
            bMonth = bMonth.next();
            n8 = BAbsTime.getDaysInMonth(n, bMonth);
        }
        return BAbsTime.make(n, bMonth, n2, n3, n4, n5, n6, bTimeZone);
    }

    public static final BAbsTime make(String string) throws IOException {
        return (BAbsTime)DEFAULT.decodeFromString(string);
    }

    public final long getMillis() {
        return this.millis;
    }

    public final int getYear() {
        if (this.bits0 == 0) {
            this.millisToFields();
        }
        return this.bits0 >> 16 & (char)-1;
    }

    public final BMonth getMonth() {
        if (this.bits0 == 0) {
            this.millisToFields();
        }
        return BMonth.make(this.bits1 >> 25 & 0xF);
    }

    public final int getDay() {
        if (this.bits0 == 0) {
            this.millisToFields();
        }
        return this.bits1 >> 20 & 0x1F;
    }

    public final int getHour() {
        if (this.bits0 == 0) {
            this.millisToFields();
        }
        return this.bits1 >> 15 & 0x1F;
    }

    public final int getMinute() {
        if (this.bits0 == 0) {
            this.millisToFields();
        }
        return this.bits1 >> 9 & 0x3F;
    }

    public final int getSecond() {
        if (this.bits0 == 0) {
            this.millisToFields();
        }
        return this.bits1 >> 3 & 0x3F;
    }

    public final int getMillisecond() {
        if (this.bits0 == 0) {
            this.millisToFields();
        }
        return this.bits0 & (char)-1;
    }

    public final BWeekday getWeekday() {
        if (this.bits0 == 0) {
            this.millisToFields();
        }
        return BWeekday.make(this.bits1 & 7);
    }

    public static final BWeekday getWeekday(int n, BMonth bMonth, int n2) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(BTimeZone.getJavaUTCInstance());
        gregorianCalendar.set(n, bMonth.getOrdinal(), n2);
        int n3 = gregorianCalendar.get(7);
        if (n3 == 1) {
            return BWeekday.sunday;
        }
        if (n3 == 2) {
            return BWeekday.monday;
        }
        if (n3 == 3) {
            return BWeekday.tuesday;
        }
        if (n3 == 4) {
            return BWeekday.wednesday;
        }
        if (n3 == 5) {
            return BWeekday.thursday;
        }
        if (n3 == 6) {
            return BWeekday.friday;
        }
        if (n3 == 7) {
            return BWeekday.saturday;
        }
        throw new BajaRuntimeException("Unrecognized weekday: " + n3);
    }

    public final long getTimeOfDayMillis() {
        return (long)(this.getHour() * 60 * 60) * 1000L + (long)(this.getMinute() * 60) * 1000L + (long)this.getSecond() * 1000L + (long)this.getMillisecond();
    }

    public final int getDayOfYear() {
        int n = this.getYear();
        BMonth bMonth = this.getMonth();
        int n2 = 0;
        BMonth bMonth2 = BMonth.january;
        while (bMonth2 != bMonth) {
            n2 += BAbsTime.getDaysInMonth(n, bMonth2);
            bMonth2 = bMonth2.next();
        }
        return n2 += this.getDay();
    }

    public final BDate getDate() {
        return BDate.make(this.getYear(), this.getMonth(), this.getDay());
    }

    public final BTime getTime() {
        return BTime.make(this.getHour(), this.getMinute(), this.getSecond(), this.getMillisecond());
    }

    public final BTimeZone getTimeZone() {
        return this.timeZone;
    }

    public final int getTimeZoneOffset() {
        int n;
        int n2;
        if (this.timeZone.isHistorical()) {
            HistoricalTimeZoneEra historicalTimeZoneEra = (HistoricalTimeZoneEra)this.timeZone.fw(1101, new Long(this.millis), null, null, null);
            n2 = historicalTimeZoneEra.getActiveUtcOffsetMillis();
            int n3 = 0;
            if (historicalTimeZoneEra.getStartRule() != null) {
                n3 = historicalTimeZoneEra.getStartRule().getDaylightAdjMillis();
            }
            n = n3;
        } else {
            n2 = this.timeZone.getUtcOffset();
            n = this.timeZone.getDaylightAdjustment();
        }
        if (n == 0) {
            return n2;
        }
        if (!this.inDaylightTime()) {
            return n2;
        }
        return n2 + n;
    }

    public final boolean inDaylightTime() {
        if (this.bits0 == 0) {
            this.millisToFields();
        }
        boolean bl = false;
        if ((this.bits1 >> 29 & 1) != 0) {
            bl = true;
        }
        return bl;
    }

    public final String getTimeZoneName(Context context) {
        return this.timeZone.getDisplayName(this, context);
    }

    public final String getTimeZoneShortName(Context context) {
        return this.timeZone.getShortDisplayName(this, context);
    }

    public final BAbsTime toLocalTime() {
        if (this.timeZone.equals(BTimeZone.getLocal())) {
            return this;
        }
        return BAbsTime.make(this, BTimeZone.getLocal());
    }

    public final BAbsTime toUtcTime() {
        if (this.timeZone.equals(BTimeZone.UTC)) {
            return this;
        }
        return BAbsTime.make(this, BTimeZone.UTC);
    }

    public final BAbsTime toNormalizedTime() {
        if (this.timeZone.equals(BTimeZone.NULL)) {
            return this;
        }
        return BAbsTime.make(this, BTimeZone.NULL);
    }

    public final BAbsTime add(BRelTime bRelTime) {
        return BAbsTime.make(this.millis + bRelTime.getMillis(), this.timeZone);
    }

    public final BAbsTime subtract(BRelTime bRelTime) {
        return BAbsTime.make(this.millis - bRelTime.getMillis(), this.timeZone);
    }

    public final BRelTime delta(BAbsTime bAbsTime) {
        return BRelTime.make(bAbsTime.millis - this.millis);
    }

    public final BAbsTime timeOfDay(int n, int n2, int n3, int n4) {
        return BAbsTime.make(this.getYear(), this.getMonth(), this.getDay(), n, n2, n3, n4, BTimeZone.getLocal());
    }

    public final BAbsTime nextDay() {
        int n = this.getYear();
        int n2 = this.getMonth().getOrdinal();
        int n3 = this.getDay();
        if (n3 == BAbsTime.getDaysInMonth(n, BMonth.make(n2))) {
            n3 = 1;
            if (n2 == 11) {
                n2 = 0;
                ++n;
            } else {
                ++n2;
            }
        } else {
            ++n3;
        }
        return BAbsTime.make(n, BMonth.make(n2), n3, this.getHour(), this.getMinute(), this.getSecond(), this.getMillisecond(), this.getTimeZone());
    }

    public final BAbsTime prevDay() {
        int n = this.getYear();
        int n2 = this.getMonth().getOrdinal();
        int n3 = this.getDay();
        if (n3 == 1) {
            if (n2 == 0) {
                n2 = 11;
                --n;
            } else {
                --n2;
            }
            n3 = BAbsTime.getDaysInMonth(n, BMonth.make(n2));
        } else {
            --n3;
        }
        return BAbsTime.make(n, BMonth.make(n2), n3, this.getHour(), this.getMinute(), this.getSecond(), this.getMillisecond(), this.getTimeZone());
    }

    public final BAbsTime nextMonth() {
        int n = this.getYear();
        int n2 = this.getMonth().getOrdinal();
        int n3 = this.getDay();
        if (n2 == 11) {
            n2 = 0;
            ++n;
        } else if (n3 == BAbsTime.getDaysInMonth(n, BMonth.make(n2))) {
            n3 = BAbsTime.getDaysInMonth(n, BMonth.make(++n2));
        } else if (n3 > BAbsTime.getDaysInMonth(n, BMonth.make(++n2))) {
            n3 = BAbsTime.getDaysInMonth(n, BMonth.make(n2));
        }
        return BAbsTime.make(n, BMonth.make(n2), n3, this.getHour(), this.getMinute(), this.getSecond(), this.getMillisecond(), this.getTimeZone());
    }

    public final BAbsTime prevMonth() {
        int n = this.getYear();
        int n2 = this.getMonth().getOrdinal();
        int n3 = this.getDay();
        if (n2 == 0) {
            n2 = 11;
            --n;
        } else if (n3 == BAbsTime.getDaysInMonth(n, BMonth.make(n2))) {
            n3 = BAbsTime.getDaysInMonth(n, BMonth.make(--n2));
        } else if (n3 > BAbsTime.getDaysInMonth(n, BMonth.make(--n2))) {
            n3 = BAbsTime.getDaysInMonth(n, BMonth.make(n2));
        }
        return BAbsTime.make(n, BMonth.make(n2), n3, this.getHour(), this.getMinute(), this.getSecond(), this.getMillisecond(), this.getTimeZone());
    }

    public final BAbsTime nextYear() {
        int n = this.getDay();
        if (this.isLeapDay()) {
            n = 28;
        }
        return BAbsTime.make(this.getYear() + 1, this.getMonth(), n, this.getHour(), this.getMinute(), this.getSecond(), this.getMillisecond(), this.getTimeZone());
    }

    public final BAbsTime prevYear() {
        int n = this.getDay();
        if (this.isLeapDay()) {
            n = 28;
        }
        return BAbsTime.make(this.getYear() - 1, this.getMonth(), n, this.getHour(), this.getMinute(), this.getSecond(), this.getMillisecond(), this.getTimeZone());
    }

    public final BAbsTime next(BWeekday bWeekday) {
        BAbsTime bAbsTime = this.nextDay();
        while (bAbsTime.getWeekday() != bWeekday) {
            bAbsTime = bAbsTime.nextDay();
        }
        return bAbsTime;
    }

    public final BAbsTime prev(BWeekday bWeekday) {
        BAbsTime bAbsTime = this.prevDay();
        while (bAbsTime.getWeekday() != bWeekday) {
            bAbsTime = bAbsTime.prevDay();
        }
        return bAbsTime;
    }

    public final int compareTo(Object object) {
        BAbsTime bAbsTime = (BAbsTime)object;
        if (this.millis < bAbsTime.millis) {
            return -1;
        }
        if (this.millis == bAbsTime.millis) {
            return 0;
        }
        return 1;
    }

    public final boolean isBefore(BAbsTime bAbsTime) {
        boolean bl = false;
        if (this.compareTo(bAbsTime) < 0) {
            bl = true;
        }
        return bl;
    }

    public final boolean isAfter(BAbsTime bAbsTime) {
        boolean bl = false;
        if (this.compareTo(bAbsTime) > 0) {
            bl = true;
        }
        return bl;
    }

    public final int hashCode() {
        return (int)(this.millis ^ this.millis >> 32);
    }

    public final boolean equals(Object object) {
        if (object instanceof BAbsTime) {
            boolean bl = false;
            if (((BAbsTime)object).millis == this.millis) {
                bl = true;
            }
            return bl;
        }
        return false;
    }

    public final boolean dateEquals(BAbsTime bAbsTime) {
        boolean bl = false;
        if (bAbsTime.getYear() == this.getYear() && bAbsTime.getMonth() == this.getMonth() && bAbsTime.getDay() == this.getDay()) {
            bl = true;
        }
        return bl;
    }

    public final boolean timeEquals(BAbsTime bAbsTime) {
        boolean bl = false;
        if (bAbsTime.getTimeOfDayMillis() == this.getTimeOfDayMillis()) {
            bl = true;
        }
        return bl;
    }

    public final boolean isLeapDay() {
        boolean bl = false;
        if (this.getMonth() == BMonth.february && this.getDay() == 29) {
            bl = true;
        }
        return bl;
    }

    public static final boolean isLeapYear(int n) {
        if (n >= 1582) {
            boolean bl = false;
            if (n % 4 == 0 && (n % 100 != 0 || n % 400 == 0)) {
                bl = true;
            }
            return bl;
        }
        boolean bl = false;
        if (n % 4 == 0) {
            bl = true;
        }
        return bl;
    }

    public static final int getDaysInMonth(int n, BMonth bMonth) {
        if (bMonth == BMonth.february) {
            return BAbsTime.isLeapYear(n) + 28;
        }
        return daysInMonth[bMonth.getOrdinal()];
    }

    public static final int getDaysInYear(int n) {
        return BAbsTime.isLeapYear(n) + 365;
    }

    public final void encode(DataOutput dataOutput) throws IOException {
        dataOutput.writeLong(this.millis);
    }

    public final BObject decode(DataInput dataInput) throws IOException {
        return BAbsTime.make(dataInput.readLong());
    }

    public final String encodeToString() {
        StringBuffer stringBuffer = new StringBuffer(32);
        if (this.getYear() > 9999) {
            throw new IllegalStateException("Year must be < 9999.");
        }
        stringBuffer.append(TextUtil.padZeros((String)String.valueOf(this.getYear()), (int)4)).append('-');
        int n = this.getMonth().getOrdinal() + 1;
        stringBuffer.append(TextUtil.padZeros((String)String.valueOf(n), (int)2)).append('-');
        int n2 = this.getDay();
        stringBuffer.append(TextUtil.padZeros((String)String.valueOf(n2), (int)2)).append('T');
        int n3 = this.getHour();
        stringBuffer.append(TextUtil.padZeros((String)String.valueOf(n3), (int)2)).append(':');
        int n4 = this.getMinute();
        stringBuffer.append(TextUtil.padZeros((String)String.valueOf(n4), (int)2)).append(':');
        int n5 = this.getSecond();
        stringBuffer.append(TextUtil.padZeros((String)String.valueOf(n5), (int)2)).append('.');
        int n6 = this.getMillisecond();
        stringBuffer.append(TextUtil.padZeros((String)String.valueOf(n6), (int)3));
        int n7 = this.getTimeZoneOffset();
        if (n7 == 0) {
            stringBuffer.append('Z');
        } else {
            int n8 = Math.abs(n7 / 3600000);
            int n9 = Math.abs(n7 % 3600000 / 60000);
            if (n7 < 0) {
                stringBuffer.append('-');
            } else {
                stringBuffer.append('+');
            }
            stringBuffer.append(TextUtil.padZeros((String)String.valueOf(n8), (int)2)).append(':');
            stringBuffer.append(TextUtil.padZeros((String)String.valueOf(n9), (int)2));
        }
        return stringBuffer.toString();
    }

    public final BObject decodeFromString(String string) throws IOException {
        char[] cArray = string.toCharArray();
        try {
            char c;
            int n = 0;
            int n2 = (cArray[n++] - 48) * 1000 + (cArray[n++] - 48) * 100 + (cArray[n++] - 48) * 10 + (cArray[n++] - 48);
            if (cArray[n++] != '-') {
                throw new Exception();
            }
            int n3 = (cArray[n++] - 48) * 10 + (cArray[n++] - 48);
            if (cArray[n++] != '-') {
                throw new Exception();
            }
            int n4 = (cArray[n++] - 48) * 10 + (cArray[n++] - 48);
            if (cArray[n++] != 'T') {
                throw new Exception();
            }
            int n5 = (cArray[n++] - 48) * 10 + (cArray[n++] - 48);
            if (cArray[n++] != ':') {
                throw new Exception();
            }
            int n6 = (cArray[n++] - 48) * 10 + (cArray[n++] - 48);
            if (cArray[n++] != ':') {
                throw new Exception();
            }
            int n7 = (cArray[n++] - 48) * 10 + (cArray[n++] - 48);
            int n8 = 0;
            if (cArray[n] == '.') {
                int n9 = ++n;
                n8 = (cArray[n9] - 48) * 100;
                if ('0' <= cArray[++n] && cArray[n] <= '9') {
                    n8 += (cArray[n++] - 48) * 10;
                }
                if ('0' <= cArray[n] && cArray[n] <= '9') {
                    n8 += cArray[n++] - 48;
                }
                while (n < cArray.length && '0' <= cArray[n] && cArray[n] <= '9') {
                    ++n;
                }
            }
            int n10 = 0;
            if ((c = cArray[n++]) != 'Z') {
                if (c != '+' && c != '-') {
                    throw new Exception();
                }
                int n11 = cArray[n++] - 48;
                if (n < cArray.length && cArray[n] != ':') {
                    n11 = n11 * 10 + (cArray[n++] - 48);
                }
                int n12 = 0;
                if (n < cArray.length) {
                    if (cArray[n++] != ':') {
                        throw new Exception();
                    }
                    n12 = 10 * (cArray[n++] - 48) + (cArray[n++] - 48);
                }
                n10 = n11 * 3600000 + n12 * 60000;
                if (c == '-') {
                    n10 *= -1;
                }
            }
            GregorianCalendar gregorianCalendar = new GregorianCalendar(new SimpleTimeZone(n10, "Offset"));
            gregorianCalendar.set(n2, n3 - 1, n4, n5, n6, n7);
            gregorianCalendar.set(14, n8);
            return BAbsTime.make(gregorianCalendar.getTime().getTime());
        }
        catch (Exception exception) {
            throw new IOException("Invalid BAbsTime: " + string);
        }
    }

    public final BIDataValue toDataValue() {
        return this;
    }

    public final boolean isNull() {
        boolean bl = false;
        if (this.millis == 0L) {
            bl = true;
        }
        return bl;
    }

    public final String toDateString(Context context) {
        if (this.millis == 0L) {
            return "null";
        }
        return TimeFormat.formatDate(this, context);
    }

    public final String toTimeString(Context context) {
        if (this.millis == 0L) {
            return "null";
        }
        return TimeFormat.formatTime(this, context);
    }

    public final String toString(Context context) {
        if (this.millis == 0L) {
            return "null";
        }
        return TimeFormat.format(this, context);
    }

    private final void millisToFields() {
        TimeZone timeZone = (TimeZone)this.timeZone.tzSupport();
        if (timeZone == null) {
            throw new LocalizableRuntimeException("baja", "AbsTime.unsupportedTimeZone", new Object[]{this.timeZone.getId()});
        }
        int n = timeZone.getOffset(this.millis);
        GregorianCalendar gregorianCalendar = new GregorianCalendar(new SimpleTimeZone(n, "util"));
        gregorianCalendar.setTimeInMillis(this.millis);
        int n2 = gregorianCalendar.get(1);
        this.bits0 |= (n2 & (char)-1) << 16;
        n2 = gregorianCalendar.get(14);
        this.bits0 |= n2 & (char)-1;
        n2 = gregorianCalendar.get(2);
        this.bits1 |= (n2 & 0xF) << 25;
        n2 = gregorianCalendar.get(5);
        this.bits1 |= (n2 & 0x1F) << 20;
        n2 = gregorianCalendar.get(11);
        this.bits1 |= (n2 & 0x1F) << 15;
        n2 = gregorianCalendar.get(12);
        this.bits1 |= (n2 & 0x3F) << 9;
        n2 = gregorianCalendar.get(13);
        this.bits1 |= (n2 & 0x3F) << 3;
        n2 = gregorianCalendar.get(7) - 1;
        this.bits1 |= n2 & 7;
        if (timeZone.inDaylightTime(gregorianCalendar.getTime())) {
            this.bits1 |= 0x20000000;
        }
    }

    public final Type getType() {
        return TYPE;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private BAbsTime(long l, BTimeZone bTimeZone) {
        this.millis = l;
        this.timeZone = bTimeZone;
    }

    static {
        NULL = DEFAULT = new BAbsTime(0L, BTimeZone.getLocal());
        END_OF_TIME = BAbsTime.make(9999, BMonth.december, 31, 23, 59, 59, 999, BTimeZone.UTC);
        Class clazz = class$javax$baja$sys$BAbsTime;
        if (clazz == null) {
            clazz = class$javax$baja$sys$BAbsTime = BAbsTime.class("[Ljavax.baja.sys.BAbsTime;", false);
        }
        TYPE = Sys.loadType(clazz);
        MIDDLE_OF_YEAR_MAP = null;
    }
}

