/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.sync;

import javax.baja.space.BComponentSpace;
import javax.baja.sync.AddKnobOp;
import javax.baja.sync.AddOp;
import javax.baja.sync.FireTopicOp;
import javax.baja.sync.LoadOp;
import javax.baja.sync.RemoveKnobOp;
import javax.baja.sync.RemoveOp;
import javax.baja.sync.RenameOp;
import javax.baja.sync.ReorderOp;
import javax.baja.sync.SetCategoryMaskOp;
import javax.baja.sync.SetFacetsOp;
import javax.baja.sync.SetFlagsOp;
import javax.baja.sync.SetOp;
import javax.baja.sync.SyncBuffer;
import javax.baja.sync.SyncDecoder;
import javax.baja.sync.SyncEncoder;
import javax.baja.sys.BComponent;
import javax.baja.sys.Context;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class SyncOp {
    public static final int LOAD = 108;
    public static final int SET = 115;
    public static final int ADD = 97;
    public static final int REMOVE = 118;
    public static final int RENAME = 114;
    public static final int REORDER = 111;
    public static final int SET_FLAGS = 102;
    public static final int SET_FACETS = 120;
    public static final int ADD_KNOB = 107;
    public static final int REMOVE_KNOB = 106;
    public static final int FIRE_TOPIC = 116;
    public static final int SET_CATEGORY_MASK = 99;
    SyncBuffer buffer;
    BComponent component;
    SyncOp prev;
    SyncOp next;
    String handle;
    boolean committed;

    public static SyncOp make(int n) {
        switch (n) {
            case 108: {
                return new LoadOp();
            }
            case 115: {
                return new SetOp();
            }
            case 97: {
                return new AddOp();
            }
            case 118: {
                return new RemoveOp();
            }
            case 114: {
                return new RenameOp();
            }
            case 111: {
                return new ReorderOp();
            }
            case 102: {
                return new SetFlagsOp();
            }
            case 120: {
                return new SetFacetsOp();
            }
            case 107: {
                return new AddKnobOp();
            }
            case 106: {
                return new RemoveKnobOp();
            }
            case 116: {
                return new FireTopicOp();
            }
            case 99: {
                return new SetCategoryMaskOp();
            }
        }
        throw new IllegalArgumentException("" + n);
    }

    public abstract int getId();

    public BComponent getComponent() {
        return this.component;
    }

    abstract void commit(SyncBuffer var1, BComponentSpace var2, Context var3) throws Exception;

    void encode(SyncEncoder syncEncoder) throws Exception {
        this.handle = "?";
        if (this.component != null) {
            this.handle = String.valueOf(this.component.getHandle());
        }
        syncEncoder.start(String.valueOf((char)this.getId())).attr("h", this.handle);
        syncEncoder.encodingSyncOp(this);
    }

    void decode(SyncBuffer syncBuffer, BComponentSpace bComponentSpace, SyncDecoder syncDecoder) throws Exception {
        this.handle = syncDecoder.elem().get("h");
        this.component = syncBuffer != null ? syncBuffer.findByHandle(this.handle, false) : bComponentSpace.findByHandle(this.handle, false);
    }

    public abstract String toString();

    String componentToString() {
        return this.component != null ? this.component.toPathString() : "null";
    }

    private final /* synthetic */ void this() {
        this.committed = false;
    }

    protected SyncOp(BComponent bComponent) {
        this.this();
        this.component = bComponent;
        if (this.component != null) {
            this.handle = String.valueOf(this.component.getHandle());
        }
    }

    protected SyncOp() {
        this.this();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class SyncOpSecurityException
    extends SecurityException {
        SyncOpSecurityException() {
        }

        SyncOpSecurityException(String string) {
            super(string);
        }
    }
}

