/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.sync;

import com.tridium.sys.engine.ProxyKnob;
import com.tridium.sys.schema.ComponentSlotMap;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import javax.baja.io.ValueDocDecoder;
import javax.baja.naming.BOrd;
import javax.baja.security.BPermissions;
import javax.baja.sys.BComponent;
import javax.baja.sys.Slot;

public class SyncDecoder
extends ValueDocDecoder {
    HashMap knobs;

    protected void decodingComponent(BComponent bComponent) throws Exception {
        ValueDocDecoder.IElement iElement = this.elem();
        String string = iElement.name();
        if (string.equals("load")) {
            this.decodingLoadInfo(bComponent, iElement);
        }
        if (string.equals("nknob")) {
            this.decodingKnob(bComponent, iElement);
        }
        this.skip();
    }

    private final void decodingLoadInfo(BComponent bComponent, ValueDocDecoder.IElement iElement) {
        if (this.knobs == null) {
            this.knobs = new HashMap();
        }
        this.knobs.put(bComponent, new ArrayList(4));
        String string = iElement.get("p", null);
        if (string != null) {
            try {
                BPermissions bPermissions = BPermissions.make(string);
                ((ComponentSlotMap)bComponent.fw(1)).setCachedPermissions(bPermissions);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private final void decodingKnob(BComponent bComponent, ValueDocDecoder.IElement iElement) {
        if (this.knobs == null) {
            throw new IllegalStateException("unexpected <nknob> without <load>");
        }
        ArrayList arrayList = (ArrayList)this.knobs.get(bComponent);
        arrayList.add(this.elem().copy());
    }

    ProxyKnob decodeKnob(BComponent bComponent) throws Exception {
        return SyncDecoder.decodeKnob(bComponent, this.elem());
    }

    static ProxyKnob decodeKnob(BComponent bComponent, ValueDocDecoder.IElement iElement) throws Exception {
        Slot slot = bComponent.getSlot(iElement.get("ss"));
        if (slot == null) {
            return null;
        }
        int n = iElement.geti("id");
        BOrd bOrd = BOrd.make(iElement.get("to"));
        String string = iElement.get("ts");
        return new ProxyKnob(n, bComponent, slot, bOrd, string);
    }

    public SyncDecoder(ValueDocDecoder.IDecoderPlugin iDecoderPlugin) throws Exception {
        super(iDecoderPlugin);
    }

    public SyncDecoder(InputStream inputStream) throws Exception {
        super(inputStream);
    }
}

