/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.sync;

import javax.baja.io.ValueDocDecoder;
import javax.baja.space.BComponentSpace;
import javax.baja.sync.SyncBuffer;
import javax.baja.sync.SyncDecoder;
import javax.baja.sync.SyncEncoder;
import javax.baja.sync.SyncOp;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.Context;

public class SetFacetsOp
extends SyncOp {
    String name;
    BFacets facets;

    public int getId() {
        return 120;
    }

    public String getSlotName() {
        return this.name;
    }

    public BFacets getFacets() {
        return this.facets;
    }

    void commit(SyncBuffer syncBuffer, BComponentSpace bComponentSpace, Context context) throws Exception {
        this.component.setFacets(this.component.getSlot(this.name), this.facets, context);
    }

    void encode(SyncEncoder syncEncoder) throws Exception {
        super.encode(syncEncoder);
        syncEncoder.attr("n", this.name);
        syncEncoder.attr("x", this.facets.encodeToString()).end().newLine();
    }

    void decode(SyncBuffer syncBuffer, BComponentSpace bComponentSpace, SyncDecoder syncDecoder) throws Exception {
        super.decode(syncBuffer, bComponentSpace, syncDecoder);
        ValueDocDecoder.IElement iElement = syncDecoder.elem();
        this.name = iElement.get("n");
        this.facets = BFacets.make(iElement.get("x"));
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SetFacets: ").append(this.componentToString()).append('.').append(this.name).append(" -> ").append(this.facets);
        return stringBuffer.toString();
    }

    public SetFacetsOp(BComponent bComponent, String string, BFacets bFacets) {
        super(bComponent);
        this.name = string;
        this.facets = bFacets;
    }

    public SetFacetsOp() {
    }
}

