/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.sync;

import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.baja.space.BComponentSpace;
import javax.baja.sync.SyncBuffer;
import javax.baja.sync.SyncDecoder;
import javax.baja.sync.SyncEncoder;
import javax.baja.sync.SyncOp;
import javax.baja.sys.BComponent;
import javax.baja.sys.Context;
import javax.baja.sys.Property;

public class ReorderOp
extends SyncOp {
    String[] order;

    public int getId() {
        return 111;
    }

    public String[] getOrder() {
        return (String[])this.order.clone();
    }

    void commit(SyncBuffer syncBuffer, BComponentSpace bComponentSpace, Context context) throws Exception {
        Property[] propertyArray = new Property[this.order.length];
        int n = 0;
        while (n < propertyArray.length) {
            propertyArray[n] = this.component.getProperty(this.order[n]);
            ++n;
        }
        this.component.reorder(propertyArray, context);
    }

    void encode(SyncEncoder syncEncoder) throws Exception {
        super.encode(syncEncoder);
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.order.length) {
            if (n > 0) {
                stringBuffer.append(';');
            }
            stringBuffer.append(this.order[n]);
            ++n;
        }
        syncEncoder.attr("o", stringBuffer.toString()).end().newLine();
    }

    void decode(SyncBuffer syncBuffer, BComponentSpace bComponentSpace, SyncDecoder syncDecoder) throws Exception {
        super.decode(syncBuffer, bComponentSpace, syncDecoder);
        String string = syncDecoder.elem().get("o");
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        this.order = arrayList.toArray(new String[arrayList.size()]);
    }

    public String toString() {
        return "Reorder: " + this.componentToString();
    }

    public ReorderOp(BComponent bComponent, String[] stringArray) {
        super(bComponent);
        this.order = stringArray;
    }

    public ReorderOp() {
    }
}

