/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.sync;

import javax.baja.io.ValueDocDecoder;
import javax.baja.space.BComponentSpace;
import javax.baja.sync.SyncBuffer;
import javax.baja.sync.SyncDecoder;
import javax.baja.sync.SyncEncoder;
import javax.baja.sync.SyncOp;
import javax.baja.sys.BComponent;
import javax.baja.sys.Context;
import javax.baja.sys.Property;

public class RenameOp
extends SyncOp {
    String oldName;
    String newName;

    public int getId() {
        return 114;
    }

    public String getOldName() {
        return this.oldName;
    }

    public String getNewName() {
        return this.newName;
    }

    void commit(SyncBuffer syncBuffer, BComponentSpace bComponentSpace, Context context) throws Exception {
        Property property = this.component.getProperty(this.oldName);
        if (property != null) {
            this.component.rename(property, this.newName, context);
        }
    }

    void encode(SyncEncoder syncEncoder) throws Exception {
        super.encode(syncEncoder);
        syncEncoder.attr("o", this.oldName);
        syncEncoder.attr("n", this.newName).end().newLine();
    }

    void decode(SyncBuffer syncBuffer, BComponentSpace bComponentSpace, SyncDecoder syncDecoder) throws Exception {
        super.decode(syncBuffer, bComponentSpace, syncDecoder);
        ValueDocDecoder.IElement iElement = syncDecoder.elem();
        this.oldName = iElement.get("o");
        this.newName = iElement.get("n");
    }

    public String toString() {
        return "Rename: " + this.componentToString() + '.' + this.oldName + " -> " + this.newName;
    }

    public RenameOp(BComponent bComponent, String string, String string2) {
        super(bComponent);
        this.oldName = string;
        this.newName = string2;
    }

    public RenameOp() {
    }
}

