/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.sync;

import com.tridium.sys.engine.NKnob;
import com.tridium.sys.schema.ComponentSlotMap;
import javax.baja.io.ValueDocDecoder;
import javax.baja.space.BComponentSpace;
import javax.baja.sync.SyncBuffer;
import javax.baja.sync.SyncDecoder;
import javax.baja.sync.SyncEncoder;
import javax.baja.sync.SyncOp;
import javax.baja.sys.BComponent;
import javax.baja.sys.Context;
import javax.baja.sys.Knob;
import javax.baja.sys.Slot;

public class RemoveKnobOp
extends SyncOp {
    Knob knob;

    public int getId() {
        return 106;
    }

    public Knob getKnob() {
        return this.knob;
    }

    void commit(SyncBuffer syncBuffer, BComponentSpace bComponentSpace, Context context) throws Exception {
        if (this.knob != null) {
            ((ComponentSlotMap)this.component.fw(1)).uninstallKnob((NKnob)this.knob);
        }
    }

    void encode(SyncEncoder syncEncoder) throws Exception {
        super.encode(syncEncoder);
        NKnob nKnob = (NKnob)this.knob;
        syncEncoder.attr("id", String.valueOf(nKnob.id));
        syncEncoder.attr("ss", String.valueOf(nKnob.getSourceSlotName())).end().newLine();
    }

    void decode(SyncBuffer syncBuffer, BComponentSpace bComponentSpace, SyncDecoder syncDecoder) throws Exception {
        super.decode(syncBuffer, bComponentSpace, syncDecoder);
        if (this.component == null) {
            return;
        }
        ValueDocDecoder.IElement iElement = syncDecoder.elem();
        int n = iElement.geti("id");
        Slot slot = this.component.getSlot(iElement.get("ss"));
        if (slot != null) {
            NKnob[] nKnobArray = (NKnob[])this.component.getKnobs(slot);
            int n2 = 0;
            while (n2 < nKnobArray.length) {
                if (nKnobArray[n2].id == n) {
                    this.knob = nKnobArray[n2];
                    break;
                }
                ++n2;
            }
        }
    }

    public String toString() {
        return "RemoveKnob: " + this.componentToString() + ' ' + this.knob;
    }

    public RemoveKnobOp(BComponent bComponent, Knob knob) {
        super(bComponent);
        this.knob = knob;
    }

    public RemoveKnobOp() {
    }
}

