/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.sync;

import javax.baja.nav.BNavRoot;
import javax.baja.nav.NavEvent;
import javax.baja.nav.NavListener;
import javax.baja.space.BComponentSpace;
import javax.baja.sync.AddKnobOp;
import javax.baja.sync.AddOp;
import javax.baja.sync.FireTopicOp;
import javax.baja.sync.LoadOp;
import javax.baja.sync.RemoveKnobOp;
import javax.baja.sync.RemoveOp;
import javax.baja.sync.RenameOp;
import javax.baja.sync.ReorderOp;
import javax.baja.sync.SetCategoryMaskOp;
import javax.baja.sync.SetFacetsOp;
import javax.baja.sync.SetFlagsOp;
import javax.baja.sync.SetOp;
import javax.baja.sync.SyncBuffer;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BFacets;
import javax.baja.sys.Property;
import javax.baja.sys.Subscriber;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ProxyBroker
extends Subscriber
implements NavListener {
    private BComponentSpace masterSpace;
    private Object bufferLock;
    private ProxySyncBuffer buffer;

    public BComponentSpace getMasterSpace() {
        return this.masterSpace;
    }

    public void start() {
        BNavRoot.INSTANCE.addNavListener(this);
    }

    public void stop() {
        BNavRoot.INSTANCE.removeNavListener(this);
        this.unsubscribeAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SyncBuffer detachBuffer() {
        Object object = this.bufferLock;
        synchronized (object) {
            ProxySyncBuffer proxySyncBuffer = this.buffer;
            this.buffer = new ProxySyncBuffer(this.masterSpace);
            return proxySyncBuffer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void loadOp(BComponent bComponent, int n) {
        Object object = this.bufferLock;
        synchronized (object) {
            this.buffer.add(new LoadOp(bComponent, n));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void loadOp(BComponent bComponent, int n, boolean bl) {
        Object object = this.bufferLock;
        synchronized (object) {
            this.buffer.add(new LoadOp(bComponent, n, bl));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void subscribeOp(BComponent bComponent, int n) {
        this.subscribe(bComponent, n);
        Object object = this.bufferLock;
        synchronized (object) {
            this.buffer.add(new LoadOp(bComponent, n));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void subscribeOp(BComponent bComponent, int n, boolean bl) {
        this.subscribe(bComponent, n);
        Object object = this.bufferLock;
        synchronized (object) {
            this.buffer.add(new LoadOp(bComponent, n, bl));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void navEvent(NavEvent navEvent) {
        if (!(navEvent.getParent() instanceof BComponent)) {
            return;
        }
        BComponent bComponent = (BComponent)navEvent.getParent();
        if (bComponent.getComponentSpace() != this.masterSpace) {
            return;
        }
        Object object = this.bufferLock;
        synchronized (object) {
            switch (navEvent.getId()) {
                case 1: {
                    Property property = bComponent.getProperty(navEvent.getNewChildName());
                    BComponent bComponent2 = (BComponent)bComponent.get(property);
                    this.buffer.add(new AddOp(bComponent, property.getName(), bComponent2, property.getDefaultFlags(), property.getFacets()));
                    break;
                }
                case 2: {
                    this.buffer.add(new RemoveOp(bComponent, navEvent.getOldChildName()));
                    break;
                }
                case 3: {
                    this.buffer.add(new RenameOp(bComponent, navEvent.getOldChildName(), navEvent.getNewChildName()));
                    break;
                }
                case 4: {
                    this.buffer.add(new ReorderOp(bComponent, navEvent.getNewOrder()));
                    break;
                }
                case 5: {
                    String string = navEvent.getOldChildName();
                    this.buffer.add(new SetOp(bComponent, string, null));
                    break;
                }
                case 6: {
                    this.buffer.add(new SetCategoryMaskOp(bComponent, navEvent.getNewChildName()));
                    break;
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void event(BComponentEvent bComponentEvent) {
        BComponent bComponent = bComponentEvent.getSourceComponent();
        if (bComponent.getComponentSpace() != this.masterSpace) {
            throw new IllegalStateException();
        }
        Object object = this.bufferLock;
        synchronized (object) {
            switch (bComponentEvent.getId()) {
                case 0: {
                    this.buffer.add(new SetOp(bComponent, bComponentEvent.getSlotName(), null));
                    break;
                }
                case 1: {
                    this.buffer.add(new AddOp(bComponent, bComponentEvent.getSlotName(), bComponentEvent.getValue(), bComponentEvent.getSlotFlags(), bComponentEvent.getSlot().getFacets()));
                    break;
                }
                case 2: {
                    this.buffer.add(new RemoveOp(bComponent, bComponentEvent.getSlotName()));
                    break;
                }
                case 3: {
                    this.buffer.add(new RenameOp(bComponent, bComponentEvent.getValue().toString(), bComponentEvent.getSlotName()));
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    this.buffer.add(new FireTopicOp(bComponent, bComponentEvent.getSlotName(), bComponentEvent.getValue()));
                    break;
                }
                case 6: {
                    this.buffer.add(new SetFlagsOp(bComponent, bComponentEvent.getSlotName(), bComponentEvent.getSlotFlags()));
                    break;
                }
                case 7: {
                    this.buffer.add(new SetFacetsOp(bComponent, bComponentEvent.getSlotName(), (BFacets)bComponentEvent.getValue()));
                    break;
                }
                case 10: {
                    break;
                }
                case 8: {
                    this.buffer.add(new AddKnobOp(bComponent, bComponentEvent.getKnob()));
                    break;
                }
                case 9: {
                    this.buffer.add(new RemoveKnobOp(bComponent, bComponentEvent.getKnob()));
                    break;
                }
            }
            return;
        }
    }

    private final /* synthetic */ void this() {
        this.bufferLock = new BufferLock();
    }

    public ProxyBroker(BComponentSpace bComponentSpace) {
        this.this();
        this.masterSpace = bComponentSpace;
        this.buffer = new ProxySyncBuffer(bComponentSpace);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class ProxySyncBuffer
    extends SyncBuffer {
        ProxySyncBuffer(BComponentSpace bComponentSpace) {
            super(bComponentSpace, true);
        }
    }

    static class BufferLock {
        BufferLock() {
        }
    }
}

