/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.security;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import javax.baja.io.BIContextEncodable;
import javax.baja.nre.util.Base64;
import javax.baja.nre.util.TextUtil;
import javax.baja.security.BPassword;
import javax.baja.security.BPbkdf2HmacSha256PasswordEncoder;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BPasswordHistory
extends BSimple
implements BIContextEncodable {
    public static final BPasswordHistory DEFAULT = new BPasswordHistory();
    public static final Type TYPE;
    private BPassword[] passwords;
    private String salt;
    private int iterationCount;
    static /* synthetic */ Class class$javax$baja$security$BPasswordHistory;

    public final Type getType() {
        return TYPE;
    }

    public final BPasswordHistory add(String string, BPassword bPassword) {
        return this.add(string, bPassword, this.passwords.length + 1);
    }

    public final BPasswordHistory add(String string, BPassword bPassword, int n) {
        if (!bPassword.getPasswordEncoder().isReversible()) {
            throw new BajaRuntimeException("Cannot add " + bPassword.getEncodingType() + " encoded passwords to BPasswordHistory.");
        }
        if (n < 0) {
            throw new InvalidParameterException("History size must be zero or greater.");
        }
        if (n == 0) {
            return DEFAULT;
        }
        BPassword bPassword2 = this.getConvertedPassword(bPassword);
        if (this.contains(string, bPassword, bPassword2, n)) {
            throw new BajaRuntimeException("Duplicate password.");
        }
        BPasswordHistory bPasswordHistory = new BPasswordHistory();
        bPasswordHistory.passwords = new BPassword[Math.min(n, this.passwords.length + 1)];
        bPasswordHistory.passwords[0] = bPassword2;
        if (this.passwords.length > 0) {
            System.arraycopy(this.passwords, 0, bPasswordHistory.passwords, 1, Math.min(n - 1, this.passwords.length));
        }
        bPasswordHistory.initSaltAndIterationCount();
        return bPasswordHistory;
    }

    private final String getOldPasswordHash(String string, BPassword bPassword) {
        String string2;
        try {
            string2 = bPassword.getPasswordEncoder().getValue();
        }
        catch (Exception exception) {
            throw new SecurityException();
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            messageDigest.update(string2.getBytes());
            messageDigest.update((TextUtil.bytesToHexString((byte[])messageDigest.digest()) + 'H' + string).getBytes());
            return TextUtil.bytesToHexString((byte[])messageDigest.digest());
        }
        catch (Exception exception) {
            return String.valueOf(string2.hashCode());
        }
    }

    public final boolean contains(String string, BPassword bPassword) {
        return this.contains(string, bPassword, this.passwords.length);
    }

    public final boolean contains(String string, BPassword bPassword, int n) {
        return this.contains(string, bPassword, null, n);
    }

    public final boolean contains(String string, BPassword bPassword, BPassword bPassword2, int n) {
        if (bPassword.getPasswordEncoder().isReversible()) {
            String string2 = null;
            if (bPassword2 != null) {
                string2 = bPassword2.getPasswordEncoder().getEncodedValue();
            }
            int n2 = 0;
            while (n2 < Math.min(this.passwords.length, n)) {
                block11: {
                    if (this.passwords[n2].getPasswordEncoder().isReversible()) {
                        try {
                            if (this.passwords[n2].getPasswordEncoder().getValue().equals(this.getOldPasswordHash(string, bPassword))) {
                                return true;
                            }
                            break block11;
                        }
                        catch (Exception exception) {
                            throw new SecurityException();
                        }
                    }
                    if (this.passwords[n2].getEncodingType().equals("pbkdf2hmacsha256/text")) {
                        if (string2 == null) {
                            string2 = this.getConvertedPassword(bPassword).getPasswordEncoder().getEncodedValue();
                        }
                        if (this.passwords[n2].getPasswordEncoder().getEncodedValue().equals(string2)) {
                            return true;
                        }
                    }
                }
                ++n2;
            }
        } else {
            return true;
        }
        return false;
    }

    public final int getSize() {
        return this.passwords.length;
    }

    public final void encode(DataOutput dataOutput) throws IOException {
        this.encode(dataOutput, null);
    }

    public final void encode(DataOutput dataOutput, Context context) throws IOException {
        dataOutput.writeInt(this.passwords.length);
        int n = 0;
        while (n < this.passwords.length) {
            dataOutput.writeUTF(this.passwords[n].encodeToString(context));
            ++n;
        }
    }

    public final BObject decode(DataInput dataInput) throws IOException {
        return this.decode(dataInput, null);
    }

    public final BObject decode(DataInput dataInput, Context context) throws IOException {
        BPasswordHistory bPasswordHistory = new BPasswordHistory();
        bPasswordHistory.passwords = new BPassword[dataInput.readInt()];
        int n = 0;
        while (n < bPasswordHistory.passwords.length) {
            bPasswordHistory.passwords[n] = (BPassword)BPassword.DEFAULT.decodeFromString(dataInput.readUTF());
            ++n;
        }
        bPasswordHistory.initSaltAndIterationCount();
        return bPasswordHistory;
    }

    public final String encodeToString() throws IOException {
        return this.encodeToString(null);
    }

    public final String encodeToString(Context context) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.passwords.length > 0) {
            int n = 0;
            while (n < this.passwords.length) {
                stringBuffer.append(this.passwords[n].encodeToString(context)).append("|");
                ++n;
            }
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        }
        return Base64.encode((String)stringBuffer.toString());
    }

    public final BObject decodeFromString(String string) throws IOException {
        return this.decodeFromString(string, null);
    }

    public final BObject decodeFromString(String string, Context context) throws IOException {
        BPasswordHistory bPasswordHistory = new BPasswordHistory();
        String[] stringArray = TextUtil.split((String)Base64.decodeToString((String)string), (char)'|');
        bPasswordHistory.passwords = new BPassword[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            try {
                bPasswordHistory.passwords[n] = (BPassword)BPassword.DEFAULT.decodeFromString(stringArray[n]);
            }
            catch (IOException iOException) {
                bPasswordHistory.passwords[n] = BPassword.make(stringArray[n]);
            }
            ++n;
        }
        bPasswordHistory.initSaltAndIterationCount();
        return bPasswordHistory;
    }

    public final boolean equals(Object object) {
        if (!(object instanceof BPasswordHistory)) {
            return false;
        }
        BPasswordHistory bPasswordHistory = (BPasswordHistory)object;
        if (bPasswordHistory.passwords.length != this.passwords.length) {
            return false;
        }
        if (bPasswordHistory.passwords.length != this.passwords.length) {
            return false;
        }
        int n = 0;
        while (n < bPasswordHistory.passwords.length) {
            if (!bPasswordHistory.passwords[n].equals(this.passwords[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private final void initSaltAndIterationCount() {
        if (this.salt == null) {
            int n = 0;
            while (n < this.passwords.length) {
                if (this.passwords[n].getEncodingType().equals("pbkdf2hmacsha256/text")) {
                    String string = this.passwords[n].getPasswordEncoder().getEncodedValue();
                    int n2 = string.indexOf(":");
                    int n3 = string.indexOf(":", n2 + 1);
                    this.salt = string.substring(0, n2);
                    this.iterationCount = Integer.parseInt(string.substring(n2 + 1, n3));
                    return;
                }
                ++n;
            }
        }
    }

    private final BPassword getConvertedPassword(BPassword bPassword) {
        try {
            if (this.salt != null && this.iterationCount != 0) {
                BPbkdf2HmacSha256PasswordEncoder bPbkdf2HmacSha256PasswordEncoder = new BPbkdf2HmacSha256PasswordEncoder();
                bPbkdf2HmacSha256PasswordEncoder.encode(bPassword.getPasswordEncoder().getValue(), this.salt, this.iterationCount);
                return BPassword.make(bPbkdf2HmacSha256PasswordEncoder);
            }
            return BPassword.make(bPassword.getPasswordEncoder().getValue(), "pbkdf2hmacsha256/text");
        }
        catch (Exception exception) {
            throw new SecurityException();
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.salt = null;
        this.iterationCount = 0;
    }

    public BPasswordHistory() {
        this.this();
        this.passwords = new BPassword[0];
    }

    static {
        Class clazz = class$javax$baja$security$BPasswordHistory;
        if (clazz == null) {
            clazz = class$javax$baja$security$BPasswordHistory = BPasswordHistory.class("[Ljavax.baja.security.BPasswordHistory;", false);
        }
        TYPE = Sys.loadType(clazz);
    }
}

