/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.security;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.Clock;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class AuditEvent {
    public static final String CHANGED = "Changed";
    public static final String ADDED = "Added";
    public static final String REMOVED = "Removed";
    public static final String RENAMED = "Renamed";
    public static final String REORDERED = "Reordered";
    public static final String FLAGS_CHANGED = "Flags Changed";
    public static final String FACETS_CHANGED = "Facets Changed";
    public static final String RECATEGORIZED = "Recategorized";
    public static final String INVOKED = "Invoked";
    public static final String LOGIN = "Login";
    public static final String LOGOUT = "Logout";
    public static final String LOGIN_FAILURE = "Login Failure";
    private DateFormat format;
    private String operation;
    private String target;
    private String slotName;
    private String oldValue;
    private String value;
    private String userName;
    private BAbsTime timestamp;

    public String getOperation() {
        return this.operation;
    }

    public String getTarget() {
        return this.target;
    }

    public String getSlotName() {
        return this.slotName;
    }

    public String getOldValue() {
        return this.oldValue;
    }

    public String getValue() {
        return this.value;
    }

    public String getUserName() {
        return this.userName;
    }

    public BAbsTime getTimestamp() {
        return this.timestamp;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('[').append(this.format.format(new Date(this.timestamp.getMillis()))).append("][").append(this.userName).append("][").append(this.target).append("] ").append(this.toSummaryString());
        return stringBuffer.toString();
    }

    public String toSummaryString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.operation.equals(CHANGED)) {
            stringBuffer.append(this.slotName).append(": ").append(this.oldValue).append(" -> ").append(this.value);
        } else if (this.operation.equals(ADDED)) {
            stringBuffer.append(this.slotName).append(": added");
        } else if (this.operation.equals(REMOVED)) {
            stringBuffer.append(this.slotName).append(": removed");
        } else if (this.operation.equals(RENAMED)) {
            stringBuffer.append(this.slotName).append(": renamed " + this.value);
        } else if (this.operation.equals(REORDERED)) {
            stringBuffer.append("reordered");
        } else if (this.operation.equals(FLAGS_CHANGED)) {
            stringBuffer.append(this.slotName).append(": flags ").append(this.oldValue).append(" -> ").append(this.value);
        } else if (this.operation.equals(RECATEGORIZED)) {
            stringBuffer.append("recategorized ").append(this.oldValue).append(" -> ").append(this.value);
        } else if (this.operation.equals(INVOKED)) {
            stringBuffer.append(this.slotName).append('(');
            if (this.value != null) {
                stringBuffer.append(this.value);
            }
            stringBuffer.append(')');
        } else if (this.operation.equals(LOGIN)) {
            stringBuffer.append("login");
        } else if (this.operation.equals(LOGOUT)) {
            stringBuffer.append("logout");
        } else if (this.operation.equals(LOGIN_FAILURE)) {
            stringBuffer.append("login failure ").append(this.value);
        } else {
            stringBuffer.append(this.operation);
            if (this.slotName != null) {
                stringBuffer.append(";slotName=" + this.slotName);
            }
            if (this.oldValue != null) {
                stringBuffer.append(";oldValue=" + this.oldValue);
            }
            if (this.value != null) {
                stringBuffer.append(";value=" + this.value);
            }
        }
        return stringBuffer.toString();
    }

    private final /* synthetic */ void this() {
        this.format = new SimpleDateFormat("HH:mm:ss dd-MMM-yy");
    }

    public AuditEvent(String string, String string2, String string3, String string4, String string5, String string6) {
        this.this();
        this.operation = string;
        this.target = string2;
        this.slotName = string3;
        this.oldValue = string4;
        this.value = string5;
        this.userName = string6;
        this.timestamp = Clock.time();
    }
}

