/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.nav;

import java.util.ArrayList;
import java.util.HashMap;
import javax.baja.naming.SlotPath;
import javax.baja.naming.UnresolvedException;
import javax.baja.nav.BINavNode;
import javax.baja.nav.BNavRoot;
import javax.baja.nav.NavEvent;
import javax.baja.nre.util.Array;
import javax.baja.security.BIProtected;
import javax.baja.security.BPermissions;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;
import javax.baja.util.LexiconText;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BNavContainer
extends BObject
implements BINavNode {
    public static final Type TYPE;
    BINavNode parent;
    String name;
    LexiconText lexText;
    ArrayList byOrder;
    HashMap byName;
    static /* synthetic */ Class class$javax$baja$nav$BNavContainer;
    static /* synthetic */ Class class$javax$baja$nav$BINavNode;

    public Type getType() {
        return TYPE;
    }

    public LexiconText getLexiconText() {
        return this.lexText;
    }

    public void setLexiconText(LexiconText lexiconText) {
        this.lexText = lexiconText;
    }

    public String getNavName() {
        return this.name;
    }

    public String getNavDisplayName(Context context) {
        if (this.lexText != null) {
            return this.lexText.getText(context);
        }
        return this.getNavName();
    }

    public String getNavDescription(Context context) {
        if (this.lexText != null) {
            return Lexicon.make(this.lexText.module, context).get(this.lexText.key + ".description", null);
        }
        return null;
    }

    public BINavNode getNavParent() {
        return this.parent;
    }

    public boolean hasNavChildren() {
        boolean bl = false;
        if (this.byName.size() > 0) {
            bl = true;
        }
        return bl;
    }

    public BINavNode getNavChild(String string) {
        return (BINavNode)this.byName.get(string);
    }

    public BINavNode resolveNavChild(String string) {
        BINavNode bINavNode = this.getNavChild(string);
        if (bINavNode == null) {
            throw new UnresolvedException(string);
        }
        return bINavNode;
    }

    public BINavNode[] getNavChildren() {
        return this.byOrder.toArray(new BINavNode[this.byOrder.size()]);
    }

    public BIcon getNavIcon() {
        return this.getIcon();
    }

    public void addNavChild(BINavNode bINavNode) {
        String string = bINavNode.getNavName();
        if (this.byName.get(string) != null) {
            throw new IllegalArgumentException("duplicate name " + string);
        }
        this.byName.put(string, bINavNode);
        this.byOrder.add(bINavNode);
        if (bINavNode instanceof BNavContainer) {
            BNavContainer bNavContainer = (BNavContainer)bINavNode;
            bNavContainer.parent = this;
        }
        this.fireNavEvent(NavEvent.makeAdded(this, string, null));
    }

    public void removeNavChild(BINavNode bINavNode) {
        String string = bINavNode.getNavName();
        if (this.byName.get(string) != bINavNode) {
            throw new IllegalArgumentException("not child " + string);
        }
        this.byName.remove(string);
        this.byOrder.remove(bINavNode);
        if (bINavNode instanceof BNavContainer) {
            BNavContainer bNavContainer = (BNavContainer)bINavNode;
            bNavContainer.parent = null;
        }
        this.fireNavEvent(NavEvent.makeRemoved(this, string, null));
    }

    public void reorderNavChildren(BINavNode[] bINavNodeArray) {
        if (bINavNodeArray.length != this.byOrder.size()) {
            throw new IllegalArgumentException("children.length != getNavChildren().length");
        }
        ArrayList<BINavNode> arrayList = new ArrayList<BINavNode>(bINavNodeArray.length);
        String[] stringArray = new String[bINavNodeArray.length];
        int n = 0;
        while (n < bINavNodeArray.length) {
            BINavNode bINavNode = bINavNodeArray[n];
            String string = bINavNode.getNavName();
            if (this.byName.get(string) != bINavNode) {
                throw new IllegalStateException("children at " + n + " not in getNavChildren()");
            }
            arrayList.add(bINavNode);
            stringArray[n] = string;
            ++n;
        }
        this.byOrder = arrayList;
        this.fireNavEvent(NavEvent.makeReordered(this, stringArray, null));
    }

    protected void fireNavEvent(NavEvent navEvent) {
        BNavRoot.INSTANCE.fireNavEvent(navEvent);
    }

    public String toString(Context context) {
        return this.name;
    }

    public void spy(SpyWriter spyWriter) throws Exception {
        super.spy(spyWriter);
        spyWriter.startProps();
        spyWriter.trTitle("NavContainer", 2);
        spyWriter.prop((Object)"navName", this.getNavName());
        spyWriter.prop((Object)"navDisplayName", this.getNavDisplayName(null));
        spyWriter.prop((Object)"navOrd", this.getNavOrd());
        spyWriter.endProps();
        BINavNode[] bINavNodeArray = this.getNavChildren();
        if (bINavNodeArray != null && bINavNodeArray.length > 0) {
            spyWriter.startTable(false);
            spyWriter.trTitle("Children", 1);
            int n = 0;
            while (n < bINavNodeArray.length) {
                BObject bObject = (BObject)((Object)bINavNodeArray[n]);
                if (bObject == null) {
                    spyWriter.tr("ERROR NULL");
                } else {
                    String string = bINavNodeArray[n].getNavName();
                    spyWriter.tr("<a href='" + SlotPath.escape(string) + "'>" + string + "</a> [" + bObject.getType() + "] " + bObject.toString());
                }
                ++n;
            }
            spyWriter.endTable();
        }
    }

    public static BINavNode[] filter(BINavNode[] bINavNodeArray, Context context) {
        try {
            if (context == null || context.getUser() == null) {
                return bINavNodeArray;
            }
            Class clazz = class$javax$baja$nav$BINavNode;
            if (clazz == null) {
                clazz = class$javax$baja$nav$BINavNode = BNavContainer.class("[Ljavax.baja.nav.BINavNode;", false);
            }
            Array array = new Array(clazz, bINavNodeArray.length);
            int n = 0;
            while (n < bINavNodeArray.length) {
                BPermissions bPermissions;
                BINavNode bINavNode = bINavNodeArray[n];
                if (!(bINavNode instanceof BIProtected) || (bPermissions = ((BIProtected)((Object)bINavNode)).getPermissions(context)).has(1)) {
                    array.add((Object)bINavNode);
                }
                ++n;
            }
            return (BINavNode[])array.trim();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return bINavNodeArray;
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.byOrder = new ArrayList();
        this.byName = new HashMap();
    }

    public BNavContainer(String string, LexiconText lexiconText) {
        this.this();
        this.name = string;
        this.lexText = lexiconText;
    }

    public BNavContainer(String string) {
        this.this();
        this.name = string;
    }

    static {
        Class clazz = class$javax$baja$nav$BNavContainer;
        if (clazz == null) {
            clazz = class$javax$baja$nav$BNavContainer = BNavContainer.class("[Ljavax.baja.nav.BNavContainer;", false);
        }
        TYPE = Sys.loadType(clazz);
    }
}

