/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.naming;

import javax.baja.file.FilePath;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.ViewQuery;
import javax.baja.security.BIProtected;
import javax.baja.security.BPermissions;
import javax.baja.space.BSpace;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIPropertyContainer;
import javax.baja.sys.BObject;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.user.BUser;

public class OrdTarget
implements Context {
    BUser user;
    String lang;
    BFacets facets;
    OrdTarget base;
    BOrd ord;
    OrdQuery[] queries;
    BObject object;
    BPermissions permissions;
    BIPropertyContainer container;
    boolean isTargetReadonly;
    Slot slot;
    Property[] propertyPath;
    boolean mergedSlotFacets;

    public static OrdTarget unmounted(BObject bObject) {
        return OrdTarget.unmounted(bObject, null);
    }

    public static OrdTarget unmounted(BObject bObject, Context context) {
        return new OrdTarget(context, BOrd.NULL, new OrdQuery[0], bObject);
    }

    public BUser getUser() {
        return this.user;
    }

    public String getLanguage() {
        return this.lang;
    }

    public BFacets getFacets() {
        if (!(this.propertyPath == null && this.slot == null || this.mergedSlotFacets || this.container == null)) {
            BFacets bFacets = BFacets.NULL;
            if (this.propertyPath != null) {
                BObject bObject = (BObject)((Object)this.container);
                boolean bl = true;
                int n = 0;
                while (n < this.propertyPath.length) {
                    Property property = this.propertyPath[n];
                    bFacets = BFacets.make(bl ? ((BIPropertyContainer)((Object)bObject)).getSlotFacets(property) : bObject.asComplex().getSlotFacets(property), bFacets);
                    bObject = bl ? ((BIPropertyContainer)((Object)bObject)).get(property) : bObject.asComplex().get(property);
                    bl = bObject instanceof BIPropertyContainer;
                    ++n;
                }
            } else {
                bFacets = BFacets.make(this.container.getSlotFacets(this.slot), bFacets);
            }
            this.facets = BFacets.make(bFacets, this.facets);
            this.mergedSlotFacets = true;
        }
        return this.facets;
    }

    public BObject getFacet(String string) {
        return this.getFacets().get(string);
    }

    public Context getBase() {
        return this.base;
    }

    public OrdTarget getBaseOrdTarget() {
        return this.base;
    }

    public BOrd getOrd() {
        return this.ord;
    }

    public BSpace getSpace() {
        OrdTarget ordTarget = this;
        while (ordTarget != null) {
            BComponent bComponent;
            BSpace bSpace = BOrd.toSpace(this.object);
            if (bSpace == null && (bComponent = this.getComponent()) != null) {
                bSpace = bComponent.getSpace();
            }
            if (bSpace != null) {
                return bSpace;
            }
            ordTarget = ordTarget.getBaseOrdTarget();
        }
        return null;
    }

    public BObject get() {
        return this.object;
    }

    public BComponent getComponent() {
        BComponent bComponent;
        if (this.container instanceof BComponent) {
            return (BComponent)this.container;
        }
        if (this.object.isComponent()) {
            return this.object.asComponent();
        }
        if (this.object.isComplex() && (bComponent = this.object.asComplex().getParentComponent()) != null) {
            return bComponent;
        }
        if (this.base != null) {
            return this.base.getComponent();
        }
        return null;
    }

    public BComplex getParent() {
        if (this.container instanceof BComplex && this.propertyPath != null) {
            BComplex bComplex = (BComplex)((Object)this.container);
            int n = 0;
            while (n < this.propertyPath.length - 1) {
                bComplex = (BComplex)bComplex.get(this.propertyPath[n]);
                ++n;
            }
            return bComplex;
        }
        if (this.base != null) {
            return this.base.getParent();
        }
        return null;
    }

    public Slot getSlotInComponent() {
        if (this.slot != null) {
            return this.slot;
        }
        if (!(this.base == null || this.container != null || this.object.isComponent() || this.object.isComplex() && this.object.asComplex().getParentComponent() != null)) {
            return this.base.getSlotInComponent();
        }
        return null;
    }

    public Property[] getPropertyPathInComponent() {
        if (this.propertyPath != null) {
            return this.propertyPath;
        }
        if (this.base != null) {
            return this.base.getPropertyPathInComponent();
        }
        return null;
    }

    public Property getPropertyInParent() {
        if (this.propertyPath != null) {
            return this.propertyPath[this.propertyPath.length - 1];
        }
        if (this.base != null) {
            return this.base.getPropertyInParent();
        }
        return null;
    }

    public BIProtected getSecurityTarget() {
        if (this.object instanceof BIProtected) {
            return (BIProtected)((Object)this.object);
        }
        if (this.container instanceof BIProtected) {
            return (BIProtected)((Object)this.container);
        }
        if (this.base != null) {
            return this.base.getSecurityTarget();
        }
        return null;
    }

    public BPermissions getPermissionsForTarget() {
        if (this.permissions == null) {
            BIProtected bIProtected = this.getSecurityTarget();
            this.permissions = bIProtected != null ? bIProtected.getPermissions(this) : BPermissions.all;
        }
        return this.permissions;
    }

    public boolean canRead() {
        BIProtected bIProtected = this.getSecurityTarget();
        if (bIProtected != null) {
            return bIProtected.canRead(this);
        }
        return true;
    }

    public boolean canWrite() {
        BIProtected bIProtected = this.getSecurityTarget();
        if (bIProtected != null) {
            return bIProtected.canWrite(this);
        }
        return true;
    }

    public boolean canInvoke() {
        BIProtected bIProtected = this.getSecurityTarget();
        if (bIProtected != null) {
            return bIProtected.canInvoke(this);
        }
        return true;
    }

    public int depth() {
        int n = 0;
        if (this.queries != null) {
            n = this.queries.length;
        }
        return n;
    }

    public OrdQuery queryAt(int n) {
        return this.queries[n];
    }

    public OrdQuery[] getOrdQueries() {
        return (OrdQuery[])this.queries.clone();
    }

    public FilePath getFilePath() {
        int n = this.queries.length - 1;
        while (n >= 0) {
            if (this.queries[n] instanceof FilePath) {
                return (FilePath)this.queries[n];
            }
            --n;
        }
        return null;
    }

    public String getFilePathFragment() {
        FilePath filePath = this.getFilePath();
        if (filePath != null) {
            return filePath.getFragment();
        }
        return null;
    }

    public ViewQuery getViewQuery() {
        int n = this.queries.length - 1;
        if (n >= 0 && this.queries[n] instanceof ViewQuery) {
            return (ViewQuery)this.queries[n];
        }
        return null;
    }

    public String getViewParameter(String string, String string2) {
        ViewQuery viewQuery = this.getViewQuery();
        if (viewQuery == null) {
            return string2;
        }
        return viewQuery.getParameter(string, string2);
    }

    public BOrd getOrdWithoutViewQuery() {
        if (this.getViewQuery() == null) {
            return this.ord;
        }
        return BOrd.make(this.queries, 0, this.queries.length - 1);
    }

    public String toString() {
        return this.ord + " -> " + this.object;
    }

    public void dump() {
        System.out.println(this.getClass().getName());
        System.out.println("  ord:         " + this.ord);
        System.out.println("  facets:      " + this.facets);
        System.out.println("  object:      " + this.object);
        System.out.println("  permissions: " + this.permissions);
        System.out.println("  container:   " + this.container);
        System.out.println("  readonly:    " + this.isTargetReadonly);
        System.out.println("  slot:        " + this.slot);
        System.out.println("  propPath:    " + (this.propertyPath == null ? "null" : "" + this.propertyPath.length));
        System.out.println("  component(): " + this.getComponent());
        System.out.println("  slot():      " + this.getSlotInComponent());
        System.out.println("  propPath():  " + (this.getPropertyPathInComponent() == null ? "null" : "" + this.getPropertyPathInComponent().length));
        if (this.base != null) {
            this.base.dump();
        }
    }

    public OrdTarget(OrdTarget ordTarget, BObject bObject) {
        this.base = ordTarget;
        this.user = ordTarget.user;
        this.lang = ordTarget.lang;
        this.facets = ordTarget.facets;
        this.ord = ordTarget.ord;
        this.queries = ordTarget.queries;
        if (bObject != null) {
            this.object = bObject;
        } else {
            this.object = ordTarget.object;
            this.permissions = ordTarget.permissions;
            this.container = ordTarget.container;
            this.isTargetReadonly = ordTarget.isTargetReadonly;
            this.slot = ordTarget.slot;
            this.propertyPath = ordTarget.propertyPath;
        }
    }

    public OrdTarget(OrdTarget ordTarget) {
        this(ordTarget, null);
    }

    OrdTarget(Context context, BOrd bOrd, OrdQuery[] ordQueryArray, BObject bObject) {
        BasicContext basicContext = new BasicContext(context);
        this.user = basicContext.getUser();
        this.lang = basicContext.getLanguage();
        this.facets = basicContext.getFacets();
        this.ord = bOrd;
        this.queries = ordQueryArray;
        this.object = bObject;
    }

    public OrdTarget(OrdTarget ordTarget, BComponent bComponent, BObject bObject, Slot slot, Property[] propertyArray) {
        this(ordTarget, (BIPropertyContainer)bComponent, bObject, slot, propertyArray);
    }

    OrdTarget(OrdTarget ordTarget, BIPropertyContainer bIPropertyContainer, BObject bObject, Slot slot, Property[] propertyArray) {
        this(ordTarget, bObject);
        this.container = bIPropertyContainer;
        this.object = bObject;
        this.slot = slot;
        this.propertyPath = propertyArray;
    }
}

