/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.naming;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.naming.BHost;
import javax.baja.naming.BIAlias;
import javax.baja.naming.BISession;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.BOrdScheme;
import javax.baja.naming.BasicQuery;
import javax.baja.naming.NullOrdException;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdQueryList;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.Path;
import javax.baja.naming.SyntaxException;
import javax.baja.naming.UnknownSchemeException;
import javax.baja.naming.UnresolvedException;
import javax.baja.naming.ViewQuery;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.space.BISpaceNode;
import javax.baja.space.BSpace;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIComparable;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BOrd
extends BSimple
implements BIComparable,
BIAlias {
    public static final BOrd NULL;
    public static final BOrd DEFAULT;
    public static final Type TYPE;
    int hashCode;
    String string;
    static /* synthetic */ Class class$javax$baja$naming$BOrd;
    static /* synthetic */ Class class$java$lang$String;

    public static final BOrd make(String string) {
        if (string.equals("null")) {
            return NULL;
        }
        return new BOrd(string);
    }

    public static final BOrd make(BOrd bOrd, BOrd bOrd2) {
        if (bOrd.toString().length() == 0) {
            return bOrd2;
        }
        if (bOrd2.toString().length() == 0) {
            return bOrd;
        }
        if (bOrd.isNull()) {
            throw new NullOrdException("base");
        }
        if (bOrd2.isNull()) {
            throw new NullOrdException("child");
        }
        return new BOrd(bOrd.string + '|' + bOrd2.string);
    }

    public static final BOrd make(BOrd bOrd, String string) {
        return BOrd.make(bOrd, BOrd.make(string));
    }

    public static final BOrd make(BOrd bOrd, OrdQuery ordQuery) {
        return BOrd.make(bOrd, BOrd.make(ordQuery));
    }

    public static final BOrd make(OrdQuery ordQuery) {
        return BOrd.make(new OrdQuery[]{ordQuery});
    }

    public static final BOrd make(OrdQuery[] ordQueryArray) {
        return BOrd.make(ordQueryArray, 0, ordQueryArray.length);
    }

    public static final BOrd make(OrdQuery[] ordQueryArray, int n, int n2) {
        if (n > n2) {
            throw new IllegalArgumentException("start > end");
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = n;
        while (n3 < n2) {
            OrdQuery ordQuery = ordQueryArray[n3];
            String string = ordQuery.getBody();
            if (n3 > n) {
                stringBuffer.append('|');
            }
            stringBuffer.append(ordQuery.getScheme()).append(':').append(ordQuery.getBody());
            ++n3;
        }
        return new BOrd(stringBuffer.toString());
    }

    public final BObject get() {
        return this.resolve(BLocalHost.INSTANCE, null).get();
    }

    public final BObject get(BObject bObject) {
        return this.resolve(bObject).get();
    }

    public final BObject get(BObject bObject, Context context) {
        return this.resolve(bObject, context).get();
    }

    public final OrdTarget resolve() {
        return this.resolve(BLocalHost.INSTANCE, null);
    }

    public final OrdTarget resolve(BObject bObject) {
        return this.resolve(bObject, null);
    }

    public final OrdTarget resolve(BObject bObject, Context context) throws NullOrdException, UnknownSchemeException, SyntaxException, UnresolvedException {
        if (bObject == null) {
            bObject = BLocalHost.INSTANCE;
        }
        OrdQuery[] ordQueryArray = this.parse();
        if (this.isNull() || ordQueryArray.length == 0) {
            throw new NullOrdException();
        }
        OrdQueryList ordQueryList = new OrdQueryList(ordQueryArray);
        while (BOrd.normalize(ordQueryList)) {
        }
        ordQueryArray = ordQueryList.toArray();
        OrdTarget ordTarget = new OrdTarget(context, this, ordQueryArray, bObject);
        int n = 0;
        while (n < ordQueryArray.length) {
            OrdQuery ordQuery = ordQueryArray[n];
            BOrdScheme bOrdScheme = BOrdScheme.lookup(ordQuery.getScheme());
            ordTarget = bOrdScheme.resolve(ordTarget, ordQuery);
            if (ordTarget == null) {
                throw new UnresolvedException(this.string);
            }
            ++n;
        }
        return ordTarget;
    }

    public static final BHost toHost(BObject bObject) {
        if (bObject instanceof BHost) {
            return (BHost)bObject;
        }
        if (bObject instanceof BISession) {
            return ((BISession)((Object)bObject)).getHost();
        }
        if (bObject instanceof BSpace) {
            return ((BSpace)bObject).getHost();
        }
        if (bObject instanceof BISpaceNode) {
            return ((BISpaceNode)((Object)bObject)).getHost();
        }
        return null;
    }

    public static final BISession toSession(BObject bObject) {
        if (bObject instanceof BISession) {
            return (BISession)((Object)bObject);
        }
        if (bObject instanceof BSpace) {
            return ((BSpace)bObject).getSession();
        }
        if (bObject instanceof BISpaceNode) {
            return ((BISpaceNode)((Object)bObject)).getSession();
        }
        return null;
    }

    public static final BSpace toSpace(BObject bObject) {
        if (bObject instanceof BSpace) {
            return (BSpace)bObject;
        }
        if (bObject instanceof BISpaceNode) {
            return ((BISpaceNode)((Object)bObject)).getSpace();
        }
        return null;
    }

    public final OrdQuery[] parse() {
        if (this.isNull()) {
            throw new NullOrdException();
        }
        OrdQuery[] ordQueryArray = new OrdQuery[32];
        int n = 0;
        String string = this.string;
        int n2 = string.length();
        int n3 = 0;
        int n4 = 0;
        int n5 = -1;
        int n6 = 0;
        while (n6 < n2) {
            char c = string.charAt(n6);
            if (c < ' ') {
                throw new SyntaxException("Invalid ord char 0x" + Integer.toHexString(c));
            }
            if (c == ' ') {
                if (n6 == n3) {
                    n3 = n6 + 1;
                }
            } else if (c == '|') {
                ordQueryArray[n++] = BOrd.parse(string, n3, n4, n5);
                n3 = n6 + 1;
                n4 = n6 + 1;
                n5 = -1;
            } else {
                if (c == ':' && n5 < 0) {
                    n5 = n6;
                }
                n4 = n6;
            }
            ++n6;
        }
        if (n3 < n2) {
            ordQueryArray[n++] = BOrd.parse(string, n3, n4, n5);
        }
        OrdQuery[] ordQueryArray2 = new OrdQuery[n];
        System.arraycopy(ordQueryArray, 0, ordQueryArray2, 0, n);
        return ordQueryArray2;
    }

    static final OrdQuery parse(String string, int n, int n2, int n3) {
        if (n3 < 0) {
            throw new SyntaxException("Missing scheme name: " + string);
        }
        String string2 = string.substring(n, n3);
        String string3 = string.substring(n3 + 1, n2 + 1);
        return BOrd.parse(string2, string3);
    }

    public static final OrdQuery parse(String string, String string2) {
        string = TextUtil.toLowerCase((String)string);
        string2 = string2.trim();
        try {
            return BOrdScheme.lookup(string).parse(string2);
        }
        catch (UnknownSchemeException unknownSchemeException) {
            return new BasicQuery(string, string2);
        }
        catch (SyntaxException syntaxException) {
            throw syntaxException;
        }
        catch (Throwable throwable) {
            throw new SyntaxException(throwable);
        }
    }

    public final BOrd getParent() {
        OrdQuery[] ordQueryArray = this.parse();
        int n = ordQueryArray.length - 1;
        if (n >= ordQueryArray.length || n < 0) {
            return null;
        }
        OrdQuery ordQuery = ordQueryArray[n];
        if (ordQuery instanceof ViewQuery) {
            if (--n >= ordQueryArray.length || n < 0) {
                return null;
            }
            ordQuery = ordQueryArray[n];
        }
        if (!(ordQuery instanceof Path)) {
            return null;
        }
        Path path = (Path)((Object)ordQuery);
        Path path2 = path.getParentPath();
        if (path2 == null) {
            return null;
        }
        ordQueryArray[n] = (OrdQuery)((Object)path2);
        return BOrd.make(ordQueryArray, 0, n + 1);
    }

    public final BOrd normalize() {
        OrdQueryList ordQueryList = new OrdQueryList(this.parse());
        while (BOrd.normalize(ordQueryList)) {
        }
        int n = 0;
        while (n < ordQueryList.size()) {
            BOrdScheme.lookup(ordQueryList.get(n).getScheme());
            ++n;
        }
        return BOrd.make(ordQueryList.toArray());
    }

    public final BOrd relativizeToHost() {
        OrdQueryList ordQueryList = new OrdQueryList(this.parse());
        while (BOrd.normalize(ordQueryList)) {
        }
        int n = ordQueryList.size() - 1;
        while (n >= 0) {
            if (ordQueryList.get(n).isHost()) {
                ordQueryList.trim(n + 1);
                break;
            }
            --n;
        }
        return BOrd.make(ordQueryList.toArray());
    }

    public final BOrd relativizeToSession() {
        OrdQueryList ordQueryList = new OrdQueryList(this.parse());
        while (BOrd.normalize(ordQueryList)) {
        }
        int n = ordQueryList.size() - 1;
        while (n >= 0) {
            if (ordQueryList.get(n).isHost() || ordQueryList.get(n).isSession()) {
                ordQueryList.trim(n + 1);
                break;
            }
            --n;
        }
        return BOrd.make(ordQueryList.toArray());
    }

    private static final boolean normalize(OrdQueryList ordQueryList) {
        ordQueryList.modified = false;
        int n = ordQueryList.size();
        int n2 = 0;
        while (n2 < n) {
            OrdQuery ordQuery = ordQueryList.get(n2);
            ordQuery.normalize(ordQueryList, n2);
            if (ordQueryList.modified) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public final BOrd substitute(BFacets bFacets) throws Exception {
        final BFacets bFacets2 = bFacets;
        final StringBuffer stringBuffer = new StringBuffer();
        this.scanForVariables(new Scanner(){

            public final void handleVariable(String string) {
                String string2 = bFacets2.gets(string, null);
                if (string2 == null) {
                    stringBuffer.append("$(").append(string).append(")");
                } else {
                    stringBuffer.append(string2);
                }
            }

            public final void appendChar(char c) {
                stringBuffer.append(c);
            }
        });
        return BOrd.make(stringBuffer.toString());
    }

    public final boolean hasVariables() {
        final boolean[] blArray = new boolean[]{false};
        this.scanForVariables(new Scanner(){

            public final void handleVariable(String string) {
                blArray[0] = true;
            }

            public final void appendChar(char c) {
            }
        });
        return blArray[0];
    }

    public final String[] getVariables() {
        Class clazz = class$java$lang$String;
        if (clazz == null) {
            clazz = class$java$lang$String = BOrd.class("[Ljava.lang.String;", false);
        }
        final Array array = new Array(clazz);
        this.scanForVariables(new Scanner(){

            public final void handleVariable(String string) {
                array.add((Object)string);
            }

            public final void appendChar(char c) {
            }
        });
        return (String[])array.trim();
    }

    private final void scanForVariables(Scanner scanner) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.string.length();
        int n2 = 0;
        while (n2 < n) {
            int n3;
            char c = this.string.charAt(n2);
            int n4 = n3 = n2 < n - 1 ? (int)this.string.charAt(n2 + 1) : -1;
            if (c == '$' && n3 == 40) {
                stringBuffer.setLength(0);
                if ((n2 += 2) >= n) {
                    throw new SyntaxException("Missing closing paren");
                }
                c = this.string.charAt(n2);
                while (c != ')') {
                    if (n2 >= n - 1) {
                        throw new SyntaxException("Missing closing paren");
                    }
                    boolean bl = false;
                    if (c >= 'A' && c <= 'Z') {
                        bl = true;
                    } else if (c >= 'a' && c <= 'z') {
                        bl = true;
                    } else if (c >= '0' && c <= '9') {
                        bl = true;
                    }
                    if (!bl) {
                        throw new SyntaxException("Illegal character in variable name: '" + (char)c + '\'');
                    }
                    stringBuffer.append(c);
                    c = this.string.charAt(++n2);
                }
                String string = stringBuffer.toString();
                if (string.length() == 0) {
                    throw new SyntaxException("Empty variable name");
                }
                scanner.handleVariable(string);
            } else {
                scanner.appendChar(c);
            }
            ++n2;
        }
    }

    public final BOrd getSubOrd(int n) {
        OrdQuery[] ordQueryArray = this.parse();
        return BOrd.make(ordQueryArray, n, ordQueryArray.length);
    }

    public final BOrd getSubOrd(int n, int n2) {
        OrdQuery[] ordQueryArray = this.parse();
        return BOrd.make(ordQueryArray, n, n2);
    }

    public final BOrd getOrd() {
        return this;
    }

    public final boolean isNull() {
        boolean bl = false;
        if (this == NULL) {
            bl = true;
        }
        return bl;
    }

    public final int hashCode() {
        if (this.hashCode == -1) {
            this.hashCode = TextUtil.toLowerCase((String)this.string).hashCode();
        }
        return this.hashCode;
    }

    public final boolean equals(Object object) {
        if (object instanceof BOrd) {
            return this.string.equals(((BOrd)object).string);
        }
        return false;
    }

    public final int compareTo(Object object) {
        return this.string.compareTo(((BOrd)object).string);
    }

    public final String toString(Context context) {
        return this.string;
    }

    public final void encode(DataOutput dataOutput) throws IOException {
        dataOutput.writeUTF(this.string);
    }

    public final BObject decode(DataInput dataInput) throws IOException {
        return BOrd.make(dataInput.readUTF());
    }

    public final String encodeToString() {
        return this.string;
    }

    public final BObject decodeFromString(String string) throws IOException {
        return BOrd.make(string);
    }

    public final Type getType() {
        return TYPE;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.hashCode = -1;
    }

    private BOrd(String string) {
        this.this();
        this.string = string;
    }

    static {
        DEFAULT = NULL = new BOrd("null");
        Class clazz = class$javax$baja$naming$BOrd;
        if (clazz == null) {
            clazz = class$javax$baja$naming$BOrd = BOrd.class("[Ljavax.baja.naming.BOrd;", false);
        }
        TYPE = Sys.loadType(clazz);
    }

    private static interface Scanner {
        public void handleVariable(String var1);

        public void appendChar(char var1);
    }
}

