/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.naming;

import com.tridium.sys.module.BModuleTypesContainer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdScheme;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SyntaxException;
import javax.baja.naming.UnresolvedException;
import javax.baja.sys.BModule;
import javax.baja.sys.BModuleSpace;
import javax.baja.sys.BObject;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BModuleScheme
extends BOrdScheme {
    public static final BModuleScheme INSTANCE = new BModuleScheme();
    public static final Type TYPE;
    public static final String moduleDevPropName = "niagara.module.dev";
    public static final String moduleDevFileName = "moduledev.properties";
    static /* synthetic */ Class class$javax$baja$naming$BModuleScheme;

    public OrdQuery parse(String string) {
        return new FilePath("module", string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OrdTarget resolve(OrdTarget ordTarget, OrdQuery ordQuery) throws SyntaxException, UnresolvedException {
        Object object;
        FilePath filePath = (FilePath)ordQuery;
        if (filePath.getBody().equals("")) {
            return new OrdTarget(ordTarget, BModuleSpace.INSTANCE);
        }
        if (!filePath.isAuthorityAbsolute()) {
            throw new UnresolvedException("Modules must be authority absolute");
        }
        BModule bModule = Sys.loadModule(filePath.getAuthority());
        if (filePath.depth() == 0) {
            return new OrdTarget(ordTarget, bModule);
        }
        if (filePath.depth() == 1) {
            if (filePath.getName().equals("types")) {
                return new OrdTarget(ordTarget, BModuleTypesContainer.get(bModule));
            }
        } else if (filePath.depth() == 2 && (object = filePath.getNames())[0].equals("types")) {
            return new OrdTarget(ordTarget, (BObject)((Object)BModuleTypesContainer.get(bModule).getNavChild(object[1])));
        }
        if (System.getProperty(moduleDevPropName, "false").equals("true") && this.isModuleDevSupported(filePath)) {
            object = Log.getLog(moduleDevPropName);
            InputStream inputStream = null;
            try {
                block18: {
                    OrdTarget ordTarget2;
                    try {
                        File file = new File(Sys.getBajaHome(), "lib/moduledev.properties");
                        if (!file.exists()) break block18;
                        inputStream = new FileInputStream(file);
                        Properties properties = new Properties();
                        properties.load(inputStream);
                        String string = properties.getProperty(filePath.getAuthority());
                        if (string == null) break block18;
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("/");
                        stringBuffer.append(string);
                        stringBuffer.append("/src");
                        stringBuffer.append(filePath.getBody().substring(filePath.getAuthority().length() + 2, filePath.getBody().length()));
                        String string2 = stringBuffer.toString();
                        ((Log)object).message("Accessing Module Dev File: " + string2);
                        BIFile bIFile = (BIFile)((Object)BOrd.make(new FilePath(string2)).get());
                        ordTarget2 = new OrdTarget(ordTarget, (BObject)((Object)bIFile));
                        Object var8_16 = null;
                    }
                    catch (IOException iOException) {
                        String string = "Error accessing module dev resource: " + ordQuery;
                        ((Log)object).error(string, iOException);
                        throw new UnresolvedException(string, iOException);
                    }
                    try {
                        if (inputStream == null) return ordTarget2;
                        inputStream.close();
                        return ordTarget2;
                    }
                    catch (Exception exception) {}
                    return ordTarget2;
                }
                Object var8_18 = null;
            }
            catch (Throwable throwable) {
                Object var8_17 = null;
                try {}
                catch (Exception exception) {}
                if (inputStream == null) throw throwable;
                inputStream.close();
                throw throwable;
                throw throwable;
            }
            try {}
            catch (Exception exception) {}
            if (inputStream != null) {
                inputStream.close();
            }
        }
        object = bModule.resolveFile(filePath);
        return new OrdTarget(ordTarget, (BObject)object);
    }

    public Type getType() {
        return TYPE;
    }

    private final boolean isModuleDevSupported(FilePath filePath) {
        String string = filePath.toString().toLowerCase();
        boolean bl = false;
        if (string.endsWith(".js") || string.endsWith(".css") || string.endsWith(".vm") || string.endsWith(".htm") || string.endsWith(".html")) {
            bl = true;
        }
        return bl;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private BModuleScheme() {
        super("module");
    }

    static {
        Class clazz = class$javax$baja$naming$BModuleScheme;
        if (clazz == null) {
            clazz = class$javax$baja$naming$BModuleScheme = BModuleScheme.class("[Ljavax.baja.naming.BModuleScheme;", false);
        }
        TYPE = Sys.loadType(clazz);
        if (System.getProperty(moduleDevPropName, "false").equals("true")) {
            System.out.println("*** Module Dev Mode Enabled: this should NOT be enabled for a release/production environment! ***");
        }
    }
}

