/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.log;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.baja.log.ConsoleLogHandler;
import javax.baja.log.LogHandler;
import javax.baja.log.LogRecord;
import javax.baja.nre.util.SortUtil;

public final class Log {
    public static final int NONE = 4;
    public static final int ERROR = 3;
    public static final int WARNING = 2;
    public static final int MESSAGE = 1;
    public static final int TRACE = 0;
    private static LogHandler handler = new ConsoleLogHandler();
    private static Hashtable logs = new Hashtable();
    private static Properties props;
    private String logName;
    private int maxSeverity;

    public static final String severityToString(int n) {
        switch (n) {
            case 0: {
                return "trace";
            }
            case 1: {
                return "message";
            }
            case 2: {
                return "warning";
            }
            case 3: {
                return "error";
            }
            case 4: {
                return "none";
            }
        }
        throw new IllegalArgumentException();
    }

    public static final int severityFromString(String string) {
        if (string.equals("trace")) {
            return 0;
        }
        if (string.equals("message")) {
            return 1;
        }
        if (string.equals("warning")) {
            return 2;
        }
        if (string.equals("error")) {
            return 3;
        }
        if (string.equals("none")) {
            return 4;
        }
        throw new IllegalArgumentException();
    }

    public static final synchronized Log[] getLogs() {
        Object[] objectArray = new Log[logs.size()];
        Object[] objectArray2 = new String[objectArray.length];
        Enumeration enumeration = logs.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            objectArray[n] = (Log)enumeration.nextElement();
            objectArray2[n] = ((Log)objectArray[n]).getLogName().toLowerCase();
            ++n;
        }
        SortUtil.sort((Object[])objectArray2, (Object[])objectArray);
        return objectArray;
    }

    public static final void save() {
        try {
            PrintWriter printWriter = new PrintWriter(new FileWriter(Log.getLogFile()));
            printWriter.println("#");
            printWriter.println("# Log file saved: " + new Date());
            printWriter.println("# Property values must be: 'trace', 'message', 'warning', or 'error'");
            printWriter.println("#");
            Log[] logArray = Log.getLogs();
            int n = 0;
            while (n < logArray.length) {
                printWriter.println(logArray[n].getLogName() + '=' + Log.severityToString(logArray[n].getSeverity()));
                ++n;
            }
            printWriter.close();
        }
        catch (IOException iOException) {
            System.out.println("ERROR: Canot save 'log.properties'");
            System.out.println("  " + iOException);
        }
    }

    public static final synchronized Log getLog(String string) {
        Log log = (Log)logs.get(string);
        if (log != null) {
            return log;
        }
        log = new Log(string, Log.getDefaultSeverity(string));
        logs.put(string, log);
        return log;
    }

    public static final synchronized void deleteLog(String string) {
        logs.remove(string);
    }

    private static final int getDefaultSeverity(String string) {
        Object object;
        if (props == null) {
            props = new Properties();
            try {
                object = new FileInputStream(Log.getLogFile());
                props.load((InputStream)object);
                ((InputStream)object).close();
            }
            catch (Exception exception) {}
        }
        if ((object = props.getProperty(string)) != null) {
            try {
                return Log.severityFromString((String)object);
            }
            catch (RuntimeException runtimeException) {}
        }
        return 1;
    }

    public static final File getLogFile() {
        return new File(System.getProperty("baja.home") + File.separator + "lib" + File.separator + "log.properties");
    }

    public final String getLogName() {
        return this.logName;
    }

    public final boolean isLoggable(int n) {
        boolean bl = false;
        if (n >= this.maxSeverity) {
            bl = true;
        }
        return bl;
    }

    public final boolean isTraceOn() {
        boolean bl = false;
        if (this.maxSeverity <= 0) {
            bl = true;
        }
        return bl;
    }

    public final int getSeverity() {
        return this.maxSeverity;
    }

    public final String getSeverityString() {
        return Log.severityToString(this.maxSeverity);
    }

    public final void setSeverity(int n) {
        this.maxSeverity = n;
    }

    public final void error(String string) {
        this.log(3, string, null);
    }

    public final void error(String string, Throwable throwable) {
        this.log(3, string, throwable);
    }

    public final void warning(String string) {
        this.log(2, string, null);
    }

    public final void warning(String string, Throwable throwable) {
        this.log(2, string, throwable);
    }

    public final void message(String string) {
        this.log(1, string, null);
    }

    public final void message(String string, Throwable throwable) {
        this.log(1, string, throwable);
    }

    public final void trace(String string) {
        this.log(0, string, null);
    }

    public final void trace(String string, Throwable throwable) {
        this.log(0, string, throwable);
    }

    public final void trace(byte[] byArray) {
        this.log(0, "", null, byArray, 0, byArray.length);
    }

    public final void trace(byte[] byArray, int n, int n2) {
        this.log(0, "", null, byArray, n, n2);
    }

    public final void trace(String string, byte[] byArray) {
        this.log(0, string, null, byArray, 0, byArray.length);
    }

    public final void trace(String string, byte[] byArray, int n, int n2) {
        this.log(0, string, null, byArray, n, n2);
    }

    public final void log(int n, String string, Throwable throwable) {
        if (this.isLoggable(n)) {
            handler.publish(new LogRecord(this.logName, n, string, throwable));
        }
    }

    public final void log(int n, String string, Throwable throwable, byte[] byArray) {
        this.log(n, string, throwable, byArray, 0, byArray.length);
    }

    public final void log(int n, String string, Throwable throwable, byte[] byArray, int n2, int n3) {
        if (this.isLoggable(n)) {
            byte[] byArray2 = new byte[n3];
            System.arraycopy(byArray, n2, byArray2, 0, n3);
            handler.publish(new LogRecord(this.logName, n, string, throwable, byArray2));
        }
    }

    public static final LogHandler install(LogHandler logHandler) {
        LogHandler logHandler2 = handler;
        handler = logHandler;
        return logHandler2;
    }

    private Log(String string, int n) {
        this.logName = string;
        this.maxSeverity = n;
    }
}

