/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.job;

import com.tridium.util.ThrowableUtil;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.Context;
import javax.baja.util.BFormat;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class JobLogItem {
    public static final int MESSAGE = 0;
    public static final int RUNNING = 1;
    public static final int CANCELED = 2;
    public static final int SUCCESS = 3;
    public static final int FAILED = 4;
    private static final String[] IDS = new String[]{"Message", "Running", "Canceled", "Success", "Failed"};
    private DateFormat format;
    int id;
    BAbsTime timestamp;
    String message;
    String details;

    public final int getId() {
        return this.id;
    }

    public final String getIdString() {
        return this.getIdString(null);
    }

    public final String getIdStringPattern() {
        return IDS[this.id];
    }

    public final String getIdString(Context context) {
        return Lexicon.make("baja", context).get(IDS[this.id].toLowerCase());
    }

    public final BAbsTime getTimestamp() {
        return this.timestamp;
    }

    public final String getMessage() {
        return this.getMessage(null);
    }

    public final String getMessagePattern() {
        return this.message;
    }

    public final String getMessage(Context context) {
        return BFormat.format(this.message, this, context);
    }

    public final String getDetails() {
        return this.getDetails(null);
    }

    public final String getDetailsPattern() {
        return this.details;
    }

    public final String getDetails(Context context) {
        if (this.details == null) {
            return null;
        }
        return BFormat.format(this.details, this, context);
    }

    public final String toString() {
        return this.toString(null);
    }

    public final String toString(Context context) {
        String string = this.getIdString(context) + " [" + this.format.format(new Date(this.timestamp.getMillis())) + "] " + this.getMessage(context);
        if (this.details != null) {
            string = string + '\n' + this.getDetails(context);
        }
        return string;
    }

    public final String encode() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(IDS[this.id]).append('|').append(this.timestamp.encodeToString()).append('|').append(JobLogItem.escape(this.message)).append('|').append(JobLogItem.escape(this.details == null ? "" : this.details));
        return stringBuffer.toString();
    }

    public static final JobLogItem decode(String string) throws Exception {
        String[] stringArray = JobLogItem.unescape(string);
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        String string4 = stringArray[2];
        String string5 = stringArray[3];
        int n = 0;
        int n2 = 0;
        while (n2 < IDS.length) {
            if (string2.equals(IDS[n2])) {
                n = n2;
                break;
            }
            ++n2;
        }
        BAbsTime bAbsTime = (BAbsTime)BAbsTime.DEFAULT.decodeFromString(string3);
        return new JobLogItem(n, bAbsTime, string4, string5);
    }

    static final String escape(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '\\') {
                stringBuffer.append("\\\\");
            } else if (c == '|') {
                stringBuffer.append("\\|");
            } else if (c == '\n') {
                stringBuffer.append("\\n");
            } else {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    static final String[] unescape(String string) {
        String[] stringArray = new String[10];
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = 0;
        while (n2 < string.length()) {
            char c = string.charAt(n2);
            if (c == '\\') {
                if ((c = string.charAt(++n2)) == 'n') {
                    stringBuffer.append('\n');
                } else {
                    stringBuffer.append(c);
                }
            } else if (c == '|') {
                stringArray[n++] = stringBuffer.toString();
                stringBuffer = new StringBuffer();
            } else {
                stringBuffer.append(c);
            }
            ++n2;
        }
        stringArray[n++] = stringBuffer.toString();
        return stringArray;
    }

    private final /* synthetic */ void this() {
        this.format = new SimpleDateFormat("HH:mm:ss dd-MMM-yy");
    }

    public JobLogItem(int n, BAbsTime bAbsTime, String string, String string2) {
        this.this();
        if (n < 0 || n >= IDS.length || string == null) {
            throw new IllegalArgumentException();
        }
        if (string2 != null && string2.length() == 0) {
            string2 = null;
        }
        this.id = n;
        this.timestamp = bAbsTime;
        this.message = string;
        this.details = string2;
    }

    public JobLogItem(int n, String string, Throwable throwable) {
        this(n, BAbsTime.make(), string, ThrowableUtil.dumpToString(throwable));
    }

    public JobLogItem(int n, String string, String string2, String[] stringArray, Throwable throwable) {
        this(n, BAbsTime.make(), BFormat.getLexiconPattern(string, string2, stringArray), ThrowableUtil.dumpToString(throwable));
    }

    public JobLogItem(int n, String string, String string2) {
        this(n, BAbsTime.make(), string, string2);
    }

    public JobLogItem(int n, String string, String string2, String[] stringArray, String string3) {
        this(n, BAbsTime.make(), BFormat.getLexiconPattern(string, string2, stringArray), string3);
    }

    public JobLogItem(int n, String string) {
        this(n, BAbsTime.make(), string, null);
    }

    public JobLogItem(int n, String string, String string2, String[] stringArray) {
        this(n, BAbsTime.make(), BFormat.getLexiconPattern(string, string2, stringArray), null);
    }
}

