/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.job;

import javax.baja.job.BJobService;
import javax.baja.job.BJobState;
import javax.baja.job.JobCancelException;
import javax.baja.job.JobLog;
import javax.baja.job.JobLogItem;
import javax.baja.naming.BOrd;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BJob
extends BComponent {
    public static final Property jobState = BJob.newProperty(3, BJobState.unknown, null);
    public static final Property progress = BJob.newProperty(3, -1, null);
    public static final Property startTime = BJob.newProperty(1, BAbsTime.NULL, null);
    public static final Property heartbeatTime = BJob.newProperty(1, BAbsTime.NULL, null);
    public static final Property endTime = BJob.newProperty(1, BAbsTime.NULL, null);
    public static final Action cancel = BJob.newAction(0, null);
    public static final Action dispose = BJob.newAction(0, null);
    public static final Action readLog = BJob.newAction(0, null);
    public static final Type TYPE;
    private static final BIcon icon;
    JobLog log;
    static /* synthetic */ Class class$javax$baja$job$BJob;

    public BJobState getJobState() {
        return (BJobState)this.get(jobState);
    }

    public void setJobState(BJobState bJobState) {
        this.set(jobState, (BValue)bJobState, null);
    }

    public int getProgress() {
        return this.getInt(progress);
    }

    public void setProgress(int n) {
        this.setInt(progress, n, null);
    }

    public BAbsTime getStartTime() {
        return (BAbsTime)this.get(startTime);
    }

    public void setStartTime(BAbsTime bAbsTime) {
        this.set(startTime, (BValue)bAbsTime, null);
    }

    public BAbsTime getHeartbeatTime() {
        return (BAbsTime)this.get(heartbeatTime);
    }

    public void setHeartbeatTime(BAbsTime bAbsTime) {
        this.set(heartbeatTime, (BValue)bAbsTime, null);
    }

    public BAbsTime getEndTime() {
        return (BAbsTime)this.get(endTime);
    }

    public void setEndTime(BAbsTime bAbsTime) {
        this.set(endTime, (BValue)bAbsTime, null);
    }

    public void cancel() {
        this.invoke(cancel, null, null);
    }

    public void dispose() {
        this.invoke(dispose, null, null);
    }

    public BString readLog() {
        return (BString)this.invoke(readLog, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BOrd submit(Context context) {
        return BJobService.getService().submit(this, context);
    }

    public void doSubmit(Context context) {
        this.setJobState(BJobState.running);
        this.setStartTime(Clock.time());
        this.setProgress(-1);
        this.resetLog();
        try {
            this.doRun(context);
        }
        catch (Throwable throwable) {
            this.failed(throwable);
        }
    }

    public boolean isAlive() {
        boolean bl = false;
        if (this.getJobState() == BJobState.running) {
            bl = true;
        }
        return bl;
    }

    public abstract void doRun(Context var1) throws Exception;

    public abstract void doCancel(Context var1) throws Exception;

    public void doDispose(Context context) {
        if (this.getJobState().isRunning()) {
            throw new IllegalStateException("Cannot dispose while running");
        }
        this.setJobState(BJobState.unknown);
        if (this.getParent() != null) {
            ((BComponent)this.getParent()).remove(this);
        }
    }

    public String toString(Context context) {
        String string = this.getType().getDisplayName(null);
        if (string.endsWith(" Job")) {
            string = string.substring(0, string.length() - 4);
        }
        return string;
    }

    public void progress(int n) {
        this.setProgress(n);
        this.heartbeat();
    }

    public void heartbeat() {
        this.setHeartbeatTime(Clock.time());
    }

    public void success() {
        this.log().success("Job Success");
        this.complete(BJobState.success);
    }

    public void canceled() {
        this.log().add(new JobLogItem(2, "Job Canceled"));
        this.complete(BJobState.canceled);
    }

    public void failed(Throwable throwable) {
        if (this.getJobState() == BJobState.canceling || throwable instanceof InterruptedException || throwable instanceof JobCancelException) {
            this.canceled();
            return;
        }
        this.log().failed("Job Failed", throwable);
        this.complete(BJobState.failed);
    }

    public void complete(BJobState bJobState) {
        if (!bJobState.isComplete()) {
            throw new IllegalArgumentException("Cannot complete as " + bJobState);
        }
        this.setJobState(bJobState);
        this.setProgress(100);
        this.setEndTime(Clock.time());
    }

    public JobLog log() {
        return this.log;
    }

    public BString doReadLog() {
        return BString.make(this.log.encode());
    }

    public void resetLog() {
        this.log = new JobLog();
    }

    public void spy(SpyWriter spyWriter) throws Exception {
        super.spy(spyWriter);
        spyWriter.w("<hr><pre>").w(this.readLog()).w("</pre>");
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.log = new JobLog();
    }

    public BJob() {
        this.this();
    }

    static {
        Class clazz = class$javax$baja$job$BJob;
        if (clazz == null) {
            clazz = class$javax$baja$job$BJob = BJob.class("[Ljavax.baja.job.BJob;", false);
        }
        TYPE = Sys.loadType(clazz);
        icon = BIcon.std("build.png");
    }
}

