/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.io;

import com.tridium.sys.schema.ComponentSlotMap;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import javax.baja.category.BCategoryMask;
import javax.baja.io.BIContextEncodable;
import javax.baja.log.Log;
import javax.baja.naming.SlotPath;
import javax.baja.registry.TypeInfo;
import javax.baja.security.BPermissions;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFloat;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLink;
import javax.baja.sys.BLong;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.virtual.BVirtualComponentSpace;
import javax.baja.xml.XWriter;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ValueDocEncoder {
    private static final int SECURITY_INACCESSIBLE = 1;
    private static final int SECURITY_READONLY = 2;
    private static final Log log = Log.getLog("sys.xml");
    private static TypeInfo nullProxyExt = null;
    private boolean encodeTransients;
    private boolean encodeComments;
    private Context context;
    private HashMap permissionsCache;
    protected final IEncoderPlugin plugin;

    public static final String marshal(BValue bValue) throws IOException {
        return BogEncoderPlugin.marshal(bValue);
    }

    public Context getContext() {
        return this.context;
    }

    public static final Context getMergedContext(BComplex bComplex, Slot slot, Context context) {
        BFacets bFacets = bComplex.getSlotFacets(slot);
        if (context == null) {
            context = bFacets;
        } else if (bFacets != null && !bFacets.isNull()) {
            context = new BasicContext(context, bFacets);
        }
        if (bComplex.isStruct() && bComplex.getParent() != null) {
            return ValueDocEncoder.getMergedContext(bComplex.getParent(), bComplex.getPropertyInParent(), context);
        }
        return context;
    }

    public boolean isSyncEncoder() {
        return false;
    }

    public boolean isEncodeTransients() {
        return this.encodeTransients;
    }

    public boolean setEncodeTransients(boolean bl) {
        boolean bl2 = this.encodeTransients;
        this.encodeTransients = bl;
        return bl2;
    }

    public boolean isEncodeComments() {
        return this.encodeComments;
    }

    public boolean setEncodeComments(boolean bl) {
        boolean bl2 = this.encodeComments;
        this.encodeComments = bl;
        return bl2;
    }

    public final IEncoderPlugin getPlugin() {
        return this.plugin;
    }

    public void encodeDocument(BValue bValue) throws IOException {
        this.plugin.encodeDocument(this, bValue);
        this.plugin.flush();
    }

    public void encode(BValue bValue) throws IOException {
        this.encode(null, bValue, Integer.MAX_VALUE);
    }

    public void encode(String string, BValue bValue, int n) throws IOException {
        Object object;
        Object object2;
        BPermissions bPermissions = BPermissions.all;
        if (this.context != null && this.context != Context.encrypt && bValue.isComponent() && !(bPermissions = this.getPermissionsFor(bValue.asComponent())).hasOperatorRead()) {
            throw new SecurityException("Missing op read permission on value");
        }
        this.plugin.start("p");
        if (string != null) {
            this.wname(string);
        }
        if (bValue.isComponent()) {
            BCategoryMask bCategoryMask;
            object2 = (BComponent)bValue;
            object = ((BComponent)object2).getHandle();
            if (object != null) {
                this.whandle(object);
            }
            if (!(bCategoryMask = ((BComponent)object2).getCategoryMask()).isNull()) {
                this.wcategories(bCategoryMask);
            }
            if (((BComponent)object2).getComponentSpace() instanceof BVirtualComponentSpace && !((ComponentSlotMap)((BObject)object2).fw(1)).isBrokerPropsLoaded()) {
                this.plugin.attr("stub", true);
            }
        }
        this.wtype(bValue);
        object2 = this.getContext();
        if (bValue.isComplex() && bValue.asComplex().getParent() != null) {
            object = bValue.asComplex();
            object2 = ValueDocEncoder.getMergedContext(((BComplex)object).getParent(), ((BComplex)object).getPropertyInParent(), this.getContext());
        }
        this.encodeValue(bValue, n, bPermissions, (Context)object2);
    }

    public final void flush() throws IOException {
        this.plugin.flush();
    }

    public final void close() throws IOException {
        this.plugin.close();
    }

    public final IEncoderPlugin start(String string) throws IOException {
        return this.plugin.start(string);
    }

    public final IEncoderPlugin startArray(String string) throws IOException {
        return this.plugin.startArray(string);
    }

    public final IEncoderPlugin endArray() throws IOException {
        return this.plugin.endArray();
    }

    public final IEncoderPlugin end() throws IOException {
        return this.plugin.end();
    }

    public final IEncoderPlugin end(String string) throws IOException {
        return this.plugin.end(string);
    }

    public final IEncoderPlugin endAttr() throws IOException {
        return this.plugin.endAttr();
    }

    public final IEncoderPlugin key(String string) throws IOException {
        return this.plugin.key(string);
    }

    public final IEncoderPlugin attr(String string, boolean bl) throws IOException {
        return this.plugin.attr(string, bl);
    }

    public final IEncoderPlugin attr(String string, double d) throws IOException {
        return this.plugin.attr(string, d);
    }

    public final IEncoderPlugin attr(String string, String string2) throws IOException {
        return this.plugin.attr(string, string2);
    }

    public final IEncoderPlugin attrSafe(String string, String string2) throws IOException {
        return this.plugin.attrSafe(string, string2);
    }

    public final IEncoderPlugin comment(String string) throws IOException {
        return this.plugin.comment(string);
    }

    public final IEncoderPlugin incrementIndent() throws IOException {
        return this.plugin.incrementIndent();
    }

    public final IEncoderPlugin decrementIndent() throws IOException {
        return this.plugin.decrementIndent();
    }

    public final IEncoderPlugin indent() throws IOException {
        return this.plugin.indent();
    }

    public final int getIndent() {
        return this.plugin.getIndent();
    }

    public final IEncoderPlugin newLine() throws IOException {
        return this.plugin.newLine();
    }

    public boolean isZipped() {
        return this.plugin.isZipped();
    }

    public void setZipped(boolean bl) throws IOException {
        this.plugin.setZipped(bl);
    }

    protected void encodingComponent(BComponent bComponent) throws IOException {
    }

    protected void encodingComponentStub(BComponent bComponent) throws IOException {
    }

    protected void encodingValue(BValue bValue, Context context) throws IOException {
    }

    protected void encodingSlot(BComplex bComplex, Slot slot) throws IOException {
    }

    protected void encodingFacets(BFacets bFacets) throws IOException {
    }

    private final void encodeSlot(BComplex bComplex, Slot slot, int n, BPermissions bPermissions) throws IOException {
        Object object;
        int n2;
        if (slot == null) {
            return;
        }
        int n3 = bComplex.getFlags(slot);
        boolean bl = false;
        if (!this.encodeTransients && (n3 & 2) != 0) {
            if (slot.isProperty() && slot.isFrozen() && n3 != slot.getDefaultFlags()) {
                bl = true;
            } else {
                return;
            }
        }
        Property property = null;
        BObject bObject = null;
        boolean bl2 = false;
        if (slot.isProperty() && !bl) {
            property = (Property)slot;
            if (this.encodePrimitive(bComplex, property, n3)) {
                return;
            }
            bObject = bComplex.get(property);
            if (slot.isFrozen()) {
                if (bObject.isComponent()) {
                    boolean bl3 = false;
                    if (!this.isSyncEncoder() && ((BValue)bObject).getType().getTypeInfo() == nullProxyExt) {
                        bl3 = true;
                    }
                    bl2 = bl3;
                } else {
                    bl2 = property.isEquivalentToDefaultValue((BValue)bObject);
                }
            } else {
                bl2 = false;
            }
        } else {
            bl2 = true;
        }
        if (this.context != null && this.context != Context.encrypt) {
            n2 = this.getSecurityMask(bPermissions, slot, (BValue)bObject, n3);
            if ((n2 & 1) != 0) {
                if (slot.isFrozen()) {
                    n3 |= 4;
                } else {
                    return;
                }
            }
            if ((n2 & 2) != 0) {
                n3 |= 1;
            }
        }
        if (bObject != null && bObject.isSimple() && this.isTypeBlackListed(((BValue)bObject).getType())) {
            if (slot.isFrozen()) {
                n3 |= 4;
            } else {
                return;
            }
        }
        if (n3 == slot.getDefaultFlags() && bl2) {
            return;
        }
        int n4 = 0;
        if (slot.isDynamic() && bObject instanceof BComponent) {
            n4 = 1;
        }
        n2 = n4;
        this.plugin.indent();
        if (n2 != 0 && this.encodeComments && (object = ((BComponent)bObject).getSlotPath()) != null) {
            this.plugin.comment(((SlotPath)object).getBody());
            this.plugin.indent();
        }
        if (slot.isProperty()) {
            this.plugin.start("p");
        } else if (slot.isAction()) {
            this.plugin.start("a");
        } else if (slot.isTopic()) {
            this.plugin.start("t");
        } else {
            throw new IllegalStateException();
        }
        this.wname(slot.getName());
        this.encodingSlot(bComplex, slot);
        if ((slot.isDynamic() && n3 != 0 || n3 != slot.getDefaultFlags()) && bComplex.isComponent()) {
            this.wflags(n3);
        }
        object = slot.getFacets();
        if (slot.isDynamic() && !((BFacets)object).isNull()) {
            this.wfacets((BFacets)object);
        }
        if (bObject instanceof BComponent) {
            BCategoryMask bCategoryMask;
            BComponent bComponent = (BComponent)bObject;
            Object object2 = bComponent.getHandle();
            if (object2 != null) {
                this.whandle(object2);
            }
            if (!(bCategoryMask = bComponent.getCategoryMask()).isNull()) {
                this.wcategories(bCategoryMask);
            }
            if (n == 0 || bComponent.getComponentSpace() instanceof BVirtualComponentSpace && !((ComponentSlotMap)bComponent.fw(1)).isBrokerPropsLoaded()) {
                this.plugin.attr("stub", true);
            }
        }
        if (property != null && !bl2) {
            this.wtype(bObject);
            this.encodeValue((BValue)bObject, n - 1, bPermissions, ValueDocEncoder.getMergedContext(bComplex, property, this.getContext()));
        } else {
            this.plugin.end().newLine();
        }
    }

    private final boolean encodePrimitive(BComplex bComplex, Property property, int n) throws IOException {
        if (property.isDynamic() || n != property.getDefaultFlags()) {
            return false;
        }
        if (property.getTypeAccess() == 7) {
            return false;
        }
        if (this.isSyncEncoder()) {
            return false;
        }
        String string = null;
        boolean bl = false;
        switch (property.getTypeAccess()) {
            case 0: {
                boolean bl2 = bComplex.getBoolean(property);
                if (bl2 == ((BBoolean)property.getDefaultValue()).getBoolean()) {
                    return true;
                }
                string = BBoolean.encode(bl2);
                break;
            }
            case 2: {
                int n2 = bComplex.getInt(property);
                if (n2 == ((BInteger)property.getDefaultValue()).getInt()) {
                    return true;
                }
                string = BInteger.encode(n2);
                break;
            }
            case 3: {
                long l = bComplex.getLong(property);
                if (l == ((BLong)property.getDefaultValue()).getLong()) {
                    return true;
                }
                string = BLong.encode(l);
                break;
            }
            case 4: {
                float f = bComplex.getFloat(property);
                if (f == ((BFloat)property.getDefaultValue()).getFloat()) {
                    return true;
                }
                string = BFloat.encode(f);
                break;
            }
            case 5: {
                double d = bComplex.getDouble(property);
                if (d == ((BDouble)property.getDefaultValue()).getDouble()) {
                    return true;
                }
                string = BDouble.encode(d);
                break;
            }
            case 6: {
                string = bComplex.getString(property);
                bl = true;
                if (string != ((BString)property.getDefaultValue()).getString()) break;
                return true;
            }
            default: {
                throw new IllegalStateException("" + property.getTypeAccess());
            }
        }
        this.plugin.indent().start("p");
        this.wname(property.getName());
        if (bl) {
            this.plugin.attrSafe("v", string);
        } else {
            this.plugin.attr("v", string);
        }
        this.encodingValue(bComplex.get(property), ValueDocEncoder.getMergedContext(bComplex, property, this.getContext()));
        this.plugin.end().newLine();
        return true;
    }

    private final void encodeValue(BValue bValue, int n, BPermissions bPermissions, Context context) throws IOException {
        this.encodingValue(bValue, context);
        if (this.isTypeBlackListed(bValue.getType()) && bValue.isSimple()) {
            bValue = (BValue)bValue.getType().getInstance();
        }
        if (bValue.isSimple()) {
            this.wvalue((BSimple)bValue);
            this.plugin.end().newLine();
        } else if (bValue.isComponent() && n < 0) {
            this.plugin.endAttr();
            this.encodingComponentStub((BComponent)bValue);
            this.plugin.end("p").newLine();
        } else {
            if (bValue.isComponent()) {
                bPermissions = this.getPermissionsFor(bValue.asComponent());
            }
            if (this.encodeStructValue(bValue)) {
                return;
            }
            this.plugin.endAttr().newLine().incrementIndent();
            BComplex bComplex = (BComplex)bValue;
            SlotCursor slotCursor = bComplex.getSlots();
            boolean bl = true;
            while (slotCursor.next()) {
                if (bl) {
                    this.plugin.startArray("s");
                    bl = false;
                }
                this.encodeSlot(bComplex, slotCursor.slot(), n, bPermissions);
            }
            if (!bl) {
                this.plugin.endArray();
            }
            if (bComplex.isComponent()) {
                this.encodingComponent(bComplex.asComponent());
            }
            this.plugin.decrementIndent().indent().end("p").newLine();
        }
    }

    private final boolean encodeStructValue(BValue bValue) throws IOException {
        if (bValue instanceof BStatusValue) {
            return this.encodeStatusValue(bValue);
        }
        if (bValue instanceof BLink) {
            return this.encodeLink(bValue);
        }
        return false;
    }

    private final boolean encodeLink(BValue bValue) throws IOException {
        if (bValue.getType() != BLink.TYPE) {
            return false;
        }
        BLink bLink = (BLink)bValue;
        this.plugin.endAttr().startArray("s");
        this.plugin.start("p").attr("n", "sourceOrd").attrSafe("v", bLink.getSourceOrd().encodeToString());
        this.encodingSlot(bLink, BLink.sourceOrd);
        this.encodingValue(bLink.getSourceOrd(), ValueDocEncoder.getMergedContext(bLink, BLink.sourceOrd, this.getContext()));
        this.plugin.end();
        this.plugin.start("p").attr("n", "sourceSlotName").attrSafe("v", bLink.getSourceSlotName());
        this.encodingSlot(bLink, BLink.sourceSlotName);
        this.encodingValue(bLink.get(BLink.sourceSlotName), ValueDocEncoder.getMergedContext(bLink, BLink.sourceSlotName, this.getContext()));
        this.plugin.end();
        this.plugin.start("p").attr("n", "targetSlotName").attrSafe("v", bLink.getTargetSlotName());
        this.encodingSlot(bLink, BLink.targetSlotName);
        this.encodingValue(bLink.get(BLink.targetSlotName), ValueDocEncoder.getMergedContext(bLink, BLink.targetSlotName, this.getContext()));
        this.plugin.end();
        if (!bLink.getEnabled()) {
            this.plugin.start("p").attr("n", "enabled").attr("v", false);
            this.encodingSlot(bLink, BLink.enabled);
            this.encodingValue(bLink.get(BLink.enabled), ValueDocEncoder.getMergedContext(bLink, BLink.enabled, this.getContext()));
            this.plugin.end();
        }
        this.plugin.endArray().end("p").newLine();
        return true;
    }

    private final boolean encodeStatusValue(BValue bValue) throws IOException {
        BStatus bStatus = null;
        if (bValue.getType() == BStatusNumeric.TYPE) {
            BStatusNumeric bStatusNumeric = (BStatusNumeric)bValue;
            this.plugin.endAttr().startArray("s").start("p").attr("n", "value").attr("v", BDouble.encode(bStatusNumeric.getValue()));
            this.encodingSlot(bStatusNumeric, BStatusNumeric.value);
            this.encodingValue(bStatusNumeric.get(BStatusNumeric.value), ValueDocEncoder.getMergedContext(bStatusNumeric, BStatusNumeric.value, this.getContext()));
            this.plugin.end();
            bStatus = bStatusNumeric.getStatus();
        } else if (bValue.getType() == BStatusBoolean.TYPE) {
            BStatusBoolean bStatusBoolean = (BStatusBoolean)bValue;
            this.plugin.endAttr().startArray("s").start("p").attr("n", "value").attr("v", BBoolean.encode(bStatusBoolean.getValue()));
            this.encodingSlot(bStatusBoolean, BStatusBoolean.value);
            this.encodingValue(bStatusBoolean.get(BStatusBoolean.value), ValueDocEncoder.getMergedContext(bStatusBoolean, BStatusBoolean.value, this.getContext()));
            this.plugin.end();
            bStatus = bStatusBoolean.getStatus();
        } else if (bValue.getType() == BStatusEnum.TYPE) {
            BStatusEnum bStatusEnum = (BStatusEnum)bValue;
            this.plugin.endAttr().startArray("s").start("p").attr("n", "value").attr("v", bStatusEnum.getValue().encodeToString());
            this.encodingSlot(bStatusEnum, BStatusEnum.value);
            this.encodingValue(bStatusEnum.get(BStatusEnum.value), ValueDocEncoder.getMergedContext(bStatusEnum, BStatusEnum.value, this.getContext()));
            this.plugin.end();
            bStatus = bStatusEnum.getStatus();
        } else if (bValue.getType() == BStatusString.TYPE) {
            BStatusString bStatusString = (BStatusString)bValue;
            this.plugin.endAttr().startArray("s").start("p").attr("n", "value").attrSafe("v", bStatusString.getValue());
            this.encodingSlot(bStatusString, BStatusString.value);
            this.encodingValue(bStatusString.get(BStatusString.value), ValueDocEncoder.getMergedContext(bStatusString, BStatusString.value, this.getContext()));
            this.plugin.end();
            bStatus = bStatusString.getStatus();
        } else {
            return false;
        }
        if (!bStatus.equals(BStatus.DEFAULT)) {
            this.plugin.start("p").attr("n", "status").attrSafe("v", bStatus.encodeToString());
            this.encodingSlot(bValue.asComplex(), BStatusValue.status);
            this.encodingValue(bStatus, ValueDocEncoder.getMergedContext(bValue.asComplex(), BStatusValue.status, this.getContext()));
            this.plugin.end();
        }
        this.plugin.endArray().end("p").newLine();
        return true;
    }

    public BPermissions getPermissionsFor(BComponent bComponent) {
        BPermissions bPermissions;
        if (this.context == null) {
            return BPermissions.all;
        }
        BUser bUser = this.context.getUser();
        if (bUser == null) {
            return BPermissions.all;
        }
        if (this.permissionsCache == null) {
            this.permissionsCache = new HashMap();
        }
        if ((bPermissions = (BPermissions)this.permissionsCache.get(bComponent)) == null) {
            bPermissions = bComponent.getPermissions(this.context);
            this.permissionsCache.put(bComponent, bPermissions);
        }
        return bPermissions;
    }

    private final int getSecurityMask(BPermissions bPermissions, Slot slot, BValue bValue, int n) {
        boolean bl = false;
        boolean bl2 = false;
        if (slot.isProperty() && bValue.isComponent()) {
            if (!this.getPermissionsFor(bValue.asComponent()).has(BPermissions.operatorRead)) {
                bl = true;
            }
        } else if (slot.isAction()) {
            if ((n & 0x100) != 0) {
                if (!bPermissions.has(BPermissions.operatorInvoke)) {
                    bl = true;
                }
            } else if (!bPermissions.has(BPermissions.adminInvoke)) {
                bl = true;
            }
        } else if ((n & 0x100) != 0) {
            if (!bPermissions.has(BPermissions.operatorRead)) {
                bl = true;
            } else if (!bPermissions.has(BPermissions.operatorWrite)) {
                bl2 = true;
            }
        } else if (!bPermissions.has(BPermissions.adminRead)) {
            bl = true;
        } else if (!bPermissions.has(BPermissions.adminWrite)) {
            bl2 = true;
        }
        int n2 = 0;
        if (bl) {
            n2 |= 1;
        }
        if (bl2) {
            n2 |= 2;
        }
        return n2;
    }

    private final ValueDocEncoder wname(String string) throws IOException {
        this.plugin.attr("n", string);
        return this;
    }

    private final ValueDocEncoder wtype(BObject bObject) throws IOException {
        this.plugin.encodeType(bObject.getType());
        return this;
    }

    private final ValueDocEncoder wtype(Type type) throws IOException {
        this.plugin.encodeType(type);
        return this;
    }

    private final ValueDocEncoder wflags(int n) throws IOException {
        this.plugin.attr("f", Flags.encodeToString(n));
        return this;
    }

    private final ValueDocEncoder whandle(Object object) throws IOException {
        this.plugin.attr("h", object.toString());
        return this;
    }

    private final ValueDocEncoder wcategories(BCategoryMask bCategoryMask) throws IOException {
        this.plugin.attr("c", bCategoryMask.encodeToString());
        return this;
    }

    private final ValueDocEncoder wfacets(BFacets bFacets) throws IOException {
        this.encodingFacets(bFacets);
        this.plugin.attrSafe("x", bFacets.encodeToString());
        return this;
    }

    private final ValueDocEncoder wvalue(BSimple bSimple) throws IOException {
        try {
            String string = this.encodeSimple(bSimple);
            this.plugin.attrSafe("v", string);
        }
        catch (Exception exception) {
            String string = "?";
            try {
                string = bSimple.toString();
            }
            catch (Exception exception2) {}
            log.error("Encoding " + bSimple.getType() + " \"" + string + '\"', exception);
            this.plugin.attr("err", bSimple.getType() + ".encodeToString()");
        }
        return this;
    }

    protected String encodeSimple(BSimple bSimple) throws IOException {
        if (bSimple instanceof BIContextEncodable) {
            return ((BIContextEncodable)((Object)bSimple)).encodeToString(this.context);
        }
        return bSimple.encodeToString();
    }

    public boolean isTypeBlackListed(Type type) {
        return false;
    }

    private final /* synthetic */ void this() {
        this.encodeComments = true;
    }

    public ValueDocEncoder(IEncoderPlugin iEncoderPlugin) throws IOException {
        this.this();
        this.plugin = iEncoderPlugin;
    }

    public ValueDocEncoder(IEncoderPlugin iEncoderPlugin, Context context) throws IOException {
        this.this();
        this.plugin = iEncoderPlugin;
        this.context = context;
    }

    public ValueDocEncoder(File file) throws IOException {
        this(new BogEncoderPlugin(file));
    }

    public ValueDocEncoder(OutputStream outputStream) throws IOException {
        this(new BogEncoderPlugin(outputStream));
    }

    public ValueDocEncoder(File file, Context context) throws IOException {
        this(new BogEncoderPlugin(file), context);
    }

    public ValueDocEncoder(OutputStream outputStream, Context context) throws IOException {
        this(new BogEncoderPlugin(outputStream), context);
    }

    static {
        try {
            nullProxyExt = Sys.getRegistry().getType("control:NullProxyExt");
        }
        catch (Exception exception) {}
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static final class BogEncoderPlugin
    implements IEncoderPlugin {
        protected int indent;
        private XWriter w;
        private HashMap modules;
        private HashMap keys;

        public final IEncoderPlugin encodeDocument(ValueDocEncoder valueDocEncoder, BValue bValue) throws IOException {
            this.w.w((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            this.w.w((Object)"<bajaObjectGraph version=\"1.0\">\n");
            valueDocEncoder.encode(bValue);
            this.w.w((Object)"</bajaObjectGraph>\n");
            return this;
        }

        public final IEncoderPlugin start(String string) throws IOException {
            this.w.w((Object)"<").w((Object)string);
            return this;
        }

        public final IEncoderPlugin startArray(String string) throws IOException {
            return this;
        }

        public final IEncoderPlugin endArray() throws IOException {
            return this;
        }

        public final IEncoderPlugin end() throws IOException {
            this.w.w((Object)"/>");
            return this;
        }

        public final IEncoderPlugin end(String string) throws IOException {
            this.w.w((Object)"</").w((Object)string).w((Object)">");
            return this;
        }

        public final IEncoderPlugin endAttr() throws IOException {
            this.w.w((Object)">");
            return this;
        }

        public final IEncoderPlugin newLine() throws IOException {
            this.w.w((Object)"\n");
            return this;
        }

        public final IEncoderPlugin key(String string) throws IOException {
            return this;
        }

        public final IEncoderPlugin attr(String string, boolean bl) throws IOException {
            this.attr(string, String.valueOf(bl));
            return this;
        }

        public final IEncoderPlugin attr(String string, double d) throws IOException {
            this.attr(string, String.valueOf(d));
            return this;
        }

        public final IEncoderPlugin attr(String string, String string2) throws IOException {
            this.w.w((Object)" ").w((Object)string).w((Object)"=\"").w((Object)string2).w((Object)"\"");
            return this;
        }

        public final IEncoderPlugin attrSafe(String string, String string2) throws IOException {
            this.w.w((Object)" ").w((Object)string).w((Object)"=\"").safe(string2).w((Object)"\"");
            return this;
        }

        public final IEncoderPlugin value(String string) throws IOException {
            return this;
        }

        public final IEncoderPlugin comment(String string) throws IOException {
            this.w.w((Object)"<!-- ").w((Object)string).w((Object)" -->\n");
            return this;
        }

        public final IEncoderPlugin incrementIndent() throws IOException {
            ++this.indent;
            return this;
        }

        public final IEncoderPlugin decrementIndent() throws IOException {
            --this.indent;
            return this;
        }

        public final IEncoderPlugin indent() throws IOException {
            this.w.indent(this.indent);
            return this;
        }

        public final int getIndent() {
            return this.indent;
        }

        public final IEncoderPlugin encodeType(Type type) throws IOException {
            BModule bModule = type.getModule();
            String string = (String)this.modules.get(bModule.getModuleName());
            if (string == null) {
                string = this.newModuleKey(bModule);
                this.attr("m", string + '=' + bModule.getModuleName());
            }
            this.attr("t", string + ':' + type.getTypeName());
            return this;
        }

        public final void flush() throws IOException {
            this.w.flush();
        }

        public final void close() throws IOException {
            this.w.close();
        }

        public final boolean isZipped() {
            return this.w.isZipped();
        }

        public final void setZipped(boolean bl) throws IOException {
            this.w.setZipped(bl);
        }

        private final String newModuleKey(BModule bModule) {
            String string = bModule.getPreferredSymbol();
            int n = 0;
            while (this.keys.get(string) != null) {
                string = "" + string.charAt(0) + n;
                ++n;
            }
            this.keys.put(string, string);
            this.modules.put(bModule.getModuleName(), string);
            return string;
        }

        public static final String marshal(BValue bValue) throws IOException {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ValueDocEncoder valueDocEncoder = new ValueDocEncoder(new BogEncoderPlugin(byteArrayOutputStream));
            valueDocEncoder.encode(bValue);
            valueDocEncoder.close();
            return new String(byteArrayOutputStream.toByteArray());
        }

        public final XWriter getWriter() {
            return this.w;
        }

        private final /* synthetic */ void this() {
            this.indent = 0;
            this.modules = new HashMap(33);
            this.keys = new HashMap(33);
        }

        public BogEncoderPlugin(File file) throws IOException {
            this.this();
            this.w = new XWriter(file);
        }

        public BogEncoderPlugin(OutputStream outputStream) throws IOException {
            this.this();
            this.w = new XWriter(outputStream);
        }
    }

    public static interface IEncoderPlugin {
        public IEncoderPlugin encodeDocument(ValueDocEncoder var1, BValue var2) throws IOException;

        public IEncoderPlugin start(String var1) throws IOException;

        public IEncoderPlugin startArray(String var1) throws IOException;

        public IEncoderPlugin endArray() throws IOException;

        public IEncoderPlugin end() throws IOException;

        public IEncoderPlugin end(String var1) throws IOException;

        public IEncoderPlugin endAttr() throws IOException;

        public IEncoderPlugin key(String var1) throws IOException;

        public IEncoderPlugin attr(String var1, boolean var2) throws IOException;

        public IEncoderPlugin attr(String var1, double var2) throws IOException;

        public IEncoderPlugin attr(String var1, String var2) throws IOException;

        public IEncoderPlugin attrSafe(String var1, String var2) throws IOException;

        public IEncoderPlugin value(String var1) throws IOException;

        public IEncoderPlugin comment(String var1) throws IOException;

        public IEncoderPlugin incrementIndent() throws IOException;

        public IEncoderPlugin decrementIndent() throws IOException;

        public IEncoderPlugin indent() throws IOException;

        public int getIndent();

        public IEncoderPlugin newLine() throws IOException;

        public IEncoderPlugin encodeType(Type var1) throws IOException;

        public void flush() throws IOException;

        public void close() throws IOException;

        public boolean isZipped();

        public void setZipped(boolean var1) throws IOException;
    }
}

