/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

public class RandomAccessFileInputStream
extends InputStream {
    private RandomAccessFile in;
    private long fp;

    public int available() throws IOException {
        long l = this.in.length() - this.fp;
        if (l > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)l;
    }

    public void close() {
    }

    public boolean markSupported() {
        return false;
    }

    public void seek(long l) {
        this.fp = l;
    }

    public int read() throws IOException {
        this.in.seek(this.fp);
        int n = this.in.read();
        ++this.fp;
        return n;
    }

    public int read(byte[] byArray) throws IOException {
        this.in.seek(this.fp);
        int n = this.in.read(byArray);
        this.fp = n != -1 ? (this.fp += (long)n) : this.in.length();
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.in.seek(this.fp);
        int n3 = this.in.read(byArray, n, n2);
        this.fp = n3 != -1 ? (this.fp += (long)n3) : this.in.length();
        return n3;
    }

    public RandomAccessFileInputStream(RandomAccessFile randomAccessFile) {
        this(randomAccessFile, 0L);
    }

    public RandomAccessFileInputStream(RandomAccessFile randomAccessFile, long l) {
        this.in = randomAccessFile;
        this.fp = l;
    }
}

