/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.io;

import com.tridium.sys.schema.ComponentSlotMap;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import javax.baja.category.BCategoryMask;
import javax.baja.io.BIContextEncodable;
import javax.baja.log.Log;
import javax.baja.naming.SlotPath;
import javax.baja.registry.TypeInfo;
import javax.baja.security.BPermissions;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFloat;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLink;
import javax.baja.sys.BLong;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.virtual.BVirtualComponentSpace;
import javax.baja.xml.XWriter;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BogEncoder
extends XWriter {
    static final int SECURITY_INACCESSIBLE = 1;
    static final int SECURITY_READONLY = 2;
    static final Log log = Log.getLog("sys.xml");
    static TypeInfo nullProxyExt = null;
    protected int indent;
    private boolean encodeTransients;
    private boolean encodeComments;
    private HashMap modules;
    private HashMap keys;
    private Context context;
    private HashMap permissionsCache;

    public static String marshal(BValue bValue) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BogEncoder bogEncoder = new BogEncoder(byteArrayOutputStream);
        bogEncoder.encode(bValue);
        bogEncoder.close();
        return new String(byteArrayOutputStream.toByteArray());
    }

    public Context getContext() {
        return this.context;
    }

    public boolean isSyncEncoder() {
        return false;
    }

    public boolean isEncodeTransients() {
        return this.encodeTransients;
    }

    public boolean setEncodeTransients(boolean bl) {
        boolean bl2 = this.encodeTransients;
        this.encodeTransients = bl;
        return bl2;
    }

    public boolean isEncodeComments() {
        return this.encodeComments;
    }

    public boolean setEncodeComments(boolean bl) {
        boolean bl2 = this.encodeComments;
        this.encodeComments = bl;
        return bl2;
    }

    public void encodeDocument(BValue bValue) throws IOException {
        this.w("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        this.w("<bajaObjectGraph version=\"1.0\">\n");
        this.encode(bValue);
        this.w("</bajaObjectGraph>\n");
        this.flush();
    }

    public void encode(BValue bValue) throws IOException {
        this.encode(null, bValue, Integer.MAX_VALUE);
    }

    public void encode(String string, BValue bValue, int n) throws IOException {
        BPermissions bPermissions = BPermissions.all;
        if (this.context != null && this.context != Context.encrypt && bValue.isComponent() && !(bPermissions = this.getPermissionsFor(bValue.asComponent())).hasOperatorRead()) {
            throw new SecurityException("Missing op read permission on value");
        }
        this.w("<p");
        if (string != null) {
            this.wname(string);
        }
        if (bValue.isComponent()) {
            BCategoryMask bCategoryMask;
            BComponent bComponent = (BComponent)bValue;
            Object object = bComponent.getHandle();
            if (object != null) {
                this.whandle(object);
            }
            if (!(bCategoryMask = bComponent.getCategoryMask()).isNull()) {
                this.wcategories(bCategoryMask);
            }
            if (bComponent.getComponentSpace() instanceof BVirtualComponentSpace && !((ComponentSlotMap)bComponent.fw(1)).isBrokerPropsLoaded()) {
                this.w(" stub=\"true\"");
            }
        }
        this.wtype(bValue);
        this.encodeValue(bValue, n, bPermissions);
    }

    protected void encodingComponent(BComponent bComponent) throws IOException {
    }

    protected void encodingComponentStub(BComponent bComponent) throws IOException {
    }

    private final void encodeSlot(BComplex bComplex, Slot slot, boolean bl, int n, BPermissions bPermissions) throws IOException {
        Object object;
        int n2;
        if (slot == null) {
            return;
        }
        if (slot.isProperty() && ((Property)slot).getType().isTransient()) {
            return;
        }
        int n3 = bComplex.getFlags(slot);
        boolean bl2 = false;
        if (!this.encodeTransients && (n3 & 2) != 0) {
            if (slot.isProperty() && slot.isFrozen() && n3 != slot.getDefaultFlags()) {
                bl2 = true;
            } else {
                return;
            }
        }
        Property property = null;
        BValue bValue = null;
        boolean bl3 = false;
        if (slot.isProperty() && !bl2) {
            property = (Property)slot;
            if (this.encodePrimitive(bComplex, property, n3)) {
                return;
            }
            bValue = bComplex.get(property);
            if (slot.isFrozen()) {
                if (bValue.isComponent()) {
                    boolean bl4 = false;
                    if (!this.isSyncEncoder() && bValue.getType().getTypeInfo() == nullProxyExt) {
                        bl4 = true;
                    }
                    bl3 = bl4;
                } else {
                    bl3 = property.isEquivalentToDefaultValue(bValue);
                }
            } else {
                bl3 = false;
            }
        } else {
            bl3 = true;
        }
        if (this.context != null && this.context != Context.encrypt) {
            n2 = this.getSecurityMask(bPermissions, slot, bValue, n3);
            if ((n2 & 1) != 0) {
                if (slot.isFrozen()) {
                    n3 |= 4;
                } else {
                    return;
                }
            }
            if ((n2 & 2) != 0) {
                n3 |= 1;
            }
        }
        if (n3 == slot.getDefaultFlags() && bl3) {
            return;
        }
        int n4 = 0;
        if (slot.isDynamic() && bValue instanceof BComponent) {
            n4 = 1;
        }
        n2 = n4;
        this.indent(this.indent);
        if (n2 != 0 && this.encodeComments && (object = ((BComponent)bValue).getSlotPath()) != null) {
            this.w("<!-- ").w((Object)((SlotPath)object).getBody()).w((Object)" -->\n");
            this.indent(this.indent);
        }
        if (slot.isProperty()) {
            this.w("<p");
        } else if (slot.isAction()) {
            this.w("<a");
        } else if (slot.isTopic()) {
            this.w("<t");
        } else {
            throw new IllegalStateException();
        }
        this.wname(slot.getName());
        if ((slot.isDynamic() && n3 != 0 || n3 != slot.getDefaultFlags()) && bComplex.isComponent()) {
            this.wflags(n3);
        }
        object = slot.getFacets();
        if (slot.isDynamic() && !((BFacets)object).isNull()) {
            this.wfacets((BFacets)object);
        }
        if (bValue instanceof BComponent) {
            BCategoryMask bCategoryMask;
            BComponent bComponent = (BComponent)bValue;
            Object object2 = bComponent.getHandle();
            if (object2 != null) {
                this.whandle(object2);
            }
            if (!(bCategoryMask = bComponent.getCategoryMask()).isNull()) {
                this.wcategories(bCategoryMask);
            }
            if (n == 0 || bComponent.getComponentSpace() instanceof BVirtualComponentSpace && !((ComponentSlotMap)bComponent.fw(1)).isBrokerPropsLoaded()) {
                this.w(" stub=\"true\"");
            }
        }
        if (property != null && !bl3) {
            if (property.isDynamic() || bl || !property.isTypeFinal()) {
                this.wtype(bValue);
            }
            this.encodeValue(bValue, n - 1, bPermissions);
        } else {
            this.w("/>\n");
        }
    }

    private final boolean encodePrimitive(BComplex bComplex, Property property, int n) throws IOException {
        if (property.isDynamic() || n != property.getDefaultFlags()) {
            return false;
        }
        if (property.getTypeAccess() == 7) {
            return false;
        }
        if (this.isSyncEncoder()) {
            return false;
        }
        String string = null;
        boolean bl = false;
        switch (property.getTypeAccess()) {
            case 0: {
                boolean bl2 = bComplex.getBoolean(property);
                if (bl2 == ((BBoolean)property.getDefaultValue()).getBoolean()) {
                    return true;
                }
                string = BBoolean.encode(bl2);
                break;
            }
            case 2: {
                int n2 = bComplex.getInt(property);
                if (n2 == ((BInteger)property.getDefaultValue()).getInt()) {
                    return true;
                }
                string = BInteger.encode(n2);
                break;
            }
            case 3: {
                long l = bComplex.getLong(property);
                if (l == ((BLong)property.getDefaultValue()).getLong()) {
                    return true;
                }
                string = BLong.encode(l);
                break;
            }
            case 4: {
                float f = bComplex.getFloat(property);
                if (f == ((BFloat)property.getDefaultValue()).getFloat()) {
                    return true;
                }
                string = BFloat.encode(f);
                break;
            }
            case 5: {
                double d = bComplex.getDouble(property);
                if (d == ((BDouble)property.getDefaultValue()).getDouble()) {
                    return true;
                }
                string = BDouble.encode(d);
                break;
            }
            case 6: {
                string = bComplex.getString(property);
                bl = true;
                if (string != ((BString)property.getDefaultValue()).getString()) break;
                return true;
            }
            default: {
                throw new IllegalStateException("" + property.getTypeAccess());
            }
        }
        this.indent(this.indent);
        this.w("<p");
        this.wname(property.getName());
        this.w(" v=\"");
        if (bl) {
            this.safe(string);
        } else {
            this.w(string);
        }
        this.w("\"/>\n");
        return true;
    }

    private final void encodeValue(BValue bValue, int n, BPermissions bPermissions) throws IOException {
        if (bValue.isSimple()) {
            this.wvalue((BSimple)bValue).w("/>\n");
        } else if (bValue.isComponent() && n < 0) {
            this.w(">");
            this.encodingComponentStub((BComponent)bValue);
            this.w("</p>\n");
        } else {
            if (bValue.isComponent()) {
                bPermissions = this.getPermissionsFor(bValue.asComponent());
            }
            if (this.encodeStructValue(bValue)) {
                return;
            }
            this.w(">\n");
            ++this.indent;
            BComplex bComplex = (BComplex)bValue;
            SlotCursor slotCursor = bComplex.getSlots();
            while (slotCursor.next()) {
                this.encodeSlot(bComplex, slotCursor.slot(), false, n, bPermissions);
            }
            if (bComplex.isComponent()) {
                this.encodingComponent(bComplex.asComponent());
            }
            --this.indent;
            this.indent(this.indent);
            this.w("</p>\n");
        }
    }

    private final boolean encodeStructValue(BValue bValue) throws IOException {
        if (bValue instanceof BStatusValue) {
            return this.encodeStatusValue(bValue);
        }
        if (bValue instanceof BLink) {
            return this.encodeLink(bValue);
        }
        return false;
    }

    private final boolean encodeLink(BValue bValue) throws IOException {
        if (bValue.getType() != BLink.TYPE) {
            return false;
        }
        BLink bLink = (BLink)bValue;
        this.w("><p n=\"sourceOrd\" v=\"").safe(bLink.getSourceOrd().encodeToString()).w((Object)"\"/><p n=\"sourceSlotName\" v=\"").safe(bLink.getSourceSlotName()).w((Object)"\"/><p n=\"targetSlotName\" v=\"").safe(bLink.getTargetSlotName()).w((Object)"\"/>");
        if (!bLink.getEnabled()) {
            this.w("<p n=\"enabled\" v=\"false\"/>");
        }
        this.w("</p>\n");
        return true;
    }

    private final boolean encodeStatusValue(BValue bValue) throws IOException {
        BStatus bStatus = null;
        if (bValue.getType() == BStatusNumeric.TYPE) {
            BStatusNumeric bStatusNumeric = (BStatusNumeric)bValue;
            this.w("><p n=\"value\" v=\"").w((Object)BDouble.encode(bStatusNumeric.getValue())).w((Object)"\"/>");
            bStatus = bStatusNumeric.getStatus();
        } else if (bValue.getType() == BStatusBoolean.TYPE) {
            BStatusBoolean bStatusBoolean = (BStatusBoolean)bValue;
            this.w("><p n=\"value\" v=\"").w((Object)BBoolean.encode(bStatusBoolean.getValue())).w((Object)"\"/>");
            bStatus = bStatusBoolean.getStatus();
        } else if (bValue.getType() == BStatusEnum.TYPE) {
            BStatusEnum bStatusEnum = (BStatusEnum)bValue;
            this.w("><p n=\"value\" v=\"").w((Object)bStatusEnum.getValue().encodeToString()).w((Object)"\"/>");
            bStatus = bStatusEnum.getStatus();
        } else if (bValue.getType() == BStatusString.TYPE) {
            BStatusString bStatusString = (BStatusString)bValue;
            this.w("><p n=\"value\" v=\"").safe(bStatusString.getValue()).w((Object)"\"/>");
            bStatus = bStatusString.getStatus();
        } else {
            return false;
        }
        if (!bStatus.equals(BStatus.DEFAULT)) {
            this.w("<p n=\"status\" v=\"").safe(bStatus.encodeToString()).w((Object)"\"/>");
        }
        this.w("</p>\n");
        return true;
    }

    public BPermissions getPermissionsFor(BComponent bComponent) {
        BPermissions bPermissions;
        if (this.context == null) {
            return BPermissions.all;
        }
        BUser bUser = this.context.getUser();
        if (bUser == null) {
            return BPermissions.all;
        }
        if (this.permissionsCache == null) {
            this.permissionsCache = new HashMap();
        }
        if ((bPermissions = (BPermissions)this.permissionsCache.get(bComponent)) == null) {
            bPermissions = bComponent.getPermissions(this.context);
            this.permissionsCache.put(bComponent, bPermissions);
        }
        return bPermissions;
    }

    private final int getSecurityMask(BPermissions bPermissions, Slot slot, BValue bValue, int n) {
        boolean bl = false;
        boolean bl2 = false;
        if (slot.isProperty() && bValue.isComponent()) {
            if (!this.getPermissionsFor(bValue.asComponent()).has(BPermissions.operatorRead)) {
                bl = true;
            }
        } else if (slot.isAction()) {
            if ((n & 0x100) != 0) {
                if (!bPermissions.has(BPermissions.operatorInvoke)) {
                    bl = true;
                }
            } else if (!bPermissions.has(BPermissions.adminInvoke)) {
                bl = true;
            }
        } else if ((n & 0x100) != 0) {
            if (!bPermissions.has(BPermissions.operatorRead)) {
                bl = true;
            } else if (!bPermissions.has(BPermissions.operatorWrite)) {
                bl2 = true;
            }
        } else if (!bPermissions.has(BPermissions.adminRead)) {
            bl = true;
        } else if (!bPermissions.has(BPermissions.adminWrite)) {
            bl2 = true;
        }
        int n2 = 0;
        if (bl) {
            n2 |= 1;
        }
        if (bl2) {
            n2 |= 2;
        }
        return n2;
    }

    private final BogEncoder wname(String string) throws IOException {
        this.w(" n=\"").w((Object)string).w('\"');
        return this;
    }

    private final BogEncoder wtype(BObject bObject) throws IOException {
        Type type = bObject.getType();
        BModule bModule = type.getModule();
        String string = this.getModuleKey(bModule);
        if (string == null) {
            string = this.newModuleKey(bModule);
            this.w(" m=\"").w((Object)string).w('=').w((Object)bModule.getModuleName()).w('\"');
        }
        this.w(" t=\"").w((Object)string).w(':').w((Object)type.getTypeName()).w('\"');
        return this;
    }

    private final BogEncoder wflags(int n) throws IOException {
        this.w(" f=\"").w((Object)Flags.encodeToString(n)).w('\"');
        return this;
    }

    private final BogEncoder whandle(Object object) throws IOException {
        this.w(" h=\"").w(object).w('\"');
        return this;
    }

    private final BogEncoder wcategories(BCategoryMask bCategoryMask) throws IOException {
        this.w(" c=\"").w((Object)bCategoryMask.encodeToString()).w('\"');
        return this;
    }

    private final BogEncoder wfacets(BFacets bFacets) throws IOException {
        this.w(" x=\"").safe(bFacets.encodeToString()).w('\"');
        return this;
    }

    private final BogEncoder wvalue(BSimple bSimple) throws IOException {
        try {
            String string = null;
            string = bSimple instanceof BIContextEncodable ? ((BIContextEncodable)((Object)bSimple)).encodeToString(this.context) : bSimple.encodeToString();
            this.w(" v=\"").safe(string).w('\"');
        }
        catch (Exception exception) {
            String string = "?";
            try {
                string = bSimple.toString();
            }
            catch (Exception exception2) {}
            log.error("Encoding " + bSimple.getType() + " \"" + string + '\"', exception);
            this.w(" err=\"" + bSimple.getType() + ".encodeToString()\"");
        }
        return this;
    }

    private final String getModuleKey(BModule bModule) {
        return (String)this.modules.get(bModule.getModuleName());
    }

    private final String newModuleKey(BModule bModule) {
        String string = bModule.getPreferredSymbol();
        int n = 0;
        while (this.keys.get(string) != null) {
            string = "" + string.charAt(0) + n;
            ++n;
        }
        this.keys.put(string, string);
        this.modules.put(bModule.getModuleName(), string);
        return string;
    }

    private final /* synthetic */ void this() {
        this.indent = 0;
        this.encodeComments = true;
        this.modules = new HashMap(33);
        this.keys = new HashMap(33);
    }

    public BogEncoder(File file) throws IOException {
        super(file);
        this.this();
    }

    public BogEncoder(OutputStream outputStream) throws IOException {
        super(outputStream);
        this.this();
    }

    public BogEncoder(File file, Context context) throws IOException {
        super(file);
        this.this();
        this.context = context;
    }

    public BogEncoder(OutputStream outputStream, Context context) throws IOException {
        super(outputStream);
        this.this();
        this.context = context;
    }

    static {
        try {
            nullProxyExt = Sys.getRegistry().getType("control:NullProxyExt");
        }
        catch (Exception exception) {}
    }
}

