/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.file;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.TimeZone;
import java.util.zip.CRC32;
import javax.baja.file.BIFile;
import javax.baja.file.BIFileStore;
import javax.baja.log.Log;
import javax.baja.nre.util.SortUtil;

public class FileUtil {
    static Log log = Log.getLog("sys.file");

    public static String getBase(String string) {
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf(46);
        if (n >= 1) {
            return string.substring(0, n);
        }
        return string;
    }

    public static String getExtension(String string) {
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf(46);
        if (n >= 1) {
            return string.substring(n + 1);
        }
        return null;
    }

    public static byte[] read(BIFileStore bIFileStore) throws IOException {
        return FileUtil.read(bIFileStore.getInputStream(), bIFileStore.getSize());
    }

    public static byte[] read(InputStream inputStream, long l) throws IOException {
        if (l < 0L || l > Integer.MAX_VALUE) {
            throw new IOException("Invalid size " + l);
        }
        int n = (int)l;
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            int n3 = inputStream.read(byArray, n2, n - n2);
            if (n3 < 0) {
                throw new IOException("Unexpected EOF");
            }
            n2 += n3;
        }
        inputStream.close();
        return byArray;
    }

    public static void write(BIFileStore bIFileStore, byte[] byArray) throws IOException {
        OutputStream outputStream = bIFileStore.getOutputStream();
        outputStream.write(byArray);
        outputStream.close();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void pipe(BIFile bIFile, BIFile bIFile2) throws IOException {
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            inputStream = bIFile.getInputStream();
            outputStream = bIFile2.getOutputStream();
            long l = bIFile.getSize();
            if (l >= 0L) {
                FileUtil.pipe(inputStream, l, outputStream);
            } else {
                FileUtil.pipe(inputStream, outputStream);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (outputStream == null) throw throwable;
                outputStream.close();
                throw throwable;
            }
            catch (Exception exception) {}
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        try {}
        catch (Exception exception) {}
        if (inputStream != null) {
            inputStream.close();
        }
        try {}
        catch (Exception exception) {
            return;
        }
        if (outputStream == null) return;
        outputStream.close();
    }

    public static void pipe(InputStream inputStream, long l, OutputStream outputStream) throws IOException {
        int n = 4096;
        byte[] byArray = new byte[n];
        while (l > 0L) {
            int n2 = inputStream.read(byArray, 0, (int)Math.min(l, (long)n));
            if (n2 <= 0) {
                throw new IOException("Unexpected EOF");
            }
            outputStream.write(byArray, 0, n2);
            l -= (long)n2;
        }
    }

    public static void pipe(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        int n2 = 4096;
        byte[] byArray = new byte[n2];
        while ((n = inputStream.read(byArray, 0, n2)) >= 0) {
            outputStream.write(byArray, 0, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getCrc(InputStream inputStream) throws IOException {
        long l;
        block3: {
            try {
                int n;
                byte[] byArray = new byte[4096];
                CRC32 cRC32 = new CRC32();
                while ((n = inputStream.read(byArray)) > 0) {
                    cRC32.update(byArray, 0, n);
                }
                l = cRC32.getValue();
                Object var2_5 = null;
                if (inputStream == null) break block3;
            }
            catch (Throwable throwable) {
                block4: {
                    Object var2_6 = null;
                    if (inputStream == null) break block4;
                    inputStream.close();
                }
                throw throwable;
            }
            inputStream.close();
        }
        return l;
    }

    public static File renameToBackup(File file, int n) {
        try {
            String string = file.getName();
            String string2 = string.substring(0, string.indexOf(46));
            File[] fileArray = FileUtil.getBackups(file.getParentFile(), string2);
            int n2 = Math.max(0, n - 1);
            while (n2 < fileArray.length) {
                fileArray[n2].delete();
                ++n2;
            }
            if (n != 0) {
                return FileUtil.renameToBackup(file);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return null;
    }

    public static File renameToBackup(File file) throws Exception {
        if (!file.exists()) {
            return null;
        }
        File file2 = new File(file.getParent());
        String string = file.getName();
        String string2 = "";
        int n = string.lastIndexOf(46);
        if (n > 0) {
            string2 = string.substring(n);
            string = string.substring(0, n);
        }
        String string3 = "yyMMdd_HHmm";
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string3);
        simpleDateFormat.setTimeZone(TimeZone.getDefault());
        String string4 = simpleDateFormat.format(new Date(file.lastModified()));
        File file3 = new File(file2, string + "_backup_" + string4 + string2);
        int n2 = 1;
        while (file3.exists()) {
            file3 = new File(file2, string + "_backup_" + string4 + '_' + n2 + string2);
            ++n2;
        }
        if (!file.renameTo(file3)) {
            throw new IOException("Cannot rename");
        }
        return file3;
    }

    public static File[] getBackups(File file, String string) {
        Object[] objectArray;
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        File[] fileArray = file.listFiles();
        int n = 0;
        while (n < fileArray.length) {
            objectArray = fileArray[n];
            String string2 = objectArray.getName();
            if (string2.startsWith(string) && string2.indexOf("_backup_") >= 0) {
                arrayList.add(objectArray);
            }
            ++n;
        }
        Object[] objectArray2 = arrayList.toArray(new File[arrayList.size()]);
        objectArray = new Long[objectArray2.length];
        int n2 = 0;
        while (n2 < objectArray2.length) {
            objectArray[n2] = new Long(((File)objectArray2[n2]).lastModified());
            ++n2;
        }
        SortUtil.rsort((Object[])objectArray, (Object[])objectArray2);
        return objectArray2;
    }

    public static void move(File file, File file2) throws IOException {
        log.trace("Move: " + file + " -> " + file2);
        if (file2.exists()) {
            throw new IOException("Cannot move to existing file: " + file2);
        }
        if (!file.renameTo(file2)) {
            throw new IOException("Cannot move: " + file + " -> " + file2);
        }
    }

    public static void copy(File file, File file2) throws IOException {
        log.trace("Copy: " + file + " -> " + file2);
        if (file2.exists()) {
            throw new IOException("Cannot copy to existing file: " + file2);
        }
        if (file.isDirectory()) {
            FileUtil.copyDir(file, file2);
        } else {
            FileUtil.copyFile(file, file2);
        }
    }

    public static void copyDir(File file, File file2) throws IOException {
        if (!file2.exists() && !file2.mkdirs()) {
            throw new IOException("Cannot make dir: " + file2);
        }
        File[] fileArray = file.listFiles();
        int n = 0;
        while (n < fileArray.length) {
            FileUtil.copy(fileArray[n], new File(file2, fileArray[n].getName()));
            ++n;
        }
        file2.setLastModified(file.lastModified());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void copyFile(File file, File file2) throws IOException {
        FileOutputStream fileOutputStream;
        block14: {
            fileOutputStream = null;
            FileInputStream fileInputStream = null;
            try {
                fileOutputStream = new FileOutputStream(file2);
                fileInputStream = new FileInputStream(file);
                byte[] byArray = new byte[4096];
                long l = file.length();
                long l2 = 0L;
                while (l2 < l) {
                    int n = fileInputStream.read(byArray, 0, byArray.length);
                    if (n < 0) {
                        throw new EOFException();
                    }
                    fileOutputStream.write(byArray, 0, n);
                    l2 += (long)n;
                }
            }
            catch (Throwable throwable) {
                Object var5_9 = null;
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                if (fileOutputStream == null) throw throwable;
                try {
                    fileOutputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            {
                Object var5_10 = null;
                if (fileInputStream == null) break block14;
            }
            try {}
            catch (IOException iOException) {}
            fileInputStream.close();
        }
        if (fileOutputStream != null) {
            try {}
            catch (IOException iOException) {}
            fileOutputStream.close();
        }
        if (!file2.exists()) return;
        file2.setLastModified(file.lastModified());
    }

    public static void delete(File file) throws IOException {
        log.trace("Delete: " + file);
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = 0;
            while (n < fileArray.length) {
                FileUtil.delete(fileArray[n]);
                ++n;
            }
        }
        if (!file.delete()) {
            throw new IOException("Cannot delete: " + file);
        }
    }

    public static boolean diff(BufferedReader bufferedReader, BufferedReader bufferedReader2) throws IOException {
        int n = 1;
        boolean bl = false;
        String string = bufferedReader.readLine();
        String string2 = bufferedReader2.readLine();
        while (string != null || string2 != null) {
            if (string == null || string2 == null || !string.equals(string2)) {
                bl = true;
            }
            ++n;
            if (string != null) {
                string = bufferedReader.readLine();
            }
            if (string2 == null) continue;
            string2 = bufferedReader2.readLine();
        }
        return bl;
    }

    public static String readString(File file) throws IOException {
        return FileUtil.readString(new FileReader(file));
    }

    public static String readString(BIFile bIFile) throws IOException {
        return FileUtil.readString(new InputStreamReader(bIFile.getInputStream()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readString(Reader reader) throws IOException {
        String string;
        try {
            String string2;
            StringBuffer stringBuffer = new StringBuffer();
            BufferedReader bufferedReader = new BufferedReader(reader);
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuffer.append(string2).append("\n");
            }
            string = stringBuffer.toString();
            Object var2_5 = null;
        }
        catch (Throwable throwable) {
            Object var2_6 = null;
            reader.close();
            throw throwable;
        }
        reader.close();
        return string;
    }

    public static String[] readLines(File file) throws IOException {
        return FileUtil.readLines(new FileReader(file));
    }

    public static String[] readLines(BIFile bIFile) throws IOException {
        return FileUtil.readLines(new InputStreamReader(bIFile.getInputStream()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] readLines(Reader reader) throws IOException {
        String[] stringArray;
        try {
            String string;
            ArrayList<String> arrayList = new ArrayList<String>();
            BufferedReader bufferedReader = new BufferedReader(reader);
            while ((string = bufferedReader.readLine()) != null) {
                arrayList.add(string);
            }
            stringArray = arrayList.toArray(new String[arrayList.size()]);
            Object var2_5 = null;
        }
        catch (Throwable throwable) {
            Object var2_6 = null;
            reader.close();
            throw throwable;
        }
        reader.close();
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileInfo getFileInfo(InputStream inputStream) throws IOException {
        FileInfo fileInfo;
        block3: {
            FileInfo fileInfo2 = new FileInfo();
            try {
                int n;
                byte[] byArray = new byte[4096];
                CRC32 cRC32 = new CRC32();
                while ((n = inputStream.read(byArray)) > 0) {
                    fileInfo2.size += (long)n;
                    cRC32.update(byArray, 0, n);
                }
                fileInfo2.crc = cRC32.getValue();
                fileInfo = fileInfo2;
                Object var3_6 = null;
                if (inputStream == null) break block3;
            }
            catch (Throwable throwable) {
                block4: {
                    Object var3_7 = null;
                    if (inputStream == null) break block4;
                    inputStream.close();
                }
                throw throwable;
            }
            inputStream.close();
        }
        return fileInfo;
    }

    public static void main(String[] stringArray) throws Exception {
        System.out.println(FileUtil.diff(new BufferedReader(new FileReader(stringArray[0])), new BufferedReader(new FileReader(stringArray[1]))) ? "MISMATCH" : "match");
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class FileInfo {
        public long size;
        public long crc;

        private final /* synthetic */ void this() {
            this.size = 0L;
            this.crc = 0L;
        }

        public FileInfo() {
            this.this();
        }
    }
}

