/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.file;

import java.util.HashMap;
import javax.baja.file.BDataFile;
import javax.baja.file.BIFileStore;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.nav.BNavRoot;
import javax.baja.nav.NavEvent;
import javax.baja.space.BSpace;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BSubSpaceFile
extends BDataFile {
    public static final Type TYPE;
    public static final Log log;
    private static HashMap cache;
    static /* synthetic */ Class class$javax$baja$file$BSubSpaceFile;

    public boolean isOpen() {
        boolean bl = false;
        if (cache.get(this.getAbsoluteOrd()) != null) {
            bl = true;
        }
        return bl;
    }

    public BSpace getSubSpace() {
        CacheItem cacheItem = (CacheItem)cache.get(this.getAbsoluteOrd());
        return cacheItem != null ? cacheItem.space : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static BSubSpaceFile[] listOpen() {
        HashMap hashMap = cache;
        synchronized (hashMap) {
            CacheItem[] cacheItemArray = cache.values().toArray(new CacheItem[cache.size()]);
            BSubSpaceFile[] bSubSpaceFileArray = new BSubSpaceFile[cacheItemArray.length];
            int n = 0;
            while (n < bSubSpaceFileArray.length) {
                log.trace("ListIsOpen[" + n + "]: " + cacheItemArray[n].file.getAbsoluteOrd());
                bSubSpaceFileArray[n] = cacheItemArray[n].file;
                ++n;
            }
            return bSubSpaceFileArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BSpace open() {
        HashMap hashMap = cache;
        synchronized (hashMap) {
            BOrd bOrd = this.getAbsoluteOrd();
            CacheItem cacheItem = (CacheItem)cache.get(bOrd);
            if (cacheItem != null) {
                if (cacheItem.openTimestamp == cacheItem.file.getLastModified().getMillis()) {
                    return cacheItem.space;
                }
                log.warning("File has been modified: " + cacheItem.file);
                this.close(false);
            }
            log.trace("Open: " + bOrd);
            cacheItem = new CacheItem();
            cacheItem.space = this.doOpen();
            cacheItem.file = this;
            cacheItem.openTimestamp = this.getLastModified().getMillis();
            cache.put(bOrd, cacheItem);
            return cacheItem.space;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void save() throws Exception {
        block3: {
            CacheItem cacheItem = null;
            HashMap hashMap = cache;
            synchronized (hashMap) {
                BOrd bOrd = this.getAbsoluteOrd();
                log.trace("Save: " + bOrd);
                cacheItem = (CacheItem)cache.get(bOrd);
                // MONITOREXIT @DISABLED, blocks:[0, 1] lbl8 : MonitorExitStatement: MONITOREXIT : var2_2
                if (cacheItem == null) break block3;
            }
            cacheItem.file.doSave();
            cacheItem.openTimestamp = cacheItem.file.getLastModified().getMillis();
        }
    }

    public void reload() throws Exception {
        this.close(false);
        this.open();
    }

    public void close() {
        this.close(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void close(boolean bl) {
        block4: {
            BOrd bOrd;
            CacheItem cacheItem = null;
            HashMap hashMap = cache;
            synchronized (hashMap) {
                bOrd = this.getAbsoluteOrd();
                log.trace("Close: " + bOrd);
                cacheItem = (CacheItem)cache.get(bOrd);
                if (cacheItem != null) {
                    log.trace("isModified: " + cacheItem.file.isModified());
                    cacheItem.file.doClose();
                    cacheItem.openTimestamp = 0L;
                    cache.remove(bOrd);
                }
                // MONITOREXIT @DISABLED, blocks:[0, 1] lbl14 : MonitorExitStatement: MONITOREXIT : var3_3
                if (cacheItem == null) break block4;
                bOrd = cacheItem.file.getNavParent().getNavOrd();
            }
            String string = cacheItem.file.getFileName();
            BFacets bFacets = bl ? BFacets.make("close", BBoolean.TRUE) : BFacets.NULL;
            BNavRoot.INSTANCE.fireNavEvent(NavEvent.makeReplaced(bOrd, string, (Context)bFacets));
        }
    }

    public abstract boolean isModified();

    protected abstract BSpace doOpen();

    protected abstract void doSave() throws Exception;

    protected abstract void doClose();

    public boolean hasNavChildren() {
        return true;
    }

    public BINavNode getNavChild(String string) {
        return this.open().getNavChild(string);
    }

    public BINavNode[] getNavChildren() {
        return this.open().getNavChildren();
    }

    public Type getType() {
        return TYPE;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BSubSpaceFile(BIFileStore bIFileStore) {
        super(bIFileStore);
    }

    public BSubSpaceFile() {
    }

    static {
        Class clazz = class$javax$baja$file$BSubSpaceFile;
        if (clazz == null) {
            clazz = class$javax$baja$file$BSubSpaceFile = BSubSpaceFile.class("[Ljavax.baja.file.BSubSpaceFile;", false);
        }
        TYPE = Sys.loadType(clazz);
        log = Log.getLog("subSpaceFile");
        cache = new HashMap();
    }

    static class CacheItem {
        public long openTimestamp;
        public BSubSpaceFile file;
        public BSpace space;

        CacheItem() {
        }
    }
}

