/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.file;

import com.tridium.sys.Nre;
import com.tridium.util.ArrayUtil;
import com.tridium.util.BRestrictedFileSpace;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.baja.file.BAbstractFileStore;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSpace;
import javax.baja.file.BIFile;
import javax.baja.file.BIFileStore;
import javax.baja.file.BLocalFileStore;
import javax.baja.file.FilePath;
import javax.baja.file.FileUtil;
import javax.baja.log.Log;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import javax.baja.nav.BINavNode;
import javax.baja.nav.BNavRoot;
import javax.baja.nav.NavEvent;
import javax.baja.nre.util.SortUtil;
import javax.baja.nre.util.TextUtil;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.LexiconText;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BFileSystem
extends BFileSpace {
    public static final Type TYPE;
    public static final BFileSystem INSTANCE;
    static final Log log;
    static ThreadLocal threadLocalContext;
    private BOrd ordInHost;
    private BOrd ordInSession;
    private HashMap specials;
    private BDirectory[] roots;
    private String baseOrdSysHome;
    private String baseOrdStationHome;
    private String baseOrdStationToSysHome;
    private BDirectory sysHome;
    private BDirectory stationHome;
    static /* synthetic */ Class class$javax$baja$file$BFileSystem;

    public Type getType() {
        return TYPE;
    }

    private final void init() {
        Object object;
        this.ordInHost = this.ordInSession = BOrd.make("file:");
        ArrayList<BDirectory> arrayList = new ArrayList<BDirectory>();
        this.specials = new HashMap();
        File file = Sys.getBajaHome();
        BLocalFileStore bLocalFileStore = new BLocalFileStore(this, new FilePath("!"), file);
        this.sysHome = new BDirectory(bLocalFileStore, LexiconText.make("baja", "nav.sysHome"));
        this.sysHome.icon = BIcon.std("home.png");
        arrayList.add(this.sysHome);
        this.specials.put("!", this.sysHome);
        this.baseOrdSysHome = this.localFileToOrd(file).toString();
        File file2 = Sys.getStationHome();
        if (file2 != null) {
            object = new BLocalFileStore(this, new FilePath("^"), file2);
            this.stationHome = new BDirectory((BIFileStore)object, LexiconText.make("baja", "nav.stationHome"));
            this.stationHome.icon = BIcon.std("database.png");
            arrayList.add(this.stationHome);
            this.specials.put("^", this.stationHome);
            String string = file2.getPath().substring(file.getPath().length() + 1);
            string = string.replace('\\', '/');
            this.baseOrdStationHome = this.localFileToOrd(file2).toString();
            this.baseOrdStationToSysHome = "local:|file:!" + string;
        }
        if (((File[])(object = File.listRoots())).length == 1 && object[0].getPath().equals("/")) {
            object = object[0].listFiles();
        }
        int n = 0;
        while (n < ((File[])object).length) {
            BDirectory bDirectory = this.toRoot(object[n]);
            bDirectory.icon = this.getIcon();
            bDirectory.navParent = this;
            arrayList.add(bDirectory);
            this.specials.put("/" + TextUtil.toLowerCase((String)bDirectory.getFileName()), bDirectory);
            ++n;
        }
        this.roots = arrayList.toArray(new BDirectory[arrayList.size()]);
    }

    private final BDirectory toRoot(File file) {
        try {
            String string = file.getPath();
            string = string.replace('\\', '/');
            if (string.endsWith("/")) {
                string = string.substring(0, string.length() - 1);
            }
            if (!string.startsWith("/")) {
                string = "/" + string;
            }
            FilePath filePath = new FilePath(string);
            BLocalFileStore bLocalFileStore = new BLocalFileStore(this, filePath, file);
            return new BDirectory(bLocalFileStore);
        }
        catch (Exception exception) {
            FileUtil.log.error("Cannot create root " + file, exception);
            return null;
        }
    }

    private final void syncRoots() {
        File[] fileArray = File.listRoots();
        if (fileArray.length == 1 && fileArray[0].getPath().equals("/")) {
            fileArray = fileArray[0].listFiles();
        }
        BDirectory[] bDirectoryArray = new BDirectory[fileArray.length];
        int n = 0;
        while (n < fileArray.length) {
            bDirectoryArray[n] = this.toRoot(fileArray[n]);
            ++n;
        }
        Object[] objectArray = this.specials.keySet().toArray();
        int n2 = 0;
        while (n2 < objectArray.length) {
            BDirectory bDirectory = (BDirectory)this.specials.get(objectArray[n2]);
            boolean bl = false;
            int n3 = 0;
            while (n3 < bDirectoryArray.length) {
                if (bDirectoryArray[n3].equals(bDirectory)) {
                    bl = true;
                    break;
                }
                ++n3;
            }
            if (!bl && !objectArray[n2].equals("!")) {
                this.roots = (BDirectory[])ArrayUtil.removeOne((Object[])this.roots, bDirectory);
                this.specials.remove(objectArray[n2]);
                this.fireNavEvent(NavEvent.makeRemoved(this, bDirectory.getFileName(), null));
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < bDirectoryArray.length) {
            if (this.specials.get("/" + TextUtil.toLowerCase((String)bDirectoryArray[n2].getFileName())) == null) {
                bDirectoryArray[n2].icon = this.getIcon();
                bDirectoryArray[n2].navParent = this;
                this.roots = (BDirectory[])ArrayUtil.addOne(this.roots, bDirectoryArray[n2]);
                this.specials.put("/" + TextUtil.toLowerCase((String)bDirectoryArray[n2].getFileName()), bDirectoryArray[n2]);
                this.fireNavEvent(NavEvent.makeAdded(this, bDirectoryArray[n2].getFileName(), null));
            }
            ++n2;
        }
    }

    public BDirectory getSysHome() {
        return this.sysHome;
    }

    public BDirectory getStationHome() {
        return this.stationHome;
    }

    public BDirectory makeDir(FilePath filePath, Context context) throws IOException {
        this.checkWritePermission(filePath, context);
        File file = this.pathToLocalFile(filePath);
        NavEvent navEvent = this.precheckAddEvent(file);
        if (file.exists()) {
            if (!file.isDirectory()) {
                throw new IOException("Exists as file: " + filePath.getBody());
            }
        } else {
            file.mkdirs();
        }
        if (navEvent != null) {
            this.fireNavEvent(navEvent);
        }
        return new BDirectory(new BLocalFileStore(INSTANCE, filePath, file));
    }

    public BIFile makeFile(FilePath filePath, Context context) throws IOException {
        Object object;
        this.checkWritePermission(filePath, context);
        File file = this.pathToLocalFile(filePath);
        NavEvent navEvent = this.precheckAddEvent(file);
        if (file.exists()) {
            if (file.isDirectory()) {
                throw new IllegalArgumentException("Exists as dir: " + filePath.getBody());
            }
        } else {
            object = new File(file.getParent());
            if (!((File)object).exists()) {
                ((File)object).mkdirs();
            }
        }
        if (!file.exists()) {
            object = new FileOutputStream(file);
            ((FileOutputStream)object).close();
        }
        if (navEvent != null) {
            this.fireNavEvent(navEvent);
        }
        return this.makeFile(new BLocalFileStore(INSTANCE, filePath, file));
    }

    public void move(FilePath filePath, FilePath filePath2, Context context) throws IOException {
        File file;
        File file2;
        boolean bl;
        this.checkWritePermission(filePath, context);
        this.checkWritePermission(filePath2, context);
        boolean bl2 = false;
        if (filePath2.getBody().indexOf(47) < 0) {
            bl2 = bl = true;
        }
        if (filePath2.isRelative()) {
            filePath2 = filePath.getParent().merge(filePath2);
        }
        if (!(file2 = this.pathToLocalFile(filePath)).renameTo(file = this.pathToLocalFile(filePath2))) {
            throw new IOException("Move: " + file2 + " -> " + file);
        }
        if (bl) {
            BOrd bOrd = BOrd.make("local:|" + filePath.getParent());
            this.fireNavEvent(NavEvent.makeRenamed(bOrd, filePath.getName(), filePath2.getName(), null));
        } else {
            BOrd bOrd = BOrd.make("local:|" + filePath.getParent());
            this.fireNavEvent(NavEvent.makeRemoved(bOrd, filePath.getName(), null));
            BOrd bOrd2 = BOrd.make("local:|" + filePath2.getParent());
            this.fireNavEvent(NavEvent.makeAdded(bOrd2, filePath2.getName(), null));
        }
    }

    public void delete(FilePath filePath, Context context) throws IOException {
        this.checkWritePermission(filePath, context);
        BIFile bIFile = this.findFile(filePath);
        if (bIFile == null) {
            return;
        }
        BLocalFileStore bLocalFileStore = (BLocalFileStore)bIFile.getStore();
        File file = bLocalFileStore.getLocalFile();
        FileUtil.delete(file);
        File file2 = new File(file.getParent());
        FilePath filePath2 = bIFile.getFilePath().getParent();
        BDirectory bDirectory = new BDirectory(new BLocalFileStore(this, filePath2, file2));
        NavEvent navEvent = NavEvent.makeRemoved(bDirectory.getNavOrd(), bIFile.getFileName(), null);
        this.fireNavEvent(navEvent);
    }

    private final NavEvent precheckAddEvent(File file) {
        if (file.exists()) {
            return null;
        }
        File file2 = file;
        File file3 = null;
        while (!file2.exists()) {
            file3 = file2;
            file2 = new File(file2.getParent());
        }
        BOrd bOrd = this.localFileToOrd(file2);
        String string = file3.getName();
        return NavEvent.makeAdded(bOrd, string, null);
    }

    protected void fireNavEvent(NavEvent navEvent) {
        BNavRoot.INSTANCE.fireNavEvent(navEvent);
        String string = navEvent.getParentOrd().toString();
        if (this.baseOrdStationHome != null) {
            if (string.startsWith("local:|file:^")) {
                String string2 = string.substring("local:|file:^".length());
                if (string2.length() > 0) {
                    string2 = "/" + string2;
                }
                BOrd bOrd = BOrd.make(this.baseOrdStationHome + string2);
                BNavRoot.INSTANCE.fireNavEvent(NavEvent.make(navEvent, bOrd));
                BOrd bOrd2 = BOrd.make(this.baseOrdStationToSysHome + string2);
                BNavRoot.INSTANCE.fireNavEvent(NavEvent.make(navEvent, bOrd2));
                return;
            }
            if (string.startsWith(this.baseOrdStationToSysHome)) {
                BOrd bOrd = BOrd.make(this.baseOrdSysHome + '/' + string.substring("local:|file:!".length()));
                BNavRoot.INSTANCE.fireNavEvent(NavEvent.make(navEvent, bOrd));
                BOrd bOrd3 = string.length() == this.baseOrdStationToSysHome.length() ? BOrd.make("local:|file:^") : BOrd.make("local:|file:^" + string.substring(this.baseOrdStationToSysHome.length() + 1));
                BNavRoot.INSTANCE.fireNavEvent(NavEvent.make(navEvent, bOrd3));
                return;
            }
            if (string.startsWith(this.baseOrdStationHome)) {
                BOrd bOrd = string.length() == this.baseOrdStationHome.length() ? BOrd.make("local:|file:^") : BOrd.make("local:|file:^" + string.substring(this.baseOrdStationHome.length() + 1));
                BNavRoot.INSTANCE.fireNavEvent(NavEvent.make(navEvent, bOrd));
                BOrd bOrd4 = BOrd.make("local:|file:!" + string.substring(this.baseOrdSysHome.length() + 1));
                BNavRoot.INSTANCE.fireNavEvent(NavEvent.make(navEvent, bOrd4));
                return;
            }
        }
        if (string.startsWith("local:|file:!")) {
            String string3 = string.substring("local:|file:!".length());
            if (string3.length() > 0) {
                string3 = "/" + string3;
            }
            BOrd bOrd = BOrd.make(this.baseOrdSysHome + string3);
            BNavRoot.INSTANCE.fireNavEvent(NavEvent.make(navEvent, bOrd));
            return;
        }
        if (string.startsWith(this.baseOrdSysHome)) {
            BOrd bOrd = string.length() == this.baseOrdSysHome.length() ? BOrd.make("local:|file:!") : BOrd.make("local:|file:!" + string.substring(this.baseOrdSysHome.length() + 1));
            BNavRoot.INSTANCE.fireNavEvent(NavEvent.make(navEvent, bOrd));
            return;
        }
    }

    public BIFile[] listFiles() {
        return (BIFile[])this.roots.clone();
    }

    public File pathToLocalFile(FilePath filePath) {
        String string = filePath.getBody();
        if (filePath.isSysHomeAbsolute()) {
            return new File(Sys.getBajaHome(), string.substring(1));
        }
        if (filePath.isStationHomeAbsolute()) {
            File file = Sys.getStationHome();
            if (file == null) {
                throw new UnresolvedException("Not a station VM");
            }
            return new File(file, string.substring(1));
        }
        if (filePath.isLocalAbsolute()) {
            if (filePath.depth() == 1) {
                String string2 = filePath.nameAt(0);
                int n = 0;
                while (n < this.roots.length) {
                    if (this.roots[n].getFileName().equalsIgnoreCase(string2)) {
                        return ((BLocalFileStore)this.roots[n].getStore()).getLocalFile();
                    }
                    ++n;
                }
            }
            return new File(string);
        }
        throw new UnresolvedException("Relative path: " + string);
    }

    public FilePath localFileToPath(File file) {
        try {
            String string = file.getCanonicalPath();
            string = string.replace('\\', '/');
            if (string.endsWith("/")) {
                string = string.substring(0, string.length() - 1);
            }
            if (!string.startsWith("/")) {
                string = "/" + string;
            }
            return new FilePath(string);
        }
        catch (Exception exception) {
            throw new UnresolvedException("Cannot map to path: " + file, exception);
        }
    }

    public BOrd localFileToOrd(File file) {
        return BOrd.make("local:|file:" + this.localFileToPath(file).getBody());
    }

    public BIFile findFile(FilePath filePath) {
        BIFile bIFile = (BIFile)this.specials.get(TextUtil.toLowerCase((String)filePath.getBody()));
        if (bIFile != null) {
            return bIFile;
        }
        return super.findFile(filePath);
    }

    public BIFileStore findStore(FilePath filePath) {
        File file = this.pathToLocalFile(filePath);
        if (file.exists()) {
            return new BLocalFileStore(this, filePath, file);
        }
        return null;
    }

    public BIFile getChild(BIFile bIFile, String string) {
        File file;
        BLocalFileStore bLocalFileStore = (BLocalFileStore)bIFile.getStore();
        if (bLocalFileStore.isDirectory() && (file = new File(bLocalFileStore.getLocalFile(), string)).exists()) {
            FilePath filePath = bLocalFileStore.getFilePath().merge(string);
            return this.makeFile(new BLocalFileStore(this, filePath, file));
        }
        return null;
    }

    public BIFile[] getChildren(BIFile bIFile) {
        Object object;
        BRestrictedFileSpace bRestrictedFileSpace = null;
        try {
            object = (Context)threadLocalContext.get();
            if (object != null && (object.getUser() != null || object.getFacet("username") instanceof BString)) {
                bRestrictedFileSpace = BRestrictedFileSpace.INSTANCE;
            }
        }
        catch (Throwable throwable) {}
        object = (BLocalFileStore)bIFile.getStore();
        File[] fileArray = ((BLocalFileStore)object).getLocalFile().listFiles();
        if (fileArray == null || fileArray.length == 0) {
            return NO_FILES;
        }
        ArrayList<BIFile> arrayList = new ArrayList<BIFile>(fileArray.length);
        int n = 0;
        while (n < fileArray.length) {
            File file = fileArray[n];
            String string = fileArray[n].getName();
            if (!FilePath.isValidName(string)) {
                log.warning("Unsupported file name \"" + string + '\"');
            } else {
                FilePath filePath = ((BAbstractFileStore)object).getFilePath().merge(string);
                if (bRestrictedFileSpace == null || bRestrictedFileSpace.inScope(filePath)) {
                    arrayList.add(this.makeFile(new BLocalFileStore(this, filePath, file)));
                }
            }
            ++n;
        }
        Object[] objectArray = arrayList.toArray(new BIFile[arrayList.size()]);
        SortUtil.sort((Object[])objectArray);
        return objectArray;
    }

    public boolean hasNavChildren() {
        return true;
    }

    public BINavNode getNavChild(String string) {
        int n = 0;
        while (n < this.roots.length) {
            if (this.roots[n].getFileName().equals(string)) {
                return this.roots[n];
            }
            ++n;
        }
        return null;
    }

    public BINavNode[] getNavChildren() {
        this.syncRoots();
        try {
            Context context = (Context)threadLocalContext.get();
            if (context != null && (context.getUser() != null || context.getFacet("username") instanceof BString)) {
                return new BINavNode[]{this.sysHome, this.stationHome};
            }
        }
        catch (Throwable throwable) {}
        return (BINavNode[])this.roots.clone();
    }

    public BOrd getOrdInHost() {
        return this.ordInHost;
    }

    public BOrd getOrdInSession() {
        return this.ordInSession;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void spy(SpyWriter spyWriter) throws Exception {
        try {
            threadLocalContext.set(spyWriter.getContext());
            if (INSTANCE == this) {
                BRestrictedFileSpace.INSTANCE.spy(spyWriter);
                Object var3_2 = null;
                threadLocalContext.set(null);
                return;
            }
            super.spy(spyWriter);
            spyWriter.startProps("FileSystem");
            spyWriter.prop((Object)"sysHome", ((BLocalFileStore)this.getSysHome().getStore()).getLocalFile());
            spyWriter.prop((Object)"stationHome", this.stationHome == null ? "null" : "" + ((BLocalFileStore)this.getStationHome().getStore()).getLocalFile());
            spyWriter.prop((Object)"isFlash", Nre.getPlatform().isFlashFileSystem());
            spyWriter.endProps();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            threadLocalContext.set(null);
            throw throwable;
        }
        {
            Object var3_4 = null;
            threadLocalContext.set(null);
            return;
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private BFileSystem() {
        super("file", LexiconText.make("baja", "nav.fileSystem"));
        this.init();
    }

    static {
        Class clazz = class$javax$baja$file$BFileSystem;
        if (clazz == null) {
            clazz = class$javax$baja$file$BFileSystem = BFileSystem.class("[Ljavax.baja.file.BFileSystem;", false);
        }
        TYPE = Sys.loadType(clazz);
        INSTANCE = new BFileSystem();
        BLocalHost.INSTANCE.addNavChild(INSTANCE);
        log = Log.getLog("sys.file");
        threadLocalContext = new ThreadLocal();
    }
}

