/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.file;

import com.tridium.util.BRestrictedFileSpace;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.baja.file.BFileSpace;
import javax.baja.file.BIFile;
import javax.baja.file.BIFileStore;
import javax.baja.file.FilePath;
import javax.baja.file.FileUtil;
import javax.baja.security.BPermissions;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BAbstractFileStore
extends BObject
implements BIFileStore {
    private static final int READONLY_MASK = -35;
    public static final Type TYPE;
    private BFileSpace space;
    private FilePath path;
    static /* synthetic */ Class class$javax$baja$file$BAbstractFileStore;

    public BFileSpace getFileSpace() {
        return this.space;
    }

    public FilePath getFilePath() {
        return this.path;
    }

    public String getFileName() {
        return this.getFilePath().getName();
    }

    public String getExtension() {
        return FileUtil.getExtension(this.getFileName());
    }

    public boolean isDirectory() {
        return false;
    }

    public long getSize() {
        return -1;
    }

    public BAbsTime getLastModified() {
        return BAbsTime.NULL;
    }

    public final boolean setLastModified(BAbsTime bAbsTime) throws IOException {
        bAbsTime = BAbsTime.make(bAbsTime.getYear(), bAbsTime.getMonth(), bAbsTime.getDay(), bAbsTime.getHour(), bAbsTime.getMinute(), bAbsTime.getSecond(), 0, bAbsTime.getTimeZone());
        return this.doSetLastModified(bAbsTime);
    }

    protected boolean doSetLastModified(BAbsTime bAbsTime) throws IOException {
        throw new IOException();
    }

    public InputStream getInputStream() throws IOException {
        throw new IOException();
    }

    public byte[] read() throws IOException {
        return FileUtil.read(this);
    }

    public OutputStream getOutputStream() throws IOException {
        throw new IOException();
    }

    public void write(byte[] byArray) throws IOException {
        FileUtil.write(this, byArray);
    }

    public BPermissions getPermissions(BIFile bIFile, Context context) {
        BPermissions bPermissions = BPermissions.all;
        if (context != null && context.getUser() != null) {
            BUser bUser = context.getUser();
            bPermissions = this.space instanceof BModule ? BPermissions.operatorRead : (!bUser.getPermissions().isSuperUser() && this.path.getAbsoluteMode() != 4 || BRestrictedFileSpace.INSTANCE.isBlacklistedForUser(bUser, bIFile) ? BPermissions.none : context.getUser().getPermissionsFor(bIFile));
        }
        if (this.isReadonly()) {
            bPermissions = BPermissions.make(bPermissions.getMask() & 0xFFFFFFDD);
        }
        return bPermissions;
    }

    public String toString(Context context) {
        return String.valueOf(this.path);
    }

    public long getCrc() throws IOException {
        return -1;
    }

    public Type getType() {
        return TYPE;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BAbstractFileStore(BFileSpace bFileSpace, FilePath filePath) {
        this.space = bFileSpace;
        this.path = filePath;
    }

    static {
        Class clazz = class$javax$baja$file$BAbstractFileStore;
        if (clazz == null) {
            clazz = class$javax$baja$file$BAbstractFileStore = BAbstractFileStore.class("[Ljavax.baja.file.BAbstractFileStore;", false);
        }
        TYPE = Sys.loadType(clazz);
    }
}

