/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.data;

import java.io.IOException;
import javax.baja.data.DataTypes;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.Type;

public class DataUtil {
    public static String marshal(BObject bObject) throws IOException {
        if (bObject == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(bObject.getType().getDataTypeSymbol());
        stringBuffer.append(':');
        if (bObject instanceof BString) {
            stringBuffer.append(SlotPath.escape(bObject.toString()));
        } else {
            stringBuffer.append(((BSimple)bObject).encodeToString());
        }
        return stringBuffer.toString();
    }

    public static BObject unmarshal(String string) throws IOException {
        if (string.equals("null")) {
            return null;
        }
        char c = string.charAt(0);
        if (string.charAt(1) != ':') {
            throw new IOException("Expecting colon " + string);
        }
        String string2 = string.substring(2);
        Type type = DataTypes.getBySymbol(c);
        if (type == null) {
            throw new IOException("Unknown symbol " + c);
        }
        if (type == BString.TYPE) {
            return BString.make(SlotPath.unescape(string2));
        }
        BSimple bSimple = (BSimple)type.getInstance();
        return bSimple.decodeFromString(string2);
    }
}

