/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.data;

import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BDouble;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFloat;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLong;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.units.BUnit;

public class DataTypes {
    public static final Type BOOLEAN = BBoolean.TYPE;
    public static final Type INTEGER = BInteger.TYPE;
    public static final Type LONG = BLong.TYPE;
    public static final Type FLOAT = BFloat.TYPE;
    public static final Type DOUBLE = BDouble.TYPE;
    public static final Type STRING = BString.TYPE;
    public static final Type ENUM = BDynamicEnum.TYPE;
    public static final Type ENUM_RANGE = BEnumRange.TYPE;
    public static final Type ABS_TIME = BAbsTime.TYPE;
    public static final Type REL_TIME = BRelTime.TYPE;
    public static final Type UNIT = BUnit.TYPE;
    public static final Type TIME_ZONE = BTimeZone.TYPE;
    private static final Type[] TYPES = new Type[]{BOOLEAN, INTEGER, LONG, FLOAT, DOUBLE, STRING, ENUM, ENUM_RANGE, ABS_TIME, REL_TIME, UNIT, TIME_ZONE};
    private static final Type[] bySymbol = new Type[128];

    public static Type[] getTypes() {
        return (Type[])TYPES.clone();
    }

    public static Type getBySymbol(char c) {
        if (c < '\u0080') {
            return bySymbol[c];
        }
        return null;
    }

    static {
        int n = 0;
        while (n < TYPES.length) {
            Type type;
            DataTypes.bySymbol[type.getDataTypeSymbol()] = type = TYPES[n];
            ++n;
        }
    }
}

