/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.category;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Comparator;
import javax.baja.category.BCategoryMask;
import javax.baja.naming.BOrd;
import javax.baja.naming.NullOrdException;
import javax.baja.naming.OrdQuery;
import javax.baja.nre.util.SortUtil;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BOrdToCategoryMap
extends BSimple {
    static final Comparator comparator = new Comparator(){

        public final int compare(Object object, Object object2) {
            int n;
            int n2 = object.toString().length();
            if (n2 == (n = object2.toString().length())) {
                return 0;
            }
            if (n2 < n) {
                return 1;
            }
            return -1;
        }
    };
    public static final BOrdToCategoryMap NULL;
    public static final BOrdToCategoryMap DEFAULT;
    public static final Type TYPE;
    private BOrd[] ords;
    private String[] ordStrings;
    private String[] ordSlashes;
    private BCategoryMask[] cats;
    private String string;
    private int hashCode;
    static /* synthetic */ Class class$javax$baja$category$BOrdToCategoryMap;

    public static final BOrdToCategoryMap make(BOrd[] bOrdArray, BCategoryMask[] bCategoryMaskArray) {
        if (bOrdArray.length != bCategoryMaskArray.length) {
            throw new IllegalArgumentException("ords.length != masks.length");
        }
        if (bOrdArray.length == 0) {
            return NULL;
        }
        bOrdArray = (BOrd[])bOrdArray.clone();
        bCategoryMaskArray = (BCategoryMask[])bCategoryMaskArray.clone();
        int n = 0;
        while (n < bOrdArray.length) {
            BOrd bOrd = bOrdArray[n];
            if (bOrd.isNull()) {
                throw new NullOrdException();
            }
            OrdQuery ordQuery = bOrd.parse()[0];
            if (ordQuery.isHost()) {
                throw new IllegalArgumentException("Cannot use host absolute ord: " + bOrd);
            }
            if (ordQuery.isSession()) {
                throw new IllegalArgumentException("Cannot use session absolute ord: " + bOrd);
            }
            ++n;
        }
        SortUtil.sort((Object[])bOrdArray, (Object[])bCategoryMaskArray, (Comparator)comparator);
        return (BOrdToCategoryMap)new BOrdToCategoryMap(bOrdArray, bCategoryMaskArray, null).intern();
    }

    public final BOrdToCategoryMap setCategoryMask(BOrd bOrd, BCategoryMask bCategoryMask) {
        int n = -1;
        String string = TextUtil.toLowerCase((String)bOrd.relativizeToSession().toString());
        int n2 = this.ordStrings.length;
        int n3 = 0;
        while (n3 < n2) {
            if (string.equals(this.ordStrings[n3])) {
                n = n3;
                break;
            }
            ++n3;
        }
        BOrd[] bOrdArray = null;
        BCategoryMask[] bCategoryMaskArray = null;
        if (n != -1) {
            if (bCategoryMask == null || bCategoryMask.isNull()) {
                bOrdArray = (BOrd[])this.removeElement(this.ords, new BOrd[this.ords.length - 1], n);
                bCategoryMaskArray = (BCategoryMask[])this.removeElement(this.cats, new BCategoryMask[this.cats.length - 1], n);
            } else {
                if (this.cats[n].equals(bCategoryMask)) {
                    return this;
                }
                bOrdArray = new BOrd[this.ords.length];
                System.arraycopy(this.ords, 0, bOrdArray, 0, this.ords.length);
                bOrdArray[n] = bOrd;
                bCategoryMaskArray = new BCategoryMask[this.cats.length];
                System.arraycopy(this.cats, 0, bCategoryMaskArray, 0, this.cats.length);
                bCategoryMaskArray[n] = bCategoryMask;
            }
            return (BOrdToCategoryMap)new BOrdToCategoryMap(bOrdArray, bCategoryMaskArray, null).intern();
        }
        if (bCategoryMask != null && !bCategoryMask.isNull()) {
            bOrdArray = new BOrd[this.ords.length + 1];
            System.arraycopy(this.ords, 0, bOrdArray, 0, this.ords.length);
            bOrdArray[this.ords.length] = bOrd;
            bCategoryMaskArray = new BCategoryMask[this.cats.length + 1];
            System.arraycopy(this.cats, 0, bCategoryMaskArray, 0, this.cats.length);
            bCategoryMaskArray[this.cats.length] = bCategoryMask;
            return BOrdToCategoryMap.make(bOrdArray, bCategoryMaskArray);
        }
        return this;
    }

    private final Object[] removeElement(Object[] objectArray, Object[] objectArray2, int n) {
        if (n == -1) {
            throw new ArrayIndexOutOfBoundsException("-1 is not a valid array index");
        }
        if (n == 0) {
            System.arraycopy(objectArray, 1, objectArray2, 0, objectArray.length - 1);
        } else if (n == objectArray.length - 1) {
            System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length - 1);
        } else {
            System.arraycopy(objectArray, 0, objectArray2, 0, n);
            System.arraycopy(objectArray, n + 1, objectArray2, n, objectArray.length - (n + 1));
        }
        return objectArray2;
    }

    public final boolean isNull() {
        boolean bl = false;
        if (this == NULL) {
            bl = true;
        }
        return bl;
    }

    public final int size() {
        return this.ords.length;
    }

    public final BOrd getOrd(int n) {
        return this.ords[n];
    }

    public final BCategoryMask getCategoryMask(int n) {
        return this.cats[n];
    }

    public final BCategoryMask getCategoryMask(BOrd bOrd) {
        String string = TextUtil.toLowerCase((String)bOrd.relativizeToSession().toString());
        int n = this.ordStrings.length;
        int n2 = 0;
        while (n2 < n) {
            if (string.equals(this.ordStrings[n2])) {
                return this.cats[n2];
            }
            ++n2;
        }
        return null;
    }

    public final BCategoryMask getAppliedCategoryMask(BOrd bOrd) {
        String string = TextUtil.toLowerCase((String)bOrd.relativizeToSession().toString());
        int n = this.ordSlashes.length;
        int n2 = 0;
        while (n2 < n) {
            if (string.equals(this.ordStrings[n2])) {
                return this.cats[n2];
            }
            if (string.startsWith(this.ordSlashes[n2])) {
                return this.cats[n2];
            }
            ++n2;
        }
        return null;
    }

    public final int hashCode() {
        try {
            if (this.hashCode == -1) {
                this.hashCode = this.encodeToString().hashCode();
            }
            return this.hashCode;
        }
        catch (Exception exception) {
            return System.identityHashCode(this);
        }
    }

    public final boolean equals(Object object) {
        if (object instanceof BOrdToCategoryMap) {
            BOrdToCategoryMap bOrdToCategoryMap = (BOrdToCategoryMap)object;
            if (this.ords.length != bOrdToCategoryMap.ords.length) {
                return false;
            }
            int n = 0;
            while (n < this.ords.length) {
                if (!this.ords[n].equals(bOrdToCategoryMap.ords[n])) {
                    return false;
                }
                if (!this.cats[n].equals(bOrdToCategoryMap.cats[n])) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    public final void encode(DataOutput dataOutput) throws IOException {
        dataOutput.writeUTF(this.encodeToString());
    }

    public final BObject decode(DataInput dataInput) throws IOException {
        return this.decodeFromString(dataInput.readUTF());
    }

    public final String encodeToString() {
        if (this.string == null) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < this.ords.length) {
                if (n > 0) {
                    stringBuffer.append('\n');
                }
                stringBuffer.append(this.ords[n].encodeToString()).append('=').append(this.cats[n]);
                ++n;
            }
            this.string = stringBuffer.toString();
        }
        return this.string;
    }

    public final BObject decodeFromString(String string) throws IOException {
        String[] stringArray = TextUtil.split((String)string, (char)'\n');
        int n = stringArray.length;
        if (n == 0) {
            return NULL;
        }
        BOrd[] bOrdArray = new BOrd[n];
        BCategoryMask[] bCategoryMaskArray = new BCategoryMask[n];
        int n2 = 0;
        while (n2 < stringArray.length) {
            String string2 = stringArray[n2];
            int n3 = string2.lastIndexOf(61);
            bOrdArray[n2] = BOrd.make(string2.substring(0, n3));
            bCategoryMaskArray[n2] = BCategoryMask.make(string2.substring(n3 + 1));
            ++n2;
        }
        return (BOrdToCategoryMap)new BOrdToCategoryMap(bOrdArray, bCategoryMaskArray, string).intern();
    }

    public final Type getType() {
        return TYPE;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.hashCode = -1;
    }

    BOrdToCategoryMap(BOrd[] bOrdArray, BCategoryMask[] bCategoryMaskArray, String string) {
        this.this();
        this.ords = bOrdArray;
        this.cats = bCategoryMaskArray;
        this.string = string;
        int n = Integer.MAX_VALUE;
        this.ordStrings = new String[bOrdArray.length];
        this.ordSlashes = new String[bOrdArray.length];
        int n2 = 0;
        while (n2 < bOrdArray.length) {
            String string2;
            this.ordStrings[n2] = string2 = TextUtil.toLowerCase((String)bOrdArray[n2].encodeToString());
            this.ordSlashes[n2] = string2.endsWith("/") || string2.endsWith("^") || string2.endsWith("!") ? string2 : string2 + '/';
            int n3 = string2.length();
            if (n3 > n) {
                throw new IllegalStateException();
            }
            n = n3;
            ++n2;
        }
    }

    static {
        DEFAULT = NULL = new BOrdToCategoryMap(new BOrd[0], new BCategoryMask[0], null);
        Class clazz = class$javax$baja$category$BOrdToCategoryMap;
        if (clazz == null) {
            clazz = class$javax$baja$category$BOrdToCategoryMap = BOrdToCategoryMap.class("[Ljavax.baja.category.BOrdToCategoryMap;", false);
        }
        TYPE = Sys.loadType(clazz);
    }
}

