/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.category;

import com.tridium.sys.schema.ComponentSlotMap;
import javax.baja.category.BCategory;
import javax.baja.category.BCategoryMask;
import javax.baja.category.BOrdToCategoryMap;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.Array;
import javax.baja.spy.SpyWriter;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIService;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.NotRunningException;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BCategoryService
extends BComponent
implements BIService {
    public static final Property ordMap = BCategoryService.newProperty(5, BOrdToCategoryMap.NULL, null);
    public static final Property updatePeriod = BCategoryService.newProperty(0, BRelTime.make(60000L), null);
    public static final Action update = BCategoryService.newAction(0, null);
    public static final Type TYPE;
    private static Type[] serviceTypes;
    private static final BIcon icon;
    static final BCategoryMask DEFAULT_MASK;
    BCategory[] lookup;
    UpdateThread thread;
    long lastUpdateTicks;
    long lastUpdateDuration;
    static /* synthetic */ Class class$javax$baja$category$BCategoryService;
    static /* synthetic */ Class class$javax$baja$category$BCategory;

    public final BOrdToCategoryMap getOrdMap() {
        return (BOrdToCategoryMap)this.get(ordMap);
    }

    public final void setOrdMap(BOrdToCategoryMap bOrdToCategoryMap) {
        this.set(ordMap, (BValue)bOrdToCategoryMap, null);
    }

    public final BRelTime getUpdatePeriod() {
        return (BRelTime)this.get(updatePeriod);
    }

    public final void setUpdatePeriod(BRelTime bRelTime) {
        this.set(updatePeriod, (BValue)bRelTime, null);
    }

    public final void update() {
        this.invoke(update, null, null);
    }

    public final Type getType() {
        return TYPE;
    }

    public static final BCategoryService getService() {
        return (BCategoryService)Sys.getService(TYPE);
    }

    public final BCategory[] getCategories() {
        Class clazz = class$javax$baja$category$BCategory;
        if (clazz == null) {
            clazz = class$javax$baja$category$BCategory = BCategoryService.class("[Ljavax.baja.category.BCategory;", false);
        }
        return (BCategory[])this.getChildren(clazz);
    }

    public final int getMaxCategoryIndex() {
        if (!this.isRunning()) {
            throw new NotRunningException();
        }
        int n = this.lookup.length - 1;
        while (n > 0) {
            if (this.lookup[n] != null) {
                return n;
            }
            --n;
        }
        return 0;
    }

    public final BCategory getCategory(int n) {
        if (!this.isRunning()) {
            throw new NotRunningException();
        }
        if (n >= this.lookup.length) {
            return null;
        }
        return this.lookup[n];
    }

    public final BCategory[] getCategories(BCategoryMask bCategoryMask) {
        if (!this.isRunning()) {
            throw new NotRunningException();
        }
        int n = Math.min(bCategoryMask.size(), this.lookup.length) + 1;
        Class clazz = class$javax$baja$category$BCategory;
        if (clazz == null) {
            clazz = class$javax$baja$category$BCategory = BCategoryService.class("[Ljavax.baja.category.BCategory;", false);
        }
        Array array = new Array(clazz, n);
        int n2 = 1;
        while (n2 < n) {
            if (bCategoryMask.get(n2) && this.lookup[n2] != null) {
                array.add((Object)this.lookup[n2]);
            }
            ++n2;
        }
        return (BCategory[])array.trim();
    }

    public final BCategoryMask getCategoryMask(BOrd bOrd) {
        BCategoryMask bCategoryMask;
        if (bOrd != null && !bOrd.isNull() && (bCategoryMask = this.getOrdMap().getCategoryMask(bOrd)) != null) {
            return bCategoryMask;
        }
        return DEFAULT_MASK;
    }

    public final BCategoryMask getAppliedCategoryMask(BOrd bOrd) {
        BCategoryMask bCategoryMask;
        if (bOrd != null && !bOrd.isNull() && (bCategoryMask = this.getOrdMap().getAppliedCategoryMask(bOrd)) != null) {
            return bCategoryMask;
        }
        return DEFAULT_MASK;
    }

    public final Type[] getServiceTypes() {
        return serviceTypes;
    }

    public final void serviceStarted() throws Exception {
    }

    public final void serviceStopped() throws Exception {
    }

    public final void started() throws Exception {
        this.rebuildLookup();
        this.thread = new UpdateThread();
        this.thread.start();
    }

    public final void stopped() throws Exception {
        this.lookup = null;
        if (this.thread != null) {
            this.thread.kill();
        }
        this.thread = null;
    }

    public final void added(Property property, Context context) {
        super.added(property, context);
        if (this.isRunning()) {
            this.rebuildLookup();
        }
    }

    public final void removed(Property property, BValue bValue, Context context) {
        super.removed(property, bValue, context);
        if (this.isRunning()) {
            this.rebuildLookup();
        }
    }

    final void rebuildLookup() {
        BCategory[] bCategoryArray = new BCategory[16];
        SlotCursor slotCursor = this.getProperties();
        while (slotCursor.nextComponent()) {
            BObject bObject = slotCursor.get();
            if (!(bObject instanceof BCategory)) continue;
            BCategory bCategory = (BCategory)bObject;
            int n = bCategory.getIndex();
            if (n <= 0) {
                bCategory.setStatus(BStatus.disabled);
                bCategory.setFaultCause("");
                continue;
            }
            if (bCategoryArray.length <= n) {
                int n2 = Math.max(bCategoryArray.length * 2, n + 1);
                if (n2 < 10) {
                    n2 = 10;
                }
                BCategory[] bCategoryArray2 = new BCategory[n2];
                System.arraycopy(bCategoryArray, 0, bCategoryArray2, 0, bCategoryArray.length);
                bCategoryArray = bCategoryArray2;
            }
            if (bCategoryArray[n] != null) {
                bCategory.setStatus(BStatus.fault);
                bCategory.setFaultCause("Duplicate index with " + bCategoryArray[n].getName());
                continue;
            }
            bCategory.setStatus(BStatus.ok);
            bCategory.setFaultCause("");
            bCategoryArray[n] = bCategory;
        }
        this.lookup = bCategoryArray;
    }

    public final void doUpdate() {
        long l;
        long l2 = Clock.ticks();
        BCategoryMask[] bCategoryMaskArray = new BCategoryMask[256];
        int n = 0;
        while (n < bCategoryMaskArray.length) {
            bCategoryMaskArray[n] = BCategoryMask.NULL;
            ++n;
        }
        ComponentSlotMap componentSlotMap = (ComponentSlotMap)Sys.getStation().fw(1);
        componentSlotMap.updateDeepOr(bCategoryMaskArray, 0);
        this.lastUpdateTicks = l = Clock.ticks();
        this.lastUpdateDuration = l - l2;
    }

    public final BIcon getIcon() {
        return icon;
    }

    public final void spy(SpyWriter spyWriter) throws Exception {
        if (this.lookup != null) {
            spyWriter.startProps("CategoryService");
            spyWriter.prop((Object)"lastUpdateTicks", BRelTime.toString(Clock.ticks() - this.lastUpdateTicks));
            spyWriter.prop((Object)"lastUpdateDuration", BRelTime.toString(this.lastUpdateDuration));
            spyWriter.endProps();
            spyWriter.startTable(true);
            spyWriter.trTitle("Lookup Table [" + this.lookup.length + ']', 2);
            int n = 0;
            while (n < this.lookup.length) {
                if (this.lookup[n] != null) {
                    spyWriter.tr("" + n, this.lookup[n].getName());
                }
                ++n;
            }
            spyWriter.endTable();
        }
        super.spy(spyWriter);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$javax$baja$category$BCategoryService;
        if (clazz == null) {
            clazz = class$javax$baja$category$BCategoryService = BCategoryService.class("[Ljavax.baja.category.BCategoryService;", false);
        }
        TYPE = Sys.loadType(clazz);
        serviceTypes = new Type[]{TYPE};
        icon = BIcon.std("category.png");
        DEFAULT_MASK = BCategoryMask.make("1");
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class UpdateThread
    extends Thread {
        boolean alive;

        public void kill() {
            this.alive = false;
            this.interrupt();
        }

        public void run() {
            while (this.alive) {
                try {
                    Thread.sleep(5000L);
                    long l = BCategoryService.this.getUpdatePeriod().getMillis();
                    if (l == 0L) continue;
                    if (l < 1000L) {
                        l = 1000L;
                    }
                    if (Clock.ticks() - BCategoryService.this.lastUpdateTicks < l) continue;
                    BCategoryService.this.doUpdate();
                }
                catch (InterruptedException interruptedException) {
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        private final /* synthetic */ void this() {
            this.alive = true;
        }

        UpdateThread() {
            super("CategoryService:Update");
            this.this();
            this.setDaemon(true);
            this.setPriority(this.getPriority() - 1);
        }
    }
}

