/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.agent;

import javax.baja.agent.AgentInfo;
import javax.baja.registry.TypeInfo;
import javax.baja.security.BPermissions;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public abstract class AgentFilter {
    public abstract boolean include(AgentInfo var1);

    public static AgentFilter is(String string) {
        return AgentFilter.is(Sys.getRegistry().getType(string));
    }

    public static AgentFilter is(Type type) {
        return AgentFilter.is(type.getTypeInfo());
    }

    public static AgentFilter is(TypeInfo typeInfo) {
        return new IsFilter(typeInfo);
    }

    public static AgentFilter not(AgentFilter agentFilter) {
        return new NotFilter(agentFilter);
    }

    public static AgentFilter has(BPermissions bPermissions) {
        return new HasFilter(bPermissions);
    }

    public static AgentFilter and(AgentFilter agentFilter, AgentFilter agentFilter2) {
        return new AndFilter(agentFilter, agentFilter2);
    }

    public static AgentFilter and(AgentFilter agentFilter, BPermissions bPermissions) {
        return AgentFilter.and(agentFilter, AgentFilter.has(bPermissions));
    }

    public static AgentFilter or(AgentFilter agentFilter, AgentFilter agentFilter2) {
        return new OrFilter(agentFilter, agentFilter2, null, null);
    }

    public static AgentFilter or(AgentFilter agentFilter, AgentFilter agentFilter2, AgentFilter agentFilter3) {
        return new OrFilter(agentFilter, agentFilter2, agentFilter3, null);
    }

    public static AgentFilter or(AgentFilter agentFilter, AgentFilter agentFilter2, AgentFilter agentFilter3, AgentFilter agentFilter4) {
        return new OrFilter(agentFilter, agentFilter2, agentFilter3, agentFilter4);
    }

    static class IsFilter
    extends AgentFilter {
        TypeInfo t;

        public final boolean include(AgentInfo agentInfo) {
            return agentInfo.getAgentType().is(this.t);
        }

        IsFilter(TypeInfo typeInfo) {
            this.t = typeInfo;
        }
    }

    static class NotFilter
    extends AgentFilter {
        AgentFilter f;

        public final boolean include(AgentInfo agentInfo) {
            return this.f.include(agentInfo) ^ true;
        }

        NotFilter(AgentFilter agentFilter) {
            this.f = agentFilter;
        }
    }

    static class HasFilter
    extends AgentFilter {
        BPermissions p;

        public final boolean include(AgentInfo agentInfo) {
            try {
                return this.p.has(agentInfo.getRequiredPermissions());
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return false;
            }
        }

        HasFilter(BPermissions bPermissions) {
            this.p = bPermissions;
        }
    }

    static class AndFilter
    extends AgentFilter {
        AgentFilter f1;
        AgentFilter f2;

        public final boolean include(AgentInfo agentInfo) {
            boolean bl = false;
            if (this.f1.include(agentInfo) && this.f2.include(agentInfo)) {
                bl = true;
            }
            return bl;
        }

        AndFilter(AgentFilter agentFilter, AgentFilter agentFilter2) {
            this.f1 = agentFilter;
            this.f2 = agentFilter2;
        }
    }

    static class OrFilter
    extends AgentFilter {
        AgentFilter f1;
        AgentFilter f2;
        AgentFilter f3;
        AgentFilter f4;

        public final boolean include(AgentInfo agentInfo) {
            if (this.f1 != null && this.f1.include(agentInfo)) {
                return true;
            }
            if (this.f2 != null && this.f2.include(agentInfo)) {
                return true;
            }
            if (this.f3 != null && this.f3.include(agentInfo)) {
                return true;
            }
            return this.f4 != null && this.f4.include(agentInfo);
        }

        OrFilter(AgentFilter agentFilter, AgentFilter agentFilter2, AgentFilter agentFilter3, AgentFilter agentFilter4) {
            this.f1 = agentFilter;
            this.f2 = agentFilter2;
            this.f3 = agentFilter3;
            this.f4 = agentFilter4;
        }
    }
}

