/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.util.jar;

import com.tridium.util.CaseInsensitiveStringTable;
import java.io.BufferedInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Manifest {
    public static final String NAME = "META-INF/MANIFEST.MF";
    private static final int LF = 10;
    private static final int CR = 13;
    private static final int COLON = 58;
    private static final int SPACE = 32;
    private CaseInsensitiveStringTable mainAttributes;
    private CaseInsensitiveStringTable attributes;

    public CaseInsensitiveStringTable getMainAttributes() {
        if (this.mainAttributes == null) {
            this.mainAttributes = new CaseInsensitiveStringTable();
        }
        return this.mainAttributes;
    }

    public CaseInsensitiveStringTable getAttributes(String string) {
        if (string.charAt(0) == '/') {
            string = string.substring(1);
        }
        return (CaseInsensitiveStringTable)this.attributes.get(string);
    }

    public void putAttributes(String string, CaseInsensitiveStringTable caseInsensitiveStringTable) {
        if (string.charAt(0) == '/') {
            string = string.substring(1);
        }
        this.attributes.put(string, (Object)caseInsensitiveStringTable);
    }

    public void write(OutputStream outputStream) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        this.write(dataOutputStream, this.mainAttributes);
        String[] stringArray = this.attributes.keyArray();
        Object[] objectArray = this.attributes.elementArray();
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            CaseInsensitiveStringTable caseInsensitiveStringTable = (CaseInsensitiveStringTable)objectArray[n];
            StringBuffer stringBuffer = new StringBuffer(80);
            stringBuffer.append("Name: ").append(string).append("\r\n");
            Manifest.checkContinuation(stringBuffer);
            dataOutputStream.writeBytes(stringBuffer.toString());
            this.write(dataOutputStream, caseInsensitiveStringTable);
            ++n;
        }
        dataOutputStream.flush();
    }

    void write(DataOutputStream dataOutputStream, CaseInsensitiveStringTable caseInsensitiveStringTable) throws IOException {
        String[] stringArray = caseInsensitiveStringTable.keyArray();
        Object[] objectArray = caseInsensitiveStringTable.elementArray();
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            String string2 = (String)objectArray[n];
            StringBuffer stringBuffer = new StringBuffer(80);
            stringBuffer.append(string).append(": ").append(string2).append("\r\n");
            Manifest.checkContinuation(stringBuffer);
            dataOutputStream.writeBytes(stringBuffer.toString());
            ++n;
        }
        dataOutputStream.writeBytes("\r\n");
    }

    static void checkContinuation(StringBuffer stringBuffer) {
        int n = stringBuffer.length();
        if (n > 72) {
            int n2;
            char[] cArray = stringBuffer.toString().toCharArray();
            if (cArray[(n2 = cArray.length) - 2] == '\r' && cArray[n2 - 1] == '\n') {
                n2 -= 2;
            }
            stringBuffer.setLength(0);
            int n3 = 0;
            while (n3 < n2) {
                stringBuffer.append(cArray[n3]);
                if (n3 > 0 && n3 % 71 == 0) {
                    stringBuffer.append("\r\n ");
                }
                ++n3;
            }
            if (stringBuffer.charAt(stringBuffer.length() - 3) == '\r' && stringBuffer.charAt(stringBuffer.length() - 2) == '\n' && stringBuffer.charAt(stringBuffer.length() - 1) == ' ') {
                stringBuffer.setLength(stringBuffer.length() - 1);
            } else if (cArray.length != n2) {
                stringBuffer.append("\r\n");
            }
        }
    }

    public void read(InputStream inputStream) throws IOException {
        int n;
        this.mainAttributes = null;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        LineInfo lineInfo = new LineInfo();
        String string = null;
        String string2 = "";
        CaseInsensitiveStringTable caseInsensitiveStringTable = new CaseInsensitiveStringTable();
        String string3 = null;
        int n2 = 0;
        while ((n = this.readLine(bufferedInputStream, lineInfo)) >= 0) {
            ++n2;
            if (n > 72) {
                Manifest.throwException("Line too long", n2);
            }
            if (lineInfo.isSectionBreak()) {
                this.addAttributes(string3, caseInsensitiveStringTable, n2);
                caseInsensitiveStringTable = new CaseInsensitiveStringTable();
                string3 = null;
                continue;
            }
            if (string == null) {
                string = lineInfo.getKey();
                string2 = lineInfo.getValue();
            } else {
                string2 = string2 + lineInfo.getValue();
            }
            if (lineInfo.isNextLineContinuation) continue;
            if (this.isName(string) && string3 == null) {
                string3 = string2;
            } else {
                this.addAttributeEntry(caseInsensitiveStringTable, string, string2, n2);
            }
            string = null;
        }
        if (string3 != null || this.mainAttributes == null) {
            this.addAttributes(string3, caseInsensitiveStringTable, n2);
        }
    }

    private final void addAttributes(String string, CaseInsensitiveStringTable caseInsensitiveStringTable, int n) throws IOException {
        if (this.mainAttributes == null) {
            this.mainAttributes = caseInsensitiveStringTable;
        } else {
            if (string == null) {
                Manifest.throwException("Section missing Name", n);
            }
            this.attributes.put(string, (Object)caseInsensitiveStringTable);
        }
    }

    private final void addAttributeEntry(CaseInsensitiveStringTable caseInsensitiveStringTable, String string, String string2, int n) {
        if (string == null) {
            return;
        }
        caseInsensitiveStringTable.put(string, (Object)string2);
    }

    private final int readLine(BufferedInputStream bufferedInputStream, LineInfo lineInfo) throws IOException {
        int n;
        lineInfo.valuePos = -1;
        lineInfo.count = 0;
        byte[] byArray = lineInfo.buf;
        int n2 = 0;
        boolean bl = false;
        do {
            n = bufferedInputStream.read();
            if (n2 == 0 && n == -1) {
                n2 = -1;
                break;
            }
            if (n == 13) {
                bufferedInputStream.mark(1);
                n = bufferedInputStream.read();
                if (n != 10) {
                    bufferedInputStream.reset();
                }
                break;
            }
            if (n == 10) break;
            if (bl && n == 32 && lineInfo.valuePos == -1) {
                lineInfo.valuePos = n2;
            }
            boolean bl2 = false;
            if (n == 58) {
                bl2 = true;
            }
            bl = bl2;
            byArray[n2++] = (byte)n;
        } while (byArray.length != n2);
        bufferedInputStream.mark(1);
        n = bufferedInputStream.read();
        boolean bl3 = false;
        if (n == 32) {
            bl3 = lineInfo.isNextLineContinuation = true;
        }
        if (!lineInfo.isNextLineContinuation) {
            bufferedInputStream.reset();
        }
        lineInfo.count = n2;
        return n2;
    }

    private final boolean isName(String string) {
        if (string.length() != 4) {
            return false;
        }
        char c = string.charAt(0);
        if (c != 'N' && c != 'n') {
            return false;
        }
        c = string.charAt(1);
        if (c != 'A' && c != 'a') {
            return false;
        }
        c = string.charAt(2);
        if (c != 'M' && c != 'm') {
            return false;
        }
        c = string.charAt(3);
        return c == 'E' || c == 'e';
    }

    static void throwException(String string, int n) throws IOException {
        if (n != -1) {
            throw new IOException(string + " [line " + n + ']');
        }
        throw new IOException(string);
    }

    public static void main(String[] stringArray) throws IOException {
        if (stringArray.length < 1) {
            System.out.println("usage: Manifest <filename>");
            return;
        }
        System.out.println("--- \"" + stringArray[0] + "\" ---");
        Manifest manifest = new Manifest(new FileInputStream(stringArray[0]));
        manifest.write(System.out);
    }

    private final /* synthetic */ void this() {
        this.attributes = new CaseInsensitiveStringTable();
    }

    public Manifest() {
        this.this();
    }

    public Manifest(InputStream inputStream) throws IOException {
        this.this();
        this.read(inputStream);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    static class LineInfo {
        int valuePos;
        byte[] buf;
        int count;
        boolean isNextLineContinuation;

        String getKey() {
            if (this.valuePos == -1) {
                return new String(this.buf, 0, 0, this.count);
            }
            return new String(this.buf, 0, 0, this.valuePos - 1);
        }

        String getValue() {
            if (this.valuePos == -1) {
                return new String(this.buf, 0, this.count);
            }
            return new String(this.buf, 0, this.valuePos + 1, this.count - this.valuePos - 1);
        }

        boolean isSectionBreak() {
            boolean bl = false;
            if (this.count == 0) {
                bl = true;
            }
            return bl;
        }

        private final /* synthetic */ void this() {
            this.valuePos = -1;
            this.buf = new byte[80];
        }

        LineInfo() {
            this.this();
        }
    }
}

