/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.util.jar;

import com.tridium.util.jar.JarEntry;
import com.tridium.util.jar.Manifest;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class JarFile {
    File file;
    public ZipFile zip;
    URL url;
    long openTime;

    public void check() {
        if (this.file.lastModified() != this.openTime) {
            try {
                System.out.println("WARNING: JarFile.reopen: " + this.file);
                this.zip.close();
                this.zip = new ZipFile(this.file);
                this.openTime = this.file.lastModified();
            }
            catch (Exception exception) {
                System.out.println("  " + exception);
            }
        }
    }

    public void close() throws IOException {
        this.zip.close();
        this.zip = null;
    }

    public File getFile() {
        return this.file;
    }

    public URL getFileURL() {
        return this.url;
    }

    public Enumeration entries() {
        this.check();
        return this.zip.entries();
    }

    public JarEntry getJarEntry(String string) {
        this.check();
        ZipEntry zipEntry = this.zip.getEntry(string);
        if (zipEntry != null) {
            return new JarEntry(this, zipEntry);
        }
        return null;
    }

    public URL getResource(String string) {
        JarEntry jarEntry = this.getJarEntry(string);
        if (jarEntry != null) {
            return jarEntry.getURL();
        }
        return null;
    }

    public Manifest getManifest() throws IOException {
        JarEntry jarEntry = this.getJarEntry("META-INF/MANIFEST.MF");
        if (jarEntry == null) {
            return null;
        }
        InputStream inputStream = jarEntry.getInputStream();
        Manifest manifest = new Manifest(inputStream);
        inputStream.close();
        return manifest;
    }

    public String toString() {
        return this.file.toString();
    }

    public JarFile(File file) throws ZipException, IOException {
        if (!file.exists()) {
            throw new FileNotFoundException("" + file);
        }
        this.file = file;
        this.zip = new ZipFile(file);
        this.url = file.toURL();
        this.openTime = file.lastModified();
    }
}

