/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.util.graph;

import com.tridium.util.graph.CyclicGraphException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Digraph {
    private static final int WHITE = 0;
    private static final int GRAY = 1;
    private static final int BLACK = 2;
    private Map graph;

    public boolean hasVertex(Object object) {
        boolean bl = false;
        if (this.graph.get(object) != null) {
            bl = true;
        }
        return bl;
    }

    public void addVertex(Object object) {
        try {
            this.addEdge(object, null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("vertex cannot be null.");
        }
    }

    public void addEdge(Object object, Object object2) {
        if (object == null) {
            throw new IllegalArgumentException("fromVertex cannot be null.");
        }
        Vertex vertex = this.getVertex(object);
        if (object2 != null) {
            Vertex vertex2 = this.getVertex(object2);
            vertex.kids.add(vertex2);
        }
    }

    public void removeEdge(Object object, Object object2) {
        if (object == null) {
            throw new IllegalArgumentException("fromVertex cannot be null.");
        }
        Vertex vertex = (Vertex)this.graph.get(object);
        if (vertex == null) {
            return;
        }
        if (object2 != null) {
            vertex.kids.remove(object2);
        } else {
            vertex.kids.clear();
            this.graph.remove(object);
            Iterator iterator = this.graph.values().iterator();
            while (iterator.hasNext()) {
                ((Vertex)iterator.next()).kids.remove(vertex);
            }
        }
    }

    public void removeVertex(Object object) {
        try {
            this.removeEdge(object, null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("vertex cannot be null.");
        }
    }

    public Object[] getNeighbors(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("fromVertex cannot be null.");
        }
        Vertex vertex = this.getVertex(object);
        if (vertex == null) {
            throw new IllegalArgumentException("fromVertex is not in the graph.");
        }
        Iterator iterator = vertex.kids.iterator();
        Object[] objectArray = new Object[vertex.kids.size()];
        int n = 0;
        while (iterator.hasNext()) {
            objectArray[n++] = ((Vertex)iterator.next()).obj;
        }
        return objectArray;
    }

    public Object[] topologicalSort() {
        final LinkedList linkedList = new LinkedList();
        DepthFirstSearch depthFirstSearch = new DepthFirstSearch(this){

            protected final void visit(Vertex vertex) {
                super.visit(vertex);
                linkedList.addFirst(vertex.obj);
            }
        };
        depthFirstSearch.search();
        return linkedList.toArray(new Object[linkedList.size()]);
    }

    public boolean isCyclic() {
        try {
            new DepthFirstSearch().search();
            return false;
        }
        catch (CyclicGraphException cyclicGraphException) {
            return true;
        }
    }

    private final Vertex getVertex(Object object) {
        Vertex vertex = (Vertex)this.graph.get(object);
        if (vertex == null) {
            vertex = new Vertex(object);
            this.graph.put(object, vertex);
        }
        return vertex;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.graph.values().iterator();
        while (iterator.hasNext()) {
            Vertex vertex = (Vertex)iterator.next();
            stringBuffer.append(vertex.obj).append(": ").append(vertex.kids).append("\n");
        }
        return stringBuffer.toString();
    }

    static /* synthetic */ int access$0() {
        return 0;
    }

    static /* synthetic */ int access$2() {
        return 1;
    }

    static /* synthetic */ int access$3() {
        return 2;
    }

    private final /* synthetic */ void this() {
        this.graph = new HashMap();
    }

    public Digraph() {
        this.this();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static class Vertex {
        private Object obj;
        private int color;
        private HashSet kids;

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Vertex vertex = (Vertex)object;
            return !(this.obj == null ? vertex.obj != null : !this.obj.equals(vertex.obj));
        }

        public int hashCode() {
            int n = 1;
            int n2 = 0;
            if (this.obj != null) {
                n2 = this.obj.hashCode();
            }
            n = 31 * n + n2;
            return n;
        }

        public String toString() {
            return this.obj.toString();
        }

        private final /* synthetic */ void this() {
            this.color = 0;
            this.kids = new HashSet();
        }

        public Vertex(Object object) {
            this.this();
            this.obj = object;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class DepthFirstSearch {
        private final void search() {
            Vertex vertex;
            Iterator iterator = Digraph.this.graph.values().iterator();
            while (iterator.hasNext()) {
                vertex = (Vertex)iterator.next();
                vertex.color = 0;
            }
            iterator = Digraph.this.graph.values().iterator();
            while (iterator.hasNext()) {
                vertex = (Vertex)iterator.next();
                switch (vertex.color) {
                    case 1: {
                        throw new IllegalStateException();
                    }
                    case 0: {
                        this.visit(vertex);
                        break;
                    }
                }
            }
        }

        protected void visit(Vertex vertex) {
            vertex.color = 1;
            Iterator iterator = vertex.kids.iterator();
            while (iterator.hasNext()) {
                Vertex vertex2 = (Vertex)iterator.next();
                switch (vertex2.color) {
                    case 1: {
                        throw new CyclicGraphException(vertex.toString() + " has cyclic dependency on " + vertex2.toString(), vertex.obj, vertex2.obj);
                    }
                    case 0: {
                        this.visit(vertex2);
                        break;
                    }
                }
            }
            vertex.color = 2;
        }

        private DepthFirstSearch() {
        }
    }
}

