/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import javax.baja.io.BajaIOException;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BajaException;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Localizable;
import javax.baja.xml.XException;

public class ThrowableUtil {
    static final int DEFAULT_STACK_DEPTH = 20;

    public static RuntimeException toRuntime(Throwable throwable) {
        if (throwable instanceof RuntimeException) {
            return (RuntimeException)throwable;
        }
        return new BajaRuntimeException(throwable);
    }

    public static Throwable getCause(Throwable throwable) {
        if (throwable instanceof BajaException) {
            return ((BajaException)throwable).getCause();
        }
        if (throwable instanceof BajaRuntimeException) {
            return ((BajaRuntimeException)throwable).getCause();
        }
        if (throwable instanceof BajaIOException) {
            return ((BajaIOException)throwable).getCause();
        }
        if (throwable instanceof XException) {
            return ((XException)throwable).getCause();
        }
        if (throwable instanceof InvocationTargetException) {
            return ((InvocationTargetException)throwable).getTargetException();
        }
        if (throwable instanceof ExceptionInInitializerError) {
            return ((ExceptionInInitializerError)throwable).getException();
        }
        return null;
    }

    public static String getStack() {
        return ThrowableUtil.dumpToString(new Exception());
    }

    public static String dumpToString(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        ThrowableUtil.dump(stringWriter, throwable, 0, 20);
        return stringWriter.toString();
    }

    public static String dumpToString(Throwable throwable, int n) {
        StringWriter stringWriter = new StringWriter();
        ThrowableUtil.dump(stringWriter, throwable, 0, n);
        return stringWriter.toString();
    }

    public static void dump(Writer writer, Throwable throwable) {
        ThrowableUtil.dump(writer, throwable, 0, 20);
    }

    public static void dump(Writer writer, Throwable throwable, int n) {
        ThrowableUtil.dump(writer, throwable, 0, n);
    }

    public static void dump(Throwable throwable) {
        ThrowableUtil.dump(System.out, throwable);
    }

    public static void dump(OutputStream outputStream, Throwable throwable) {
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
            ThrowableUtil.dump(outputStreamWriter, throwable, 0, 20);
            ((Writer)outputStreamWriter).flush();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private static final void dump(Writer writer, Throwable throwable, int n, int n2) {
        try {
            if (throwable == null) {
                return;
            }
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            throwable.printStackTrace(printWriter);
            printWriter.flush();
            BufferedReader bufferedReader = new BufferedReader(new StringReader(stringWriter.toString()));
            int n3 = 0;
            while (n3 < n2) {
                String string = bufferedReader.readLine();
                if (string == null) break;
                writer.write(TextUtil.getSpaces((int)(n * 2)));
                int n4 = string.length();
                int n5 = 0;
                while (n5 < n4) {
                    char c = string.charAt(n5);
                    if (c == '\t') {
                        writer.write("   ");
                    } else {
                        writer.write(c);
                    }
                    ++n5;
                }
                writer.write(10);
                ++n3;
            }
            Throwable throwable2 = ThrowableUtil.getCause(throwable);
            if (throwable2 != null) {
                ThrowableUtil.dump(writer, throwable2, n + 1, n2);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static Localizable toLocalizable(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        if (throwable instanceof Localizable) {
            return (Localizable)((Object)throwable);
        }
        return ThrowableUtil.toLocalizable(ThrowableUtil.getCause(throwable));
    }
}

