/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.util;

import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.TextUtil;
import javax.baja.space.BComponentSpace;
import javax.baja.sys.BComponent;
import javax.baja.sys.BLink;
import javax.baja.sys.Knob;

public class LinkUtil {
    public static String toDisplay(BLink bLink) {
        try {
            return LinkUtil.toDisplaySource(bLink) + " -> " + LinkUtil.toDisplayTarget(bLink);
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
            return "err";
        }
    }

    public static String toDisplaySource(BLink bLink) {
        try {
            BComponentSpace bComponentSpace = LinkUtil.toSpace(bLink);
            return LinkUtil.toPath(bComponentSpace, bLink.getSourceOrd()) + '.' + LinkUtil.toSlot(bLink.getSourceSlotName());
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
            return "err";
        }
    }

    public static String toDisplayTarget(BLink bLink) {
        try {
            return LinkUtil.toPath(bLink.getTargetComponent()) + '.' + LinkUtil.toSlot(bLink.getTargetSlotName());
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
            return "err";
        }
    }

    public static String toDisplay(Knob knob) {
        try {
            return LinkUtil.toDisplaySource(knob) + " -> " + LinkUtil.toDisplayTarget(knob);
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
            return "err";
        }
    }

    public static String toDisplaySource(Knob knob) {
        try {
            return LinkUtil.toPath(knob.getSourceComponent()) + '.' + LinkUtil.toSlot(knob.getSourceSlotName());
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
            return "err";
        }
    }

    public static String toDisplayTarget(Knob knob) {
        try {
            BComponentSpace bComponentSpace = LinkUtil.toSpace(knob);
            return LinkUtil.toPath(bComponentSpace, knob.getTargetOrd()) + '.' + LinkUtil.toSlot(knob.getTargetSlotName());
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
            return "err";
        }
    }

    public static BComponentSpace toSpace(BLink bLink) {
        return bLink.getTargetComponent().getComponentSpace();
    }

    public static BComponentSpace toSpace(Knob knob) {
        return knob.getSourceComponent().getComponentSpace();
    }

    public static String toPath(BComponent bComponent) {
        return LinkUtil.toPath(bComponent.getSlotPath());
    }

    public static String toPath(BComponentSpace bComponentSpace, BOrd bOrd) {
        String string = bOrd.toString();
        if (!string.startsWith("h:")) {
            return string;
        }
        String string2 = string.substring(2);
        SlotPath slotPath = bComponentSpace.handleToSlotPath(string2);
        if (slotPath == null) {
            return string;
        }
        return LinkUtil.toPath(slotPath);
    }

    public static String toPath(SlotPath slotPath) {
        return slotPath.toDisplayString();
    }

    public static String toSlot(String string) {
        return TextUtil.toFriendly((String)string);
    }
}

