/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.timezone;

import com.tridium.sys.Nre;
import com.tridium.timezone.HistoricalDstRule;
import com.tridium.timezone.HistoricalTimeZone;
import com.tridium.timezone.HistoricalTimeZoneDate;
import com.tridium.timezone.HistoricalTimeZoneEra;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import javax.baja.log.Log;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.ByteBuffer;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BMonth;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BTime;
import javax.baja.sys.BWeekday;
import javax.baja.timezone.BTimeZone;
import javax.baja.timezone.TimeZoneDatabase;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class TzJarUtil {
    private static final short INVALID_INDEX = 7334;
    private static final Log logger = Log.getLog("timezone.jarUtil");
    private static final long MAX_MILLIS = 253433923199999L;
    private static final long MIN_MILLIS = -2208988800000L;
    static /* synthetic */ Class class$javax$baja$timezone$BTimeZone;
    static /* synthetic */ Class class$com$tridium$timezone$HistoricalDstRule;
    static /* synthetic */ Class class$java$lang$String;

    public static final Array getTimeZones(InputStream inputStream) {
        return TzJarUtil.getTimeZones(inputStream, System.currentTimeMillis());
    }

    public static final synchronized Array getTimeZones(InputStream inputStream, long l) {
        logger.trace("entered TzJarUtil::getTimeZones(" + l + ')');
        Class clazz = class$javax$baja$timezone$BTimeZone;
        if (clazz == null) {
            clazz = class$javax$baja$timezone$BTimeZone = TzJarUtil.class("[Ljavax.baja.timezone.BTimeZone;", false);
        }
        Array array = new Array(clazz);
        HistoricalTimeZoneDate historicalTimeZoneDate = HistoricalTimeZoneDate.makeFromEpochMillis(l);
        boolean bl = false;
        if (historicalTimeZoneDate.getTheYear() < HistoricalTimeZone.MIN_YEAR) {
            bl = true;
        }
        boolean bl2 = bl;
        boolean bl3 = false;
        if (historicalTimeZoneDate.getTheYear() >= HistoricalTimeZone.MAX_YEAR) {
            bl3 = true;
        }
        boolean bl4 = bl3;
        try {
            HistoricalTimeZoneDate historicalTimeZoneDate2 = null;
            HistoricalTimeZoneDate historicalTimeZoneDate3 = null;
            HistoricalTimeZoneDate historicalTimeZoneDate4 = HistoricalTimeZoneDate.makeMinimumDate();
            HistoricalTimeZoneDate historicalTimeZoneDate5 = HistoricalTimeZoneDate.makeMinimumDate();
            HistoricalTimeZoneEra historicalTimeZoneEra = null;
            Class clazz2 = class$com$tridium$timezone$HistoricalDstRule;
            if (clazz2 == null) {
                clazz2 = class$com$tridium$timezone$HistoricalDstRule = TzJarUtil.class("[Lcom.tridium.timezone.HistoricalDstRule;", false);
            }
            Array array2 = new Array(clazz2);
            Class clazz3 = class$com$tridium$timezone$HistoricalDstRule;
            if (clazz3 == null) {
                clazz3 = class$com$tridium$timezone$HistoricalDstRule = TzJarUtil.class("[Lcom.tridium.timezone.HistoricalDstRule;", false);
            }
            Array array3 = new Array(clazz3);
            Class clazz4 = class$java$lang$String;
            if (clazz4 == null) {
                clazz4 = class$java$lang$String = TzJarUtil.class("[Ljava.lang.String;", false);
            }
            Array array4 = new Array(clazz4);
            Class clazz5 = class$java$lang$String;
            if (clazz5 == null) {
                clazz5 = class$java$lang$String = TzJarUtil.class("[Ljava.lang.String;", false);
            }
            Array array5 = new Array(clazz5);
            short s = 0;
            short s2 = 0;
            short s3 = 0;
            short s4 = 0;
            short s5 = 0;
            short s6 = 0;
            short s7 = 0;
            short s8 = 0;
            short s9 = 0;
            short s10 = 0;
            short s11 = 0;
            short s12 = 7334;
            short s13 = 7334;
            short s14 = 7334;
            short s15 = 7334;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            String string = null;
            String string2 = null;
            StringBuffer stringBuffer = new StringBuffer();
            char c = '0';
            JarDataInputStream jarDataInputStream = new JarDataInputStream(inputStream);
            JarEntry jarEntry = null;
            while ((jarEntry = jarDataInputStream.getNextJarEntry()) != null) {
                if (jarEntry.getName().endsWith(".class") || jarEntry.getName().endsWith(".properties") || jarEntry.getName().startsWith("META-INF") || jarEntry.getName().startsWith("meta-inf")) {
                    jarDataInputStream.closeEntry();
                    continue;
                }
                s = jarDataInputStream.readShort();
                s2 = jarDataInputStream.readShort();
                s3 = jarDataInputStream.readShort();
                s4 = jarDataInputStream.readShort();
                s5 = 0;
                s6 = 0;
                s7 = 0;
                s8 = 0;
                s9 = 0;
                s10 = 0;
                s11 = 0;
                s12 = 7334;
                s13 = 7334;
                s14 = 7334;
                s15 = 7334;
                n = 0;
                n2 = 0;
                n3 = 0;
                string = null;
                string2 = null;
                stringBuffer = new StringBuffer();
                c = '\u0000';
                array2.clear();
                array3.clear();
                array4.clear();
                array5.clear();
                if (s != 0) {
                    c = jarDataInputStream.readChar();
                    while (c != ';') {
                        if (c == ',') {
                            array4.add((Object)stringBuffer.toString());
                            stringBuffer = new StringBuffer();
                        } else {
                            stringBuffer.append(c);
                        }
                        c = jarDataInputStream.readChar();
                    }
                    array4.add((Object)stringBuffer.toString());
                    stringBuffer = new StringBuffer();
                }
                if (s2 != 0) {
                    c = jarDataInputStream.readChar();
                    while (c != ';') {
                        if (c == ',') {
                            array5.add((Object)stringBuffer.toString());
                            stringBuffer = new StringBuffer();
                        } else {
                            stringBuffer.append(c);
                        }
                        c = jarDataInputStream.readChar();
                    }
                    array5.add((Object)stringBuffer.toString());
                }
                short s16 = 0;
                while (s16 < s3) {
                    s7 = jarDataInputStream.readShort();
                    s9 = jarDataInputStream.readShort();
                    s8 = jarDataInputStream.readShort();
                    s10 = jarDataInputStream.readShort();
                    n = jarDataInputStream.readInt();
                    s11 = jarDataInputStream.readShort();
                    n3 = jarDataInputStream.readInt();
                    s15 = jarDataInputStream.readShort();
                    if ((s15 < 0 || s15 >= s) && s15 != 7334) {
                        logger.error("could not parse timezone (invalid dst uses letter) from timezones.jar; returning null");
                        try {
                            jarDataInputStream.closeEntry();
                        }
                        catch (IOException iOException) {}
                        try {
                            jarDataInputStream.readFully();
                        }
                        catch (IOException iOException) {}
                        try {
                            jarDataInputStream.close();
                        }
                        catch (IOException iOException) {}
                        return null;
                    }
                    string = s15 == 7334 ? "" : (String)array4.get((int)s15);
                    array2.add((Object)HistoricalDstRule.make("", string, "", HistoricalTimeZoneDate.START_OF_TIME, HistoricalTimeZoneDate.END_OF_TIME, HistoricalTimeZoneDate.make((short)-1, BMonth.make(s7), HistoricalTimeZoneDate.HistoricalTimeZoneDay.make(s9, s8, BWeekday.make(s10)), BTime.make(BRelTime.make(n)), s11), n3));
                    s16 = (short)(s16 + 1);
                }
                s16 = 0;
                while (s16 < s4) {
                    s7 = jarDataInputStream.readShort();
                    s9 = jarDataInputStream.readShort();
                    s8 = jarDataInputStream.readShort();
                    s10 = jarDataInputStream.readShort();
                    n = jarDataInputStream.readInt();
                    s11 = jarDataInputStream.readShort();
                    n3 = jarDataInputStream.readInt();
                    s15 = jarDataInputStream.readShort();
                    if ((s15 < 0 || s15 >= s) && s15 != 7334) {
                        logger.error("could not parse timezone (invalid std uses letter) from timezones.jar; returning null");
                        try {
                            jarDataInputStream.closeEntry();
                        }
                        catch (IOException iOException) {}
                        try {
                            jarDataInputStream.readFully();
                        }
                        catch (IOException iOException) {}
                        try {
                            jarDataInputStream.close();
                        }
                        catch (IOException iOException) {}
                        return null;
                    }
                    string = s15 == 7334 ? "" : (String)array4.get((int)s15);
                    array3.add((Object)HistoricalDstRule.make("", string, "", HistoricalTimeZoneDate.START_OF_TIME, HistoricalTimeZoneDate.END_OF_TIME, HistoricalTimeZoneDate.make((short)-1, BMonth.make(s7), HistoricalTimeZoneDate.HistoricalTimeZoneDay.make(s9, s8, BWeekday.make(s10)), BTime.make(BRelTime.make(n)), s11), n3));
                    s16 = (short)(s16 + 1);
                }
                s5 = jarDataInputStream.readShort();
                historicalTimeZoneDate2 = HistoricalTimeZoneDate.makeMaximumDate();
                historicalTimeZoneDate3 = HistoricalTimeZoneDate.makeMinimumDate();
                for (s16 = 0; s16 < s5; s16 = (short)(s16 + 1)) {
                    s6 = jarDataInputStream.readShort();
                    s7 = jarDataInputStream.readShort();
                    s9 = jarDataInputStream.readShort();
                    s8 = jarDataInputStream.readShort();
                    s10 = jarDataInputStream.readShort();
                    n = jarDataInputStream.readInt();
                    s11 = jarDataInputStream.readShort();
                    historicalTimeZoneDate5.update(s6, BMonth.make(s7), HistoricalTimeZoneDate.HistoricalTimeZoneDay.make(s9, s8, BWeekday.make(s10)), BTime.make(BRelTime.make(n)), s11);
                    if (!bl4 && historicalTimeZoneDate5.occursBeforeAbsolute(historicalTimeZoneDate)) break;
                    n2 = jarDataInputStream.readInt();
                    s12 = jarDataInputStream.readShort();
                    s13 = jarDataInputStream.readShort();
                    s14 = jarDataInputStream.readShort();
                    if (bl4) break;
                    historicalTimeZoneDate4.update(historicalTimeZoneDate5);
                    if (s16 != s5 || !bl2) continue;
                }
                if (s16 == s5) {
                    historicalTimeZoneDate3.update(HistoricalTimeZoneDate.makeFromEpochMillis(-2208988800000L));
                    historicalTimeZoneDate2.update(historicalTimeZoneDate5);
                } else {
                    historicalTimeZoneDate3.update(historicalTimeZoneDate5);
                    if (bl4) {
                        historicalTimeZoneDate2.update(HistoricalTimeZoneDate.makeFromEpochMillis(253433923199999L));
                    } else {
                        historicalTimeZoneDate2.update(historicalTimeZoneDate4);
                    }
                }
                if ((s14 < 0 || s14 >= s2) && s14 != 7334) {
                    logger.error("could not parse timezone (invalid uses format) from timezones.jar; returning null");
                    try {
                        jarDataInputStream.closeEntry();
                    }
                    catch (IOException iOException) {}
                    try {
                        jarDataInputStream.readFully();
                    }
                    catch (IOException iOException) {}
                    try {
                        jarDataInputStream.close();
                    }
                    catch (IOException iOException) {}
                    return null;
                }
                string2 = s14 == 7334 ? "" : (String)array5.get((int)s14);
                historicalTimeZoneEra = HistoricalTimeZoneEra.make(n2, "", string2, historicalTimeZoneDate2);
                if (s12 >= 0 && s12 < s3 || s12 == 7334) {
                    if (s12 != 7334) {
                        historicalTimeZoneEra.addRule((HistoricalDstRule)array2.get((int)s12));
                    }
                } else {
                    logger.error("could not parse timezone (invalid uses start rule) from timezones.jar; returning null");
                    try {
                        jarDataInputStream.closeEntry();
                    }
                    catch (IOException iOException) {}
                    try {
                        jarDataInputStream.readFully();
                    }
                    catch (IOException iOException) {}
                    try {
                        jarDataInputStream.close();
                    }
                    catch (IOException iOException) {}
                    return null;
                }
                if (s13 >= 0 && s13 < s4 || s13 == 7334) {
                    if (s13 != 7334) {
                        historicalTimeZoneEra.addRule((HistoricalDstRule)array3.get((int)s13));
                    }
                } else {
                    logger.error("could not parse timezone (invalid uses end rule) from timezones.jar; returning null");
                    try {
                        jarDataInputStream.closeEntry();
                    }
                    catch (IOException iOException) {}
                    try {
                        jarDataInputStream.readFully();
                    }
                    catch (IOException iOException) {}
                    try {
                        jarDataInputStream.close();
                    }
                    catch (IOException iOException) {}
                    return null;
                }
                historicalTimeZoneEra.setValidFromDate(historicalTimeZoneDate3);
                array.add(BTimeZone.DEFAULT.fw(1102, HistoricalTimeZone.make(jarEntry.getName().replace('\\', '/'), historicalTimeZoneEra), null, null, null));
                jarDataInputStream.closeEntry();
            }
            try {
                jarDataInputStream.readFully();
            }
            catch (IOException iOException) {}
            try {
                jarDataInputStream.close();
            }
            catch (IOException iOException) {}
        }
        catch (IOException iOException) {
            logger.error("error parsing file: timezones.jar; " + iOException.getMessage());
        }
        return array;
    }

    public static final HistoricalTimeZone getTimeZone(String string) {
        return TzJarUtil.getTimeZone(string, System.currentTimeMillis());
    }

    public static final HistoricalTimeZone getTimeZone(String string, long l) {
        return TzJarUtil.decodeTimeZone(string, l, false, false);
    }

    public static final void dumpTimeZone(String string) {
        TzJarUtil.decodeTimeZone(string, 0L, false, true);
    }

    public static final HistoricalTimeZone getCompleteTimeZone(String string) {
        return TzJarUtil.decodeTimeZone(string, 0L, true, false);
    }

    private static final synchronized HistoricalTimeZone decodeTimeZone(String string, long l, boolean bl, boolean bl2) {
        boolean bl3;
        logger.trace("entered decodeTimeZone(" + string + ", " + l);
        HistoricalTimeZoneDate historicalTimeZoneDate = HistoricalTimeZoneDate.makeFromEpochMillis(l);
        boolean bl4 = false;
        if (historicalTimeZoneDate.getTheYear() < HistoricalTimeZone.MIN_YEAR) {
            bl4 = true;
        }
        boolean bl5 = bl4;
        boolean bl6 = false;
        if (historicalTimeZoneDate.getTheYear() >= HistoricalTimeZone.MAX_YEAR) {
            bl6 = bl3 = true;
        }
        if (!TimeZoneDatabase.isZoneIdSupported(string)) {
            logger.error("the timezone " + string + " is not supported by timezones.jar, returning null");
            return null;
        }
        HistoricalTimeZoneDate historicalTimeZoneDate2 = HistoricalTimeZoneDate.makeMaximumDate();
        HistoricalTimeZoneDate historicalTimeZoneDate3 = HistoricalTimeZoneDate.makeMinimumDate();
        HistoricalTimeZoneDate historicalTimeZoneDate4 = HistoricalTimeZoneDate.makeMaximumDate();
        HistoricalTimeZoneDate historicalTimeZoneDate5 = HistoricalTimeZoneDate.makeMaximumDate();
        HistoricalTimeZoneEra historicalTimeZoneEra = null;
        HistoricalTimeZone historicalTimeZone = null;
        Class clazz = class$com$tridium$timezone$HistoricalDstRule;
        if (clazz == null) {
            clazz = class$com$tridium$timezone$HistoricalDstRule = TzJarUtil.class("[Lcom.tridium.timezone.HistoricalDstRule;", false);
        }
        Array array = new Array(clazz);
        Class clazz2 = class$com$tridium$timezone$HistoricalDstRule;
        if (clazz2 == null) {
            clazz2 = class$com$tridium$timezone$HistoricalDstRule = TzJarUtil.class("[Lcom.tridium.timezone.HistoricalDstRule;", false);
        }
        Array array2 = new Array(clazz2);
        Class clazz3 = class$java$lang$String;
        if (clazz3 == null) {
            clazz3 = class$java$lang$String = TzJarUtil.class("[Ljava.lang.String;", false);
        }
        Array array3 = new Array(clazz3);
        Class clazz4 = class$java$lang$String;
        if (clazz4 == null) {
            clazz4 = class$java$lang$String = TzJarUtil.class("[Ljava.lang.String;", false);
        }
        Array array4 = new Array(clazz4);
        try {
            JarEntry jarEntry = null;
            DataInputStream dataInputStream = null;
            JarFile jarFile = null;
            jarFile = new JarFile(Nre.bootEnv.findTimeZoneDatabase());
            jarEntry = jarFile.getJarEntry(string.replace('/', '\\'));
            if (jarEntry == null) {
                logger.error("could not find the timezone: " + string + " in local timezones.jar");
                jarFile.close();
                throw new IOException();
            }
            dataInputStream = new DataInputStream(jarFile.getInputStream(jarEntry));
            short s = dataInputStream.readShort();
            short s2 = dataInputStream.readShort();
            short s3 = dataInputStream.readShort();
            short s4 = dataInputStream.readShort();
            short s5 = 0;
            short s6 = 0;
            short s7 = 0;
            short s8 = 0;
            short s9 = 0;
            short s10 = 0;
            short s11 = 0;
            short s12 = 7334;
            short s13 = 7334;
            short s14 = 7334;
            short s15 = 7334;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            String string2 = null;
            String string3 = null;
            StringBuffer stringBuffer = new StringBuffer();
            char c = '0';
            if (s != 0) {
                c = dataInputStream.readChar();
                while (c != ';') {
                    if (c == ',') {
                        array3.add((Object)stringBuffer.toString());
                        stringBuffer = new StringBuffer();
                    } else {
                        stringBuffer.append(c);
                    }
                    c = dataInputStream.readChar();
                }
                array3.add((Object)stringBuffer.toString());
                stringBuffer = new StringBuffer();
            }
            if (s2 != 0) {
                c = dataInputStream.readChar();
                while (c != ';') {
                    if (c == ',') {
                        array4.add((Object)stringBuffer.toString());
                        stringBuffer = new StringBuffer();
                    } else {
                        stringBuffer.append(c);
                    }
                    c = dataInputStream.readChar();
                }
                array4.add((Object)stringBuffer.toString());
            }
            short s16 = 0;
            while (s16 < s3) {
                s7 = dataInputStream.readShort();
                s9 = dataInputStream.readShort();
                s8 = dataInputStream.readShort();
                s10 = dataInputStream.readShort();
                n = dataInputStream.readInt();
                s11 = dataInputStream.readShort();
                n3 = dataInputStream.readInt();
                s15 = dataInputStream.readShort();
                if ((s15 < 0 || s15 >= s) && s15 != 7334) {
                    logger.error("could not parse timezone (invalid dst uses letter) from timezones.jar; returning null");
                    dataInputStream.close();
                    jarFile.close();
                    return null;
                }
                string2 = s15 == 7334 ? "" : (String)array3.get((int)s15);
                array.add((Object)HistoricalDstRule.make("", string2, "", HistoricalTimeZoneDate.START_OF_TIME, HistoricalTimeZoneDate.END_OF_TIME, HistoricalTimeZoneDate.make((short)-1, BMonth.make(s7), HistoricalTimeZoneDate.HistoricalTimeZoneDay.make(s9, s8, BWeekday.make(s10)), BTime.make(BRelTime.make(n)), s11), n3));
                s16 = (short)(s16 + 1);
            }
            s16 = 0;
            while (s16 < s4) {
                s7 = dataInputStream.readShort();
                s9 = dataInputStream.readShort();
                s8 = dataInputStream.readShort();
                s10 = dataInputStream.readShort();
                n = dataInputStream.readInt();
                s11 = dataInputStream.readShort();
                n3 = dataInputStream.readInt();
                s15 = dataInputStream.readShort();
                if ((s15 < 0 || s15 >= s) && s15 != 7334) {
                    logger.error("could not parse timezone (invalid std uses letter) from timezones.jar; returning null");
                    dataInputStream.close();
                    jarFile.close();
                    return null;
                }
                string2 = s15 == 7334 ? "" : (String)array3.get((int)s15);
                array2.add((Object)HistoricalDstRule.make("", string2, "", HistoricalTimeZoneDate.START_OF_TIME, HistoricalTimeZoneDate.END_OF_TIME, HistoricalTimeZoneDate.make((short)-1, BMonth.make(s7), HistoricalTimeZoneDate.HistoricalTimeZoneDay.make(s9, s8, BWeekday.make(s10)), BTime.make(BRelTime.make(n)), s11), n3));
                s16 = (short)(s16 + 1);
            }
            s5 = dataInputStream.readShort();
            s16 = 0;
            while ((bl2 || bl) && s16 < s5 || !bl2 && !bl && s16 < s5) {
                s6 = dataInputStream.readShort();
                s7 = dataInputStream.readShort();
                s9 = dataInputStream.readShort();
                s8 = dataInputStream.readShort();
                s10 = dataInputStream.readShort();
                n = dataInputStream.readInt();
                s11 = dataInputStream.readShort();
                historicalTimeZoneDate5.update(s6, BMonth.make(s7), HistoricalTimeZoneDate.HistoricalTimeZoneDay.make(s9, s8, BWeekday.make(s10)), BTime.make(BRelTime.make(n)), s11);
                if (!bl2 && !bl && !bl3 && historicalTimeZoneDate5.occursBeforeAbsolute(historicalTimeZoneDate)) break;
                n2 = dataInputStream.readInt();
                s12 = dataInputStream.readShort();
                s13 = dataInputStream.readShort();
                s14 = dataInputStream.readShort();
                if (bl3 || (s16 = (short)(s16 + 1)) == s5 && bl5 && !bl && !bl2) break;
                if (!bl2 && !bl) {
                    historicalTimeZoneDate4.update(historicalTimeZoneDate5);
                    continue;
                }
                if ((s14 < 0 || s14 >= s2) && s14 != 7334) {
                    logger.error("could not parse timezone: " + string + " (invalid uses format) from timezones.jar; returning null");
                    dataInputStream.close();
                    jarFile.close();
                    return null;
                }
                string3 = s14 == 7334 ? "" : (String)array4.get((int)s14);
                historicalTimeZoneEra = HistoricalTimeZoneEra.make(n2, "", string3, new HistoricalTimeZoneDate(historicalTimeZoneDate5));
                if (s12 >= 0 && s12 < s3 || s12 == 7334) {
                    if (s12 != 7334) {
                        historicalTimeZoneEra.addRule((HistoricalDstRule)array.get((int)s12));
                    }
                } else {
                    logger.error("could not parse timezone: " + string + " (invalid uses start rule) from timezones.jar; returning null");
                    dataInputStream.close();
                    jarFile.close();
                    return null;
                }
                if (s13 >= 0 && s13 < s4 || s13 == 7334) {
                    if (s13 != 7334) {
                        historicalTimeZoneEra.addRule((HistoricalDstRule)array2.get((int)s13));
                    }
                } else {
                    logger.error("could not parse timezone: " + string + " (invalid uses end rule) from timezones.jar; returning null");
                    dataInputStream.close();
                    jarFile.close();
                    return null;
                }
                if (historicalTimeZone == null) {
                    historicalTimeZone = HistoricalTimeZone.make(string);
                }
                historicalTimeZone.addEra(historicalTimeZoneEra);
            }
            if (bl2 || bl) {
                if (historicalTimeZone != null) {
                    HistoricalTimeZoneEra historicalTimeZoneEra2 = null;
                    short s17 = 0;
                    while (s17 < historicalTimeZone.getNumberEras()) {
                        if (s17 == 0) {
                            historicalTimeZoneEra2 = historicalTimeZone.getEraAtIndex(s17);
                            historicalTimeZoneEra2.setValidUntilDate(HistoricalTimeZoneDate.makeFromEpochMillis(253433923199999L));
                            historicalTimeZone.setEraAtIndex(historicalTimeZoneEra2, s17);
                        }
                        if (s17 != historicalTimeZone.getNumberEras() - 1) {
                            historicalTimeZoneEra2 = historicalTimeZone.getEraAtIndex(s17);
                            historicalTimeZoneEra2.setValidFromDate(historicalTimeZone.getEraAtIndex((short)(s17 + 1)).getValidUntilDate());
                            historicalTimeZone.setEraAtIndex(historicalTimeZoneEra2, s17);
                        } else {
                            historicalTimeZoneEra2 = historicalTimeZone.getEraAtIndex(s17);
                            historicalTimeZoneEra2.setValidFromDate(HistoricalTimeZoneDate.makeFromEpochMillis(-2208988800000L));
                            historicalTimeZone.setEraAtIndex(historicalTimeZoneEra2, s17);
                        }
                        s17 = (short)(s17 + 1);
                    }
                }
                dataInputStream.close();
                jarFile.close();
                if (bl2) {
                    if (historicalTimeZone != null) {
                        System.out.println(historicalTimeZone.toVerboseString());
                        System.out.println(" Current Time in this Time Zone: ");
                        System.out.println("\t\t" + BAbsTime.make(System.currentTimeMillis(), BTimeZone.getTimeZone(historicalTimeZone.getHistoricalTimeZoneName())));
                    }
                    return null;
                }
                return historicalTimeZone;
            }
            if (s16 == s5) {
                historicalTimeZoneDate3.update(HistoricalTimeZoneDate.makeFromEpochMillis(-2208988800000L));
                historicalTimeZoneDate2.update(historicalTimeZoneDate5);
            } else {
                historicalTimeZoneDate3.update(historicalTimeZoneDate5);
                if (bl3) {
                    historicalTimeZoneDate2.update(HistoricalTimeZoneDate.makeFromEpochMillis(253433923199999L));
                } else {
                    historicalTimeZoneDate2.update(historicalTimeZoneDate4);
                }
            }
            if ((s14 < 0 || s14 >= s2) && s14 != 7334) {
                logger.error("could not parse timezone: " + string + " (invalid uses format) from timezones.jar; returning null");
                dataInputStream.close();
                jarFile.close();
                return null;
            }
            string3 = s14 == 7334 ? "" : (String)array4.get((int)s14);
            historicalTimeZoneEra = HistoricalTimeZoneEra.make(n2, "", string3, historicalTimeZoneDate2);
            if (s12 >= 0 && s12 < s3 || s12 == 7334) {
                if (s12 != 7334) {
                    historicalTimeZoneEra.addRule((HistoricalDstRule)array.get((int)s12));
                }
            } else {
                logger.error("could not parse timezone: " + string + " (invalid uses start rule) from timezones.jar; returning null");
                dataInputStream.close();
                jarFile.close();
                return null;
            }
            if (s13 >= 0 && s13 < s4 || s13 == 7334) {
                if (s13 != 7334) {
                    historicalTimeZoneEra.addRule((HistoricalDstRule)array2.get((int)s13));
                }
            } else {
                logger.error("could not parse timezone: " + string + " (invalid uses end rule) from timezones.jar; returning null");
                dataInputStream.close();
                jarFile.close();
                return null;
            }
            historicalTimeZoneEra.setValidFromDate(new HistoricalTimeZoneDate(historicalTimeZoneDate3));
            historicalTimeZone = HistoricalTimeZone.make(string, historicalTimeZoneEra);
            dataInputStream.close();
            jarFile.close();
        }
        catch (Exception exception) {
            return null;
        }
        logger.trace("successfully generated timezone:" + string + " for " + l);
        return historicalTimeZone;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class JarDataInputStream
    extends JarInputStream {
        private static final int SIZE_OF_CHAR = 2;
        private static final int SIZE_OF_SHORT = 2;
        private static final int SIZE_OF_INT = 4;
        private static final int SIZE_OF_LONG = 8;
        private int entryBytesRead = 0;

        public JarEntry getNextJarEntry() throws IOException {
            this.entryBytesRead = 0;
            return super.getNextJarEntry();
        }

        byte readByte() throws IOException {
            byte[] byArray = new byte[1];
            this.entryBytesRead += super.read(byArray, 0, 1);
            return byArray[0];
        }

        char readChar() throws IOException {
            return new ByteBuffer(this.read(2)).readChar();
        }

        short readShort() throws IOException {
            return new ByteBuffer(this.read(2)).readShort();
        }

        int readInt() throws IOException {
            return new ByteBuffer(this.read(4)).readInt();
        }

        long readLong() throws IOException {
            return new ByteBuffer(this.read(8)).readLong();
        }

        byte[] read(int n) throws IOException {
            byte[] byArray = new byte[n];
            int n2 = 0;
            while (n2 < n) {
                byArray[n2] = (byte)super.read();
                ++n2;
            }
            this.entryBytesRead += n;
            return byArray;
        }

        int getEntryBytesRead() {
            return this.entryBytesRead;
        }

        void readFully() throws IOException {
            byte[] byArray = new byte[1024];
            while (this.in.read(byArray, 0, 1024) > 0) {
            }
        }

        public JarDataInputStream(InputStream inputStream) throws IOException {
            super(inputStream);
        }
    }
}

