/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.timezone;

import com.tridium.timezone.HistoricalDstRule;
import com.tridium.timezone.HistoricalTimeZoneDate;
import java.util.LinkedList;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class HistoricalTimeZoneEra {
    private int activeUtcOffsetMillis;
    private String activeZoneFormat;
    private String activeRuleName;
    private HistoricalTimeZoneDate validUntilDate;
    private HistoricalTimeZoneDate validFromDate;
    private Array myStartRules;
    private Array myEndRules;
    static /* synthetic */ Class class$com$tridium$timezone$HistoricalDstRule;

    public static final HistoricalTimeZoneEra make() {
        return HistoricalTimeZoneEra.make(0, "none", "none", HistoricalTimeZoneDate.makeMaximumDate());
    }

    public static final HistoricalTimeZoneEra make(int n, String string, String string2, HistoricalTimeZoneDate historicalTimeZoneDate) {
        HistoricalTimeZoneEra historicalTimeZoneEra = new HistoricalTimeZoneEra();
        historicalTimeZoneEra.activeZoneFormat = string2;
        historicalTimeZoneEra.activeRuleName = string;
        historicalTimeZoneEra.activeUtcOffsetMillis = n;
        historicalTimeZoneEra.validUntilDate = historicalTimeZoneDate.convertToExactDate();
        historicalTimeZoneEra.validFromDate = null;
        historicalTimeZoneEra.myStartRules = null;
        historicalTimeZoneEra.myEndRules = null;
        return historicalTimeZoneEra;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof HistoricalTimeZoneEra)) {
            return false;
        }
        HistoricalTimeZoneEra historicalTimeZoneEra = (HistoricalTimeZoneEra)object;
        boolean bl = false;
        if (this.activeZoneFormat.equals(historicalTimeZoneEra.activeZoneFormat) && this.activeRuleName.equals(historicalTimeZoneEra.activeRuleName) && this.activeUtcOffsetMillis == historicalTimeZoneEra.activeUtcOffsetMillis && this.validUntilDate.equals(historicalTimeZoneEra.validUntilDate) && this.validFromDate.equals(historicalTimeZoneEra.validFromDate) && this.myEndRules.equals((Object)historicalTimeZoneEra.myEndRules) && this.myStartRules.equals((Object)historicalTimeZoneEra.myStartRules)) {
            bl = true;
        }
        return bl;
    }

    public final String toString() {
        String string;
        HistoricalDstRule historicalDstRule = this.getStartRule();
        String string2 = string = this.activeUtcOffsetMillis > 0 ? "+" : "";
        if (historicalDstRule != null) {
            return "(" + string + this.utcOffsetAsString(this.activeUtcOffsetMillis) + '/' + string + this.utcOffsetAsString(this.activeUtcOffsetMillis + historicalDstRule.getDaylightAdjMillis()) + ')';
        }
        return new String("(" + string + this.utcOffsetAsString(this.activeUtcOffsetMillis) + ')');
    }

    public final String toVerboseString() {
        int n;
        HistoricalDstRule historicalDstRule;
        StringBuffer stringBuffer = new StringBuffer("Format: " + this.activeZoneFormat + " Utc Offset: " + this.utcOffsetAsString(this.activeUtcOffsetMillis) + '\n');
        if (this.validFromDate != null) {
            stringBuffer.append(" Valid From: " + this.validFromDate + '\n');
        }
        if (this.validUntilDate != null) {
            stringBuffer.append(" Valid Until: " + this.validUntilDate + '\n');
        }
        if (this.myStartRules != null) {
            historicalDstRule = null;
            n = 0;
            while (n < this.myStartRules.size()) {
                historicalDstRule = (HistoricalDstRule)this.myStartRules.get(n);
                stringBuffer.append("\t\t" + historicalDstRule.toVerboseString() + ' ' + this.getShortForRule(historicalDstRule) + '\n');
                ++n;
            }
        }
        if (this.myEndRules != null) {
            historicalDstRule = null;
            n = 0;
            while (n < this.myEndRules.size()) {
                historicalDstRule = (HistoricalDstRule)this.myEndRules.get(n);
                stringBuffer.append("\t\t" + historicalDstRule.toVerboseString() + ' ' + this.getShortForRule(historicalDstRule) + '\n');
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    private final String utcOffsetAsString(int n) {
        String string;
        String string2;
        String string3;
        short s;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n2 = n;
        short s2 = (short)((long)n2 / 3600000L);
        if (n2 < 0) {
            n2 = -n2;
        }
        if ((s = (short)((long)(n2 = (int)((long)n2 - (long)Math.abs(s2) * 3600000L)) / 60000L)) < 10) {
            if (s == 0) {
                bl = true;
                string3 = new String("00");
            } else {
                string3 = new String("0" + s);
            }
        } else {
            string3 = new String("" + s);
        }
        n2 = (int)((long)n2 - (long)s * 60000L);
        short s3 = (short)((long)n2 / 1000L);
        if (s3 < 10) {
            if (s3 == 0) {
                bl2 = true;
                string2 = new String("00");
            } else {
                string2 = new String("0" + s3);
            }
        } else {
            string2 = new String("" + s3);
        }
        n2 = (int)((long)n2 - (long)s3 * 1000L);
        short s4 = (short)n2;
        if (s4 < 100) {
            if (s4 < 10) {
                if (s4 == 0) {
                    bl3 = true;
                    string = new String("000");
                } else {
                    string = new String("00" + s4);
                }
            } else {
                string = new String("0" + s4);
            }
        } else {
            string = new String("" + s4);
        }
        if (bl && bl2 && bl3) {
            return new String("" + s2);
        }
        if (bl2 && bl3) {
            return new String("" + s2 + ':' + string3);
        }
        if (bl3) {
            return new String("" + s2 + ':' + string3 + ':' + string2);
        }
        return new String("" + s2 + ':' + string3 + ':' + string2 + '.' + string);
    }

    public final boolean determineRules(HistoricalTimeZoneDate historicalTimeZoneDate, LinkedList linkedList) {
        if (this.activeRuleName.equals("-")) {
            return true;
        }
        HistoricalDstRule historicalDstRule = null;
        boolean bl = false;
        short s = (short)(linkedList.size() - 1);
        while (s >= 0) {
            historicalDstRule = (HistoricalDstRule)linkedList.get(s);
            if (historicalDstRule.getRuleName().equals(this.activeRuleName)) {
                bl = true;
                if (historicalDstRule.ruleAppliesForInterval(historicalTimeZoneDate, this.validUntilDate)) {
                    if (historicalDstRule.isStartRule()) {
                        if (this.myStartRules == null) {
                            Class clazz = class$com$tridium$timezone$HistoricalDstRule;
                            if (clazz == null) {
                                clazz = HistoricalTimeZoneEra.class("[Lcom.tridium.timezone.HistoricalDstRule;", false);
                            }
                            this.myStartRules = new Array(clazz);
                        }
                        this.myStartRules.add(0, (Object)new HistoricalDstRule(historicalDstRule));
                    } else {
                        if (this.myEndRules == null) {
                            Class clazz = class$com$tridium$timezone$HistoricalDstRule;
                            if (clazz == null) {
                                clazz = HistoricalTimeZoneEra.class("[Lcom.tridium.timezone.HistoricalDstRule;", false);
                            }
                            this.myEndRules = new Array(clazz);
                        }
                        this.myEndRules.add(0, (Object)new HistoricalDstRule(historicalDstRule));
                    }
                }
            } else if (bl && !this.activeRuleName.equals("NZ") && !this.activeRuleName.equals("Chatham")) break;
            s = (short)(s - 1);
        }
        return bl;
    }

    public final void addRule(HistoricalDstRule historicalDstRule) {
        if (historicalDstRule.isStartRule()) {
            if (this.myStartRules == null) {
                Class clazz = class$com$tridium$timezone$HistoricalDstRule;
                if (clazz == null) {
                    clazz = class$com$tridium$timezone$HistoricalDstRule = HistoricalTimeZoneEra.class("[Lcom.tridium.timezone.HistoricalDstRule;", false);
                }
                this.myStartRules = new Array(clazz);
            }
            this.myStartRules.add(0, (Object)historicalDstRule);
        } else if (historicalDstRule.isEndRule()) {
            if (this.myEndRules == null) {
                Class clazz = class$com$tridium$timezone$HistoricalDstRule;
                if (clazz == null) {
                    clazz = class$com$tridium$timezone$HistoricalDstRule = HistoricalTimeZoneEra.class("[Lcom.tridium.timezone.HistoricalDstRule;", false);
                }
                this.myEndRules = new Array(clazz);
            }
            this.myEndRules.add(0, (Object)historicalDstRule);
        }
    }

    public final HistoricalDstRule getStartRuleAtIndex(short s) {
        return this.myStartRules != null && s >= 0 && s < this.myStartRules.size() ? (HistoricalDstRule)this.myStartRules.get((int)s) : null;
    }

    public final HistoricalDstRule getEndRuleAtIndex(short s) {
        return this.myEndRules != null && s >= 0 && s < this.myEndRules.size() ? (HistoricalDstRule)this.myEndRules.get((int)s) : null;
    }

    private final String getShortForRule(HistoricalDstRule historicalDstRule) {
        StringBuffer stringBuffer = new StringBuffer("");
        short s = (short)this.activeZoneFormat.indexOf("%s");
        if (s != -1) {
            stringBuffer.append(this.activeZoneFormat.substring(0, this.activeZoneFormat.indexOf("%s")));
            if (!historicalDstRule.getRuleLetters().equals("-")) {
                stringBuffer.append(historicalDstRule.getRuleLetters());
            }
        } else {
            return this.activeZoneFormat;
        }
        stringBuffer.append(this.activeZoneFormat.substring(this.activeZoneFormat.indexOf("%s") + 2));
        return new String(stringBuffer.toString());
    }

    public final String getShortName(boolean bl) {
        HistoricalDstRule historicalDstRule = null;
        int n = -1;
        if (bl) {
            if (this.myStartRules == null || this.myStartRules.size() == 0) {
                String string = this.activeZoneFormat;
                String string2 = null;
                string2 = string.indexOf("%s") != -1 ? TextUtil.replace((String)string, (String)"%s", (String)"") : (string.indexOf("/") != -1 ? string.substring(string.indexOf("/")) : string);
                return string2;
            }
            short s = (short)this.activeZoneFormat.indexOf(47);
            n = s;
            if (s != -1) {
                return this.activeZoneFormat.substring(n + 1);
            }
            historicalDstRule = this.getStartRule();
        } else {
            if (this.myEndRules == null || this.myEndRules.size() == 0) {
                String string = this.activeZoneFormat;
                String string3 = null;
                string3 = string.indexOf("%s") != -1 ? TextUtil.replace((String)string, (String)"%s", (String)"") : (string.indexOf("/") != -1 ? string.substring(0, string.indexOf("/")) : string);
                return string3;
            }
            short s = (short)this.activeZoneFormat.indexOf(47);
            n = s;
            if (s != -1) {
                return this.activeZoneFormat.substring(0, n);
            }
            historicalDstRule = this.getEndRule();
        }
        return historicalDstRule != null ? this.getShortForRule(historicalDstRule) : "";
    }

    public final HistoricalDstRule getEndRule() {
        if (this.myEndRules == null || this.myEndRules.size() == 0 || this.myEndRules.size() > 1) {
            return null;
        }
        return (HistoricalDstRule)this.myEndRules.get(0);
    }

    public final HistoricalDstRule getStartRule() {
        if (this.myStartRules == null || this.myStartRules.size() == 0 || this.myStartRules.size() > 1) {
            return null;
        }
        return (HistoricalDstRule)this.myStartRules.get(0);
    }

    public final short getNumberStartRules() {
        short s = 0;
        if (this.myStartRules != null) {
            s = (short)this.myStartRules.size();
        }
        return s;
    }

    public final short getNumberEndRules() {
        short s = 0;
        if (this.myEndRules != null) {
            s = (short)this.myEndRules.size();
        }
        return s;
    }

    public final void setValidFromDate(HistoricalTimeZoneDate historicalTimeZoneDate) {
        this.validFromDate = new HistoricalTimeZoneDate(historicalTimeZoneDate);
    }

    public final void setValidUntilDate(HistoricalTimeZoneDate historicalTimeZoneDate) {
        this.validUntilDate = new HistoricalTimeZoneDate(historicalTimeZoneDate);
    }

    public final int getActiveUtcOffsetMillis() {
        return this.activeUtcOffsetMillis;
    }

    public final String getActiveRuleName() {
        return this.activeRuleName;
    }

    public final String getActiveZoneFormat() {
        return this.activeZoneFormat;
    }

    public final HistoricalTimeZoneDate getValidUntilDate() {
        return this.validUntilDate;
    }

    public final HistoricalTimeZoneDate getValidFromDate() {
        return this.validFromDate;
    }

    public final boolean isValidForEpochMillis(long l) {
        HistoricalTimeZoneDate historicalTimeZoneDate = HistoricalTimeZoneDate.makeFromEpochMillis(l);
        boolean bl = false;
        if (this.validFromDate.occursBeforeOrOnAbsolute(historicalTimeZoneDate) && this.validUntilDate.occursAfterAbsolute(historicalTimeZoneDate)) {
            bl = true;
        }
        return bl;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private HistoricalTimeZoneEra() {
    }

    public HistoricalTimeZoneEra(HistoricalTimeZoneEra historicalTimeZoneEra) {
        this.activeZoneFormat = new String(historicalTimeZoneEra.activeZoneFormat);
        this.activeRuleName = new String(historicalTimeZoneEra.activeRuleName);
        this.activeUtcOffsetMillis = historicalTimeZoneEra.activeUtcOffsetMillis;
        this.validUntilDate = historicalTimeZoneEra.validUntilDate != null ? new HistoricalTimeZoneDate(historicalTimeZoneEra.validUntilDate) : null;
        HistoricalTimeZoneDate historicalTimeZoneDate = this.validFromDate = historicalTimeZoneEra.validFromDate != null ? new HistoricalTimeZoneDate(historicalTimeZoneEra.validFromDate) : null;
        if (historicalTimeZoneEra.myStartRules == null) {
            this.myStartRules = null;
        } else {
            Class clazz = class$com$tridium$timezone$HistoricalDstRule;
            if (clazz == null) {
                clazz = class$com$tridium$timezone$HistoricalDstRule = HistoricalTimeZoneEra.class("[Lcom.tridium.timezone.HistoricalDstRule;", false);
            }
            this.myStartRules = new Array(clazz);
            this.myStartRules.addAll(historicalTimeZoneEra.myStartRules);
        }
        if (historicalTimeZoneEra.myEndRules == null) {
            this.myEndRules = null;
        } else {
            Class clazz = class$com$tridium$timezone$HistoricalDstRule;
            if (clazz == null) {
                clazz = class$com$tridium$timezone$HistoricalDstRule = HistoricalTimeZoneEra.class("[Lcom.tridium.timezone.HistoricalDstRule;", false);
            }
            this.myEndRules = new Array(clazz);
            this.myEndRules.addAll(historicalTimeZoneEra.myEndRules);
        }
    }
}

