/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.transfer;

import com.tridium.space.BGateway;
import com.tridium.sys.transfer.CompToBog;
import com.tridium.sys.transfer.CompToComp;
import com.tridium.sys.transfer.FileToComp;
import com.tridium.sys.transfer.FileToFile;
import com.tridium.sys.transfer.IntraFileSpaceMove;
import com.tridium.sys.transfer.RemoteIntraSpace;
import com.tridium.sys.transfer.RemoteTransferSpace;
import com.tridium.sys.transfer.TransferListener;
import com.tridium.sys.transfer.TransferResult;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSpace;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.space.BComponentSpace;
import javax.baja.space.BISpaceNode;
import javax.baja.space.BSpace;
import javax.baja.space.Mark;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.virtual.BVirtualGateway;

public abstract class TransferStrategy {
    public static final int ACTION_COPY = 16;
    public static final int ACTION_MOVE = 32;
    public static final String PARAM_EXACT = "exact";
    public static final String PARAM_ORIGIN = "origin";
    public static final String PARAM_COPY_SOURCE = "copySource";
    public static final String PARAM_KEEP_ALL_LINKS = "keepAllLinks";
    public static final Log log = Log.getLog("sys.transfer");
    int action;
    BObject target;
    Mark mark;
    Context context;
    BComponent params;
    TransferListener listener;

    public static TransferStrategy make(int n, Mark mark, BObject bObject, BComponent bComponent, Context context) {
        Object object;
        if (TransferStrategy.isDebugOn()) {
            TransferStrategy.debug("====== TransferStrategy.make ======");
            TransferStrategy.debug(" action  = " + n);
            TransferStrategy.debug(" mark    = " + mark);
            TransferStrategy.debug(" target  = " + bObject);
            TransferStrategy.debug(" params  = " + bComponent);
            TransferStrategy.debug(" context = " + context);
        }
        bObject = TransferStrategy.toActualTarget(bObject);
        if (mark.getValues().length == 1) {
            object = mark.getNames()[0];
            BObject bObject2 = mark.getValues()[0];
            if (bObject2 instanceof BComponentSpace) {
                BComponent bComponent2 = ((BComponentSpace)bObject2).getRootComponent();
                mark = new Mark(bComponent2, (String)object);
            }
        }
        if ((object = TransferStrategy.makeImpl(n, mark, bObject, context)) == null) {
            return null;
        }
        if (TransferStrategy.isDebugOn()) {
            TransferStrategy.debug(" class   = " + object.getClass().getName());
        }
        ((TransferStrategy)object).action = n;
        ((TransferStrategy)object).mark = mark;
        ((TransferStrategy)object).target = bObject;
        ((TransferStrategy)object).params = bComponent;
        ((TransferStrategy)object).context = context;
        return object;
    }

    public static BObject toActualTarget(BObject bObject) {
        BComponent bComponent;
        BComponentSpace bComponentSpace;
        if (bObject instanceof BGateway) {
            bObject = ((BGateway)bObject).getGatewaySpace();
        }
        if (bObject instanceof BComponentSpace) {
            return ((BComponentSpace)bObject).getRootComponent();
        }
        if (bObject.getType().getTypeName().equals("FoxFileSpace")) {
            return (BObject)((Object)((BFileSpace)bObject).resolveFile(new FilePath("^")));
        }
        if (bObject.getType().getTypeName().equals("BogFile")) {
            return BOrd.make("bog:|slot:/").get(bObject);
        }
        if (bObject.getType().getTypeName().equals("SaxFile")) {
            return BOrd.make("sax:|slot:/").get(bObject);
        }
        if (bObject instanceof BVirtualGateway && (bComponentSpace = ((BVirtualGateway)bObject).getVirtualSpace()) != null && (bComponent = bComponentSpace.getRootComponent()) != null) {
            bComponent.loadSlots();
            return bComponent;
        }
        return bObject;
    }

    static TransferStrategy makeImpl(int n, Mark mark, BObject bObject, Context context) {
        if (bObject instanceof BComponent) {
            return TransferStrategy.toComp(n, mark, (BComponent)bObject, context);
        }
        if (bObject instanceof BIFile) {
            return TransferStrategy.toFile(n, mark, (BIFile)((Object)bObject), context);
        }
        return null;
    }

    static TransferStrategy toComp(int n, Mark mark, BComponent bComponent, Context context) {
        BComponentSpace bComponentSpace;
        BSpace bSpace = TransferStrategy.toSpace(mark);
        if (bSpace == (bComponentSpace = bComponent.getComponentSpace())) {
            if (bComponentSpace instanceof RemoteTransferSpace) {
                return new RemoteIntraSpace();
            }
            if (n == 32) {
                return (TransferStrategy)bSpace.fw(113);
            }
        }
        TransferStrategy transferStrategy = null;
        if (bSpace == null) {
            transferStrategy = new CompToComp();
        } else if (bSpace instanceof BComponentSpace) {
            transferStrategy = (TransferStrategy)bSpace.fw(114);
            if (transferStrategy == null) {
                transferStrategy = new CompToComp();
            }
        } else if (bSpace instanceof BFileSpace && (transferStrategy = (TransferStrategy)bSpace.fw(115)) == null) {
            transferStrategy = new FileToComp();
        }
        return transferStrategy;
    }

    static TransferStrategy toFile(int n, Mark mark, BIFile bIFile, Context context) {
        BSpace bSpace = TransferStrategy.toSpace(mark);
        if (bSpace instanceof BFileSpace) {
            return TransferStrategy.fileToFile(n, mark, bIFile, context);
        }
        if (bSpace instanceof BComponentSpace) {
            return TransferStrategy.componentToFile(n, mark, bIFile, context);
        }
        return null;
    }

    static TransferStrategy fileToFile(int n, Mark mark, BIFile bIFile, Context context) {
        BFileSpace bFileSpace;
        BFileSpace bFileSpace2 = (BFileSpace)TransferStrategy.toSpace(mark);
        if (bFileSpace2 == (bFileSpace = bIFile.getFileSpace())) {
            if (bFileSpace instanceof RemoteTransferSpace) {
                return new RemoteIntraSpace();
            }
            BObject[] bObjectArray = mark.getValues();
            boolean bl = false;
            int n2 = 0;
            while (n2 < bObjectArray.length && !bl) {
                if (bObjectArray[n2] instanceof BIFile && ((BIFile)((Object)bObjectArray[n2])).isDirectory()) {
                    bl = true;
                }
                ++n2;
            }
            if (n == 32 && !bl) {
                return new IntraFileSpaceMove();
            }
        }
        return new FileToFile();
    }

    static TransferStrategy componentToFile(int n, Mark mark, BIFile bIFile, Context context) {
        if (bIFile instanceof BDirectory) {
            return new CompToBog();
        }
        return null;
    }

    public int getAction() {
        return this.action;
    }

    public boolean isCopy() {
        boolean bl = false;
        if (this.action == 16) {
            bl = true;
        }
        return bl;
    }

    public boolean isMove() {
        boolean bl = false;
        if (this.action == 32) {
            bl = true;
        }
        return bl;
    }

    public Mark getMark() {
        return this.mark;
    }

    public BObject getTarget() {
        return this.target;
    }

    public Context getContext() {
        return this.context;
    }

    public abstract TransferResult transfer() throws Exception;

    public BComponent getParameters() {
        return this.params;
    }

    public BObject getParameter(String string, BObject bObject) {
        if (this.params == null) {
            return bObject;
        }
        BValue bValue = this.params.get(string);
        if (bValue != null) {
            return bValue;
        }
        return bObject;
    }

    public boolean getParameter(String string, boolean bl) {
        if (this.params == null) {
            return bl;
        }
        BBoolean bBoolean = (BBoolean)this.params.get(string);
        if (bBoolean != null) {
            return bBoolean.getBoolean();
        }
        return bl;
    }

    public int getParameter(String string, int n) {
        if (this.params == null) {
            return n;
        }
        BInteger bInteger = (BInteger)this.params.get(string);
        if (bInteger != null) {
            return bInteger.getInt();
        }
        return n;
    }

    public String getParameter(String string, String string2) {
        if (this.params == null) {
            return string2;
        }
        BString bString = (BString)this.params.get(string);
        if (bString != null) {
            return bString.getString();
        }
        return string2;
    }

    public TransferListener getListener() {
        return this.listener;
    }

    public void setListener(TransferListener transferListener) {
        this.listener = transferListener;
    }

    public void updateStatus(String string) {
        try {
            if (this.listener != null) {
                this.listener.updateStatus(string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static String toString(BObject bObject) {
        try {
            BComponent bComponent;
            if (bObject instanceof BComponent && (bComponent = (BComponent)bObject).isMounted()) {
                return bComponent.toPathString();
            }
            return bObject.getType().toString();
        }
        catch (Exception exception) {
            return "error";
        }
    }

    public static BSpace toSpace(Mark mark) {
        return TransferStrategy.toSpace(mark.getValues()[0]);
    }

    public static BSpace toSpace(BObject bObject) {
        if (bObject instanceof BISpaceNode) {
            return ((BISpaceNode)((Object)bObject)).getSpace();
        }
        return null;
    }

    public static boolean isDebugOn() {
        return log.isTraceOn();
    }

    public static void debug(String string) {
        System.out.print("> ");
        System.out.println(string);
    }

    public void dump() {
        TransferStrategy.debug("Transfer: " + this.getClass().getName());
        TransferStrategy.debug("  o action:   " + (this.isMove() ? "move" : "copy"));
        TransferStrategy.debug("  o target:   " + this.target);
        TransferStrategy.debug("  o mark:     " + this.mark);
        TransferStrategy.debug("  o context:  " + this.context);
        this.dumpExtra();
        if (this.params == null) {
            TransferStrategy.debug("  o params: null");
        } else {
            TransferStrategy.debug("  o params:");
            Property[] propertyArray = this.params.getPropertiesArray();
            int n = 0;
            while (n < propertyArray.length) {
                TransferStrategy.debug("      " + propertyArray[n].getName() + " = " + this.params.get(propertyArray[n]));
                ++n;
            }
        }
    }

    protected void dumpExtra() {
    }
}

