/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.transfer;

import com.tridium.sys.transfer.TransferResult;
import com.tridium.sys.transfer.TransferStrategy;
import com.tridium.util.ObjectUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.baja.file.BAbstractFile;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSpace;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.file.FileUtil;
import javax.baja.sys.BObject;
import javax.baja.util.Lexicon;

public class FileToFile
extends TransferStrategy {
    BIFile[] sourceFiles;
    BDirectory targetDir;
    String[] insertNames;
    Lexicon lex;
    String lexCopying;
    String lexMoving;
    String lexDeleting;

    public TransferResult transfer() throws Exception {
        this.init();
        this.name();
        this.copy();
        this.remove();
        return this.makeResult();
    }

    protected void init() throws Exception {
        if (FileToFile.isDebugOn()) {
            FileToFile.debug("init");
        }
        this.targetDir = (BDirectory)this.target;
        BObject[] bObjectArray = this.mark.getValues();
        this.sourceFiles = new BIFile[bObjectArray.length];
        int n = 0;
        while (n < bObjectArray.length) {
            BIFile bIFile;
            this.sourceFiles[n] = bIFile = (BIFile)((Object)bObjectArray[n]);
            if (bIFile == this.targetDir) {
                throw new IllegalStateException("Source == destination: " + this.targetDir.getFilePath());
            }
            ++n;
        }
        this.lex = Lexicon.make("baja", this.context);
        this.lexCopying = this.lex.getText("file.copying");
        this.lexMoving = this.lex.getText("file.moving");
        this.lexDeleting = this.lex.getText("file.deleting");
    }

    protected void name() throws Exception {
        if (FileToFile.isDebugOn()) {
            FileToFile.debug("name");
        }
        HashMap hashMap = FileToFile.namesToHashMap(this.targetDir);
        String[] stringArray = this.mark.getNames();
        this.insertNames = new String[stringArray.length];
        int n = 0;
        while (n < this.insertNames.length) {
            this.insertNames[n] = FileToFile.getUniqueFilename(hashMap, stringArray[n]);
            if (FileToFile.isDebugOn()) {
                FileToFile.debug("  " + stringArray[n] + " -> " + this.insertNames[n]);
            }
            hashMap.put(this.insertNames[n], "x");
            ++n;
        }
    }

    public static HashMap namesToHashMap(BDirectory bDirectory) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        BIFile[] bIFileArray = bDirectory.listFiles();
        int n = 0;
        while (n < bIFileArray.length) {
            hashMap.put(bIFileArray[n].getFileName(), "x");
            ++n;
        }
        return hashMap;
    }

    public static String getUniqueFilename(BDirectory bDirectory, String string) {
        return FileToFile.getUniqueFilename(FileToFile.namesToHashMap(bDirectory), string);
    }

    public static boolean isUniqueFilename(BDirectory bDirectory, String string) {
        boolean bl = false;
        if (FileToFile.namesToHashMap(bDirectory).get(string) == null) {
            bl = true;
        }
        return bl;
    }

    public static String getUniqueFilename(HashMap hashMap, String string) {
        if (!hashMap.containsKey(string)) {
            return string;
        }
        String string2 = "";
        int n = string.lastIndexOf(46);
        if (n > 0) {
            string2 = string.substring(n);
            string = string.substring(0, n);
        }
        String string3 = ObjectUtil.generateUniqueName(string, new MapNameContainer(hashMap, string2));
        return string3 + string2;
    }

    protected void copy() throws Exception {
        if (FileToFile.isDebugOn()) {
            FileToFile.debug("copy");
        }
        int n = 0;
        while (n < this.sourceFiles.length) {
            this.copy(this.sourceFiles[n], this.targetDir, this.insertNames[n]);
            ++n;
        }
    }

    private final void copy(BIFile bIFile, BDirectory bDirectory, String string) throws Exception {
        if (bIFile instanceof BDirectory) {
            this.copyDir((BDirectory)bIFile, bDirectory, string);
        } else {
            this.copyFile(bIFile, bDirectory, string);
        }
    }

    private final void copyDir(BDirectory bDirectory, BDirectory bDirectory2, String string) throws Exception {
        if (FileToFile.isDebugOn()) {
            FileToFile.debug("  copyDir: " + bDirectory.getFilePath());
        }
        BFileSpace bFileSpace = bDirectory2.getFileSpace();
        BDirectory bDirectory3 = bFileSpace.makeDir(bDirectory2.getFilePath().merge(string), this.getContext());
        BIFile[] bIFileArray = bDirectory.listFiles();
        int n = 0;
        while (n < bIFileArray.length) {
            this.copy(bIFileArray[n], bDirectory3, bIFileArray[n].getFileName());
            ++n;
        }
        bDirectory3.setLastModified(bDirectory.getLastModified());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void copyFile(BIFile bIFile, BDirectory bDirectory, String string) throws Exception {
        BIFile bIFile2;
        block18: {
            block19: {
                if (FileToFile.isDebugOn()) {
                    FileToFile.debug("    copyFile: " + bIFile.getFilePath());
                    FileToFile.debug("       isMove: " + this.isMove());
                    FileToFile.debug("       dest: " + bDirectory);
                }
                if (bDirectory.toString(null).equals("file:!trash") || bDirectory.toString(null).startsWith("file:!trash/")) {
                    this.updateStatus(this.lexDeleting + " \"" + string + "\"...");
                } else if (this.isMove()) {
                    this.updateStatus(this.lexMoving + " \"" + string + "\"...");
                } else {
                    this.updateStatus(this.lexCopying + " \"" + string + "\"...");
                }
                BFileSpace bFileSpace = bDirectory.getFileSpace();
                bIFile2 = bFileSpace.makeFile(bDirectory.getFilePath().merge(string), this.getContext());
                if (!bIFile.getExtension().equalsIgnoreCase("bog")) break block19;
                InputStream inputStream = null;
                OutputStream outputStream = null;
                try {
                    inputStream = bIFile.getInputStream();
                    outputStream = bIFile2.getOutputStream();
                    FileUtil.pipe(inputStream, outputStream);
                }
                catch (Throwable throwable) {
                    Object var9_9 = null;
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                    catch (Exception exception) {}
                    try {
                        if (outputStream == null) throw throwable;
                        outputStream.close();
                        throw throwable;
                    }
                    catch (Exception exception) {}
                    throw throwable;
                }
                {
                    Object var9_10 = null;
                    try {}
                    catch (Exception exception) {}
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    try {}
                    catch (Exception exception) {}
                    if (outputStream != null) {
                        outputStream.close();
                    }
                    break block18;
                }
                break block18;
            }
            FileUtil.pipe(bIFile, bIFile2);
        }
        if (!(bIFile2 instanceof BAbstractFile)) return;
        ((BAbstractFile)bIFile2).setLastModified(bIFile.getLastModified());
    }

    protected void remove() throws Exception {
        if (!this.isMove()) {
            return;
        }
        if (FileToFile.isDebugOn()) {
            FileToFile.debug("remove");
        }
        int n = 0;
        while (n < this.sourceFiles.length) {
            BIFile bIFile = this.sourceFiles[n];
            BFileSpace bFileSpace = bIFile.getFileSpace();
            FilePath filePath = bIFile.getFilePath();
            if (this.targetDir.toString(null).startsWith("file:!trash")) {
                this.updateStatus(this.lexDeleting + " \"" + filePath.getName() + "\"...");
            } else {
                this.updateStatus(this.lexMoving + " \"" + filePath.getName() + "\"...");
            }
            bFileSpace.delete(filePath, this.getContext());
            ++n;
        }
    }

    protected TransferResult makeResult() throws Exception {
        return null;
    }

    static class MapNameContainer
    implements ObjectUtil.NameContainer {
        Map map;
        String ext;

        public boolean contains(String string) {
            boolean bl = false;
            if (this.map.get(string + this.ext) != null) {
                bl = true;
            }
            return bl;
        }

        MapNameContainer(Map map, String string) {
            this.map = map;
            this.ext = string;
        }
    }
}

