/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.transfer;

import com.tridium.sys.transfer.TransferStrategy;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import javax.baja.io.ValueDocDecoder;
import javax.baja.io.ValueDocEncoder;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.space.BComponentSpace;
import javax.baja.space.Mark;
import javax.baja.sync.Transaction;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BLink;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Knob;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DeleteOp {
    static final int MAGIC_1 = 7649;
    static final int MAGIC_2 = 11745;
    static final char MAGIC_3 = '\u2de2';
    static final BFacets noRemoveLinks = BFacets.make("niagaraRemoveLinks", BBoolean.FALSE);
    protected BComponentSpace space;
    protected Context context;
    protected int size;
    protected BOrd[] parentOrds;
    protected String[] propNames;
    protected BValue[] values;
    protected int[] flags;
    protected BFacets[] facets;
    protected ExternalLink[] extLinks;
    protected ExternalComposite[] extComposites;
    static /* synthetic */ Class class$com$tridium$sys$transfer$DeleteOp$ExternalComposite;
    static /* synthetic */ Class class$com$tridium$sys$transfer$DeleteOp$ExternalLink;

    public static DeleteOp make(Mark mark, Context context) {
        return new DeleteOp(mark, context);
    }

    public static DeleteOp make(BComponentSpace bComponentSpace, Context context, InputStream inputStream) throws Exception {
        DeleteOp deleteOp = new DeleteOp();
        deleteOp.space = bComponentSpace;
        deleteOp.context = context;
        deleteOp.read(inputStream);
        return deleteOp;
    }

    public DeleteOp delete() {
        return (DeleteOp)this.space.fw(106, this, null, null, null);
    }

    public DeleteOp undelete() {
        return (DeleteOp)this.space.fw(107, this, null, null, null);
    }

    public DeleteOp doDelete() {
        Process process = new Process();
        process.resolveParents();
        process.resolveProps();
        process.save();
        process.explode();
        process.saveAndRemoveExternalLinks();
        process.remove();
        return this;
    }

    public DeleteOp doUndelete() {
        Process process = new Process();
        process.resolveParents();
        process.add();
        process.restoreExternalComposites();
        process.restoreExternalLinks();
        return this;
    }

    private final void read(InputStream inputStream) throws Exception {
        Object object;
        int n;
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        if (dataInputStream.readInt() != 7649) {
            throw new IOException("Invalid magic 1");
        }
        if (dataInputStream.readInt() != 1) {
            throw new IOException("Invalid version");
        }
        this.size = dataInputStream.readInt();
        this.parentOrds = new BOrd[this.size];
        this.propNames = new String[this.size];
        int n2 = 0;
        while (n2 < this.size) {
            this.parentOrds[n2] = BOrd.make(dataInputStream.readUTF());
            this.propNames[n2] = dataInputStream.readUTF();
            ++n2;
        }
        if (dataInputStream.readBoolean()) {
            n2 = dataInputStream.readInt();
            this.extLinks = new ExternalLink[n2];
            n = 0;
            while (n < n2) {
                String[] stringArray = TextUtil.split((String)dataInputStream.readUTF(), (char)'\n');
                object = BOrd.make(stringArray[0]);
                int n3 = 0;
                if (stringArray.length >= 2) {
                    n3 = Integer.parseInt(stringArray[1], 16);
                }
                int n4 = n3;
                BLink bLink = (BLink)ValueDocDecoder.unmarshal(dataInputStream.readUTF());
                this.extLinks[n] = new ExternalLink((BOrd)object, bLink, n4);
                ++n;
            }
        }
        dataInputStream.readUTF();
        Class clazz = class$com$tridium$sys$transfer$DeleteOp$ExternalComposite;
        if (clazz == null) {
            clazz = class$com$tridium$sys$transfer$DeleteOp$ExternalComposite = DeleteOp.class("[Lcom.tridium.sys.transfer.DeleteOp$ExternalComposite;", false);
        }
        Array array = new Array(clazz);
        n = dataInputStream.readInt();
        int n5 = 0;
        while (n5 < n) {
            object = dataInputStream.readUTF();
            if (((String)object).startsWith("c")) {
                array.add((Object)new ExternalComposite().decode((String)object));
            }
            ++n5;
        }
        this.extComposites = (ExternalComposite[])array.trim();
        if (dataInputStream.readInt() != 11745) {
            throw new IOException("Invalid magic 2");
        }
        if (dataInputStream.readBoolean()) {
            this.flags = new int[this.size];
            this.facets = new BFacets[this.size];
            this.values = new BValue[this.size];
            n5 = 0;
            while (n5 < this.size) {
                this.flags[n5] = dataInputStream.readInt();
                this.facets[n5] = BFacets.make(dataInputStream.readUTF());
                dataInputStream.readUTF();
                ++n5;
            }
            if (dataInputStream.readInt() != 11746) {
                throw new IOException("Invalid magic 3");
            }
            ValueDocDecoder valueDocDecoder = new ValueDocDecoder(dataInputStream);
            int n6 = 0;
            while (n6 < this.size) {
                valueDocDecoder.next();
                this.values[n6] = valueDocDecoder.decode();
                ++n6;
            }
        }
    }

    public void write(OutputStream outputStream) throws Exception {
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        dataOutputStream.writeInt(7649);
        dataOutputStream.writeInt(1);
        dataOutputStream.writeInt(this.size);
        int n = 0;
        while (n < this.size) {
            dataOutputStream.writeUTF(this.parentOrds[n].toString());
            dataOutputStream.writeUTF(this.propNames[n]);
            ++n;
        }
        if (this.extLinks == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            dataOutputStream.writeInt(this.extLinks.length);
            n = 0;
            while (n < this.extLinks.length) {
                dataOutputStream.writeUTF(this.extLinks[n].target.toString() + '\n' + Integer.toHexString(this.extLinks[n].flags));
                dataOutputStream.writeUTF(ValueDocEncoder.marshal(this.extLinks[n].link));
                ++n;
            }
        }
        dataOutputStream.writeUTF("");
        if (this.extComposites == null) {
            dataOutputStream.writeInt(0);
        } else {
            dataOutputStream.writeInt(this.extComposites.length);
            n = 0;
            while (n < this.extComposites.length) {
                dataOutputStream.writeUTF(this.extComposites[n].encode());
                ++n;
            }
        }
        dataOutputStream.writeInt(11745);
        if (this.values == null) {
            dataOutputStream.writeBoolean(false);
            dataOutputStream.flush();
        } else {
            dataOutputStream.writeBoolean(true);
            n = 0;
            while (n < this.size) {
                dataOutputStream.writeInt(this.flags[n]);
                dataOutputStream.writeUTF(this.facets[n].encodeToString());
                dataOutputStream.writeUTF("");
                ++n;
            }
            dataOutputStream.writeInt(11746);
            dataOutputStream.flush();
            ValueDocEncoder valueDocEncoder = new ValueDocEncoder(dataOutputStream);
            valueDocEncoder.setEncodeTransients(true);
            valueDocEncoder.setEncodeComments(false);
            int n2 = 0;
            while (n2 < this.size) {
                valueDocEncoder.encode(this.values[n2]);
                ++n2;
            }
            valueDocEncoder.flush();
        }
    }

    public void dump() {
        PrintWriter printWriter = new PrintWriter(System.out);
        this.dump(printWriter);
        printWriter.flush();
    }

    public void dump(PrintWriter printWriter) {
        printWriter.println("DeleteOp");
        printWriter.println("  size=" + this.size);
        printWriter.println("  items=");
        int n = 0;
        while (n < this.size) {
            printWriter.println("    [" + n + "] " + this.parentOrds[n] + '/' + this.propNames[n]);
            ++n;
        }
        if (this.values != null) {
            printWriter.println("  values=");
            n = 0;
            while (n < this.size) {
                printWriter.println("    [" + n + "] " + this.values[n].toDebugString());
                BComponent[] bComponentArray = ((BComponent)this.values[n]).getChildComponents();
                int n2 = 0;
                while (n2 < bComponentArray.length) {
                    if (bComponentArray[n2].getPropertyInParent().isDynamic()) {
                        printWriter.println("          " + bComponentArray[n2].getName() + ' ' + bComponentArray[n2].toDebugString());
                    }
                    ++n2;
                }
                BLink[] bLinkArray = this.values[n].asComponent().getLinks();
                int n3 = 0;
                while (n3 < bLinkArray.length) {
                    printWriter.println("          " + bLinkArray[n3].getName() + ' ' + bLinkArray[n3]);
                    ++n3;
                }
                ++n;
            }
        }
        if (this.extLinks != null) {
            printWriter.println("  extLinks=");
            n = 0;
            while (n < this.extLinks.length) {
                printWriter.println("    [" + n + "] " + this.extLinks[n]);
                ++n;
            }
        }
        if (this.extComposites != null) {
            printWriter.println("  extComposites=");
            n = 0;
            while (n < this.extComposites.length) {
                printWriter.println("    [" + n + "] " + this.extComposites[n]);
                ++n;
            }
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected DeleteOp() {
    }

    protected DeleteOp(Mark mark, Context context) {
        this.space = (BComponentSpace)TransferStrategy.toSpace(mark);
        this.context = context;
        this.size = mark.size();
        this.parentOrds = new BOrd[this.size];
        this.propNames = new String[this.size];
        int n = 0;
        while (n < this.size) {
            BComplex bComplex = (BComplex)mark.getValue(n);
            BComponent bComponent = (BComponent)bComplex.getParent();
            String string = bComplex.getPropertyInParent().getName();
            this.parentOrds[n] = bComponent.getHandleOrd();
            this.propNames[n] = string;
            ++n;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class Process {
        protected BComponent[] parents;
        protected Property[] props;
        protected HashMap byHandle;

        public void resolveParents() {
            this.parents = new BComponent[DeleteOp.this.size];
            int n = 0;
            while (n < DeleteOp.this.size) {
                this.parents[n] = (BComponent)DeleteOp.this.parentOrds[n].get(DeleteOp.this.space);
                ++n;
            }
        }

        public void resolveProps() {
            this.props = new Property[DeleteOp.this.size];
            int n = 0;
            while (n < DeleteOp.this.size) {
                this.props[n] = this.parents[n].getProperty(DeleteOp.this.propNames[n]);
                if (this.props[n] == null) {
                    throw new IllegalStateException("Missing prop to delete: " + DeleteOp.this.parentOrds[n] + "::" + DeleteOp.this.propNames[n]);
                }
                ++n;
            }
        }

        public void save() {
            DeleteOp.this.values = new BValue[DeleteOp.this.size];
            DeleteOp.this.flags = new int[DeleteOp.this.size];
            DeleteOp.this.facets = new BFacets[DeleteOp.this.size];
            int n = 0;
            while (n < DeleteOp.this.size) {
                BComponent bComponent = this.parents[n];
                Property property = this.props[n];
                DeleteOp.this.values[n] = bComponent.get(property);
                DeleteOp.this.flags[n] = property.getDefaultFlags();
                DeleteOp.this.facets[n] = property.getFacets();
                ++n;
            }
        }

        public void explode() {
            this.byHandle = new HashMap();
            int n = 0;
            while (n < DeleteOp.this.size) {
                if (DeleteOp.this.values[n] instanceof BComponent) {
                    this.explode((BComponent)DeleteOp.this.values[n]);
                }
                ++n;
            }
        }

        private final void explode(BComponent bComponent) {
            this.byHandle.put(bComponent.getHandle(), bComponent);
            SlotCursor slotCursor = bComponent.getProperties();
            while (slotCursor.nextComponent()) {
                this.explode((BComponent)slotCursor.get());
            }
        }

        public void saveAndRemoveExternalLinks() {
            Class clazz = class$com$tridium$sys$transfer$DeleteOp$ExternalLink;
            if (clazz == null) {
                clazz = class$com$tridium$sys$transfer$DeleteOp$ExternalLink = DeleteOp.class("[Lcom.tridium.sys.transfer.DeleteOp$ExternalLink;", false);
            }
            Array array = new Array(clazz);
            Class clazz2 = class$com$tridium$sys$transfer$DeleteOp$ExternalComposite;
            if (clazz2 == null) {
                clazz2 = class$com$tridium$sys$transfer$DeleteOp$ExternalComposite = DeleteOp.class("[Lcom.tridium.sys.transfer.DeleteOp$ExternalComposite;", false);
            }
            Array array2 = new Array(clazz2);
            Iterator iterator = this.byHandle.values().iterator();
            while (iterator.hasNext()) {
                this.saveAndRemoveExternalLinks((BComponent)iterator.next(), null, array, array2);
            }
            DeleteOp.this.extLinks = (ExternalLink[])array.trim();
            DeleteOp.this.extComposites = (ExternalComposite[])array2.trim();
        }

        private final void saveAndRemoveExternalLinks(BComponent bComponent, Slot slot, Array array, Array array2) {
            Slot slot2;
            BComplex bComplex;
            Object object;
            BComplex bComplex2;
            Knob[] knobArray = slot == null ? bComponent.getKnobs() : bComponent.getKnobs(slot);
            int n = 0;
            while (n < knobArray.length) {
                Knob knob = knobArray[n];
                bComplex2 = knob.getTargetComponent();
                object = knob.getTargetSlot();
                bComplex = knob.getLink();
                if (bComplex == null) {
                    System.out.println("WARNING: Cannot save knob for undo: " + knob);
                } else {
                    slot2 = bComplex.getPropertyInParent();
                    if (slot != null || this.byHandle.get(((BComponent)bComplex2).getHandle()) == null) {
                        boolean bl = false;
                        if (object.isDynamic() && (slot2.getDefaultFlags() & 0x1000) != 0 && (object.getDefaultFlags() & 0x1000) != 0) {
                            bl = true;
                        }
                        boolean bl2 = bl;
                        array.add((Object)new ExternalLink(((BComponent)bComplex2).getHandleOrd(), (BLink)bComplex.newCopy(), slot2.getDefaultFlags()));
                        ((BComponent)bComplex2).remove((Property)slot2, DeleteOp.this.context);
                        if (bl2) {
                            this.removeCompositeSlot((BComponent)bComplex2, (Property)object, array, array2);
                        }
                    }
                }
                ++n;
            }
            BLink[] bLinkArray = slot == null ? bComponent.getLinks() : bComponent.getLinks(slot);
            int n2 = 0;
            while (n2 < bLinkArray.length) {
                bComplex2 = bLinkArray[n2];
                object = null;
                try {
                    object = ((BLink)bComplex2).getSourceComponent();
                }
                catch (Exception exception) {}
                if (object == null) {
                    System.out.println("WARNING: Cannot save link for undo: " + bComplex2);
                } else {
                    boolean bl;
                    bComplex = ((BLink)bComplex2).getTargetComponent();
                    slot2 = ((BLink)bComplex2).getSourceSlot();
                    Property property = bComplex2.getPropertyInParent();
                    boolean bl3 = false;
                    if (slot2.isDynamic() && (slot2.getDefaultFlags() & 0x1000) != 0 && (property.getDefaultFlags() & 0x1000) != 0) {
                        bl3 = true;
                    }
                    if ((bl = bl3) || slot != null) {
                        array.add((Object)new ExternalLink(((BComponent)bComplex).getHandleOrd(), (BLink)bComplex2.newCopy(), property.getDefaultFlags()));
                        ((BComponent)bComplex).remove(property, DeleteOp.this.context);
                    }
                    if (bl) {
                        this.removeCompositeSlot((BComponent)object, (Property)slot2, array, array2);
                    }
                }
                ++n2;
            }
        }

        public void removeCompositeSlot(BComponent bComponent, Property property, Array array, Array array2) {
            ExternalComposite externalComposite = new ExternalComposite();
            externalComposite.composite = bComponent.getHandleOrd();
            externalComposite.name = property.getName();
            externalComposite.flags = property.getDefaultFlags();
            externalComposite.facets = property.getFacets();
            externalComposite.type = property.getType();
            array2.add((Object)externalComposite);
            this.saveAndRemoveExternalLinks(bComponent, property, array, array2);
            bComponent.remove(property, DeleteOp.this.context);
        }

        public void remove() {
            BasicContext basicContext = new BasicContext(DeleteOp.this.context, noRemoveLinks);
            int n = 0;
            while (n < DeleteOp.this.size) {
                this.parents[n].remove(this.props[n], (Context)basicContext);
                ++n;
            }
        }

        public void add() {
            try {
                Transaction transaction = DeleteOp.this.space.newTransaction(DeleteOp.this.context);
                int n = 0;
                while (n < DeleteOp.this.size) {
                    BComponent bComponent = this.parents[n];
                    String string = DeleteOp.this.propNames[n];
                    BValue bValue = DeleteOp.this.values[n];
                    int n2 = DeleteOp.this.flags[n];
                    BFacets bFacets = DeleteOp.this.facets[n];
                    bComponent.add(string, bValue, n2, bFacets, transaction);
                    ++n;
                }
                transaction.commit(DeleteOp.this.context);
            }
            catch (Exception exception) {
                throw new BajaRuntimeException(exception);
            }
        }

        public void restoreExternalComposites() {
            int n = 0;
            while (n < DeleteOp.this.extComposites.length) {
                try {
                    ExternalComposite externalComposite = DeleteOp.this.extComposites[n];
                    BComponent bComponent = (BComponent)externalComposite.composite.get(DeleteOp.this.space);
                    BValue bValue = (BValue)externalComposite.type.getInstance();
                    bComponent.add(externalComposite.name, bValue, externalComposite.flags, externalComposite.facets);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                ++n;
            }
        }

        public void restoreExternalLinks() {
            int n = 0;
            while (n < DeleteOp.this.extLinks.length) {
                BOrd bOrd = DeleteOp.this.extLinks[n].target;
                BLink bLink = DeleteOp.this.extLinks[n].link;
                int n2 = DeleteOp.this.extLinks[n].flags;
                try {
                    BComponent bComponent = (BComponent)bOrd.get(DeleteOp.this.space);
                    bComponent.add(null, (BValue)bLink, n2);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                ++n;
            }
        }
    }

    static class ExternalLink {
        BOrd target;
        BLink link;
        int flags;

        public String toString() {
            return "" + this.target + ' ' + this.link;
        }

        ExternalLink(BOrd bOrd, BLink bLink, int n) {
            this.target = bOrd;
            this.link = bLink;
            this.flags = n;
        }
    }

    static class ExternalComposite {
        BOrd composite;
        String name;
        int flags;
        BFacets facets;
        Type type;

        public String toString() {
            return this.composite + ' ' + this.name + ' ' + Integer.toHexString(this.flags) + ' ' + this.facets + ' ' + this.type;
        }

        String encode() throws IOException {
            return "c\n" + this.composite.encodeToString() + '\n' + this.name + '\n' + Integer.toHexString(this.flags) + '\n' + this.facets.encodeToString() + '\n' + this.type.toString();
        }

        ExternalComposite decode(String string) throws IOException {
            String[] stringArray = TextUtil.split((String)string, (char)'\n');
            this.composite = BOrd.make(stringArray[1]);
            this.name = stringArray[2];
            this.flags = Integer.parseInt(stringArray[3], 16);
            this.facets = BFacets.make(stringArray[4]);
            this.type = Sys.getType(stringArray[5]);
            return this;
        }

        ExternalComposite() {
        }
    }
}

