/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.transfer;

import com.tridium.sys.schema.ComponentSlotMap;
import com.tridium.sys.transfer.CompTransferResult;
import com.tridium.sys.transfer.TransferListener;
import com.tridium.sys.transfer.TransferResult;
import com.tridium.sys.transfer.TransferStrategy;
import com.tridium.util.ObjectUtil;
import java.util.ArrayList;
import java.util.HashMap;
import javax.baja.naming.BOrd;
import javax.baja.space.BComponentSpace;
import javax.baja.sync.SyncBuffer;
import javax.baja.sync.Transaction;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.CopyHints;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.util.BFormat;
import javax.baja.util.BNameMap;
import javax.baja.util.BWsAnnotation;

public class CompToComp
extends TransferStrategy {
    protected boolean sameSpace;
    protected boolean sameParent;
    protected boolean exact;
    protected boolean copySource;
    protected boolean keepAllLinks;
    protected BComponent sourceParent;
    protected BObject[] sourceValues;
    protected String[] suggestedNames;
    protected int sourceCount;
    protected BWsAnnotation origin;
    protected BFormat[] insertDisplayNames;
    protected String[] insertNames;
    protected BValue[] insertValues;
    protected HashMap handleMap;

    public TransferResult transfer() throws Exception {
        this.init();
        this.load();
        this.name();
        this.annotate();
        this.remapHandles();
        this.relink();
        this.insert();
        this.remove();
        return this.makeResult();
    }

    public void init() {
        this.sourceValues = this.mark.getValues();
        this.suggestedNames = this.mark.getNames();
        this.sourceCount = this.sourceValues.length;
        this.origin = (BWsAnnotation)this.getParameter("origin", (BObject)null);
        this.sourceParent = this.getSourceParent();
        this.sameParent = this.isSameParent();
        this.sameSpace = this.isSameSpace();
        this.exact = this.getParameter("exact", this.isMove());
        this.copySource = this.getParameter("copySource", true);
        this.keepAllLinks = this.getParameter("keepAllLinks", false);
        if (this.context == null) {
            this.context = new BasicContext();
        }
        if (CompToComp.isDebugOn()) {
            this.dump();
        }
    }

    private final BComponent getSourceParent() {
        int n = 0;
        while (n < this.sourceValues.length) {
            BObject bObject = this.sourceValues[n];
            if (bObject.isComponent()) {
                return (BComponent)bObject.asComponent().getParent();
            }
            ++n;
        }
        return null;
    }

    private final boolean isSameParent() {
        int n = 0;
        while (n < this.sourceValues.length) {
            BObject bObject = this.sourceValues[n];
            if (bObject.isComponent() && bObject.asComponent().getParent() == this.target) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private final boolean isSameSpace() {
        if (this.sourceParent != null && this.target.isComponent()) {
            boolean bl = false;
            if (this.sourceParent.getSpace() == this.target.asComponent().getSpace()) {
                bl = true;
            }
            return bl;
        }
        return false;
    }

    protected void load() throws Exception {
        if (CompToComp.isDebugOn()) {
            CompToComp.debug("load");
        }
        this.insertValues = new BValue[this.sourceCount];
        System.arraycopy(this.sourceValues, 0, this.insertValues, 0, this.sourceCount);
        if (this.copySource) {
            TransferListenerCopyHints transferListenerCopyHints = new TransferListenerCopyHints();
            transferListenerCopyHints.defaultOnClone = this.exact ^ true;
            transferListenerCopyHints.swizzleHandles = true;
            if (CompToComp.isDebugOn()) {
                CompToComp.debug("  newCopy: " + transferListenerCopyHints);
            }
            this.insertValues = BValue.newCopy(this.insertValues, transferListenerCopyHints);
        }
    }

    protected void name() throws Exception {
        if (CompToComp.isDebugOn()) {
            CompToComp.debug("name");
        }
        this.insertNames = (String[])this.suggestedNames.clone();
        this.insertDisplayNames = new BFormat[this.sourceCount];
        HashMap<String, String> hashMap = new HashMap<String, String>();
        BComponent bComponent = this.target.asComponent();
        BComponentSpace bComponentSpace = bComponent.getComponentSpace();
        TargetNameContainer targetNameContainer = new TargetNameContainer(bComponent, hashMap);
        int n = 0;
        while (n < this.insertNames.length) {
            BNameMap bNameMap;
            BComplex bComplex;
            BComplex bComplex2;
            String string = this.insertNames[n];
            string = (String)bComponentSpace.fw(111, string, targetNameContainer, null, null);
            hashMap.put(string, string);
            this.insertNames[n] = string;
            if (this.sourceValues[n].isComplex() && (bComplex2 = (bComplex = (BComplex)this.sourceValues[n]).getParent()) != null && (bNameMap = (BNameMap)bComplex2.get("displayNames")) != null) {
                this.insertDisplayNames[n] = bNameMap.get(bComplex.getName());
            }
            ++n;
        }
    }

    public static String getUniqueName(BComponent bComponent, String string) {
        return ObjectUtil.generateUniqueSlotName(string, new TargetNameContainer(bComponent, new HashMap()));
    }

    protected void annotate() throws Exception {
        if (CompToComp.isDebugOn()) {
            CompToComp.debug("annotate");
        }
        if (this.origin != null) {
            this.moveToOrigin();
        } else if (this.sameParent) {
            int n = 0;
            while (n < this.sourceCount) {
                this.stagger(this.insertValues[n], 1);
                ++n;
            }
        }
    }

    protected void moveToOrigin() {
        BWsAnnotation bWsAnnotation = CompToComp.computeOrigin(this.sourceValues, this.sourceCount);
        int n = this.origin.p - bWsAnnotation.p;
        int n2 = this.origin.q - bWsAnnotation.q;
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.insertValues.length) {
            BWsAnnotation bWsAnnotation2;
            BComponent bComponent = (BComponent)this.insertValues[n4];
            Property property = bComponent.getProperty("wsAnnotation");
            if (property != null) {
                bWsAnnotation2 = (BWsAnnotation)bComponent.get(property);
                bComponent.set(property, (BValue)bWsAnnotation2.translate(n, n2));
            } else {
                bWsAnnotation2 = BWsAnnotation.make(this.origin.p + n3, this.origin.q + n3, 8);
                n3 += 4;
                bComponent.add("wsAnnotation", bWsAnnotation2);
            }
            ++n4;
        }
    }

    public static BWsAnnotation computeOrigin(BObject[] bObjectArray, int n) {
        int n2 = Integer.MAX_VALUE;
        int n3 = Integer.MAX_VALUE;
        int n4 = 0;
        while (n4 < n) {
            BWsAnnotation bWsAnnotation = (BWsAnnotation)bObjectArray[n4].asComplex().get("wsAnnotation");
            if (bWsAnnotation != null) {
                n2 = Math.min(n2, bWsAnnotation.p);
                n3 = Math.min(n3, bWsAnnotation.q);
            }
            ++n4;
        }
        if (n2 == Integer.MAX_VALUE) {
            n2 = 0;
        }
        if (n3 == Integer.MAX_VALUE) {
            n3 = 0;
        }
        return BWsAnnotation.make(n2, n3);
    }

    protected void stagger(BObject bObject, int n) {
        BComplex bComplex = (BComplex)bObject;
        Property property = bComplex.getProperty("wsAnnotation");
        if (property != null) {
            BWsAnnotation bWsAnnotation = (BWsAnnotation)bComplex.get(property);
            bComplex.set(property, (BValue)bWsAnnotation.translate(n, n));
        }
    }

    protected void remapHandles() {
        if (CompToComp.isDebugOn()) {
            CompToComp.debug("remapHandles");
        }
        ArrayList arrayList = new ArrayList();
        int n = 0;
        while (n < this.insertValues.length) {
            if (this.insertValues[n].isComponent()) {
                this.listComponents(arrayList, this.insertValues[n].asComponent());
            }
            ++n;
        }
        n = arrayList.size();
        BComponentSpace bComponentSpace = this.getTargetSpace();
        Object[] objectArray = (Object[])bComponentSpace.fw(103, new Integer(n), null, null, null);
        this.handleMap = new HashMap();
        int n2 = 0;
        while (n2 < n) {
            BComponent bComponent = (BComponent)arrayList.get(n2);
            Object object = bComponent.getHandle();
            Object object2 = objectArray[n2];
            ((ComponentSlotMap)bComponent.fw(1)).setHandle(object2);
            if (object != null) {
                if (CompToComp.isDebugOn()) {
                    CompToComp.debug("  " + object + " -> " + object2);
                }
                this.handleMap.put(object, object2);
            }
            ++n2;
        }
    }

    protected void listComponents(ArrayList arrayList, BComponent bComponent) {
        arrayList.add(bComponent);
        SlotCursor slotCursor = bComponent.getProperties();
        while (slotCursor.nextComponent()) {
            this.listComponents(arrayList, slotCursor.get().asComponent());
        }
    }

    protected BComponentSpace getTargetSpace() {
        return this.target.asComponent().getComponentSpace();
    }

    protected void relink() throws Exception {
        if (CompToComp.isDebugOn()) {
            CompToComp.debug("relink");
        }
        int n = 0;
        while (n < this.sourceCount) {
            if (this.insertValues[n] instanceof BComplex) {
                this.relink((BComplex)this.insertValues[n]);
                if (this.listener != null) {
                    this.updateStatus("Updating links \"" + CompToComp.toString(this.sourceValues[n]) + "\"...");
                }
            }
            ++n;
        }
    }

    private final void relink(BComplex bComplex) {
        BComplex bComplex2 = bComplex;
        Property[] propertyArray = bComplex2.getPropertiesArray();
        int n = 0;
        while (n < propertyArray.length) {
            Property property = propertyArray[n];
            if (property.getTypeAccess() == 7) {
                BValue bValue = bComplex2.get(property);
                if (bValue instanceof BLink) {
                    this.relink((BLink)bValue);
                } else if (bValue instanceof BOrd) {
                    BOrd bOrd = this.relink((BOrd)bValue);
                    if (bOrd != null) {
                        bComplex2.set(property, (BValue)bOrd);
                    }
                } else if (bValue instanceof BComplex) {
                    this.relink((BComplex)bValue);
                }
            }
            ++n;
        }
    }

    private final BOrd relink(BOrd bOrd) {
        BOrd bOrd2;
        String string = bOrd.toString();
        if (!string.startsWith("h:")) {
            if (CompToComp.isDebugOn()) {
                CompToComp.debug("  ord not handle: " + bOrd);
            }
            return null;
        }
        String string2 = string.substring(2).trim();
        Object v = this.handleMap.get(string2);
        if (v == null) {
            bOrd2 = BOrd.make("h:" + ComponentSlotMap.unswizzle(string2));
            if (CompToComp.isDebugOn()) {
                CompToComp.debug("  ord unswizzle: " + bOrd + " -> " + bOrd2);
            }
        } else {
            bOrd2 = BOrd.make("h:" + v);
            if (CompToComp.isDebugOn()) {
                CompToComp.debug("  ord remap: " + bOrd + " -> " + bOrd2);
            }
        }
        return bOrd2;
    }

    private final void relink(BLink bLink) {
        String string = bLink.getSourceOrd().toString();
        if (!string.startsWith("h:")) {
            if (CompToComp.isDebugOn()) {
                CompToComp.debug("  link not handle: " + string);
            }
            return;
        }
        String string2 = string.substring(2).trim();
        Object v = this.handleMap.get(string2);
        if (v == null) {
            if (this.sameSpace && (this.exact || this.keepAllLinks)) {
                BOrd bOrd = BOrd.make("h:" + ComponentSlotMap.unswizzle(string2));
                if (CompToComp.isDebugOn()) {
                    CompToComp.debug("  link unsizzle: " + string + " -> " + bOrd);
                }
                bLink.setSourceOrd(bOrd);
            } else {
                if (CompToComp.isDebugOn()) {
                    CompToComp.debug("  link remove: " + string);
                }
                BComponent bComponent = (BComponent)bLink.getParent();
                bComponent.remove(bLink.getPropertyInParent());
                String string3 = bLink.getTargetSlotName();
                Slot slot = bComponent.getSlot(string3);
                if (slot instanceof Property) {
                    Property property = (Property)slot;
                    bComponent.set(property, property.getDefaultValue().newCopy());
                }
            }
        } else {
            BOrd bOrd = BOrd.make("h:" + v);
            if (CompToComp.isDebugOn()) {
                CompToComp.debug("  link remap: " + string + " -> " + bOrd);
            }
            bLink.setSourceOrd(bOrd);
        }
    }

    protected void insert() throws Exception {
        BComponent bComponent;
        Context context;
        if (CompToComp.isDebugOn()) {
            CompToComp.debug("insert");
        }
        if ((context = Transaction.start(bComponent = this.target.asComponent(), this.context)) instanceof SyncBuffer) {
            ((SyncBuffer)((Object)context)).fw(this.listener);
        }
        if (CompToComp.isDebugOn()) {
            CompToComp.debug("  tx: " + context.getClass().getName());
        }
        int n = 0;
        while (n < this.insertValues.length) {
            if (this.insertDisplayNames[n] != null) {
                BNameMap bNameMap = (BNameMap)bComponent.get("displayNames");
                if (bNameMap == null) {
                    bNameMap = BNameMap.make(BNameMap.NULL, this.insertNames[n], this.insertDisplayNames[n]);
                    bComponent.add("displayNames", bNameMap);
                } else {
                    bNameMap = BNameMap.make(bNameMap, this.insertNames[n], this.insertDisplayNames[n]);
                    bComponent.set("displayNames", (BValue)bNameMap);
                }
            }
            bComponent.add(this.insertNames[n], this.insertValues[n], context);
            if (this.listener != null) {
                this.updateStatus("Inserting \"" + CompToComp.toString(this.sourceValues[n]) + "\"...");
            }
            ++n;
        }
        Transaction.end(bComponent, context);
    }

    protected void remove() throws Exception {
        if (!this.isMove()) {
            return;
        }
        if (CompToComp.isDebugOn()) {
            CompToComp.debug("remove");
        }
        int n = 0;
        while (n < this.sourceValues.length) {
            BComplex bComplex = (BComplex)this.sourceValues[n];
            BComplex bComplex2 = bComplex.getParent();
            if (bComplex2 != null) {
                bComplex2.asComponent().remove(bComplex.getPropertyInParent(), this.context);
            }
            ++n;
        }
    }

    protected TransferResult makeResult() throws Exception {
        return new CompTransferResult(this.action, this.sourceParent, this.suggestedNames, (BComponent)this.target, this.insertNames);
    }

    public void dumpExtra() {
        CompToComp.debug("  o source[" + this.sourceCount + "]:");
        int n = 0;
        while (n < this.sourceCount) {
            CompToComp.debug("      " + this.suggestedNames[n] + ": " + this.sourceValues[n].toDebugString());
            ++n;
        }
        CompToComp.debug("  o sourceParent: " + this.sourceParent);
        CompToComp.debug("  o sameParent:   " + this.sameParent);
        CompToComp.debug("  o exact:        " + this.exact);
        CompToComp.debug("  o copySource:   " + this.copySource);
        CompToComp.debug("  o origin:       " + this.origin);
        CompToComp.debug("  o exact:        " + this.exact);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class TransferListenerCopyHints
    extends CopyHints
    implements TransferListener {
        public void updateStatus(String string) {
            CompToComp.this.updateStatus(string);
        }

        TransferListenerCopyHints() {
        }
    }

    public static class TargetNameContainer
    implements ObjectUtil.NameContainer {
        BComponent target;
        HashMap dups;

        public boolean contains(String string) {
            boolean bl = false;
            if (this.target.asComponent().getSlot(string) != null || this.dups.get(string) != null) {
                bl = true;
            }
            return bl;
        }

        public TargetNameContainer(BComponent bComponent, HashMap hashMap) {
            this.target = bComponent;
            this.dups = hashMap;
        }
    }
}

