/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.station;

import com.tridium.sys.BIPlatform;
import com.tridium.sys.Nre;
import com.tridium.sys.station.Station;
import java.io.File;
import javax.baja.spy.Spy;
import javax.baja.spy.SpyDir;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BStation;
import javax.baja.sys.Clock;
import javax.baja.sys.Sys;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class StationManager
extends Thread {
    boolean isAlive;

    public void kill() {
        this.isAlive = false;
        this.interrupt();
    }

    public void run() {
        while (this.isAlive) {
            try {
                Thread.sleep(60000L);
                BIPlatform bIPlatform = Nre.getPlatform();
                if (!bIPlatform.isStationAutoSaveEnabled()) continue;
                long l = bIPlatform.getStationAutoSaveFrequency();
                long l2 = Clock.ticks() - Station.lastSaveAttemptTicks;
                if (l2 <= l) continue;
                Sys.getStation().save();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public void postInit() {
        IndexPage indexPage = new IndexPage();
        Nre.spySysManagers.add("stationManager", indexPage);
        indexPage.add("backups", new BackupPage());
    }

    private final /* synthetic */ void this() {
        this.isAlive = true;
    }

    public StationManager() {
        super("Nre:Station");
        this.this();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class IndexPage
    extends SpyDir {
        public void write(SpyWriter spyWriter) throws Exception {
            Object object;
            BStation bStation = Station.station;
            BIPlatform bIPlatform = Nre.getPlatform();
            if (bStation == null) {
                spyWriter.print("VM is not a station");
                return;
            }
            spyWriter.startProps("StationManager");
            spyWriter.prop((Object)"stationName", bStation.getStationName());
            spyWriter.prop((Object)"atSteadyState", Sys.atSteadyState());
            spyWriter.trTitle("Platform", 2);
            spyWriter.prop((Object)"type", bIPlatform.getType());
            spyWriter.prop((Object)"isFlashFileSystem", bIPlatform.isFlashFileSystem());
            spyWriter.prop((Object)"autoSaveEnabled", bIPlatform.isStationAutoSaveEnabled());
            spyWriter.prop((Object)"autoSaveFreq", bIPlatform.getStationAutoSaveFrequency() / 1000L + "sec");
            spyWriter.prop((Object)"saveBackupCount", bIPlatform.getStationSaveBackupCount());
            spyWriter.trTitle("Console", 2);
            spyWriter.prop((Object)"isAlive", Station.console.isAlive());
            spyWriter.prop((Object)"threadName", Station.console.getName());
            spyWriter.trTitle("Boot Debug", 2);
            spyWriter.prop((Object)"commandLine", Nre.commandLine);
            spyWriter.prop((Object)"bootFile", Station.bootFile);
            spyWriter.prop((Object)"bootTime", BAbsTime.make(Nre.bootTime));
            spyWriter.prop((Object)"bootFileLock", Station.bootFileLock);
            spyWriter.trTitle("Save Debug", 2);
            spyWriter.prop((Object)"lastSaveDuration", Station.getLastSaveDurationString());
            spyWriter.prop((Object)"lastSuccessfulSaveTime", Station.lastSuccessfulSaveTime);
            spyWriter.prop((Object)"lastSaveSpan", BRelTime.toString(Station.lastSaveSpan));
            spyWriter.prop((Object)"lastSaveFile", Station.lastSaveFile);
            spyWriter.prop((Object)"inSave", Station.inSave);
            spyWriter.trTitle("Backups", 2);
            spyWriter.prop((Object)"backups", "<a href='backups'>List Backups</a>");
            spyWriter.trTitle("SaveListeners", 2);
            int n = 0;
            while (n < Station.saveListeners.size()) {
                object = Station.saveListeners.get(n);
                spyWriter.prop((Object)object.getClass().getName(), object);
                ++n;
            }
            spyWriter.trTitle("RemoteListeners", 2);
            n = 0;
            while (n < Station.remoteListeners.size()) {
                object = Station.remoteListeners.get(n);
                spyWriter.prop((Object)object.getClass().getName(), object);
                ++n;
            }
            spyWriter.endProps();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class BackupPage
    extends Spy {
        public void write(SpyWriter spyWriter) throws Exception {
            File[] fileArray = Station.getBackups();
            if (fileArray.length == 0) {
                spyWriter.w("No backup files available");
                return;
            }
            spyWriter.startTable(true);
            spyWriter.trTitle("Station Backups", 4);
            spyWriter.w("<tr>").th("Age").th("Name").th("Timestamp").th("Size").w("</tr>\n");
            int n = 0;
            while (n < fileArray.length) {
                File file = fileArray[n];
                spyWriter.tr("" + n, file.getName(), BAbsTime.make(file.lastModified()), file.length() / 1024L + "kb");
                ++n;
            }
            spyWriter.endTable();
        }
    }
}

