/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.station;

import com.tridium.dataRecovery.BDataRecoveryComponentRecorder;
import com.tridium.nre.util.FileLock;
import com.tridium.nre.util.FileLockException;
import com.tridium.sys.Console;
import com.tridium.sys.Nre;
import com.tridium.sys.station.BStationSaveJob;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import javax.baja.agent.AgentFilter;
import javax.baja.category.BCategoryMask;
import javax.baja.dataRecovery.BIDataRecoveryService;
import javax.baja.dataRecovery.DataRecoveryServiceInFaultException;
import javax.baja.file.FileUtil;
import javax.baja.io.ValueDocDecoder;
import javax.baja.io.ValueDocEncoder;
import javax.baja.job.BJob;
import javax.baja.job.JobCancelException;
import javax.baja.license.Feature;
import javax.baja.license.LicenseException;
import javax.baja.log.Log;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.Array;
import javax.baja.space.BComponentSpace;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BStation;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.ModuleNotFoundException;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.LexiconText;
import javax.baja.util.Version;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class Station {
    static byte[] noPayload = new byte[0];
    public static final int ERROR = -1;
    public static final int ERROR_INVALID_USAGE = -2;
    public static final int ERROR_INVALID_LICENSE = -3;
    public static final int ERROR_BOG_NOT_FOUND = -4;
    public static final int ERROR_CANNOT_LOAD_BOG = -5;
    public static final String FAULT_LOW_HEAP = "stationFault.lowHeap";
    public static final String FAULT_LOW_MEMORY = "stationFault.lowSystemMemory";
    public static final String FAULT_RAM_DISK_SPACE = "stationFault.ramDiskSpace";
    public static final String FAULT_DISK_SPACE = "stationFault.diskSpace";
    public static final String FAULT_FD_USAGE = "stationFault.fdUsage";
    public static final String FAULT_FILE_USAGE = "stationFault.fileUsage";
    public static final String FAULT_RESOURCE_LIMIT = "stationFault.resourceLimit";
    public static final String FAULT_DEMO_ONLY = "stationFault.demoOnly";
    public static final String FAULT_DATA_RECOVERY_SAVE = "stationFault.dataRecoverySave";
    public static final String FAULT_FACTORY_DEFAULT_CREDENTIALS = "stationFault.factoryDefaultCredentials";
    public static final Log log = Log.getLog("sys");
    public static BComponentSpace space;
    public static BStation station;
    public static File bootFile;
    public static Console console;
    public static BAbsTime lastSuccessfulSaveTime;
    public static long lastSuccessfulSaveTicks;
    public static long lastSaveAttemptTicks;
    public static long lastSaveSpan;
    public static boolean inSave;
    public static File lastSaveFile;
    public static boolean atSteadyState;
    public static FileLock bootFileLock;
    public static final Object saveLock;
    public static boolean stationStarted;
    static Array saveListeners;
    static Array remoteListeners;
    static String stationFault;
    static boolean demoOnly;
    static final Object restoreLock;
    static boolean restoreComplete;
    static boolean saveAfterRestore;
    static /* synthetic */ Class class$com$tridium$sys$station$Station$SaveListener;
    static /* synthetic */ Class class$com$tridium$sys$station$Station$RemoteListener;
    static /* synthetic */ Class class$javax$baja$sys$Type;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static final void bootStation(File file) throws Exception {
        console = new Console();
        console.start();
        bootFileLock = FileLock.lock((File)file);
        Nre.engineManager.suspend();
        atSteadyState = false;
        Station.loadStation(file);
        Nre.loadPlatform();
        Station.checkLicense();
        Station.initDataRecoveryService();
        Station.initServices();
        space.fw(105, Boolean.FALSE, null, null, null);
        Station.startStation();
        Object object = restoreLock;
        synchronized (object) {
            restoreComplete = true;
        }
        System.gc();
        Nre.engineManager.resume();
        console.ready();
        if (saveAfterRestore) {
            Station.saveAsync(null);
        }
        Station.waitForSteadyState();
        Nre.stationManager.start();
        Nre.resourceManager.start();
        Nre.metricsRecount.start();
    }

    static final void loadStation(File file) throws Exception {
        try {
            String string;
            long l = Clock.ticks();
            log.message("Loading \"" + file + "\"...");
            if (!file.exists()) {
                throw new Exception(file.getPath() + " file does not exist, can not load station");
            }
            if (file.length() == 0L) {
                throw new Exception(file.getPath() + " file is empty, can not load station");
            }
            ValueDocDecoder valueDocDecoder = new ValueDocDecoder(file);
            valueDocDecoder.setTypeResolver(Nre.registryManager.typeResolver);
            BValue bValue = valueDocDecoder.decodeDocument();
            if (!(bValue instanceof BStation)) {
                throw new Exception("The config.bog contains " + bValue.getType() + ", not baja:Station");
            }
            station = (BStation)bValue;
            if (valueDocDecoder.getWarningCount() > 0) {
                System.out.println("###########################################################################");
                System.out.println("#");
                System.out.println("# WARNING: \"config.bog\" contains " + valueDocDecoder.getWarningCount() + " warnings");
                System.out.println("#");
                System.out.println("###########################################################################");
            }
            if (!SlotPath.isValidName(string = Nre.stationHome.getName())) {
                throw new Exception("Invalid station name \"" + string + '\"');
            }
            station.setStationName(string);
            if (station.getCategoryMask().isNull()) {
                station.setCategoryMask(BCategoryMask.make("1"), null);
            }
            space = new BComponentSpace("station", LexiconText.make("baja", "nav.station"), BOrd.make("station:"));
            space.fw(105, Boolean.TRUE, null, null, null);
            BLocalHost.INSTANCE.addNavChild(space);
            space.setRootComponent(station);
            long l2 = Clock.ticks();
            log.message("Loaded (" + (l2 - l) + "ms)");
        }
        catch (Throwable throwable) {
            log.error("Cannot load station", throwable);
            System.exit(-5);
        }
    }

    static final void checkLicense() throws Exception {
        try {
            Feature feature = Sys.getLicenseManager().checkFeature("tridium", "station");
            Nre.resourceManager.checkLicense(feature);
            demoOnly = feature.getb("demoOnly", false);
            if (demoOnly) {
                stationFault = FAULT_DEMO_ONLY;
            }
        }
        catch (LicenseException licenseException) {
            log.error("Not licensed: " + licenseException);
            Nre.licenseManager.dump();
            System.out.println();
            System.out.println("########################################");
            System.out.println("# FATAL: Not licensed to run a station #");
            System.out.println("########################################");
            System.exit(-3);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static final void initDataRecoveryService() throws Exception {
        long l;
        block11: {
            l = Clock.ticks();
            BIDataRecoveryService bIDataRecoveryService = null;
            try {
                bIDataRecoveryService = (BIDataRecoveryService)((Object)Nre.serviceManager.getService("baja:IDataRecoveryService"));
                if (!bIDataRecoveryService.isEnabled()) {
                    return;
                }
            }
            catch (ServiceNotFoundException serviceNotFoundException) {
                return;
            }
            if (bIDataRecoveryService == null) return;
            BDataRecoveryComponentRecorder bDataRecoveryComponentRecorder = (BDataRecoveryComponentRecorder)((BObject)((Object)bIDataRecoveryService)).getAgents().filter(AgentFilter.is(BDataRecoveryComponentRecorder.TYPE)).getDefault().getInstance();
            bDataRecoveryComponentRecorder.setDataRecoveryService(bIDataRecoveryService);
            space.fw(1002, bDataRecoveryComponentRecorder, null, null, null);
            boolean bl = false;
            try {
                Nre.serviceManager.initDataRecoverySourceServices(bIDataRecoveryService);
                bl = true;
                try {
                    bIDataRecoveryService = Nre.serviceManager.startDataRecoveryService();
                    bDataRecoveryComponentRecorder.setDataRecoveryService(bIDataRecoveryService);
                    boolean bl2 = false;
                    if (saveAfterRestore || bIDataRecoveryService.hasRecoveryData()) {
                        bl2 = true;
                    }
                    saveAfterRestore = bl2;
                }
                catch (DataRecoveryServiceInFaultException dataRecoveryServiceInFaultException) {
                    bl = false;
                    log.warning("DataRecoveryService in fault, could not restore recovery data (if any existed). Data recovery component recording not started.", dataRecoveryServiceInFaultException);
                }
                catch (Throwable throwable) {
                    log.error("Error during restoration by the DataRecoveryService.  Some recovery data may not be restored for service " + bIDataRecoveryService, throwable);
                }
            }
            catch (Throwable throwable) {
                Object var6_10 = null;
                space.fw(1002, null, null, null, null);
                throw throwable;
            }
            {
                Object var6_11 = null;
                space.fw(1002, null, null, null, null);
            }
            {
                if (!bl) break block11;
                Nre.serviceManager.addDataRecoveryComponentRecorder(bIDataRecoveryService, bDataRecoveryComponentRecorder);
            }
        }
        long l2 = Clock.ticks();
        log.message("DataRecoveryService restoration check complete (" + (l2 - l) + "ms)");
    }

    static final void initServices() throws Exception {
        long l = Clock.ticks();
        Nre.serviceManager.startAllServices();
        long l2 = Clock.ticks();
        log.message("Services Initialized (" + (l2 - l) + "ms)");
    }

    static final void startStation() throws Exception {
        long l = Clock.ticks();
        station.start();
        stationStarted = true;
        try {
            Nre.getPlatform().stationStarted();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        Nre.engineManager.stationStarted(station);
        long l2 = Clock.ticks();
        log.message("Niagara Runtime Environment: " + Sys.getBajaModule().getVendorVersion());
        log.message("*** Station Started (" + (l2 - l) + "ms) [" + (System.currentTimeMillis() - Nre.bootTime) + "ms total] ***");
    }

    static final void waitForSteadyState() throws Exception {
        int n = Integer.getInteger("niagara.steadystate", 10000);
        Thread.sleep(n);
        atSteadyState = true;
        log.trace("At Steady State (" + n + "ms)");
        Nre.engineManager.atSteadyState(station);
    }

    public static final void shutdown(boolean bl) throws Exception {
        Station.saveSync();
        try {
            BIDataRecoveryService bIDataRecoveryService = Nre.serviceManager.getActiveDataRecoveryService();
            if (bIDataRecoveryService != null) {
                bIDataRecoveryService.shutdownStarted();
            }
        }
        catch (Throwable throwable) {
            log.warning("Could not notify DataRecoveryService of pending station shutdown", throwable);
        }
        Nre.stationManager.kill();
        Station.stopStation();
        Station.stopServices();
        bootFileLock.unlock();
        log.message("*** Station shutdown ***");
        System.out.flush();
        if (bl) {
            System.exit(0);
        }
    }

    static final void stopStation() throws Exception {
        station.stop();
        log.message("Station stopped");
    }

    static final void stopServices() throws Exception {
        Nre.serviceManager.stopAllServices();
        log.message("Services stopped");
    }

    public static final String getStationFault() {
        return stationFault;
    }

    public static final void setStationFault(String string) {
        if (BString.equals(stationFault, string)) {
            return;
        }
        stationFault = demoOnly && string == null ? FAULT_DEMO_ONLY : string;
        Station.broadcastStationFault();
    }

    public static final void broadcastStationFault() {
        byte[] byArray = stationFault == null ? new byte[]{} : stationFault.getBytes();
        Station.fireRemoteEvent(new Message("stationFault", byArray));
    }

    public static final File[] getBackups() {
        try {
            return FileUtil.getBackups(Sys.getStationHome(), "config");
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return new File[0];
        }
    }

    public static final File renameToBackup(File file) {
        try {
            return FileUtil.renameToBackup(file, Nre.getPlatform().getStationSaveBackupCount());
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final void saveAsync(Context context) throws Exception {
        if (station == null) {
            throw new IllegalStateException("System not booted as station");
        }
        if (inSave) {
            return;
        }
        Object object = restoreLock;
        synchronized (object) {
            if (!restoreComplete) {
                saveAfterRestore = true;
                return;
            }
        }
        try {
            new BStationSaveJob().submit(context);
            return;
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            log.error("Missing JobService");
            Station.saveSync();
        }
    }

    public static final void saveSync() throws Exception {
        Station.saveSync(new BStationSaveJob());
    }

    public static final void saveSync(BJob bJob) throws Exception {
        Station.saveSync(bJob, 100);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final void saveSync(BJob var0, int var1_1) throws Exception {
        var2_2 = var0.log();
        var3_3 = null;
        var4_4 = new SaveListener[]{};
        Station.log.message("Saving station...");
        var2_2.start("Saving station...");
        var5_5 = Station.saveLock;
        synchronized (var5_5) {
            Station.inSave = true;
            try {
                block18: {
                    try {
                        block17: {
                            try {
                                var3_3 = Nre.serviceManager.getServices("baja:IDataRecoveryService");
                            }
                            catch (ServiceNotFoundException var9_6) {
                                var3_3 = null;
                            }
                            if (var3_3 != null) {
                                var9_7 = 0;
                                while (var9_7 < var3_3.length) {
                                    ((BIDataRecoveryService)var3_3[var9_7]).saveStarted();
                                    ++var9_7;
                                }
                            }
                            var9_8 = new File(Nre.stationHome, "config.bog");
                            var10_10 = new File(var9_8 + ".working");
                            Station.lastSaveAttemptTicks = var11_12 = Clock.ticks();
                            var2_2.start("Write working to " + var10_10);
                            var13_13 = new StationEncoder(var10_10, var0, var1_1);
                            var13_13.setZipped(true);
                            var13_13.encodeDocument(Station.station);
                            var13_13.close();
                            var2_2.endSuccess();
                            var2_2.start("Make backup");
                            var14_14 = Station.renameToBackup(var9_8);
                            var2_2.endSuccess("" + var14_14);
                            var2_2.start("Rename working to " + var9_8);
                            var10_10.renameTo(var9_8);
                            var2_2.endSuccess();
                            var4_4 = Station.getSaveListeners();
                            var15_15 = 0;
                            while (true) {
                                if (var15_15 >= var4_4.length) {
                                    System.gc();
                                    Station.saveOk(var4_4);
                                    if (var3_3 != null) {
                                        var15_15 = 0;
                                        break;
                                    }
                                    break block17;
                                }
                                var16_17 = var4_4[var15_15];
                                var2_2.start("Save " + var16_17);
                                var16_17.stationSave();
                                var2_2.endSuccess();
                                ++var15_15;
                            }
                            while (var15_15 < var3_3.length) {
                                ((BIDataRecoveryService)var3_3[var15_15]).saveFinished();
                                ++var15_15;
                            }
                        }
                        var15_16 = Clock.ticks();
                        Station.lastSaveFile = var9_8;
                        Station.lastSuccessfulSaveTicks = var15_16;
                        Station.lastSaveSpan = var15_16 - var11_12;
                        Station.lastSuccessfulSaveTime = Clock.time();
                        Station.log.message("Saved " + var9_8 + " (" + Station.lastSaveSpan + "ms)");
                        var2_2.success("Saved " + Station.lastSaveSpan + "ms");
                        var0.progress(var1_1);
                        ** GOTO lbl-1000
                    }
                    catch (Exception var9_9) {
                        Station.log.error("Save failed", var9_9);
                        Station.saveFail(var4_4, var9_9.toString());
                        if (var3_3 == null) break block18;
                        var10_11 = 0;
                    }
                    while (var10_11 < var3_3.length) {
                        ((BIDataRecoveryService)var3_3[var10_11]).saveFailed(var9_9);
                        ++var10_11;
                    }
                }
                throw var9_9;
            }
            catch (Throwable var7_18) {
                var8_19 = null;
                Station.inSave = false;
                throw var7_18;
            }
lbl-1000:
            // 1 sources

            {
                var8_20 = null;
                Station.inSave = false;
            }
            return;
        }
    }

    private static final void saveOk(SaveListener[] saveListenerArray) {
        if (saveListenerArray == null) {
            return;
        }
        int n = 0;
        while (n < saveListenerArray.length) {
            try {
                saveListenerArray[n].stationSaveOk();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            ++n;
        }
    }

    private static final void saveFail(SaveListener[] saveListenerArray, String string) {
        if (saveListenerArray == null) {
            return;
        }
        int n = 0;
        while (n < saveListenerArray.length) {
            try {
                saveListenerArray[n].stationSaveFail(string);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            ++n;
        }
    }

    public static final String getLastSaveDurationString() {
        long l = lastSuccessfulSaveTicks;
        if (l == 0L) {
            return "null";
        }
        return BRelTime.toString(Clock.ticks() - l) + " ago";
    }

    private static final void checkForWorkingFile(File file) throws IOException {
        if (file.exists()) {
            return;
        }
        File file2 = new File(file.getCanonicalPath() + ".working");
        if (file2.exists()) {
            file2.renameTo(file);
        }
    }

    public static final void broadcastStationMixIns() {
        try {
            Type[] typeArray = space.getEnabledMixIns();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeInt(0);
            dataOutputStream.writeInt(typeArray.length);
            int n = 0;
            while (n < typeArray.length) {
                dataOutputStream.writeUTF(typeArray[n].toString());
                ++n;
            }
            Station.fireRemoteEvent(new Message("mixIns", byteArrayOutputStream.toByteArray()));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static final Type[] decodeMixIns(byte[] byArray) throws Exception {
        Class clazz = class$javax$baja$sys$Type;
        if (clazz == null) {
            clazz = class$javax$baja$sys$Type = Station.class("[Ljavax.baja.sys.Type;", false);
        }
        Array array = new Array(clazz);
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
        int n = dataInputStream.readInt();
        int n2 = dataInputStream.readInt();
        int n3 = 0;
        while (n3 < n2) {
            String string = dataInputStream.readUTF();
            try {
                array.add((Object)Sys.getType(string));
            }
            catch (Exception exception) {
                System.out.println("WARNING: No local type for MixIn " + string);
                System.out.println("  " + exception);
            }
            ++n3;
        }
        return (Type[])array.trim();
    }

    public static final void fireRemoteEvent(Message message) {
        RemoteListener[] remoteListenerArray = Station.getRemoteListeners();
        int n = 0;
        while (n < remoteListenerArray.length) {
            try {
                remoteListenerArray[n].stationEvent(message);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            ++n;
        }
    }

    public static final Message remoteCall(Message message) throws Exception {
        String string = message.id;
        if (string.equals("resource.update")) {
            Nre.resourceManager.update();
            return null;
        }
        if (string.equals("resource.report")) {
            return Nre.resourceManager.report(message);
        }
        if (string.equals("module.version")) {
            try {
                return new Message(message.id, Sys.getRegistry().getModule(new String(message.payload)).getVendorVersion().toString().getBytes());
            }
            catch (ModuleNotFoundException moduleNotFoundException) {
                return new Message(message.id, Version.NULL.toString().getBytes());
            }
        }
        throw new Exception("Unknown call: " + string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final RemoteListener[] getRemoteListeners() {
        Array array = remoteListeners;
        synchronized (array) {
            return (RemoteListener[])remoteListeners.trim();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final void addRemoteListener(RemoteListener remoteListener) {
        Array array = remoteListeners;
        synchronized (array) {
            remoteListeners.add((Object)remoteListener);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final void removeRemoteListener(RemoteListener remoteListener) {
        Array array = remoteListeners;
        synchronized (array) {
            remoteListeners.remove((Object)remoteListener);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final SaveListener[] getSaveListeners() {
        Array array = saveListeners;
        synchronized (array) {
            return (SaveListener[])saveListeners.trim();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final void addSaveListener(SaveListener saveListener) {
        Array array = saveListeners;
        synchronized (array) {
            saveListeners.add((Object)saveListener);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final void removeSaveListener(SaveListener saveListener) {
        Array array = saveListeners;
        synchronized (array) {
            saveListeners.remove((Object)saveListener);
            return;
        }
    }

    public static final void usage() {
        Station.println("");
        Station.println("usage:");
        Station.println("  station [nreOptions] <project> [stationOptions]");
        Station.println("parameters:");
        Station.println("  project       station database containing 'config.xxx'");
        Station.println("nreOptions:");
        Station.println("  -locale:<x>   set the default locale (en_US)");
        Station.println("stationOptions:");
        Station.println("  -bootFile:<x> use the specified file in project dir to boot station");
    }

    static final void println(String string) {
        System.out.println(string);
    }

    public static final void main(String[] stringArray) throws Exception {
        CharSequence charSequence;
        if (stringArray.length < 1) {
            Station.usage();
            System.exit(-2);
        }
        if (!Nre.stationHome.exists() || !Nre.stationHome.isDirectory()) {
            log.error("FATAL: Station directory not found: " + Nre.stationHome);
            System.exit(-4);
        }
        final String string = Nre.args.parameters[1];
        File[] fileArray = Nre.stationHome.getParentFile().listFiles(new FilenameFilter(){

            public final boolean accept(File file, String string2) {
                return string2.equalsIgnoreCase(string);
            }
        });
        if (1 == fileArray.length && !fileArray[0].getName().equals(string)) {
            charSequence = new StringBuffer().append("\n###########################################################################\n").append("# Could not find an exact match for given station name: ").append(string).append("\n").append("# Using station '").append(fileArray[0].getName()).append("' since it is a case insensitive match.").append("\n###########################################################################\n");
            log.warning(((StringBuffer)charSequence).toString());
            Nre.stationHome = fileArray[0];
        }
        if ((charSequence = Nre.args.getOption("bootFile")) != null) {
            bootFile = new File(Nre.stationHome, (String)charSequence);
            Station.checkForWorkingFile(bootFile);
            if (!bootFile.exists()) {
                log.error("FATAL: Station database not found: " + bootFile);
                System.exit(-4);
            }
        } else {
            File file = new File(Nre.stationHome, "config.bog");
            Station.checkForWorkingFile(file);
            if (!file.exists()) {
                log.error("FATAL: Station database not found: " + file);
                System.exit(-4);
            }
            bootFile = file;
        }
        try {
            Station.bootStation(bootFile);
        }
        catch (FileLockException fileLockException) {
            log.error("FATAL: Station " + Nre.stationHome.getName() + " failed, could not obtain lock on station bootfile \"" + bootFile.getName() + "\":\n", fileLockException);
            System.exit(-1);
        }
        catch (Exception exception) {
            log.error("FATAL: Station " + Nre.stationHome.getName() + " failed to boot", exception);
            System.exit(-1);
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        lastSuccessfulSaveTime = BAbsTime.NULL;
        lastSuccessfulSaveTicks = Clock.ticks();
        lastSaveAttemptTicks = Clock.ticks();
        atSteadyState = true;
        saveLock = new Object();
        stationStarted = false;
        Class clazz = class$com$tridium$sys$station$Station$SaveListener;
        if (clazz == null) {
            clazz = class$com$tridium$sys$station$Station$SaveListener = Station.class("[Lcom.tridium.sys.station.Station$SaveListener;", false);
        }
        saveListeners = new Array(clazz);
        Class clazz2 = class$com$tridium$sys$station$Station$RemoteListener;
        if (clazz2 == null) {
            clazz2 = class$com$tridium$sys$station$Station$RemoteListener = Station.class("[Lcom.tridium.sys.station.Station$RemoteListener;", false);
        }
        remoteListeners = new Array(clazz2);
        stationFault = null;
        demoOnly = false;
        restoreLock = new Object();
        restoreComplete = false;
        saveAfterRestore = false;
    }

    public static class Message {
        public final String id;
        public final byte[] payload;

        public Message(String string, byte[] byArray) {
            if (byArray == null) {
                byArray = noPayload;
            }
            this.id = string;
            this.payload = byArray;
        }
    }

    public static interface SaveListener {
        public void stationSave() throws Exception;

        public void stationSaveOk() throws Exception;

        public void stationSaveFail(String var1) throws Exception;
    }

    static class StationEncoder
    extends ValueDocEncoder {
        BJob job;
        int total;
        int count;
        double totalProgress;

        protected void encodingComponent(BComponent bComponent) throws IOException {
            super.encodingComponent(bComponent);
            if (this.job == null) {
                return;
            }
            if (!this.job.isAlive() && this.job.isMounted()) {
                throw new JobCancelException();
            }
            ++this.count;
            if (this.count % 10 == 0) {
                this.job.heartbeat();
                this.job.progress((int)((double)this.count / (double)this.total * this.totalProgress));
            }
        }

        StationEncoder(File file, BJob bJob, int n) throws Exception {
            super(file, Context.encrypt);
            this.job = bJob;
            this.totalProgress = n;
            this.total = station.getComponentSpace().getComponentCount();
        }
    }

    public static interface RemoteListener {
        public void stationEvent(Message var1) throws Exception;
    }
}

