/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.spy;

import com.tridium.sys.Nre;
import javax.baja.spy.Spy;
import javax.baja.spy.SpyDir;
import javax.baja.spy.SpyWriter;

public class UtilSpy
extends SpyDir {
    public void write(SpyWriter spyWriter) throws Exception {
        super.write(spyWriter);
        spyWriter.println("<hr>");
    }

    public UtilSpy() {
        this.add("gc", new GC());
        this.add("forceThreadDump", new ForceThreadDump());
    }

    static class GC
    extends Spy {
        public void write(SpyWriter spyWriter) throws Exception {
            long l = Runtime.getRuntime().totalMemory() / 1024L;
            long l2 = Runtime.getRuntime().freeMemory() / 1024L;
            System.gc();
            long l3 = Runtime.getRuntime().totalMemory() / 1024L;
            long l4 = Runtime.getRuntime().freeMemory() / 1024L;
            spyWriter.startProps("Force Garbage Collection");
            spyWriter.trTitle("Before GC", 2);
            spyWriter.prop((Object)"totalMemory", l + "kb");
            spyWriter.prop((Object)"freeMemory", l2 + "kb");
            spyWriter.prop((Object)"usedMemory", l - l2 + "kb");
            spyWriter.trTitle("After GC", 2);
            spyWriter.prop((Object)"totalMemory", l3 + "kb");
            spyWriter.prop((Object)"freeMemory", l4 + "kb");
            spyWriter.prop((Object)"usedMemory", l3 - l4 + "kb");
            spyWriter.trTitle("Freed", 2);
            spyWriter.prop((Object)"freed", l - l2 - (l3 - l4) + "kb");
            spyWriter.endProps();
        }

        GC() {
        }
    }

    static class ForceThreadDump
    extends Spy {
        public void write(SpyWriter spyWriter) throws Exception {
            Nre.dumpThreads();
            spyWriter.println("The thread dump has been performed.  Access to the dump");
            spyWriter.println("cannot be provided via the spy utility since it is done");
            spyWriter.println("by native code.  Try using the Platform Manager.");
        }

        ForceThreadDump() {
        }
    }
}

