/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.spy;

import com.tridium.sys.Nre;
import java.io.IOException;
import java.util.Locale;
import java.util.TimeZone;
import javax.baja.spy.Spy;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BStation;
import javax.baja.sys.Clock;
import javax.baja.sys.Sys;

public class SysInfoSpy
extends Spy {
    private static BAbsTime bootTime = Clock.time();
    private static long bootTicks = Clock.ticks();

    public void write(SpyWriter spyWriter) throws IOException {
        long l = Runtime.getRuntime().totalMemory() / 1024L;
        long l2 = Runtime.getRuntime().freeMemory() / 1024L;
        String string = Sys.getLocalHost().toString();
        spyWriter.startProps("System Overview");
        spyWriter.prop((Object)"hostname", string);
        spyWriter.prop((Object)"hostModel", Nre.getHostModel());
        spyWriter.prop((Object)"baja.bajaVersion", Sys.getBajaModule().getBajaVersion());
        spyWriter.prop((Object)"baja.vendor", Sys.getBajaModule().getVendor());
        spyWriter.prop((Object)"baja.vendorVersion", Sys.getBajaModule().getVendorVersion());
        spyWriter.prop((Object)"commandLine", Nre.commandLine);
        spyWriter.prop((Object)"baja.home", Sys.getBajaHome());
        spyWriter.prop((Object)"user.home", Sys.getUserHome());
        if (Sys.getStation() != null) {
            BStation bStation = Sys.getStation();
            spyWriter.trTitle("Station", 2);
            spyWriter.prop((Object)"station.name", bStation.getStationName());
            spyWriter.prop((Object)"station.home", Sys.getStationHome());
            spyWriter.prop((Object)"atSteadyState", Sys.atSteadyState());
            spyWriter.prop((Object)"componentCount", "" + bStation.getComponentSpace().getComponentCount());
            BFacets bFacets = bStation.getSysInfo();
            String[] stringArray = bFacets.list();
            if (stringArray.length > 0) {
                spyWriter.trTitle("Station - sysInfo", 2);
                int n = 0;
                while (n < stringArray.length) {
                    spyWriter.prop((Object)stringArray[n], bFacets.get(stringArray[n]));
                    ++n;
                }
            }
        }
        spyWriter.trTitle("Time", 2);
        spyWriter.prop((Object)"currentTime", Clock.time());
        spyWriter.prop((Object)"currentTicks", "" + Clock.ticks());
        spyWriter.prop((Object)"bootTime", bootTime);
        spyWriter.prop((Object)"bootTicks", "" + bootTicks);
        spyWriter.prop((Object)"upTime", BRelTime.toString(Clock.ticks() - bootTicks));
        spyWriter.trTitle("Performance", 2);
        spyWriter.prop((Object)"totalMemory", l + "kb");
        spyWriter.prop((Object)"freeMemory", l2 + "kb");
        spyWriter.prop((Object)"usedMemory", l - l2 + "kb");
        spyWriter.trTitle("Platform", 2);
        spyWriter.prop((Object)"java.version", System.getProperty("java.version"));
        spyWriter.prop((Object)"java.vendor", System.getProperty("java.vendor"));
        spyWriter.prop((Object)"java.vm.name", System.getProperty("java.vm.name"));
        spyWriter.prop((Object)"java.vm.version", System.getProperty("java.vm.version"));
        spyWriter.prop((Object)"classpath", System.getProperty("java.class.path"));
        spyWriter.prop((Object)"java.home", System.getProperty("java.home"));
        spyWriter.prop((Object)"os.name", System.getProperty("os.name"));
        spyWriter.prop((Object)"os.version", System.getProperty("os.version"));
        spyWriter.prop((Object)"os.arch", System.getProperty("os.arch"));
        spyWriter.prop((Object)"baja.home", System.getProperty("baja.home"));
        spyWriter.prop((Object)"nre.hostid", Nre.getHostId());
        spyWriter.prop((Object)"nre.vmUuid", Nre.vmUuid);
        spyWriter.prop((Object)"language", Sys.getLanguage());
        spyWriter.prop((Object)"locale", Locale.getDefault());
        spyWriter.prop((Object)"timezone", TimeZone.getDefault().getID());
        spyWriter.endProps();
    }
}

