/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.service;

import com.tridium.dataRecovery.BDataRecoveryComponentRecorder;
import com.tridium.sys.Nre;
import com.tridium.sys.service.BServiceEvent;
import com.tridium.sys.service.ServiceListener;
import com.tridium.sys.station.Station;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import javax.baja.agent.AgentFilter;
import javax.baja.dataRecovery.BIDataRecoveryService;
import javax.baja.dataRecovery.BIDataRecoverySourceService;
import javax.baja.job.BIJobService;
import javax.baja.job.BJob;
import javax.baja.log.Log;
import javax.baja.nre.util.Array;
import javax.baja.space.BComponentSpace;
import javax.baja.spy.Spy;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIService;
import javax.baja.sys.BObject;
import javax.baja.sys.Clock;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ServiceManager {
    public static int jobMaxCountPerType = 3;
    public static long jobMinAgeToKeep = 600000L;
    static final Log log = Log.getLog("sys.service");
    private Hashtable byKey;
    private Hashtable byComp;
    private boolean servicesRunning;
    private BComponentSpace dataRecoverySpace;
    private BIDataRecoveryService dataRecoveryService;
    private BDataRecoveryComponentRecorder dataRecoveryRecorder;
    private boolean dataRecoveryRunning;
    private boolean dataRecoverySourcesInitialized;
    private ArrayList listeners;
    static /* synthetic */ Class class$javax$baja$job$BJob;

    public synchronized BComponent[] getAllServices() {
        return this.byComp.values().toArray(new BComponent[this.byComp.size()]);
    }

    public synchronized BComponent getService(String string) throws ServiceNotFoundException {
        BComponent[] bComponentArray = (BComponent[])this.byKey.get(string);
        if (bComponentArray == null) {
            throw new ServiceNotFoundException(string);
        }
        return bComponentArray[0];
    }

    public synchronized BComponent[] getServices(String string) throws ServiceNotFoundException {
        BComponent[] bComponentArray = (BComponent[])this.byKey.get(string);
        if (bComponentArray == null) {
            throw new ServiceNotFoundException(string);
        }
        BComponent[] bComponentArray2 = new BComponent[bComponentArray.length];
        System.arraycopy(bComponentArray, 0, bComponentArray2, 0, bComponentArray.length);
        return bComponentArray2;
    }

    public synchronized void clearAllServices() {
        this.byKey.clear();
        this.byComp.clear();
        this.servicesRunning = false;
    }

    public synchronized void register(BComponent bComponent) {
        if (bComponent.getComponentSpace() != Station.space) {
            return;
        }
        Type[] typeArray = ((BIService)((Object)bComponent)).getServiceTypes();
        if (typeArray == null) {
            return;
        }
        int n = 0;
        while (n < typeArray.length) {
            Type type = typeArray[n];
            String string = type.toString();
            if (!type.getTypeClass().isInstance(bComponent)) {
                log.error("Component " + bComponent.getType() + " not instanceof " + string);
            } else {
                log.trace("Register: " + bComponent + " {" + string + '}');
                BComponent[] bComponentArray = (BComponent[])this.byKey.get(string);
                if (bComponentArray == null) {
                    bComponentArray = new BComponent[]{bComponent};
                } else {
                    BComponent[] bComponentArray2 = new BComponent[bComponentArray.length + 1];
                    System.arraycopy(bComponentArray, 0, bComponentArray2, 0, bComponentArray.length);
                    bComponentArray2[bComponentArray.length] = bComponent;
                    bComponentArray = bComponentArray2;
                }
                this.byKey.put(string, bComponentArray);
                this.byComp.put(bComponent, bComponent);
            }
            ++n;
        }
        if (this.dataRecoverySourcesInitialized && bComponent instanceof BIDataRecoverySourceService) {
            try {
                BIDataRecoveryService bIDataRecoveryService = (BIDataRecoveryService)((Object)this.getService("baja:IDataRecoveryService"));
                if (bIDataRecoveryService != null && bIDataRecoveryService.isEnabled()) {
                    ((BIDataRecoverySourceService)((Object)bComponent)).initDataRecoverySource(bIDataRecoveryService);
                }
            }
            catch (ServiceNotFoundException serviceNotFoundException) {
            }
            catch (Throwable throwable) {
                log.error("Error during initialization of data recovery source for service " + bComponent, throwable);
            }
        }
        if (this.servicesRunning) {
            this.startService(bComponent);
        }
    }

    public synchronized void unregister(BComponent bComponent) {
        Type[] typeArray;
        if (this.servicesRunning) {
            this.stopService(bComponent);
        }
        if ((typeArray = ((BIService)((Object)bComponent)).getServiceTypes()) == null) {
            return;
        }
        int n = 0;
        while (n < typeArray.length) {
            String string = typeArray[n].toString();
            log.trace("Unregister: " + bComponent + " {" + string + '}');
            this.byComp.remove(bComponent);
            BComponent[] bComponentArray = (BComponent[])this.byKey.get(string);
            if (bComponentArray == null) {
                return;
            }
            int n2 = bComponentArray.length;
            if (n2 == 1 && bComponent == bComponentArray[0]) {
                this.byKey.remove(string);
            } else {
                int n3 = 0;
                while (n3 < n2) {
                    if (bComponent == bComponentArray[n3]) {
                        BComponent[] bComponentArray2 = new BComponent[n2 - 1];
                        System.arraycopy(bComponentArray, 0, bComponentArray2, 0, n3);
                        System.arraycopy(bComponentArray, n3 + 1, bComponentArray2, n3, n2 - n3 - 1);
                        this.byKey.put(string, bComponentArray2);
                        break;
                    }
                    ++n3;
                }
            }
            ++n;
        }
    }

    public synchronized void startAllServices() {
        this.servicesRunning = true;
        if (!this.dataRecoveryRunning) {
            this.startDataRecoveryService();
        }
        BComponent[] bComponentArray = this.getAllServices();
        int n = 0;
        while (n < bComponentArray.length) {
            if (bComponentArray[n] != this.dataRecoveryService) {
                this.startService(bComponentArray[n]);
            }
            ++n;
        }
    }

    public synchronized void stopAllServices() {
        this.servicesRunning = false;
        BComponent[] bComponentArray = this.getAllServices();
        int n = 0;
        while (n < bComponentArray.length) {
            if (bComponentArray[n] != this.dataRecoveryService) {
                this.stopService(bComponentArray[n]);
            }
            ++n;
        }
        this.stopDataRecoveryService();
    }

    public synchronized BIDataRecoveryService startDataRecoveryService() {
        this.dataRecoveryRunning = true;
        try {
            BComponent bComponent = this.getService("baja:IDataRecoveryService");
            if (!((BIDataRecoveryService)((Object)bComponent)).isEnabled()) {
                this.dataRecoveryService = null;
                return this.dataRecoveryService;
            }
            this.startService(bComponent);
            this.dataRecoveryService = (BIDataRecoveryService)((Object)bComponent);
            return this.dataRecoveryService;
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            return null;
        }
    }

    public synchronized void stopDataRecoveryService() {
        this.dataRecoveryRunning = false;
        if (this.dataRecoveryService != null) {
            this.stopService((BComponent)((Object)this.dataRecoveryService));
            this.dataRecoveryService = null;
            this.dataRecoverySpace = null;
            this.dataRecoveryRecorder = null;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void startService(BComponent bComponent) {
        String string = "???";
        try {
            try {
                string = bComponent.toString();
                log.trace("Start Service: " + string);
                bComponent.fw(15, null, null, null, null);
                ((BIService)((Object)bComponent)).serviceStarted();
                if (this.servicesRunning && bComponent instanceof BIDataRecoveryService && this.dataRecoveryService == null && ((BIDataRecoveryService)((Object)bComponent)).isEnabled()) {
                    this.initDataRecoveryComponentRecorder((BIDataRecoveryService)((Object)bComponent));
                }
            }
            catch (Throwable throwable) {
                log.error("Service start failed: " + string, throwable);
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            try {
                if (!this.servicesRunning) throw throwable;
                this.fireServiceEvent(new BServiceEvent(0, (BIService)((Object)bComponent)));
                throw throwable;
            }
            catch (Throwable throwable2) {
                log.error("Could not notify ServiceListeners of serviceAdded event for service " + bComponent, throwable2);
            }
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        try {}
        catch (Throwable throwable) {
            log.error("Could not notify ServiceListeners of serviceAdded event for service " + bComponent, throwable);
            return;
        }
        if (!this.servicesRunning) return;
        this.fireServiceEvent(new BServiceEvent(0, (BIService)((Object)bComponent)));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stopService(BComponent bComponent) {
        String string = "???";
        try {
            try {
                string = bComponent.toString();
                log.trace("Stop Service: " + string);
                bComponent.fw(16, null, null, null, null);
                ((BIService)((Object)bComponent)).serviceStopped();
                if (bComponent == this.dataRecoveryService) {
                    this.dataRecoveryService = null;
                    this.dataRecoverySpace = null;
                    this.dataRecoveryRecorder = null;
                }
            }
            catch (Throwable throwable) {
                log.error("Service stop failed: " + string, throwable);
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            try {
                if (!this.servicesRunning) throw throwable;
                this.fireServiceEvent(new BServiceEvent(1, (BIService)((Object)bComponent)));
                throw throwable;
            }
            catch (Throwable throwable2) {
                log.error("Could not notify ServiceListeners of serviceRemoved event for service " + bComponent, throwable2);
            }
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        try {}
        catch (Throwable throwable) {
            log.error("Could not notify ServiceListeners of serviceRemoved event for service " + bComponent, throwable);
            return;
        }
        if (!this.servicesRunning) return;
        this.fireServiceEvent(new BServiceEvent(1, (BIService)((Object)bComponent)));
    }

    public void initDataRecoverySourceServices(BIDataRecoveryService bIDataRecoveryService) {
        this.dataRecoverySourcesInitialized = true;
        try {
            BComponent[] bComponentArray = this.getAllServices();
            int n = 0;
            if (bComponentArray != null) {
                n = bComponentArray.length;
            }
            int n2 = n;
            int n3 = 0;
            while (n3 < n2) {
                try {
                    if (bComponentArray[n3] instanceof BIDataRecoverySourceService) {
                        ((BIDataRecoverySourceService)((Object)bComponentArray[n3])).initDataRecoverySource(bIDataRecoveryService);
                    }
                }
                catch (Throwable throwable) {
                    log.error("Error during initialization of data recovery source for service " + bComponentArray[n3], throwable);
                }
                ++n3;
            }
        }
        catch (ServiceNotFoundException serviceNotFoundException) {}
    }

    public static void houseKeeping(BIJobService bIJobService) {
        BJob bJob;
        BComponent bComponent = (BComponent)((Object)bIJobService);
        BJob[] bJobArray = bIJobService.getJobs();
        HashMap<String, Array> hashMap = new HashMap<String, Array>();
        int n = 0;
        while (n < bJobArray.length) {
            bJob = bJobArray[n];
            String string = bJob.getType().toString();
            Array array = (Array)hashMap.get(string);
            if (array == null) {
                Class clazz = class$javax$baja$job$BJob;
                if (clazz == null) {
                    clazz = ServiceManager.class("[Ljavax.baja.job.BJob;", false);
                }
                array = new Array(clazz);
                hashMap.put(string, array);
            }
            array.add((Object)bJob);
            ++n;
        }
        Iterator iterator = hashMap.values().iterator();
        while (iterator.hasNext()) {
            bJob = (Array)iterator.next();
            ServiceManager.cleanupJobs(bComponent, (Array)bJob);
        }
    }

    static void cleanupJobs(BComponent bComponent, Array array) {
        while (array.size() > jobMaxCountPerType) {
            BJob bJob = null;
            int n = 0;
            while (n < array.size()) {
                long l;
                BJob bJob2 = (BJob)array.get(n);
                BAbsTime bAbsTime = bJob2.getEndTime();
                if (bJob2.getJobState().isComplete() && !bAbsTime.isNull() && (l = Clock.millis() - bAbsTime.getMillis()) >= jobMinAgeToKeep && (bJob == null || bAbsTime.isBefore(bJob.getEndTime()))) {
                    bJob = bJob2;
                }
                ++n;
            }
            if (bJob == null) {
                return;
            }
            bComponent.remove(bJob);
            array.remove(bJob);
        }
    }

    private final void initDataRecoveryComponentRecorder(BIDataRecoveryService bIDataRecoveryService) {
        this.dataRecoveryService = bIDataRecoveryService;
        BDataRecoveryComponentRecorder bDataRecoveryComponentRecorder = (BDataRecoveryComponentRecorder)((BObject)((Object)bIDataRecoveryService)).getAgents().filter(AgentFilter.is(BDataRecoveryComponentRecorder.TYPE)).getDefault().getInstance();
        bDataRecoveryComponentRecorder.setDataRecoveryService(bIDataRecoveryService);
        this.addDataRecoveryComponentRecorder(bIDataRecoveryService, bDataRecoveryComponentRecorder);
    }

    public void addDataRecoveryComponentRecorder(BIDataRecoveryService bIDataRecoveryService, BDataRecoveryComponentRecorder bDataRecoveryComponentRecorder) {
        if (bIDataRecoveryService == this.dataRecoveryService) {
            this.dataRecoverySpace = ((BComponent)((Object)bIDataRecoveryService)).getComponentSpace();
            this.dataRecoveryRecorder = bDataRecoveryComponentRecorder;
        }
    }

    public BDataRecoveryComponentRecorder getDataRecoveryComponentRecorder(BComponentSpace bComponentSpace) {
        if (bComponentSpace == this.dataRecoverySpace) {
            return this.dataRecoveryRecorder;
        }
        return null;
    }

    public BIDataRecoveryService getActiveDataRecoveryService() {
        return this.dataRecoveryService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ServiceListener[] getServiceListeners() {
        ServiceListener[] serviceListenerArray = null;
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            return this.listeners.toArray(new ServiceListener[this.listeners.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addServiceListener(ServiceListener serviceListener) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            int n = 0;
            while (true) {
                if (n >= this.listeners.size()) {
                    this.listeners.add(serviceListener);
                    return;
                }
                if (this.listeners.get(n) == serviceListener) {
                    return;
                }
                ++n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeServiceListener(ServiceListener serviceListener) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            int n = 0;
            while (n < this.listeners.size()) {
                if (this.listeners.get(n) == serviceListener) {
                    this.listeners.remove(n);
                    break;
                }
                ++n;
            }
            return;
        }
    }

    public void fireServiceEvent(BServiceEvent bServiceEvent) {
        if (log.isTraceOn()) {
            log.trace("Firing service event " + bServiceEvent);
        }
        ServiceListener[] serviceListenerArray = this.getServiceListeners();
        int n = 0;
        while (n < serviceListenerArray.length) {
            try {
                serviceListenerArray[n].serviceEvent(bServiceEvent);
            }
            catch (Throwable throwable) {
                log.error("Error notifying ServiceListener '" + serviceListenerArray[n] + "' of service event " + bServiceEvent, throwable);
            }
            ++n;
        }
    }

    public void postInit() {
        Nre.spySysManagers.add("serviceManager", new Page());
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.byKey = new Hashtable();
        this.byComp = new Hashtable();
        this.dataRecoverySpace = null;
        this.dataRecoveryService = null;
        this.dataRecoveryRecorder = null;
        this.dataRecoverySourcesInitialized = false;
        this.listeners = new ArrayList();
    }

    public ServiceManager() {
        this.this();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class Page
    extends Spy {
        public void write(SpyWriter spyWriter) throws Exception {
            if (ServiceManager.this.byComp.size() == 0) {
                spyWriter.write("No services registered");
                return;
            }
            spyWriter.startTable(true);
            spyWriter.trTitle("Registered Services", 2);
            Enumeration enumeration = ServiceManager.this.byKey.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                BComponent[] bComponentArray = (BComponent[])ServiceManager.this.byKey.get(string);
                spyWriter.w("<tr>").th(string).td(bComponentArray[0].toPathString()).w("</tr>\n");
                int n = 1;
                while (n < bComponentArray.length) {
                    spyWriter.w("<tr>").td("&nbsp;").td(bComponentArray[n].toPathString()).w("</tr>\n");
                    ++n;
                }
            }
            spyWriter.endTable();
        }
    }
}

