/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.schema;

import com.tridium.dataRecovery.BDataRecoveryComponentEvent;
import com.tridium.dataRecovery.BDataRecoveryComponentRecorder;
import com.tridium.sys.Nre;
import com.tridium.sys.engine.EngineUtil;
import com.tridium.sys.engine.NKnob;
import com.tridium.sys.schema.ActionCursor;
import com.tridium.sys.schema.ComplexType;
import com.tridium.sys.schema.ComponentSlotMap;
import com.tridium.sys.schema.NAction;
import com.tridium.sys.schema.NProperty;
import com.tridium.sys.schema.NSlot;
import com.tridium.sys.schema.NTopic;
import com.tridium.sys.schema.PropertyCursor;
import com.tridium.sys.schema.SlotsCursor;
import com.tridium.sys.schema.TopicCursor;
import com.tridium.sys.schema.UnhandledSlotException;
import com.tridium.sys.transfer.TransferListener;
import javax.baja.category.BCategoryMask;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nav.BINavNode;
import javax.baja.nav.BNavRoot;
import javax.baja.nav.NavEvent;
import javax.baja.security.AuditEvent;
import javax.baja.security.Auditor;
import javax.baja.security.BIProtected;
import javax.baja.security.BPassword;
import javax.baja.security.BPermissions;
import javax.baja.security.BPermissionsMap;
import javax.baja.security.PermissionException;
import javax.baja.space.BComponentSpace;
import javax.baja.space.TrapCallbacks;
import javax.baja.sync.Transaction;
import javax.baja.sys.Action;
import javax.baja.sys.AlreadyParentedException;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFloat;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLink;
import javax.baja.sys.BLong;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.CopyHints;
import javax.baja.sys.Flags;
import javax.baja.sys.NoSuchSlotException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Topic;
import javax.baja.user.BUser;

public abstract class ComplexSlotMap {
    ComplexSlotMap parent;
    NProperty propertyInParent;
    BComplex instance;

    public void init(ComplexType complexType, BComplex bComplex) {
        this.instance = bComplex;
        NSlot[] nSlotArray = complexType.slots;
        int n = 0;
        while (n < nSlotArray.length) {
            if (nSlotArray[n].isProperty()) {
                NProperty nProperty = (NProperty)nSlotArray[n];
                switch (nProperty.typeAccess) {
                    case 0: {
                        bComplex.setBoolean(nProperty, ((BBoolean)nProperty.value).getBoolean(), null);
                        break;
                    }
                    case 2: {
                        bComplex.setInt(nProperty, ((BInteger)nProperty.value).getInt(), null);
                        break;
                    }
                    case 3: {
                        bComplex.setLong(nProperty, ((BLong)nProperty.value).getLong(), null);
                        break;
                    }
                    case 4: {
                        bComplex.setFloat(nProperty, ((BFloat)nProperty.value).getFloat(), null);
                        break;
                    }
                    case 5: {
                        bComplex.setDouble(nProperty, ((BDouble)nProperty.value).getDouble(), null);
                        break;
                    }
                    case 6: {
                        bComplex.setString(nProperty, ((BString)nProperty.value).getString(), null);
                        break;
                    }
                    case 7: {
                        bComplex.set(nProperty, nProperty.value.newCopy(true), null);
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
            ++n;
        }
    }

    public final BComplex getInstance() {
        return this.instance;
    }

    public final ComplexType getType() {
        return (ComplexType)this.instance.getType();
    }

    public String getName() {
        if (this.propertyInParent == null) {
            return null;
        }
        return this.propertyInParent.getName();
    }

    public String getDisplayName(Context context) {
        if (this.propertyInParent == null) {
            return null;
        }
        return this.parent.instance.getDisplayName(this.propertyInParent, context);
    }

    public boolean equivalent(ComplexSlotMap complexSlotMap) {
        NSlot[] nSlotArray = this.getType().slots;
        int n = 0;
        while (n < nSlotArray.length) {
            NSlot nSlot = nSlotArray[n];
            if (this.getFlags(nSlot) != complexSlotMap.getFlags(nSlot)) {
                return false;
            }
            if (nSlot.isProperty()) {
                NProperty nProperty = (NProperty)nSlot;
                switch (nProperty.typeAccess) {
                    case 0: {
                        if (this.gb(n) == complexSlotMap.gb(n)) break;
                        return false;
                    }
                    case 2: {
                        if (this.gi(n) == complexSlotMap.gi(n)) break;
                        return false;
                    }
                    case 3: {
                        if (this.gj(n) == complexSlotMap.gj(n)) break;
                        return false;
                    }
                    case 4: {
                        if (BFloat.equals(this.gf(n), complexSlotMap.gf(n))) break;
                        return false;
                    }
                    case 5: {
                        if (BDouble.equals(this.gd(n), complexSlotMap.gd(n))) break;
                        return false;
                    }
                    case 6: {
                        if (this.gs(n).equals(complexSlotMap.gs(n))) break;
                        return false;
                    }
                    case 7: {
                        if (this.g(n).equivalent(complexSlotMap.g(n))) break;
                        return false;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
            ++n;
        }
        return true;
    }

    public static BValue newCopy(BValue bValue, CopyHints copyHints, int n) {
        if (bValue instanceof BComplex) {
            ComplexSlotMap complexSlotMap = (ComplexSlotMap)bValue.fw(1, null, null, null, null);
            return complexSlotMap.newCopy(copyHints, n);
        }
        if (copyHints.swizzleHandles && bValue instanceof BOrd) {
            return ComponentSlotMap.swizzle((BOrd)bValue, n);
        }
        return bValue.newCopy(copyHints);
    }

    public BComplex newCopy(CopyHints copyHints, int n) {
        try {
            BComplex bComplex = this.newBComplexInstance();
            Context context = Context.copying;
            boolean bl = copyHints.defaultOnClone;
            boolean bl2 = false;
            if (copyHints.cx != null && (copyHints.cx.getUser() != null || copyHints.cx.getFacets() != null && copyHints.cx.getFacets().gets("username", null) != null)) {
                bl2 = true;
            }
            boolean bl3 = bl2;
            NProperty[] nPropertyArray = this.getType().properties;
            int n2 = 0;
            while (n2 < nPropertyArray.length) {
                NProperty nProperty = nPropertyArray[n2];
                if (!(Flags.isDefaultOnClone(this.instance, nProperty) && bl || bl3 && nProperty.getType().equals(BPassword.TYPE))) {
                    switch (nProperty.typeAccess) {
                        case 0: {
                            bComplex.setBoolean(nProperty, this.gb(nProperty.index), context);
                            break;
                        }
                        case 2: {
                            bComplex.setInt(nProperty, this.gi(nProperty.index), context);
                            break;
                        }
                        case 3: {
                            bComplex.setLong(nProperty, this.gj(nProperty.index), context);
                            break;
                        }
                        case 4: {
                            bComplex.setFloat(nProperty, this.gf(nProperty.index), context);
                            break;
                        }
                        case 5: {
                            bComplex.setDouble(nProperty, this.gd(nProperty.index), context);
                            break;
                        }
                        case 6: {
                            bComplex.setString(nProperty, this.gs(nProperty.index), context);
                            break;
                        }
                        case 7: {
                            BValue bValue;
                            BValue bValue2 = this.g(nProperty.index);
                            if (bValue2.isComponent() && copyHints.cx != null) {
                                if (!((BComponent)bValue2).getPermissions(copyHints.cx).hasOperatorRead()) break;
                                bValue = ComplexSlotMap.newCopy(bValue2, copyHints, n);
                                bComplex.set(nProperty, bValue, context);
                                break;
                            }
                            bValue = ComplexSlotMap.newCopy(bValue2, copyHints, n);
                            bComplex.set(nProperty, bValue, context);
                            break;
                        }
                        default: {
                            throw new IllegalStateException();
                        }
                    }
                }
                ++n2;
            }
            return bComplex;
        }
        catch (NoSuchMethodError noSuchMethodError) {
            throw new UnsupportedOperationException("Default constructor not available for " + this);
        }
    }

    public void copyFrom(ComplexSlotMap complexSlotMap, Context context) {
        BComplex bComplex = this.instance;
        NProperty[] nPropertyArray = this.getType().properties;
        NProperty[] nPropertyArray2 = complexSlotMap.getType().properties;
        NProperty[] nPropertyArray3 = nPropertyArray;
        if (this.getClass() != complexSlotMap.getClass() && nPropertyArray2.length < nPropertyArray3.length) {
            nPropertyArray3 = nPropertyArray2;
        }
        int n = 0;
        while (n < nPropertyArray3.length) {
            NProperty nProperty = nPropertyArray[n];
            NProperty nProperty2 = nPropertyArray2[n];
            if (nProperty.declaringType != nProperty2.declaringType) {
                throw new IllegalStateException("Unlike declaring types for property " + nProperty.declaringType + " != " + nProperty2.declaringType);
            }
            switch (nProperty.typeAccess) {
                case 0: {
                    bComplex.setBoolean(nProperty, complexSlotMap.gb(nProperty2.index), context);
                    break;
                }
                case 2: {
                    bComplex.setInt(nProperty, complexSlotMap.gi(nProperty2.index), context);
                    break;
                }
                case 3: {
                    bComplex.setLong(nProperty, complexSlotMap.gj(nProperty2.index), context);
                    break;
                }
                case 4: {
                    bComplex.setFloat(nProperty, complexSlotMap.gf(nProperty2.index), context);
                    break;
                }
                case 5: {
                    bComplex.setDouble(nProperty, complexSlotMap.gd(nProperty2.index), context);
                    break;
                }
                case 6: {
                    bComplex.setString(nProperty, complexSlotMap.gs(nProperty2.index), context);
                    break;
                }
                case 7: {
                    BValue bValue = this.g(nProperty.index);
                    BValue bValue2 = complexSlotMap.g(nProperty2.index);
                    if (bValue.getClass() == bValue2.getClass() && !bValue.isSimple()) {
                        bValue.asComplex().copyFrom(bValue2.asComplex(), context);
                        break;
                    }
                    bComplex.set(nProperty, bValue2.newCopy(), context);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            ++n;
        }
    }

    public void loadSlots() {
    }

    public int getSlotCount() {
        return this.getType().slots.length;
    }

    public Slot getSlot(String string) {
        return (Slot)this.getType().byName.get(string);
    }

    public Slot[] getSlotsArray() {
        NSlot[] nSlotArray = this.getType().slots;
        Slot[] slotArray = new Slot[nSlotArray.length];
        System.arraycopy(nSlotArray, 0, slotArray, 0, slotArray.length);
        return slotArray;
    }

    public Property[] getPropertiesArray() {
        NProperty[] nPropertyArray = this.getType().properties;
        Property[] propertyArray = new Property[nPropertyArray.length];
        System.arraycopy(nPropertyArray, 0, propertyArray, 0, propertyArray.length);
        return propertyArray;
    }

    public Property[] getFrozenPropertiesArray() {
        return this.getPropertiesArray();
    }

    public Property[] getDynamicPropertiesArray() {
        return new Property[0];
    }

    public Action[] getActionsArray() {
        NAction[] nActionArray = this.getType().actions;
        Action[] actionArray = new Action[nActionArray.length];
        System.arraycopy(nActionArray, 0, actionArray, 0, actionArray.length);
        return actionArray;
    }

    public Topic[] getTopicsArray() {
        NTopic[] nTopicArray = this.getType().topics;
        Topic[] topicArray = new Topic[nTopicArray.length];
        System.arraycopy(nTopicArray, 0, topicArray, 0, topicArray.length);
        return topicArray;
    }

    public SlotCursor getSlots() {
        return new SlotsCursor(this.instance, this.getType().slots, null);
    }

    public SlotCursor getProperties() {
        return new PropertyCursor(this.instance, this.getType().properties, null);
    }

    public SlotCursor getActions() {
        return new ActionCursor(this.instance, this.getType().actions, null);
    }

    public SlotCursor getTopics() {
        return new TopicCursor(this.instance, this.getType().topics, null);
    }

    public final BValue get(String string) {
        Property property = (Property)this.getSlot(string);
        if (property == null) {
            return null;
        }
        return this.get(property);
    }

    public final BValue get(Property property) {
        try {
            NProperty nProperty = (NProperty)property;
            BValue bValue = this.getOverride(nProperty);
            if (bValue != null) {
                return bValue;
            }
            BValue bValue2 = nProperty.isFrozen ? this.g(nProperty.index) : nProperty.value;
            return bValue2;
        }
        catch (UnhandledSlotException unhandledSlotException) {
            throw new NoSuchSlotException(this.getType(), property);
        }
    }

    public final boolean getBoolean(Property property) {
        try {
            NProperty nProperty = (NProperty)property;
            BValue bValue = this.getOverride(nProperty);
            if (bValue != null) {
                return ((BBoolean)bValue).getBoolean();
            }
            if (nProperty.isFrozen) {
                return this.gb(nProperty.index);
            }
            return ((BBoolean)nProperty.value).getBoolean();
        }
        catch (UnhandledSlotException unhandledSlotException) {
            throw new NoSuchSlotException(this.getType(), property);
        }
    }

    public final int getInt(Property property) {
        try {
            NProperty nProperty = (NProperty)property;
            BValue bValue = this.getOverride(nProperty);
            if (bValue != null) {
                return ((BInteger)bValue).getInt();
            }
            if (nProperty.isFrozen) {
                return this.gi(nProperty.index);
            }
            return ((BInteger)nProperty.value).getInt();
        }
        catch (UnhandledSlotException unhandledSlotException) {
            throw new NoSuchSlotException(this.getType(), property);
        }
    }

    public final long getLong(Property property) {
        try {
            NProperty nProperty = (NProperty)property;
            BValue bValue = this.getOverride(nProperty);
            if (bValue != null) {
                return ((BLong)bValue).getLong();
            }
            if (nProperty.isFrozen) {
                return this.gj(nProperty.index);
            }
            return ((BLong)nProperty.value).getLong();
        }
        catch (UnhandledSlotException unhandledSlotException) {
            throw new NoSuchSlotException(this.getType(), property);
        }
    }

    public final float getFloat(Property property) {
        try {
            NProperty nProperty = (NProperty)property;
            BValue bValue = this.getOverride(nProperty);
            if (bValue != null) {
                return ((BFloat)bValue).getFloat();
            }
            if (nProperty.isFrozen) {
                return this.gf(nProperty.index);
            }
            return ((BFloat)nProperty.value).getFloat();
        }
        catch (UnhandledSlotException unhandledSlotException) {
            throw new NoSuchSlotException(this.getType(), property);
        }
    }

    public final double getDouble(Property property) {
        try {
            NProperty nProperty = (NProperty)property;
            BValue bValue = this.getOverride(nProperty);
            if (bValue != null) {
                return ((BDouble)bValue).getDouble();
            }
            if (nProperty.isFrozen) {
                return this.gd(nProperty.index);
            }
            return ((BDouble)nProperty.value).getDouble();
        }
        catch (UnhandledSlotException unhandledSlotException) {
            throw new NoSuchSlotException(this.getType(), property);
        }
    }

    public final String getString(Property property) {
        try {
            NProperty nProperty = (NProperty)property;
            BValue bValue = this.getOverride(nProperty);
            if (bValue != null) {
                return ((BString)bValue).toString();
            }
            if (nProperty.isFrozen) {
                return this.gs(nProperty.index);
            }
            return ((BString)nProperty.value).getString();
        }
        catch (UnhandledSlotException unhandledSlotException) {
            throw new NoSuchSlotException(this.getType(), property);
        }
    }

    BValue getOverride(Property property) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void set(Property property, BValue bValue, ComplexSlotMap complexSlotMap, BValue bValue2, ComplexSlotMap complexSlotMap2, Context context) {
        try {
            Object object;
            BValue bValue3;
            BComplex bComplex;
            String string;
            ComponentBase componentBase;
            BUser bUser;
            boolean bl;
            NProperty nProperty;
            block45: {
                BObject bObject;
                BObject bObject2;
                nProperty = (NProperty)property;
                bl = false;
                if (bValue == bValue2 || bValue != null && bValue.isSimple() && bValue.equals(bValue2)) {
                    if (!bValue2.isComponent()) return;
                    ComponentSlotMap componentSlotMap = (ComponentSlotMap)this;
                    ComponentSlotMap componentSlotMap2 = (ComponentSlotMap)complexSlotMap2;
                    if (componentSlotMap.getSpace() == componentSlotMap2.getSpace()) return;
                    componentSlotMap2.mount(componentSlotMap.getSpace(), context, null);
                    return;
                }
                if (context instanceof Transaction) {
                    this.setTransaction(nProperty, bValue2, (Transaction)context);
                    return;
                }
                TrapCallbacks trapCallbacks = this.getSpaceTrap();
                if (trapCallbacks != null && trapCallbacks.isTrapEnabled() && trapCallbacks.trapSets() && context != Context.commit && !this.setSpace(trapCallbacks, nProperty, bValue2, context)) {
                    return;
                }
                bUser = null;
                componentBase = null;
                string = null;
                boolean bl2 = this.instance instanceof BLink;
                if (context != null && context.getUser() != null) {
                    BComponent bComponent;
                    bUser = context.getUser();
                    componentBase = this.getComponentBase(nProperty, context);
                    if (componentBase != null) {
                        bUser.checkWrite(componentBase.component, componentBase.propertyPath[0]);
                        if (bValue instanceof BIProtected) {
                            bUser.check((BIProtected)((Object)bValue), Flags.isOperator(this.instance, nProperty) ? BPermissions.operatorWrite : BPermissions.adminWrite);
                        }
                        string = ComplexSlotMap.toAuditString(componentBase, bValue, context);
                    }
                    if (property.getType().is(BPermissionsMap.TYPE) && !bUser.getPermissions().isSuperUser()) {
                        bObject2 = (BPermissionsMap)bValue2;
                        bObject = (BPermissionsMap)bValue;
                        if (((BPermissionsMap)bObject2).isSuperUser() != ((BPermissionsMap)bObject).isSuperUser()) {
                            throw new PermissionException("SuperUser required");
                        }
                        int n = 1;
                        while (n <= ((BPermissionsMap)bObject2).size()) {
                            int n2 = ((BPermissionsMap)bObject).getPermissions(n).getMask() ^ ((BPermissionsMap)bObject2).getPermissions(n).getMask();
                            if ((~bUser.getPermissions().getPermissions(n).getMask() & n2) != 0) {
                                throw new PermissionException(bUser.getPermissions().getPermissions(n) + " < " + ((BPermissionsMap)bObject2).getPermissions(n));
                            }
                            ++n;
                        }
                    }
                    if (bl2 && (bObject = ((BComplex)(bObject2 = (BLink)this.instance)).getParent()) instanceof BComponent && (bComponent = (BComponent)bObject).isRunning()) {
                        if (property.equals(BLink.sourceOrd)) {
                            BComponent bComponent2 = (BComponent)((BOrd)bValue2).get(bComponent);
                            if (bComponent2 instanceof BUser) {
                                bUser.checkWrite(bComponent2, bComponent2.getSlot(((BLink)bObject2).getSourceSlotName()));
                            } else {
                                bUser.checkRead(bComponent2, bComponent2.getSlot(((BLink)bObject2).getSourceSlotName()));
                            }
                        } else if (property.equals(BLink.sourceSlotName)) {
                            BComponent bComponent3 = (BComponent)((BLink)bObject2).getSourceOrd().get(bComponent);
                            if (bComponent3 instanceof BUser) {
                                bUser.checkWrite(bComponent3, bComponent3.getSlot(bValue2.toString(null)));
                            } else {
                                bUser.checkRead(bComponent3, bComponent3.getSlot(bValue2.toString(null)));
                            }
                        } else if (property.equals(BLink.targetSlotName)) {
                            bUser.checkWrite(bComponent, bComponent.getSlot(bValue2.toString(null)));
                        }
                    }
                }
                bObject2 = this.findRecoveryData(0, nProperty, context);
                bObject = null;
                boolean bl3 = false;
                if (bObject2 != null) {
                    if (this.instance.isComponent()) {
                        bObject = BDataRecoveryComponentEvent.makeChangeEvent(this.instance.asComponent(), nProperty, bValue2);
                    } else {
                        bl3 = true;
                    }
                }
                BComplex bComplex2 = this.instance;
                synchronized (bComplex2) {
                    block44: {
                        try {
                            if (nProperty.isFrozen) {
                                this.s(nProperty.index, bValue2);
                            } else {
                                nProperty.value = bValue2;
                            }
                            if (!bValue2.isSimple()) {
                                this.parent(nProperty, complexSlotMap2, context, null, (BDataRecoveryComponentRecorder)bObject2, (BDataRecoveryComponentEvent)bObject);
                                if (bValue2.isComponent()) {
                                    bl = true;
                                }
                            } else if (bObject != null) {
                                ((BDataRecoveryComponentRecorder)bObject2).record((BDataRecoveryComponentEvent)bObject, context);
                            }
                            if (bValue == null || bValue.isSimple()) break block44;
                            this.unparent(nProperty, complexSlotMap, context);
                            if (bValue.isComponent()) {
                                bl = true;
                            }
                        }
                        catch (RuntimeException runtimeException) {
                            if (nProperty.isFrozen) {
                                this.s(nProperty.index, bValue);
                                throw runtimeException;
                            }
                            nProperty.value = bValue;
                            throw runtimeException;
                        }
                    }
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 3] lbl94 : MonitorExitStatement: MONITOREXIT : var17_25
                    if (bl3) {
                        this.modified(nProperty, context, (BDataRecoveryComponentRecorder)bObject2);
                    } else {
                        this.modified(nProperty, context, null);
                    }
                    if (!bl2) break block45;
                }
                bComplex = (BLink)this.instance;
                bValue3 = bComplex.getParent();
                if (bValue3 instanceof BComponent && ((BComponent)(object = (BComponent)bValue3)).isRunning()) {
                    EngineUtil.deactivate((BLink)bComplex);
                    EngineUtil.activate((BLink)bComplex);
                }
            }
            if (bl) {
                bComplex = this.instance.asComponent();
                bValue3 = ((BComponent)bComplex).getNavOrd();
                object = nProperty.getName();
                if (bValue3 != null) {
                    BNavRoot.INSTANCE.fireNavEvent(NavEvent.makeReplaced((BINavNode)((Object)bComplex), (String)object, null));
                }
            }
            if (string == null) return;
            this.audit(componentBase, bUser, "Changed", string, ComplexSlotMap.toAuditString(componentBase, bValue2, context));
            return;
        }
        catch (UnhandledSlotException unhandledSlotException) {
            throw new NoSuchSlotException(this.getType(), property);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void setBoolean(Property property, boolean bl, Context context) {
        try {
            NProperty nProperty = (NProperty)property;
            boolean bl2 = nProperty.isFrozen ? this.gb(nProperty.index) : this.getBoolean(nProperty);
            if (bl2 == bl) {
                return;
            }
            if (context instanceof Transaction) {
                this.setTransaction(nProperty, BBoolean.make(bl), (Transaction)context);
                return;
            }
            TrapCallbacks trapCallbacks = this.getSpaceTrap();
            if (trapCallbacks != null && trapCallbacks.isTrapEnabled() && trapCallbacks.trapSets() && context != Context.commit && !this.setSpace(trapCallbacks, nProperty, BBoolean.make(bl), context)) {
                return;
            }
            BUser bUser = null;
            ComponentBase componentBase = null;
            String string = null;
            if (context != null && context.getUser() != null) {
                bUser = context.getUser();
                componentBase = this.getComponentBase(nProperty, context);
                if (componentBase != null) {
                    bUser.checkWrite(componentBase.component, componentBase.propertyPath[0]);
                    string = ComplexSlotMap.toAuditString(componentBase, BBoolean.make(bl2), context);
                }
            }
            BDataRecoveryComponentRecorder bDataRecoveryComponentRecorder = this.findRecoveryData(0, nProperty, context);
            boolean bl3 = false;
            if (bDataRecoveryComponentRecorder != null) {
                if (this.instance.isComponent()) {
                    bDataRecoveryComponentRecorder.record(BDataRecoveryComponentEvent.makeChangeEvent(this.instance.asComponent(), nProperty, BBoolean.make(bl)), context);
                } else {
                    bl3 = true;
                }
            }
            BComplex bComplex = this.instance;
            synchronized (bComplex) {
                if (nProperty.isFrozen) {
                    this.sb(nProperty.index, bl);
                } else {
                    nProperty.value = BBoolean.make(bl);
                }
                // MONITOREXIT @DISABLED, blocks:[0, 1, 2] lbl35 : MonitorExitStatement: MONITOREXIT : var12_13
                if (bl3) {
                    this.modified(nProperty, context, bDataRecoveryComponentRecorder);
                } else {
                    this.modified(nProperty, context, null);
                }
                if (string == null) return;
                this.audit(componentBase, bUser, "Changed", string, ComplexSlotMap.toAuditString(componentBase, BBoolean.make(bl), context));
                return;
            }
        }
        catch (UnhandledSlotException unhandledSlotException) {
            throw new NoSuchSlotException(this.getType(), property);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void setInt(Property property, int n, Context context) {
        try {
            NProperty nProperty = (NProperty)property;
            int n2 = nProperty.isFrozen ? this.gi(nProperty.index) : this.getInt(nProperty);
            if (n2 == n) {
                return;
            }
            if (context instanceof Transaction) {
                this.setTransaction(nProperty, BInteger.make(n), (Transaction)context);
                return;
            }
            TrapCallbacks trapCallbacks = this.getSpaceTrap();
            if (trapCallbacks != null && trapCallbacks.isTrapEnabled() && trapCallbacks.trapSets() && context != Context.commit && !this.setSpace(trapCallbacks, nProperty, BInteger.make(n), context)) {
                return;
            }
            BUser bUser = null;
            ComponentBase componentBase = null;
            String string = null;
            if (context != null && context.getUser() != null) {
                bUser = context.getUser();
                componentBase = this.getComponentBase(nProperty, context);
                if (componentBase != null) {
                    bUser.checkWrite(componentBase.component, componentBase.propertyPath[0]);
                    string = ComplexSlotMap.toAuditString(componentBase, BInteger.make(n2), context);
                }
            }
            BDataRecoveryComponentRecorder bDataRecoveryComponentRecorder = this.findRecoveryData(0, nProperty, context);
            boolean bl = false;
            if (bDataRecoveryComponentRecorder != null) {
                if (this.instance.isComponent()) {
                    bDataRecoveryComponentRecorder.record(BDataRecoveryComponentEvent.makeChangeEvent(this.instance.asComponent(), nProperty, BInteger.make(n)), context);
                } else {
                    bl = true;
                }
            }
            BComplex bComplex = this.instance;
            synchronized (bComplex) {
                if (nProperty.isFrozen) {
                    this.si(nProperty.index, n);
                } else {
                    nProperty.value = BInteger.make(n);
                }
                // MONITOREXIT @DISABLED, blocks:[0, 1, 2] lbl35 : MonitorExitStatement: MONITOREXIT : var12_13
                if (bl) {
                    this.modified(nProperty, context, bDataRecoveryComponentRecorder);
                } else {
                    this.modified(nProperty, context, null);
                }
                if (string == null) return;
                this.audit(componentBase, bUser, "Changed", string, ComplexSlotMap.toAuditString(componentBase, BInteger.make(n), context));
                return;
            }
        }
        catch (UnhandledSlotException unhandledSlotException) {
            throw new NoSuchSlotException(this.getType(), property);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void setLong(Property property, long l, Context context) {
        try {
            NProperty nProperty = (NProperty)property;
            long l2 = nProperty.isFrozen ? this.gj(nProperty.index) : this.getLong(nProperty);
            if (l2 == l) {
                return;
            }
            if (context instanceof Transaction) {
                this.setTransaction(nProperty, BLong.make(l), (Transaction)context);
                return;
            }
            TrapCallbacks trapCallbacks = this.getSpaceTrap();
            if (trapCallbacks != null && trapCallbacks.isTrapEnabled() && trapCallbacks.trapSets() && context != Context.commit && !this.setSpace(trapCallbacks, nProperty, BLong.make(l), context)) {
                return;
            }
            BUser bUser = null;
            ComponentBase componentBase = null;
            String string = null;
            if (context != null && context.getUser() != null) {
                bUser = context.getUser();
                componentBase = this.getComponentBase(nProperty, context);
                if (componentBase != null) {
                    bUser.checkWrite(componentBase.component, componentBase.propertyPath[0]);
                    string = ComplexSlotMap.toAuditString(componentBase, BLong.make(l2), context);
                }
            }
            BDataRecoveryComponentRecorder bDataRecoveryComponentRecorder = this.findRecoveryData(0, nProperty, context);
            boolean bl = false;
            if (bDataRecoveryComponentRecorder != null) {
                if (this.instance.isComponent()) {
                    bDataRecoveryComponentRecorder.record(BDataRecoveryComponentEvent.makeChangeEvent(this.instance.asComponent(), nProperty, BLong.make(l)), context);
                } else {
                    bl = true;
                }
            }
            BComplex bComplex = this.instance;
            synchronized (bComplex) {
                if (nProperty.isFrozen) {
                    this.sj(nProperty.index, l);
                } else {
                    nProperty.value = BLong.make(l);
                }
                // MONITOREXIT @DISABLED, blocks:[0, 1, 2] lbl35 : MonitorExitStatement: MONITOREXIT : var14_13
                if (bl) {
                    this.modified(nProperty, context, bDataRecoveryComponentRecorder);
                } else {
                    this.modified(nProperty, context, null);
                }
                if (string == null) return;
                this.audit(componentBase, bUser, "Changed", string, ComplexSlotMap.toAuditString(componentBase, BLong.make(l), context));
                return;
            }
        }
        catch (UnhandledSlotException unhandledSlotException) {
            throw new NoSuchSlotException(this.getType(), property);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void setFloat(Property property, float f, Context context) {
        try {
            NProperty nProperty = (NProperty)property;
            float f2 = nProperty.isFrozen ? this.gf(nProperty.index) : this.getFloat(nProperty);
            if (BFloat.equals(f2, f)) {
                return;
            }
            if (context instanceof Transaction) {
                this.setTransaction(nProperty, BFloat.make(f), (Transaction)context);
                return;
            }
            TrapCallbacks trapCallbacks = this.getSpaceTrap();
            if (trapCallbacks != null && trapCallbacks.isTrapEnabled() && trapCallbacks.trapSets() && context != Context.commit && !this.setSpace(trapCallbacks, nProperty, BFloat.make(f), context)) {
                return;
            }
            BUser bUser = null;
            ComponentBase componentBase = null;
            String string = null;
            if (context != null && context.getUser() != null) {
                bUser = context.getUser();
                componentBase = this.getComponentBase(nProperty, context);
                if (componentBase != null) {
                    bUser.checkWrite(componentBase.component, componentBase.propertyPath[0]);
                    string = ComplexSlotMap.toAuditString(componentBase, BFloat.make(f2), context);
                }
            }
            BDataRecoveryComponentRecorder bDataRecoveryComponentRecorder = this.findRecoveryData(0, nProperty, context);
            boolean bl = false;
            if (bDataRecoveryComponentRecorder != null) {
                if (this.instance.isComponent()) {
                    bDataRecoveryComponentRecorder.record(BDataRecoveryComponentEvent.makeChangeEvent(this.instance.asComponent(), nProperty, BFloat.make(f)), context);
                } else {
                    bl = true;
                }
            }
            BComplex bComplex = this.instance;
            synchronized (bComplex) {
                if (nProperty.isFrozen) {
                    this.sf(nProperty.index, f);
                } else {
                    nProperty.value = BFloat.make(f);
                }
                // MONITOREXIT @DISABLED, blocks:[0, 1, 2] lbl35 : MonitorExitStatement: MONITOREXIT : var12_13
                if (bl) {
                    this.modified(nProperty, context, bDataRecoveryComponentRecorder);
                } else {
                    this.modified(nProperty, context, null);
                }
                if (string == null) return;
                this.audit(componentBase, bUser, "Changed", string, ComplexSlotMap.toAuditString(componentBase, BFloat.make(f), context));
                return;
            }
        }
        catch (UnhandledSlotException unhandledSlotException) {
            throw new NoSuchSlotException(this.getType(), property);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void setDouble(Property property, double d, Context context) {
        try {
            NProperty nProperty = (NProperty)property;
            double d2 = nProperty.isFrozen ? this.gd(nProperty.index) : this.getDouble(nProperty);
            if (BDouble.equals(d2, d)) {
                return;
            }
            if (context instanceof Transaction) {
                this.setTransaction(nProperty, BDouble.make(d), (Transaction)context);
                return;
            }
            TrapCallbacks trapCallbacks = this.getSpaceTrap();
            if (trapCallbacks != null && trapCallbacks.isTrapEnabled() && trapCallbacks.trapSets() && context != Context.commit && !this.setSpace(trapCallbacks, nProperty, BDouble.make(d), context)) {
                return;
            }
            BUser bUser = null;
            ComponentBase componentBase = null;
            String string = null;
            if (context != null && context.getUser() != null) {
                bUser = context.getUser();
                componentBase = this.getComponentBase(nProperty, context);
                if (componentBase != null) {
                    bUser.checkWrite(componentBase.component, componentBase.propertyPath[0]);
                    string = ComplexSlotMap.toAuditString(componentBase, BDouble.make(d2), context);
                }
            }
            BDataRecoveryComponentRecorder bDataRecoveryComponentRecorder = this.findRecoveryData(0, nProperty, context);
            boolean bl = false;
            if (bDataRecoveryComponentRecorder != null) {
                if (this.instance.isComponent()) {
                    bDataRecoveryComponentRecorder.record(BDataRecoveryComponentEvent.makeChangeEvent(this.instance.asComponent(), nProperty, BDouble.make(d)), context);
                } else {
                    bl = true;
                }
            }
            BComplex bComplex = this.instance;
            synchronized (bComplex) {
                if (nProperty.isFrozen) {
                    this.sd(nProperty.index, d);
                } else {
                    nProperty.value = BDouble.make(d);
                }
                // MONITOREXIT @DISABLED, blocks:[0, 1, 2] lbl35 : MonitorExitStatement: MONITOREXIT : var14_13
                if (bl) {
                    this.modified(nProperty, context, bDataRecoveryComponentRecorder);
                } else {
                    this.modified(nProperty, context, null);
                }
                if (string == null) return;
                this.audit(componentBase, bUser, "Changed", string, ComplexSlotMap.toAuditString(componentBase, BDouble.make(d), context));
                return;
            }
        }
        catch (UnhandledSlotException unhandledSlotException) {
            throw new NoSuchSlotException(this.getType(), property);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void setString(Property property, String string, Context context) {
        try {
            NProperty nProperty = (NProperty)property;
            String string2 = nProperty.isFrozen ? this.gs(nProperty.index) : this.getString(nProperty);
            if (string.equals(string2)) {
                return;
            }
            if (context instanceof Transaction) {
                this.setTransaction(nProperty, BString.make(string), (Transaction)context);
                return;
            }
            TrapCallbacks trapCallbacks = this.getSpaceTrap();
            if (trapCallbacks != null && trapCallbacks.isTrapEnabled() && trapCallbacks.trapSets() && context != Context.commit && !this.setSpace(trapCallbacks, nProperty, BString.make(string), context)) {
                return;
            }
            BUser bUser = null;
            ComponentBase componentBase = null;
            String string3 = null;
            if (context != null && context.getUser() != null) {
                bUser = context.getUser();
                componentBase = this.getComponentBase(nProperty, context);
                if (componentBase != null) {
                    bUser.checkWrite(componentBase.component, componentBase.propertyPath[0]);
                    string3 = string2;
                }
            }
            BDataRecoveryComponentRecorder bDataRecoveryComponentRecorder = this.findRecoveryData(0, nProperty, context);
            boolean bl = false;
            if (bDataRecoveryComponentRecorder != null) {
                if (this.instance.isComponent()) {
                    bDataRecoveryComponentRecorder.record(BDataRecoveryComponentEvent.makeChangeEvent(this.instance.asComponent(), nProperty, BString.make(string)), context);
                } else {
                    bl = true;
                }
            }
            BComplex bComplex = this.instance;
            synchronized (bComplex) {
                if (nProperty.isFrozen) {
                    this.ss(nProperty.index, string);
                } else {
                    nProperty.value = BString.make(string);
                }
                // MONITOREXIT @DISABLED, blocks:[0, 1, 2] lbl35 : MonitorExitStatement: MONITOREXIT : var12_13
                if (bl) {
                    this.modified(nProperty, context, bDataRecoveryComponentRecorder);
                } else {
                    this.modified(nProperty, context, null);
                }
                if (string3 == null) return;
                this.audit(componentBase, bUser, "Changed", string3, string);
                return;
            }
        }
        catch (UnhandledSlotException unhandledSlotException) {
            throw new NoSuchSlotException(this.getType(), property);
        }
    }

    final void setTransaction(NProperty nProperty, BValue bValue, Transaction transaction) {
        ComponentBase componentBase = this.getComponentBase(nProperty, transaction);
        if (componentBase == null) {
            throw new IllegalStateException("Cannot call set() on unmounted struct using transaction: " + this.instance.toDebugString());
        }
        transaction.set(componentBase.component, componentBase.propertyPath, bValue, null);
    }

    final boolean setSpace(TrapCallbacks trapCallbacks, NProperty nProperty, BValue bValue, Context context) {
        ComponentBase componentBase = this.getComponentBase(nProperty, context);
        return trapCallbacks.set(componentBase.component, componentBase.propertyPath, bValue, context);
    }

    public static ComponentBase getComponentBase(BComplex bComplex, Property property) {
        return ComplexSlotMap.getSlotMap(bComplex).getComponentBase(property);
    }

    final ComponentBase getComponentBase(Property property) {
        Property[] propertyArray = new Property[32];
        int n = propertyArray.length - 1;
        propertyArray[n--] = property;
        ComplexSlotMap complexSlotMap = this;
        while (!(complexSlotMap instanceof ComponentSlotMap)) {
            if (complexSlotMap == null) {
                return null;
            }
            propertyArray[n--] = complexSlotMap.propertyInParent;
            complexSlotMap = complexSlotMap.parent;
        }
        Property[] propertyArray2 = new Property[propertyArray.length - n - 1];
        System.arraycopy(propertyArray, n + 1, propertyArray2, 0, propertyArray2.length);
        ComponentBase componentBase = new ComponentBase();
        componentBase.component = complexSlotMap.instance.asComponent();
        componentBase.propertyPath = propertyArray2;
        return componentBase;
    }

    final ComponentBase getComponentBase(Property property, Context context) {
        ComponentBase componentBase = this.getComponentBase(property);
        if (componentBase != null) {
            componentBase.cx = context;
        }
        return componentBase;
    }

    void modified(NProperty nProperty, Context context, BDataRecoveryComponentRecorder bDataRecoveryComponentRecorder) {
        if (this.parent != null) {
            BDataRecoveryComponentRecorder bDataRecoveryComponentRecorder2 = bDataRecoveryComponentRecorder;
            if (bDataRecoveryComponentRecorder != null) {
                int n;
                int[] nArray = null;
                boolean bl = nProperty.isFrozen();
                boolean bl2 = this.propertyInParent.isFrozen();
                boolean bl3 = false;
                if (bl && bl2) {
                    bl3 = true;
                }
                boolean bl4 = bl3;
                StringBuffer stringBuffer = null;
                if (bl4) {
                    try {
                        int n2 = this.propertyInParent.index;
                        n = nProperty.index;
                        nArray = new int[]{n2, n};
                    }
                    catch (Throwable throwable) {
                        bl4 = false;
                        stringBuffer = new StringBuffer("slot:");
                        stringBuffer.append(this.propertyInParent.getName());
                    }
                } else if (bl) {
                    bl4 = false;
                    try {
                        int n3 = nProperty.index;
                        nArray = new int[]{n3};
                    }
                    catch (Throwable throwable) {
                        bl = false;
                        bl4 = false;
                    }
                    stringBuffer = new StringBuffer("slot:");
                    stringBuffer.append(this.propertyInParent.getName());
                }
                ComplexSlotMap complexSlotMap = this.parent;
                while (complexSlotMap != null && !(complexSlotMap.instance instanceof BComponent)) {
                    boolean bl5 = false;
                    if (bl4 && complexSlotMap.propertyInParent.isFrozen()) {
                        bl5 = true;
                    }
                    if (bl4 = bl5) {
                        try {
                            n = complexSlotMap.propertyInParent.index;
                            int n4 = nArray.length;
                            int n5 = n4 + 1;
                            int[] nArray2 = new int[n5];
                            System.arraycopy(nArray, 0, nArray2, 1, n4);
                            nArray2[0] = n;
                            nArray = nArray2;
                        }
                        catch (Throwable throwable) {
                            bl4 = false;
                        }
                    }
                    if (!bl4) {
                        if (stringBuffer == null) {
                            stringBuffer = new StringBuffer("slot:");
                            stringBuffer.append(complexSlotMap.propertyInParent.getName());
                        } else {
                            StringBuffer stringBuffer2 = new StringBuffer(complexSlotMap.propertyInParent.getName());
                            stringBuffer2.append('/');
                            stringBuffer.insert(5, stringBuffer2.toString());
                        }
                    }
                    complexSlotMap = complexSlotMap.parent;
                }
                if (complexSlotMap != null) {
                    BOrd bOrd = ((BComponent)complexSlotMap.instance).getOrdInSpace();
                    BOrd bOrd2 = stringBuffer != null ? BOrd.make(bOrd, stringBuffer.toString()) : bOrd;
                    bDataRecoveryComponentRecorder.record(BDataRecoveryComponentEvent.makeChangeEvent(this.instance, bOrd2, nArray, nProperty, this.instance.get(nProperty)), context);
                    bDataRecoveryComponentRecorder2 = null;
                }
            }
            this.parent.modified(this.propertyInParent, context, bDataRecoveryComponentRecorder2);
        }
    }

    BDataRecoveryComponentRecorder findRecoveryData(int n, Slot slot, Context context) {
        int n2;
        BDataRecoveryComponentRecorder bDataRecoveryComponentRecorder = null;
        if (this.parent != null) {
            bDataRecoveryComponentRecorder = this.parent.findRecoveryData(n, this.propertyInParent, context);
        }
        if (bDataRecoveryComponentRecorder != null && slot != null && !bDataRecoveryComponentRecorder.isEventCritical(n, this.instance, slot, n2 = this.getFlags(slot), context)) {
            bDataRecoveryComponentRecorder = null;
        }
        return bDataRecoveryComponentRecorder;
    }

    BDataRecoveryComponentRecorder findRecoveryData(int n, Slot slot, int n2, Context context) {
        BDataRecoveryComponentRecorder bDataRecoveryComponentRecorder = null;
        if (this.parent != null) {
            bDataRecoveryComponentRecorder = this.parent.findRecoveryData(n, this.propertyInParent, this.parent.getFlags(this.propertyInParent), context);
        }
        if (bDataRecoveryComponentRecorder != null && slot != null && !bDataRecoveryComponentRecorder.isEventCritical(n, this.instance, slot, n2, context)) {
            bDataRecoveryComponentRecorder = null;
        }
        return bDataRecoveryComponentRecorder;
    }

    public int getFlags(Slot slot) {
        return ((NSlot)slot).flags;
    }

    public void setFlags(Slot slot, int n, Context context) {
        throw new UnsupportedOperationException("setFlags() not supported on BStruct");
    }

    public BComplex getParent() {
        return this.parent == null ? null : this.parent.instance;
    }

    public Property getPropertyInParent() {
        return this.propertyInParent;
    }

    void parent(NProperty nProperty, ComplexSlotMap complexSlotMap, Context context, TransferListener transferListener, BDataRecoveryComponentRecorder bDataRecoveryComponentRecorder, BDataRecoveryComponentEvent bDataRecoveryComponentEvent) {
        if (complexSlotMap.parent != null) {
            throw new AlreadyParentedException(nProperty + " <- " + complexSlotMap.instance);
        }
        complexSlotMap.parent = this;
        complexSlotMap.propertyInParent = nProperty;
        if (bDataRecoveryComponentRecorder != null && bDataRecoveryComponentEvent != null) {
            bDataRecoveryComponentRecorder.record(bDataRecoveryComponentEvent, context);
        }
    }

    void unparent(NProperty nProperty, ComplexSlotMap complexSlotMap, Context context) {
        complexSlotMap.parent = null;
        complexSlotMap.propertyInParent = null;
    }

    public TrapCallbacks getSpaceTrap() {
        return this.parent == null ? null : this.parent.getSpaceTrap();
    }

    public BComponentSpace getSpace() {
        return this.parent == null ? null : this.parent.getSpace();
    }

    static SlotPath getSlotPathFromContext(Context context) {
        try {
            BString bString = (BString)context.getFacet("auditTargetSlotPathScheme");
            BString bString2 = (BString)context.getFacet("auditTargetSlotPathBody");
            if (bString2 != null) {
                if (bString != null) {
                    return new SlotPath(bString.getString(), bString2.getString());
                }
                return new SlotPath(bString2.getString());
            }
        }
        catch (Throwable throwable) {}
        return null;
    }

    public void audit(ComponentBase componentBase, BUser bUser, String string, String string2, String string3) {
        String string4;
        BComponent bComponent = componentBase.component;
        Property[] propertyArray = componentBase.propertyPath;
        SlotPath slotPath = bComponent.getSlotPath();
        if (slotPath == null && componentBase.cx != null) {
            slotPath = ComplexSlotMap.getSlotPathFromContext(componentBase.cx);
        }
        if (slotPath == null) {
            return;
        }
        if (Flags.isNoAudit(bComponent, propertyArray[0])) {
            return;
        }
        if (propertyArray.length == 1) {
            string4 = propertyArray[0].getName();
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < propertyArray.length) {
                stringBuffer.append(propertyArray[n].getName()).append('/');
                ++n;
            }
            stringBuffer.setLength(stringBuffer.length() - 1);
            string4 = stringBuffer.toString();
        }
        this.audit(slotPath, bUser, string, string4, string2, string3);
    }

    public void audit(SlotPath slotPath, BUser bUser, String string, String string2, String string3, String string4) {
        try {
            Auditor auditor = Nre.auditor;
            if (auditor != null && slotPath != null) {
                if (slotPath.getScheme().equals("slot")) {
                    auditor.audit(new AuditEvent(string, slotPath.getBody(), string2, string3, string4, bUser.getUsername()));
                } else {
                    auditor.audit(new AuditEvent(string, slotPath.toString(), string2, string3, string4, bUser.getUsername()));
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static String toAuditString(ComponentBase componentBase, BValue bValue, Context context) {
        try {
            return ComplexSlotMap.toAuditString(componentBase.component, componentBase.propertyPath[0], bValue, context);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return throwable.toString();
        }
    }

    public static String toAuditString(BComponent bComponent, Slot slot, BValue bValue, Context context) {
        try {
            BFacets bFacets;
            if (bValue == null) {
                return null;
            }
            if (bComponent != null && slot != null && (bFacets = bComponent.getSlotFacets(slot)) != null && !bFacets.isNull()) {
                context = new BasicContext(context, bFacets);
            }
            return bValue.toString(context);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return throwable.toString();
        }
    }

    public static ComplexSlotMap getSlotMap(BObject bObject) {
        return (ComplexSlotMap)bObject.fw(1, null, null, null, null);
    }

    public static ComponentSlotMap getComponentSlotMap(BObject bObject) {
        return (ComponentSlotMap)bObject.fw(1, null, null, null, null);
    }

    public Object getHandle() {
        throw this.notComponent();
    }

    public SlotPath getSlotPath() {
        throw this.notComponent();
    }

    public BValue invoke(Action action, BValue bValue, Context context) {
        throw this.notComponent();
    }

    public void fire(Topic topic, BValue bValue, Context context) {
        throw this.notComponent();
    }

    public Property add(String string, int n, BValue bValue, ComplexSlotMap complexSlotMap, BFacets bFacets, Context context, TransferListener transferListener) {
        throw this.notComponent();
    }

    public BValue remove(Property property, Context context) {
        throw this.notComponent();
    }

    public void rename(Property property, String string, Context context) {
        throw this.notComponent();
    }

    public void setFacets(Slot slot, BFacets bFacets, Context context) {
        throw this.notComponent();
    }

    public void reorderToTop(Property property, Context context) {
        throw this.notComponent();
    }

    public void reorderToBottom(Property property, Context context) {
        throw this.notComponent();
    }

    public void reorder(Property[] propertyArray, Context context) {
        throw this.notComponent();
    }

    public void start() {
        throw this.notComponent();
    }

    public void stop() {
        throw this.notComponent();
    }

    public boolean isRunning() {
        throw this.notComponent();
    }

    public int getKnobCount() {
        throw this.notComponent();
    }

    public NKnob[] getKnobs() {
        throw this.notComponent();
    }

    public NKnob[] getKnobs(Slot slot) {
        throw this.notComponent();
    }

    public boolean isSubscribed() {
        throw this.notComponent();
    }

    public Subscriber[] getSubscribers() {
        throw this.notComponent();
    }

    public boolean isPermanentlySubscribed() {
        throw this.notComponent();
    }

    public void setPermanentlySubscribed(boolean bl) {
        throw this.notComponent();
    }

    public boolean isPendingMove() {
        throw this.notComponent();
    }

    public void setPendingMove(boolean bl) {
        throw this.notComponent();
    }

    public BPermissions getCachedPermissions() {
        throw this.notComponent();
    }

    public BCategoryMask getAppliedCategoryMask() {
        throw this.notComponent();
    }

    public BCategoryMask getCategoryMask() {
        throw this.notComponent();
    }

    public void setCategoryMask(BCategoryMask bCategoryMask, Context context) {
        throw this.notComponent();
    }

    private final IllegalStateException notComponent() {
        return new IllegalStateException("Not a BComponent");
    }

    public abstract BComplex newBComplexInstance() throws NoSuchMethodError;

    public abstract ComplexSlotMap newSlotMapInstance();

    public BValue g(int n) {
        throw new UnhandledSlotException();
    }

    public boolean gb(int n) {
        throw new UnhandledSlotException();
    }

    public int gi(int n) {
        throw new UnhandledSlotException();
    }

    public long gj(int n) {
        throw new UnhandledSlotException();
    }

    public float gf(int n) {
        throw new UnhandledSlotException();
    }

    public double gd(int n) {
        throw new UnhandledSlotException();
    }

    public String gs(int n) {
        throw new UnhandledSlotException();
    }

    public void s(int n, BValue bValue) {
        throw new UnhandledSlotException();
    }

    public void sb(int n, boolean bl) {
        throw new UnhandledSlotException();
    }

    public void si(int n, int n2) {
        throw new UnhandledSlotException();
    }

    public void sj(int n, long l) {
        throw new UnhandledSlotException();
    }

    public void sf(int n, float f) {
        throw new UnhandledSlotException();
    }

    public void sd(int n, double d) {
        throw new UnhandledSlotException();
    }

    public void ss(int n, String string) {
        throw new UnhandledSlotException();
    }

    public BValue invoke(int n, BComponent bComponent, BValue bValue, Context context) {
        throw new UnhandledSlotException();
    }

    public static final class ComponentBase {
        public BComponent component;
        public Property[] propertyPath;
        Context cx;
    }
}

