/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.schema;

import com.tridium.asm.Assembler;
import com.tridium.asm.AttributeInfo;
import com.tridium.asm.Buffer;
import com.tridium.asm.Code;
import com.tridium.asm.ConstantPool;
import com.tridium.asm.FieldInfo;
import com.tridium.asm.Jvm;
import com.tridium.asm.MethodInfo;
import com.tridium.asm.OpCodes;
import com.tridium.sys.schema.NAction;
import com.tridium.sys.schema.NProperty;
import com.tridium.sys.schema.NSlot;
import javax.baja.nre.util.TextUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
class Compiler
implements OpCodes {
    int init;
    int exceptionCls;
    int exceptionCtor;
    int npropCls;
    int npropGetDef;
    int bbooleanCls;
    int bintegerCls;
    int blongCls;
    int bfloatCls;
    int bdoubleCls;
    int bstringCls;
    int bbooleanMake;
    int bintegerMake;
    int blongMake;
    int bfloatMake;
    int bdoubleMake;
    int bstringMake;
    int getBoolean;
    int getInt;
    int getLong;
    int getFloat;
    int getDouble;
    int getString;
    SwitchCode g;
    SwitchCode s;
    SwitchCode gb;
    SwitchCode sb;
    SwitchCode gi;
    SwitchCode si;
    SwitchCode gj;
    SwitchCode sj;
    SwitchCode gf;
    SwitchCode sf;
    SwitchCode gd;
    SwitchCode sd;
    SwitchCode gs;
    SwitchCode ss;
    SwitchCode invoke;
    Assembler asm;
    ConstantPool cp;
    int complexClass;
    NSlot[] slots;
    int[] propFields;

    Buffer compile() {
        this.genFields();
        this.genConstructor();
        this.genNewSlotMapInstance();
        this.genNewBComplexInstance();
        this.genAccessors();
        this.addAccessors();
        this.asm.addAttribute(new AttributeInfo(this.asm, "SourceFile", "AutoGenerated"));
        return this.asm.compile();
    }

    private final void genFields() {
        int n = 2;
        this.propFields = new int[this.slots.length];
        int n2 = 0;
        while (n2 < this.slots.length) {
            if (this.slots[n2].isProperty()) {
                NProperty nProperty = (NProperty)this.slots[n2];
                String string = "p" + n2;
                String string2 = null;
                switch (nProperty.typeAccess) {
                    case 0: {
                        string2 = "Z";
                        break;
                    }
                    case 2: {
                        string2 = "I";
                        break;
                    }
                    case 3: {
                        string2 = "J";
                        break;
                    }
                    case 4: {
                        string2 = "F";
                        break;
                    }
                    case 5: {
                        string2 = "D";
                        break;
                    }
                    case 6: {
                        string2 = "Ljava/lang/String;";
                        break;
                    }
                    case 7: {
                        string2 = "Ljavax/baja/sys/BValue;";
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                FieldInfo fieldInfo = new FieldInfo(this.asm, "p" + n2, string2, n);
                this.asm.addField(fieldInfo);
                this.propFields[n2] = this.cp.field(fieldInfo);
            }
            ++n2;
        }
    }

    private final void genConstructor() {
        Code code = new Code(this.asm);
        code.add(42);
        code.add(183, code.cp.method(this.asm.superClass, this.init(), "()V"));
        code.add(177);
        this.asm.addMethod(new MethodInfo(this.asm, this.init(), "()V", 1, code));
    }

    private final void genNewSlotMapInstance() {
        int n = this.cp.method(this.asm.thisClass, this.init(), "()V");
        Code code = new Code(this.asm);
        code.add(187, this.asm.thisClass);
        code.add(89);
        code.add(183, n);
        code.add(176);
        this.asm.addMethod(new MethodInfo(this.asm, "newSlotMapInstance", "()Lcom/tridium/sys/schema/ComplexSlotMap;", 1, code));
    }

    private final void genNewBComplexInstance() {
        int n = this.cp.method(this.complexClass, this.init(), "()V");
        Code code = new Code(this.asm);
        code.add(187, this.complexClass);
        code.add(89);
        code.add(183, n);
        code.add(176);
        this.asm.addMethod(new MethodInfo(this.asm, "newBComplexInstance", "()Ljavax/baja/sys/BComplex;", 1, code));
    }

    private final void genAccessors() {
        int n = 0;
        while (n < this.slots.length) {
            NSlot nSlot = this.slots[n];
            if (!nSlot.isTopic()) {
                if (nSlot.isAction()) {
                    if (this.invoke == null) {
                        this.invoke = this.beginAccessorMethod();
                    }
                    this.genInvoke((NAction)nSlot, this.invoke);
                } else {
                    NProperty nProperty = (NProperty)nSlot;
                    if (this.g == null) {
                        this.g = this.beginAccessorMethod();
                        this.s = this.beginAccessorMethod();
                    }
                    switch (nProperty.getTypeAccess()) {
                        case 0: {
                            if (this.gb == null) {
                                this.gb = this.beginAccessorMethod();
                                this.sb = this.beginAccessorMethod();
                            }
                            this.genGetBoolean(nProperty, this.g, this.gb);
                            this.genSetBoolean(nProperty, this.s, this.sb);
                            break;
                        }
                        case 2: {
                            if (this.gi == null) {
                                this.gi = this.beginAccessorMethod();
                                this.si = this.beginAccessorMethod();
                            }
                            this.genGetInt(nProperty, this.g, this.gi);
                            this.genSetInt(nProperty, this.s, this.si);
                            break;
                        }
                        case 3: {
                            if (this.gj == null) {
                                this.gj = this.beginAccessorMethod();
                                this.sj = this.beginAccessorMethod();
                            }
                            this.genGetLong(nProperty, this.g, this.gj);
                            this.genSetLong(nProperty, this.s, this.sj);
                            break;
                        }
                        case 4: {
                            if (this.gf == null) {
                                this.gf = this.beginAccessorMethod();
                                this.sf = this.beginAccessorMethod();
                            }
                            this.genGetFloat(nProperty, this.g, this.gf);
                            this.genSetFloat(nProperty, this.s, this.sf);
                            break;
                        }
                        case 5: {
                            if (this.gd == null) {
                                this.gd = this.beginAccessorMethod();
                                this.sd = this.beginAccessorMethod();
                            }
                            this.genGetDouble(nProperty, this.g, this.gd);
                            this.genSetDouble(nProperty, this.s, this.sd);
                            break;
                        }
                        case 6: {
                            if (this.gs == null) {
                                this.gs = this.beginAccessorMethod();
                                this.ss = this.beginAccessorMethod();
                            }
                            this.genGetString(nProperty, this.g, this.gs);
                            this.genSetString(nProperty, this.s, this.ss);
                            break;
                        }
                        case 7: {
                            this.genGetGeneric(nProperty, this.g);
                            this.genSetGeneric(nProperty, this.s);
                            break;
                        }
                    }
                }
            }
            ++n;
        }
    }

    private final void addAccessors() {
        if (this.g != null) {
            this.asm.addMethod(new MethodInfo(this.asm, "g", "(I)Ljavax/baja/sys/BValue;", 17, this.g.code));
            this.asm.addMethod(new MethodInfo(this.asm, "s", "(ILjavax/baja/sys/BValue;)V", 17, this.s.code));
        }
        if (this.gb != null) {
            this.asm.addMethod(new MethodInfo(this.asm, "gb", "(I)Z", 17, this.gb.code));
            this.asm.addMethod(new MethodInfo(this.asm, "sb", "(IZ)V", 17, this.sb.code));
        }
        if (this.gi != null) {
            this.asm.addMethod(new MethodInfo(this.asm, "gi", "(I)I", 17, this.gi.code));
            this.asm.addMethod(new MethodInfo(this.asm, "si", "(II)V", 17, this.si.code));
        }
        if (this.gj != null) {
            this.asm.addMethod(new MethodInfo(this.asm, "gj", "(I)J", 17, this.gj.code));
            this.asm.addMethod(new MethodInfo(this.asm, "sj", "(IJ)V", 17, this.sj.code));
        }
        if (this.gf != null) {
            this.asm.addMethod(new MethodInfo(this.asm, "gf", "(I)F", 17, this.gf.code));
            this.asm.addMethod(new MethodInfo(this.asm, "sf", "(IF)V", 17, this.sf.code));
        }
        if (this.gd != null) {
            this.asm.addMethod(new MethodInfo(this.asm, "gd", "(I)D", 17, this.gd.code));
            this.asm.addMethod(new MethodInfo(this.asm, "sd", "(ID)V", 17, this.sd.code));
        }
        if (this.gs != null) {
            this.asm.addMethod(new MethodInfo(this.asm, "gs", "(I)Ljava/lang/String;", 17, this.gs.code));
            this.asm.addMethod(new MethodInfo(this.asm, "ss", "(ILjava/lang/String;)V", 17, this.ss.code));
        }
        if (this.invoke != null) {
            this.asm.addMethod(new MethodInfo(this.asm, "invoke", "(ILjavax/baja/sys/BComponent;Ljavax/baja/sys/BValue;Ljavax/baja/sys/Context;)Ljavax/baja/sys/BValue;", 17, this.invoke.code));
        }
    }

    private final void genGetGeneric(NProperty nProperty, SwitchCode switchCode) {
        Code code = switchCode.code;
        int n = this.propFields[nProperty.index];
        int n2 = code.add(42);
        code.add(180, n);
        code.add(176);
        this.backpatch(switchCode, nProperty.index, n2);
    }

    private final void genGetBoolean(NProperty nProperty, SwitchCode switchCode, SwitchCode switchCode2) {
        Code code = switchCode.code;
        int n = this.propFields[nProperty.index];
        int n2 = code.add(42);
        code.add(180, n);
        code.add(184, this.bbooleanMake());
        code.add(176);
        this.backpatch(switchCode, nProperty.index, n2);
        code = switchCode2.code;
        n2 = code.add(42);
        code.add(180, n);
        code.add(172);
        this.backpatch(switchCode2, nProperty.index, n2);
    }

    private final void genGetInt(NProperty nProperty, SwitchCode switchCode, SwitchCode switchCode2) {
        Code code = switchCode.code;
        int n = this.propFields[nProperty.index];
        int n2 = code.add(42);
        code.add(180, n);
        code.add(184, this.bintegerMake());
        code.add(176);
        this.backpatch(switchCode, nProperty.index, n2);
        code = switchCode2.code;
        n2 = code.add(42);
        code.add(180, n);
        code.add(172);
        this.backpatch(switchCode2, nProperty.index, n2);
    }

    private final void genGetLong(NProperty nProperty, SwitchCode switchCode, SwitchCode switchCode2) {
        Code code = switchCode.code;
        int n = this.propFields[nProperty.index];
        int n2 = code.add(42);
        code.add(180, n);
        code.add(184, this.blongMake());
        code.add(176);
        this.backpatch(switchCode, nProperty.index, n2);
        code = switchCode2.code;
        n2 = code.add(42);
        code.add(180, n);
        code.add(173);
        this.backpatch(switchCode2, nProperty.index, n2);
    }

    private final void genGetFloat(NProperty nProperty, SwitchCode switchCode, SwitchCode switchCode2) {
        Code code = switchCode.code;
        int n = this.propFields[nProperty.index];
        int n2 = code.add(42);
        code.add(180, n);
        code.add(184, this.bfloatMake());
        code.add(176);
        this.backpatch(switchCode, nProperty.index, n2);
        code = switchCode2.code;
        n2 = code.add(42);
        code.add(180, n);
        code.add(174);
        this.backpatch(switchCode2, nProperty.index, n2);
    }

    private final void genGetDouble(NProperty nProperty, SwitchCode switchCode, SwitchCode switchCode2) {
        Code code = switchCode.code;
        int n = this.propFields[nProperty.index];
        int n2 = code.add(42);
        code.add(180, n);
        code.add(184, this.bdoubleMake());
        code.add(176);
        this.backpatch(switchCode, nProperty.index, n2);
        code = switchCode2.code;
        n2 = code.add(42);
        code.add(180, n);
        code.add(175);
        this.backpatch(switchCode2, nProperty.index, n2);
    }

    private final void genGetString(NProperty nProperty, SwitchCode switchCode, SwitchCode switchCode2) {
        Code code = switchCode.code;
        int n = this.propFields[nProperty.index];
        int n2 = code.add(42);
        code.add(180, n);
        code.add(184, this.bstringMake());
        code.add(176);
        this.backpatch(switchCode, nProperty.index, n2);
        code = switchCode2.code;
        n2 = code.add(42);
        code.add(180, n);
        code.add(176);
        this.backpatch(switchCode2, nProperty.index, n2);
    }

    private final void genSetGeneric(NProperty nProperty, SwitchCode switchCode) {
        Code code = switchCode.code;
        int n = this.propFields[nProperty.index];
        int n2 = this.cp.cls(nProperty.typeClass);
        int n3 = code.add(42);
        code.add(44);
        code.add(192, n2);
        code.add(181, n);
        code.add(177);
        this.backpatch(switchCode, nProperty.index, n3);
    }

    private final void genSetBoolean(NProperty nProperty, SwitchCode switchCode, SwitchCode switchCode2) {
        Code code = switchCode.code;
        int n = this.propFields[nProperty.index];
        int n2 = code.add(42);
        code.add(44);
        code.add(192, this.bbooleanCls());
        code.add(182, this.getBoolean());
        code.add(181, n);
        code.add(177);
        this.backpatch(switchCode, nProperty.index, n2);
        code = switchCode2.code;
        n2 = code.add(42);
        code.add(28);
        code.add(181, n);
        code.add(177);
        this.backpatch(switchCode2, nProperty.index, n2);
    }

    private final void genSetInt(NProperty nProperty, SwitchCode switchCode, SwitchCode switchCode2) {
        Code code = switchCode.code;
        int n = this.propFields[nProperty.index];
        int n2 = code.add(42);
        code.add(44);
        code.add(192, this.bintegerCls());
        code.add(182, this.getInt());
        code.add(181, n);
        code.add(177);
        this.backpatch(switchCode, nProperty.index, n2);
        code = switchCode2.code;
        n2 = code.add(42);
        code.add(28);
        code.add(181, n);
        code.add(177);
        this.backpatch(switchCode2, nProperty.index, n2);
    }

    private final void genSetLong(NProperty nProperty, SwitchCode switchCode, SwitchCode switchCode2) {
        Code code = switchCode.code;
        int n = this.propFields[nProperty.index];
        int n2 = code.add(42);
        code.add(44);
        code.add(192, this.blongCls());
        code.add(182, this.getLong());
        code.add(181, n);
        code.add(177);
        this.backpatch(switchCode, nProperty.index, n2);
        code = switchCode2.code;
        n2 = code.add(42);
        code.add(32);
        code.add(181, n);
        code.add(177);
        this.backpatch(switchCode2, nProperty.index, n2);
    }

    private final void genSetFloat(NProperty nProperty, SwitchCode switchCode, SwitchCode switchCode2) {
        Code code = switchCode.code;
        int n = this.propFields[nProperty.index];
        int n2 = code.add(42);
        code.add(44);
        code.add(192, this.bfloatCls());
        code.add(182, this.getFloat());
        code.add(181, n);
        code.add(177);
        this.backpatch(switchCode, nProperty.index, n2);
        code = switchCode2.code;
        n2 = code.add(42);
        code.add(36);
        code.add(181, n);
        code.add(177);
        this.backpatch(switchCode2, nProperty.index, n2);
    }

    private final void genSetDouble(NProperty nProperty, SwitchCode switchCode, SwitchCode switchCode2) {
        Code code = switchCode.code;
        int n = this.propFields[nProperty.index];
        int n2 = code.add(42);
        code.add(44);
        code.add(192, this.bdoubleCls());
        code.add(182, this.getDouble());
        code.add(181, n);
        code.add(177);
        this.backpatch(switchCode, nProperty.index, n2);
        code = switchCode2.code;
        n2 = code.add(42);
        code.add(40);
        code.add(181, n);
        code.add(177);
        this.backpatch(switchCode2, nProperty.index, n2);
    }

    private final void genSetString(NProperty nProperty, SwitchCode switchCode, SwitchCode switchCode2) {
        Code code = switchCode.code;
        int n = this.propFields[nProperty.index];
        int n2 = code.add(42);
        code.add(44);
        code.add(192, this.bstringCls());
        code.add(182, this.getString());
        code.add(181, n);
        code.add(177);
        this.backpatch(switchCode, nProperty.index, n2);
        code = switchCode2.code;
        n2 = code.add(42);
        code.add(44);
        code.add(181, n);
        code.add(177);
        this.backpatch(switchCode2, nProperty.index, n2);
    }

    private final void genInvoke(NAction nAction, SwitchCode switchCode) {
        Code code = switchCode.code;
        Class clazz = nAction.parameterClass;
        Class clazz2 = nAction.returnClass;
        int n = code.add(44);
        code.add(192, this.complexClass);
        if (clazz != null) {
            int n2 = this.cp.cls(clazz);
            code.add(45);
            code.add(192, n2);
        }
        if (nAction.doTakesContext) {
            code.add(25, 4);
        }
        String string = "do" + TextUtil.capitalize((String)nAction.name);
        StringBuffer stringBuffer = new StringBuffer("(");
        if (clazz != null) {
            stringBuffer.append(Jvm.fieldDescriptor(clazz));
        }
        if (nAction.doTakesContext) {
            stringBuffer.append("Ljavax/baja/sys/Context;");
        }
        stringBuffer.append(")");
        if (clazz2 == null) {
            stringBuffer.append("V");
        } else {
            stringBuffer.append(Jvm.fieldDescriptor(clazz2));
        }
        int n3 = this.cp.method(this.complexClass, string, stringBuffer.toString());
        code.add(182, n3);
        if (clazz2 == null) {
            code.add(1);
        }
        code.add(176);
        this.backpatch(switchCode, nAction.index, n);
    }

    private final SwitchCode beginAccessorMethod() {
        Code code = new Code(this.asm);
        int n = this.slots.length;
        code.add(27);
        int n2 = code.addPad(170);
        int n3 = code.code.u4(0);
        int n4 = n3 + 12 + n * 4;
        int n5 = n4 - n2;
        code.code.u4(n3, n5);
        code.code.u4(0);
        code.code.u4(n - 1);
        int n6 = n3 + 12;
        int n7 = 0;
        while (n7 < n) {
            code.code.u4(n5);
            ++n7;
        }
        code.add(187, this.exceptionCls());
        code.add(89);
        code.add(183, this.exceptionCtor());
        code.add(191);
        return new SwitchCode(code, n2, n6);
    }

    private final void backpatch(SwitchCode switchCode, int n, int n2) {
        switchCode.code.code.u4(switchCode.firstJumpOffset + n * 4, n2 - switchCode.switchOffset);
    }

    int init() {
        if (this.init == 0) {
            this.init = this.cp.utf("<init>");
        }
        return this.init;
    }

    int exceptionCls() {
        if (this.exceptionCls == 0) {
            this.exceptionCls = this.cp.cls("com/tridium/sys/schema/UnhandledSlotException");
        }
        return this.exceptionCls;
    }

    int exceptionCtor() {
        if (this.exceptionCtor == 0) {
            this.exceptionCtor = this.cp.method(this.exceptionCls(), this.init(), "()V");
        }
        return this.exceptionCtor;
    }

    int npropCls() {
        if (this.npropCls == 0) {
            this.npropCls = this.cp.cls("com/tridium/sys/schema/NProperty");
        }
        return this.npropCls;
    }

    int npropGetDef() {
        if (this.npropGetDef == 0) {
            this.npropGetDef = this.cp.method(this.npropCls(), "getDefaultValue", "()Ljavax/baja/sys/BValue;");
        }
        return this.npropGetDef;
    }

    int bbooleanCls() {
        if (this.bbooleanCls == 0) {
            this.bbooleanCls = this.cp.cls("javax/baja/sys/BBoolean");
        }
        return this.bbooleanCls;
    }

    int bintegerCls() {
        if (this.bintegerCls == 0) {
            this.bintegerCls = this.cp.cls("javax/baja/sys/BInteger");
        }
        return this.bintegerCls;
    }

    int blongCls() {
        if (this.blongCls == 0) {
            this.blongCls = this.cp.cls("javax/baja/sys/BLong");
        }
        return this.blongCls;
    }

    int bfloatCls() {
        if (this.bfloatCls == 0) {
            this.bfloatCls = this.cp.cls("javax/baja/sys/BFloat");
        }
        return this.bfloatCls;
    }

    int bdoubleCls() {
        if (this.bdoubleCls == 0) {
            this.bdoubleCls = this.cp.cls("javax/baja/sys/BDouble");
        }
        return this.bdoubleCls;
    }

    int bstringCls() {
        if (this.bstringCls == 0) {
            this.bstringCls = this.cp.cls("javax/baja/sys/BString");
        }
        return this.bstringCls;
    }

    int bbooleanMake() {
        if (this.bbooleanMake == 0) {
            this.bbooleanMake = this.cp.method(this.bbooleanCls(), "make", "(Z)Ljavax/baja/sys/BBoolean;");
        }
        return this.bbooleanMake;
    }

    int bintegerMake() {
        if (this.bintegerMake == 0) {
            this.bintegerMake = this.cp.method(this.bintegerCls(), "make", "(I)Ljavax/baja/sys/BInteger;");
        }
        return this.bintegerMake;
    }

    int blongMake() {
        if (this.blongMake == 0) {
            this.blongMake = this.cp.method(this.blongCls(), "make", "(J)Ljavax/baja/sys/BLong;");
        }
        return this.blongMake;
    }

    int bfloatMake() {
        if (this.bfloatMake == 0) {
            this.bfloatMake = this.cp.method(this.bfloatCls(), "make", "(F)Ljavax/baja/sys/BFloat;");
        }
        return this.bfloatMake;
    }

    int bdoubleMake() {
        if (this.bdoubleMake == 0) {
            this.bdoubleMake = this.cp.method(this.bdoubleCls(), "make", "(D)Ljavax/baja/sys/BDouble;");
        }
        return this.bdoubleMake;
    }

    int bstringMake() {
        if (this.bstringMake == 0) {
            this.bstringMake = this.cp.method(this.bstringCls(), "make", "(Ljava/lang/String;)Ljavax/baja/sys/BString;");
        }
        return this.bstringMake;
    }

    int getBoolean() {
        if (this.getBoolean == 0) {
            this.getBoolean = this.cp.method(this.bbooleanCls(), "getBoolean", "()Z");
        }
        return this.getBoolean;
    }

    int getInt() {
        if (this.getInt == 0) {
            this.getInt = this.cp.method(this.bintegerCls(), "getInt", "()I");
        }
        return this.getInt;
    }

    int getLong() {
        if (this.getLong == 0) {
            this.getLong = this.cp.method(this.blongCls(), "getLong", "()J");
        }
        return this.getLong;
    }

    int getFloat() {
        if (this.getFloat == 0) {
            this.getFloat = this.cp.method(this.bfloatCls(), "getFloat", "()F");
        }
        return this.getFloat;
    }

    int getDouble() {
        if (this.getDouble == 0) {
            this.getDouble = this.cp.method(this.bdoubleCls(), "getDouble", "()D");
        }
        return this.getDouble;
    }

    int getString() {
        if (this.getString == 0) {
            this.getString = this.cp.method(this.bstringCls(), "getString", "()Ljava/lang/String;");
        }
        return this.getString;
    }

    private final /* synthetic */ void this() {
        this.g = null;
        this.s = null;
        this.gb = null;
        this.sb = null;
        this.gi = null;
        this.si = null;
        this.gj = null;
        this.sj = null;
        this.gf = null;
        this.sf = null;
        this.gd = null;
        this.sd = null;
        this.gs = null;
        this.ss = null;
        this.invoke = null;
    }

    Compiler(String string, String string2, Class clazz, NSlot[] nSlotArray) {
        this.this();
        int n = 33;
        this.asm = new Assembler(string2, string, n, null);
        this.cp = this.asm.cp;
        this.slots = nSlotArray;
        this.complexClass = this.cp.cls(clazz);
    }

    static class SwitchCode {
        Code code;
        int switchOffset;
        int firstJumpOffset;

        SwitchCode(Code code, int n, int n2) {
            this.code = code;
            this.switchOffset = n;
            this.firstJumpOffset = n2;
        }
    }
}

