/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.resource;

import com.tridium.sys.BIPlatform;
import com.tridium.sys.Nre;
import com.tridium.sys.metrics.Metrics;
import com.tridium.sys.resource.ResourceManager;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.HashMap;
import javax.baja.nre.util.ByteBuffer;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;

public class ResourceReport
implements Cloneable {
    static DecimalFormat ruFormat = new DecimalFormat("#,##0.000 kRU");
    int[] cpu;
    int[] mem;
    private int totalMem;
    private int ruLimit;
    private int ruTotal;
    private int ruDefault;
    private HashMap ru = new HashMap();
    private HashMap props = new HashMap();
    private int numComps;
    private String platStationFault;

    public int[] cpu() {
        return this.cpu;
    }

    public int[] mem() {
        return this.mem;
    }

    public int totalMem() {
        return this.totalMem;
    }

    public String platStationFault() {
        return this.platStationFault;
    }

    public int ruLimit() {
        return this.ruLimit;
    }

    public int ruTotal() {
        return this.ruTotal;
    }

    public int ruDefault() {
        return this.ruDefault;
    }

    public String[] ruCategories() {
        return this.ru.keySet().toArray(new String[this.ru.size()]);
    }

    public int ru(String string) {
        Category category = (Category)this.ru.get(string);
        int n = 0;
        if (category != null) {
            n = category.usage;
        }
        return n;
    }

    public String[] props() {
        return this.props.keySet().toArray(new String[this.props.size()]);
    }

    public String prop(String string) {
        return (String)this.props.get(string);
    }

    public final void add(int n) {
        this.ruTotal += n;
        this.ruDefault += n;
    }

    public final void add(String string, int n) {
        this.ruTotal += n;
        Category category = (Category)this.ru.get(string);
        if (category == null) {
            category = new Category(string);
            this.ru.put(string, category);
        }
        category.usage += n;
    }

    public final void put(String string, String string2) {
        this.props.put(string, string2);
    }

    void generate(ResourceManager resourceManager) {
        BIPlatform bIPlatform = Nre.getPlatform();
        this.totalMem = bIPlatform.getTotalMemory();
        this.ruLimit = resourceManager.ruLimit;
        this.computeResourceUnits(Sys.getStation());
        this.put("resources.total", ResourceReport.rustr(this.ruTotal));
        this.put("resources.limit", this.ruLimit < 0 ? "none" : ResourceReport.rustr(this.ruLimit));
        this.put("resources.category.component", ResourceReport.rustr(this.ruDefault));
        String[] stringArray = this.ruCategories();
        int n = 0;
        while (n < stringArray.length) {
            this.put("resources.category." + stringArray[n], ResourceReport.rustr(this.ru(stringArray[n])));
            ++n;
        }
        this.put("mem.used", ResourceReport.memstr(bIPlatform.getMemoryUsage()));
        this.put("mem.total", ResourceReport.memstr(this.totalMem));
        long l = Runtime.getRuntime().totalMemory() / 1024L;
        long l2 = Runtime.getRuntime().freeMemory() / 1024L;
        this.put("heap.total", ResourceReport.memstr(l));
        this.put("heap.free", ResourceReport.memstr(l2));
        String string = System.getProperty("platform.maxHeap");
        if (string != null) {
            long l3 = 0L;
            l3 = string.endsWith("M") ? (long)(Integer.parseInt(string.substring(0, string.length() - 1)) * 1024) : (string.endsWith("K") ? (long)Integer.parseInt(string.substring(0, string.length() - 1)) : 0L);
            this.put("heap.max", ResourceReport.memstr(l3));
        }
        this.put("component.count", "" + Sys.getStation().getComponentSpace().getComponentCount());
        this.put("version.niagara", "" + Sys.getBajaModule().getVendorVersion());
        this.put("version.java", System.getProperty("java.vm.name") + ' ' + System.getProperty("java.vm.version"));
        this.put("version.os", System.getProperty("os.arch") + ' ' + System.getProperty("os.name") + ' ' + System.getProperty("os.version"));
        if (Metrics.isUsingCapacityLicensing()) {
            Metrics.writeToResourceReport(this);
        }
        this.platStationFault = bIPlatform.checkForStationFault();
        bIPlatform.queryResources(this);
    }

    private final void computeResourceUnits(BObject bObject) {
        this.add(1);
        try {
            bObject.fw(21, this, null, null, null);
        }
        catch (Exception exception) {
            System.out.println("ERROR: ResourceReport on " + bObject.getType() + ": " + exception);
        }
        if (!(bObject instanceof BComplex)) {
            return;
        }
        BComplex bComplex = (BComplex)bObject;
        if (bComplex instanceof BComponent) {
            this.add(20);
        }
        SlotCursor slotCursor = bComplex.getProperties();
        while (slotCursor.next()) {
            try {
                Property property = slotCursor.property();
                if (property.getTypeAccess() != 7) {
                    this.add(1);
                    continue;
                }
                this.computeResourceUnits(slotCursor.get());
            }
            catch (Exception exception) {
                System.out.println("ERROR: ResourceReport: " + exception);
            }
        }
    }

    public static String memstr(long l) {
        if (l < 1024L) {
            return l + " KB";
        }
        return l / 1024L + " MB";
    }

    public static String rustr(int n) {
        return ruFormat.format((double)n / 1000.0);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (Exception exception) {
            throw new IllegalStateException();
        }
    }

    public byte[] encode() throws Exception {
        ByteBuffer byteBuffer = new ByteBuffer(1024);
        int n = this.cpu.length;
        byteBuffer.writeUTF("startReport");
        byteBuffer.writeInt(1);
        byteBuffer.writeUTF("");
        byteBuffer.writeInt(this.totalMem);
        byteBuffer.writeInt(this.ruLimit);
        byteBuffer.writeInt(this.ruTotal);
        byteBuffer.writeInt(this.ruDefault);
        String[] stringArray = this.ruCategories();
        byteBuffer.writeInt(this.ru.size());
        int n2 = 0;
        while (n2 < stringArray.length) {
            byteBuffer.writeUTF(stringArray[n2]);
            byteBuffer.writeInt(this.ru(stringArray[n2]));
            ++n2;
        }
        byteBuffer.writeInt(n);
        n2 = 0;
        while (n2 < n) {
            byteBuffer.writeByte(this.cpu[n2]);
            byteBuffer.writeInt(this.mem[n2]);
            ++n2;
        }
        String[] stringArray2 = this.props();
        byteBuffer.writeInt(stringArray2.length);
        int n3 = 0;
        while (n3 < stringArray2.length) {
            byteBuffer.writeUTF(stringArray2[n3]);
            byteBuffer.writeUTF(this.prop(stringArray2[n3]));
            ++n3;
        }
        byteBuffer.writeUTF("endReport");
        return byteBuffer.toByteArray();
    }

    public static ResourceReport decode(byte[] byArray) throws Exception {
        int n;
        ByteBuffer byteBuffer = new ByteBuffer(byArray);
        ResourceReport resourceReport = new ResourceReport();
        if (!byteBuffer.readUTF().equals("startReport")) {
            throw new IOException();
        }
        if (byteBuffer.readInt() != 1) {
            throw new IOException();
        }
        byteBuffer.readUTF();
        resourceReport.totalMem = byteBuffer.readInt();
        resourceReport.ruLimit = byteBuffer.readInt();
        resourceReport.ruTotal = byteBuffer.readInt();
        resourceReport.ruDefault = byteBuffer.readInt();
        int n2 = byteBuffer.readInt();
        int n3 = 0;
        while (n3 < n2) {
            String string = byteBuffer.readUTF();
            n = byteBuffer.readInt();
            resourceReport.ru.put(string, new Category(string, n));
            ++n3;
        }
        n3 = byteBuffer.readInt();
        resourceReport.cpu = new int[n3];
        resourceReport.mem = new int[n3];
        int n4 = 0;
        while (n4 < n3) {
            resourceReport.cpu[n4] = byteBuffer.readByte();
            resourceReport.mem[n4] = byteBuffer.readInt();
            ++n4;
        }
        n4 = byteBuffer.readInt();
        n = 0;
        while (n < n4) {
            String string = byteBuffer.readUTF();
            String string2 = byteBuffer.readUTF();
            resourceReport.props.put(string, string2);
            ++n;
        }
        if (!byteBuffer.readUTF().equals("endReport")) {
            throw new IOException();
        }
        return resourceReport;
    }

    static class Category {
        String key;
        int usage;

        Category(String string) {
            this.key = string;
        }

        Category(String string, int n) {
            this.key = string;
            this.usage = n;
        }
    }
}

