/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.resource;

import com.tridium.sys.BIPlatform;
import com.tridium.sys.Nre;
import com.tridium.sys.metrics.Metrics;
import com.tridium.sys.resource.ResourceReport;
import com.tridium.sys.station.Station;
import com.tridium.util.ArrayUtil;
import javax.baja.license.Feature;
import javax.baja.log.Log;
import javax.baja.spy.Spy;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Clock;
import javax.baja.sys.Sys;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ResourceManager
extends Thread {
    static final Log log = Log.getLog("sys.resource");
    static final int NUM_READINGS = 60;
    boolean isAlive;
    long startTicks;
    BAbsTime startTime;
    Object lock;
    int[] cpu;
    int[] mem;
    int reading;
    ResourceReport snapshot;
    long updateTime;
    int ruLimit;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ResourceReport report() {
        Object object = this.lock;
        synchronized (object) {
            ResourceReport resourceReport = (ResourceReport)this.snapshot.clone();
            resourceReport.cpu = ArrayUtil.orderCircular(this.cpu, this.reading);
            resourceReport.mem = ArrayUtil.orderCircular(this.mem, this.reading);
            resourceReport.put("heap.used", ResourceReport.memstr(resourceReport.mem[59]));
            resourceReport.put("cpu.usage", "" + resourceReport.cpu[59] + '%');
            Nre.engineManager.reportResources(resourceReport);
            long l = Clock.ticks() - this.startTicks;
            l -= l % 1000L;
            resourceReport.put("time.uptime", BRelTime.toString(l));
            resourceReport.put("time.start", this.startTime.toString());
            resourceReport.put("time.current", Clock.time().toString());
            return resourceReport;
        }
    }

    public BAbsTime getStartTime() {
        return this.startTime;
    }

    public Station.Message report(Station.Message message) throws Exception {
        return new Station.Message(message.id, this.report().encode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void update() {
        long l = Clock.ticks();
        ResourceReport resourceReport = new ResourceReport();
        resourceReport.generate(this);
        Object object = this.lock;
        synchronized (object) {
            this.snapshot = resourceReport;
        }
        long l2 = Clock.ticks();
        this.updateTime = l2 - l;
        String string = this.snapshot.platStationFault();
        if (string != null) {
            Station.setStationFault(string);
            return;
        }
        if (this.ruLimit >= 0 && this.snapshot.ruTotal() >= this.ruLimit) {
            Station.setStationFault("stationFault.resourceLimit");
            return;
        }
        Station.setStationFault(null);
    }

    public void checkLicense(Feature feature) {
        if (Metrics.isUsingCapacityLicensing()) {
            return;
        }
        String string = feature.get("resource.limit", null);
        if (string == null || string.equalsIgnoreCase("none")) {
            return;
        }
        this.ruLimit = Integer.parseInt(string) * 1000;
        this.update();
        int n = this.snapshot.ruTotal();
        String string2 = ResourceReport.rustr(n);
        String string3 = ResourceReport.rustr(this.ruLimit);
        log.message("Resource license used=" + string2 + " limit=" + string3);
        if (n > this.ruLimit) {
            System.out.println("#####################################################################");
            System.out.println("# STATION IS UNLICENSED!!!");
            System.out.println("# Licensed resource units exceeded.");
            System.out.println("# Used = " + string2 + "  >  Limit = " + string3);
            System.out.println("#####################################################################");
            if ((double)n >= (double)this.ruLimit * 1.1) {
                System.exit(-3);
            }
        }
    }

    public void kill() {
        this.isAlive = false;
        this.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        BIPlatform bIPlatform = Nre.getPlatform();
        long l = 0L;
        while (this.isAlive) {
            try {
                Thread.sleep(1000L);
                bIPlatform.poll();
                long l2 = Runtime.getRuntime().totalMemory() / 1024L - Runtime.getRuntime().freeMemory() / 1024L;
                Object object = this.lock;
                synchronized (object) {
                    this.cpu[this.reading] = ResourceManager.cap(bIPlatform.getCpuUsage(), 0, 100);
                    this.mem[this.reading] = ResourceManager.cap((int)l2, 0, Integer.MAX_VALUE);
                    this.reading = (this.reading + 1) % 60;
                }
                if (Clock.ticks() - l <= 60000L) continue;
                this.update();
                l = Clock.ticks();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public void postInit() {
        Nre.spySysManagers.add("resourceManager", new Page());
    }

    public static int cap(int n, int n2, int n3) {
        if (n < n2) {
            return n2;
        }
        if (n > n3) {
            return n3;
        }
        return n;
    }

    private final /* synthetic */ void this() {
        this.isAlive = true;
        this.startTicks = Clock.ticks();
        this.startTime = Clock.time();
        this.lock = new Object();
        this.cpu = new int[60];
        this.mem = new int[60];
        this.reading = 0;
        this.ruLimit = -1;
    }

    public ResourceManager() {
        super("Nre:ResourceManager");
        this.this();
        this.setDaemon(true);
        this.setPriority(this.getPriority() - 1);
        this.snapshot = new ResourceReport();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class Page
    extends Spy {
        public void write(SpyWriter spyWriter) throws Exception {
            if (Sys.getStation() == null) {
                spyWriter.print("VM is not a station");
                return;
            }
            if (Metrics.isUsingCapacityLicensing()) {
                spyWriter.print("<pre>");
                spyWriter.println("Detected Capacity Licensing, ignoring resource limit.");
                spyWriter.print("</pre>");
            }
            spyWriter.startProps("Resource Manager Stats");
            spyWriter.prop((Object)"updateTime", BRelTime.toString(ResourceManager.this.updateTime));
            spyWriter.prop((Object)"ruLimit", ResourceManager.this.ruLimit);
            spyWriter.prop((Object)"snapshot.ruLimit", "" + ResourceManager.this.snapshot.ruLimit());
            spyWriter.prop((Object)"snapshot.ruTotal", "" + ResourceManager.this.snapshot.ruTotal());
            spyWriter.prop((Object)"snapshot.ruDefault", "" + ResourceManager.this.snapshot.ruDefault());
            spyWriter.endProps();
            ResourceReport resourceReport = ResourceManager.this.report();
            spyWriter.startTable(true);
            int n = 0;
            while (n < resourceReport.cpu.length) {
                spyWriter.tr("" + resourceReport.cpu[n] + '%', resourceReport.mem[n] + "kb");
                ++n;
            }
            spyWriter.endTable();
        }
    }
}

